/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.background.ImageBackground;
import com.fr.form.event.Listener;
import com.fr.form.ui.FreeButton;
import com.fr.general.Background;
import com.fr.general.FRFont;
import com.fr.js.JavaScript;
import com.fr.js.JavaScriptImpl;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.core.UUID;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class CardSwitchButton
extends FreeButton {
    public static final int DEF_WIDTH = 200;
    private static final String XML_TAG = "SwitchTagAttr";
    private static final String NAME_TAG = "layoutName";
    private static final String IDX_TAG = "index";
    private static final String XML_TAG_ISCUSTOMSTYLE = "isCustomStyle";
    private static final String XML_TAG_INITIAL = "initial";
    private static final String XML_TAG_OVER = "over";
    private static final String XML_TAG_CLICK = "click";
    private boolean isShowButton = false;
    private double opacity = 0.6;
    private static final int START_INDEX = 3;
    private int index;
    private String cardLayoutName;

    public CardSwitchButton() {
    }

    public Background getInitialBackground() {
        return this.initialBackground;
    }

    public void setInitialBackground(Background background) {
        this.initialBackground = background;
        if (background instanceof ImageBackground && ((ImageBackground)background).getImage() != null) {
            this.setButtonSize(((ImageBackground)background).getImage().getWidth(null), ((ImageBackground)background).getImage().getHeight(null));
        }
    }

    private void setButtonSize(int n2, int n3) {
    }

    public int getbuttonWidth() {
        return this.getButtonWidth();
    }

    public int getbuttonHeight() {
        return this.getButtonHeight();
    }

    public CardSwitchButton(String string) {
        this(0, string);
    }

    public CardSwitchButton(int n2, String string) {
        this.index = n2;
        this.cardLayoutName = string;
        this.initDesignerStyle(UUID.randomUUID().toString());
    }

    public String getXType() {
        return "cardswitch";
    }

    public void initDesignerStyle(String string) {
        this.setWidgetName(string);
        this.setFont(FRFont.getInstance());
    }

    public boolean isShowButton() {
        return this.isShowButton;
    }

    public void setShowButton(boolean bl) {
        this.isShowButton = bl;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d2) {
        this.opacity = d2;
    }

    private String getClickJs() {
        if (StringUtils.isEmpty((String)this.cardLayoutName) || this.index < 0) {
            return "";
        }
        return "this.options.form.getWidgetByName('" + this.cardLayoutName + "').showCardByIndex(" + this.index + ")";
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n2) {
        this.index = n2 > 0 ? n2 : 0;
    }

    public String getCardLayoutName() {
        return this.cardLayoutName;
    }

    public void setCardLayoutName(String string) {
        this.cardLayoutName = string;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        this.initWebStyle();
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("opacity", this.opacity);
        return jSONObject;
    }

    private void initWebStyle() {
        Listener listener = new Listener(XML_TAG_CLICK);
        JavaScriptImpl javaScriptImpl = new JavaScriptImpl(this.getClickJs());
        listener.setAction((JavaScript)javaScriptImpl);
        this.addListener(listener);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG(XML_TAG);
        if (StringUtils.isNotEmpty((String)this.cardLayoutName)) {
            xMLPrintWriter.attr(NAME_TAG, this.cardLayoutName);
        }
        if (this.index != 0) {
            xMLPrintWriter.attr(IDX_TAG, this.index);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals(XML_TAG)) {
                this.cardLayoutName = xMLableReader.getAttrAsString(NAME_TAG, "");
                this.index = xMLableReader.getAttrAsInt(IDX_TAG, 0);
            } else if (string.equals(XML_TAG_INITIAL)) {
                this.setInitialBackground(this.readBackground(xMLableReader));
                this.isCustomStyle = true;
            }
        }
    }
}

