/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.platform.msg.control;

import com.fr.base.FRContext;
import com.fr.base.platform.msg.Message;
import com.fr.base.platform.msg.MessageDataAccessObject;
import com.fr.base.platform.msg.cache.MobileMessageCache;
import com.fr.base.platform.msg.cache.MobileMessageCacheImpl;
import com.fr.base.platform.msg.cache.PCMessageCache;
import com.fr.base.platform.msg.cache.PCMessageCacheImpl;
import com.fr.base.platform.msg.control.TerminalType;
import com.fr.stable.StringUtils;
import java.util.List;

public class MessageCacheControl {
    private static MessageCacheControl ac;

    public static MessageCacheControl getInstance() {
        if (ac == null) {
            ac = new MessageCacheControl();
        }
        return ac;
    }

    public static void registerMessageCache(MessageDataAccessObject messageDataAccessObject) {
        try {
            List list = messageDataAccessObject.findAll();
            for (Message message : list) {
                if (message.isReaded()) continue;
                MessageCacheControl.injectCache(message);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    public static void injectCache(Message message) throws Exception {
        String string = message.getTerminaltype();
        if (StringUtils.isNotEmpty((String)string)) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                MessageCacheControl.injectCacheToDifTerminal(string2, message);
            }
        }
    }

    public static void injectCacheToDifTerminal(String string, Message message) throws Exception {
        if (StringUtils.isNotEmpty((String)string)) {
            TerminalType terminalType = TerminalType.parse(string);
            if (terminalType.equals((Object)TerminalType.PC)) {
                PCMessageCache.injectMessageCache(message);
            } else {
                MobileMessageCache.injectMessageCache(terminalType, message);
            }
        }
    }

    public boolean save(Message message) throws Exception {
        if (message == null) {
            return false;
        }
        String string = message.getType() + message.getId();
        boolean bl = PCMessageCacheImpl.getInstance().cache(string, message);
        boolean bl2 = MobileMessageCacheImpl.getInstance().cache(string, message);
        return bl && bl2;
    }

    public boolean delete(String string) throws Exception {
        boolean bl = PCMessageCacheImpl.getInstance().removeCache(string);
        boolean bl2 = MobileMessageCacheImpl.getInstance().removeCache(string);
        return bl && bl2;
    }

    public boolean updateToasted(String string) throws Exception {
        boolean bl = PCMessageCacheImpl.getInstance().updateToasted(string);
        boolean bl2 = MobileMessageCacheImpl.getInstance().updateToasted(string);
        return bl && bl2;
    }
}

