/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.platform.msg.cache;

import com.fr.base.platform.msg.Message;
import com.fr.base.platform.msg.cache.MessageCacheUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PCMessageCache {
    protected static Map<String, Message> pcListMap = new ConcurrentHashMap<String, Message>();

    public static void injectMessageCache(Message message) {
        String string = message.getType() + message.getId();
        pcListMap.put(string, message);
    }

    public static void clearMessageCache() {
        pcListMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cache(String string, Message message) throws Exception {
        Map<String, Message> map = pcListMap;
        synchronized (map) {
            if (message == null) {
                return false;
            }
            if (pcListMap.containsKey(string)) {
                return false;
            }
            pcListMap.put(string, message);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeCache(String string) throws Exception {
        Map<String, Message> map = pcListMap;
        synchronized (map) {
            Message message = pcListMap.get(string);
            if (message != null) {
                pcListMap.remove(string);
            }
            return true;
        }
    }

    public static Message[] getAllMessages(String string) throws Exception {
        return MessageCacheUtils.getAllMessages(pcListMap, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateToasted(String string) throws Exception {
        Map<String, Message> map = pcListMap;
        synchronized (map) {
            Message message = pcListMap.get(string);
            if (message != null) {
                message.setToasted(true);
            }
            return true;
        }
    }
}

