/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jshx.smgp.server;

import cn.com.jshx.smgp.bean.Deliver;
import cn.com.jshx.smgp.bean.Login;
import cn.com.jshx.smgp.bean.Submit;
import cn.com.jshx.smgp.server.ActiveTestThread;
import cn.com.jshx.smgp.server.ServerHandleConnect;
import cn.com.jshx.smgp.server.inf.ServerEventInterface;
import cn.com.jshx.smgp.server.result.LoginResult;
import cn.com.jshx.smgp.server.result.SubmitResult;
import cn.com.jshx.smgp.server.util.ClientStatus;
import cn.com.jshx.smgp.server.util.GenerateNum;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Vector;

public class Server
extends Thread {
    private int serverPort = 8890;
    private ServerEventInterface serverEventInterface;
    private ServerSocket server;
    private int connectCount = 0;
    private int TimeOut = 900;
    private GenerateNum generateNum = new GenerateNum();
    private HashMap<String, ClientStatus> clientlist = new HashMap();
    private HashMap<String, String> spnum2Account = new HashMap();

    public int getTimeOut() {
        return this.TimeOut;
    }

    public void setTimeOut(int timeOut) {
        this.TimeOut = timeOut;
    }

    public HashMap<String, ClientStatus> getClientlist() {
        return this.clientlist;
    }

    public void setClientlist(HashMap<String, ClientStatus> clientlist) {
        this.clientlist = clientlist;
    }

    public Server(ServerEventInterface serverEventInterface, int port) {
        this.serverEventInterface = serverEventInterface;
        this.serverPort = port;
    }

    @Override
    public void run() {
        try {
            this.server = new ServerSocket(this.serverPort);
            ActiveTestThread activeTestThread = new ActiveTestThread(this);
            activeTestThread.start();
            while (true) {
                Socket clientsocket = this.server.accept();
                ServerHandleConnect serverHandleConnect = new ServerHandleConnect(this, clientsocket, this.TimeOut);
                serverHandleConnect.start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private synchronized void connected(String account, String ipaddress, ServerHandleConnect serverHandleConnect) {
        String key = String.valueOf(account) + "$" + ipaddress;
        System.out.println("IpAddress:" + ipaddress + "," + "Account:" + account + " has connected!");
        if (this.clientlist.get(key) == null) {
            this.clientlist.put(key, new ClientStatus(account, ipaddress, serverHandleConnect));
        } else {
            this.clientlist.get(key).AddNew(serverHandleConnect);
        }
        ++this.connectCount;
    }

    public void SendDeliver(Deliver deliver) {
        boolean havefind = false;
        deliver.MsgID = this.generateNum.GenerateMsgID();
        if (deliver.IsReport == 0) {
            deliver.LinkID = this.generateNum.GenerateLinkID();
        }
        for (String key : this.spnum2Account.keySet()) {
            if (deliver.DestTermID.indexOf(key) < 0) continue;
            havefind = true;
            ClientStatus clientStatus = this.clientlist.get(this.spnum2Account.get(key));
            if (clientStatus == null) continue;
            Vector<ServerHandleConnect> clientv = clientStatus.getServerHandleConnectList();
            ServerHandleConnect tmphanlde = null;
            int i = 0;
            while (i < clientv.size()) {
                if (tmphanlde == null) {
                    tmphanlde = clientv.get(i);
                }
                if (tmphanlde.getLoginMode() == 1) {
                    tmphanlde.SendDeliver(deliver);
                    break;
                }
                if (tmphanlde.getLoginMode() == 2) {
                    tmphanlde = clientv.get(i);
                }
                ++i;
            }
            tmphanlde.SendDeliver(deliver);
        }
        if (!havefind) {
            System.out.println(String.valueOf(deliver.DestTermID) + " is not Connected");
        } else {
            System.out.println("Deliver has Sended to Client!");
        }
    }

    public void disconnect(String account, String ipaddress, ServerHandleConnect serverHandleConnect) {
        String key = String.valueOf(account) + "$" + ipaddress;
        if (this.clientlist.get(key).removeClientConnected(serverHandleConnect)) {
            System.out.println("IpAddress:" + ipaddress + "," + "Account:" + account + " all has disconnected!");
            this.clientlist.remove(key);
        } else {
            System.out.println("IpAddress:" + ipaddress + "," + "Account:" + account + "  has disconnected!");
        }
    }

    public void disconnect(ServerHandleConnect serverHandleConnect) {
        System.out.println("other disconnected");
        serverHandleConnect.stop();
        serverHandleConnect.destroy();
    }

    public LoginResult onLogin(Login login, ServerHandleConnect serverHandleConnect) {
        LoginResult loginresult = this.serverEventInterface.onLogin(login);
        if (loginresult.getStatus() == 0) {
            this.spnum2Account.put(loginresult.getSpNum(), String.valueOf(login.Account) + "$" + login.ipaddress);
            this.connected(login.Account, login.ipaddress, serverHandleConnect);
        }
        return loginresult;
    }

    public SubmitResult onSumit(Submit submit, String account) {
        SubmitResult submitResult = this.serverEventInterface.onSumit(submit, account);
        submitResult.setMsgID(this.generateNum.GenerateMsgID());
        return submitResult;
    }
}

