/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jshx.smgp.pdu;

import cn.com.jshx.smgp.bean.Submit;
import cn.com.jshx.smgp.protocol.TlvId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class WapPushPdu {
    private static byte[] WapPushUdhi = new byte[]{5, 4, 11, -124, 35, -16};
    private static byte[] WapPushHeader2 = new byte[]{37, 6, 10, 3, -82, -127, -22, -81, -126, -115, -39, -76, -124};
    private static byte[] WapPushIndicator;
    private static byte[] WapPushDisplayTextHeader;
    private static byte[] EndOfWapPush;

    static {
        byte[] byArray = new byte[9];
        byArray[0] = 2;
        byArray[1] = 5;
        byArray[2] = 106;
        byArray[4] = 69;
        byArray[5] = -58;
        byArray[6] = 8;
        byArray[7] = 12;
        byArray[8] = 3;
        WapPushIndicator = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[1] = 1;
        byArray2[2] = 3;
        WapPushDisplayTextHeader = byArray2;
        byte[] byArray3 = new byte[3];
        byArray3[1] = 1;
        byArray3[2] = 1;
        EndOfWapPush = byArray3;
    }

    public static Submit[] getWapPushSubmit(String desc, String url, Submit submit) {
        Submit[] arraySubmit = null;
        try {
            byte[] PushBody = WapPushPdu.getWapPushBody(desc, url);
            if (PushBody.length < 128) {
                arraySubmit = new Submit[]{submit};
                arraySubmit[0].AddTlv(TlvId.TP_udhi, "1");
                arraySubmit[0].AddTlv(TlvId.TP_pid, "0");
                arraySubmit[0].setMsgFormat(4);
                arraySubmit[0].setServiceID("WAP");
                arraySubmit[0].AddTlv(TlvId.SubmitMsgType, "1");
                arraySubmit[0].setMsgContent(WapPushPdu.mergeByteArray(WapPushPdu.getWapPushHeader(1, 1), PushBody));
            } else {
                Vector<byte[]> contentArray = WapPushPdu.SplitContent(PushBody);
                arraySubmit = new Submit[contentArray.size()];
                int i = 0;
                while (i < contentArray.size()) {
                    arraySubmit[i] = submit;
                    arraySubmit[i].AddTlv(TlvId.TP_udhi, "1");
                    arraySubmit[i].AddTlv(TlvId.TP_pid, "0");
                    arraySubmit[i].setMsgFormat(4);
                    arraySubmit[i].setServiceID("WAP");
                    arraySubmit[i].AddTlv(TlvId.SubmitMsgType, "1");
                    arraySubmit[i].setMsgContent(WapPushPdu.mergeByteArray(WapPushPdu.getWapPushHeader(contentArray.size(), i + 1), contentArray.get(i)));
                    ++i;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return arraySubmit;
    }

    public static Submit[] getWapPushSubmit(String desc, String url, String srcTermid, String destTermid, String chargeTermid, String productID) {
        Submit[] arraySubmit = null;
        try {
            byte[] PushBody = WapPushPdu.getWapPushBody(desc, url);
            if (PushBody.length < 128) {
                arraySubmit = new Submit[]{new Submit()};
                arraySubmit[0].AddTlv(TlvId.TP_udhi, "1");
                arraySubmit[0].setMsgFormat(4);
                arraySubmit[0].setSrcTermid(srcTermid);
                arraySubmit[0].setChargeTermid(chargeTermid);
                arraySubmit[0].setDestTermid(destTermid);
                arraySubmit[0].setMsgContent(WapPushPdu.mergeByteArray(WapPushPdu.getWapPushHeader(1, 1), PushBody));
                arraySubmit[0].setProductID(productID);
                arraySubmit[0].setMsgType(7);
            } else {
                Vector<byte[]> contentArray = WapPushPdu.SplitContent(PushBody);
                arraySubmit = new Submit[contentArray.size()];
                int i = 0;
                while (i < contentArray.size()) {
                    arraySubmit[i] = new Submit();
                    arraySubmit[i].AddTlv(TlvId.TP_udhi, "1");
                    arraySubmit[i].setMsgFormat(4);
                    arraySubmit[i].setSrcTermid(srcTermid);
                    arraySubmit[i].setChargeTermid(chargeTermid);
                    arraySubmit[i].setDestTermid(destTermid);
                    arraySubmit[i].setMsgContent(WapPushPdu.mergeByteArray(WapPushPdu.getWapPushHeader(contentArray.size(), i + 1), contentArray.get(i)));
                    arraySubmit[i].setProductID(productID);
                    arraySubmit[i].setMsgType(7);
                    ++i;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return arraySubmit;
    }

    private static Vector<byte[]> SplitContent(byte[] content) {
        ByteArrayInputStream buf = new ByteArrayInputStream(content);
        Vector<byte[]> tmpv = new Vector<byte[]>();
        int msgCount = content.length / 128 + 1;
        int LeftLen = content.length;
        int i = 0;
        while (i < msgCount) {
            byte[] tmp = new byte[128];
            if (LeftLen < 128) {
                tmp = new byte[LeftLen];
            }
            try {
                buf.read(tmp);
                tmpv.add(tmp);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            LeftLen -= tmp.length;
            ++i;
        }
        return tmpv;
    }

    public static byte[] getWapPushHeader(int total, int cur) {
        byte[] wappushUdhi = WapPushUdhi;
        byte[] longsmsUdhi = WapPushPdu.getLongSmsUdhi(total, cur);
        int udhiLength = wappushUdhi.length + longsmsUdhi.length;
        byte[] lenHeader = new byte[]{(byte)udhiLength};
        return WapPushPdu.mergeByteArray(lenHeader, WapPushPdu.mergeByteArray(wappushUdhi, longsmsUdhi));
    }

    public static byte[] getWapPushBody(String desc, String url) throws UnsupportedEncodingException {
        return WapPushPdu.mergeByteArray(WapPushPdu.mergeByteArray(WapPushPdu.mergeByteArray(WapPushPdu.mergeByteArray(WapPushPdu.mergeByteArray(WapPushHeader2, WapPushIndicator), url.getBytes("UTF-8")), WapPushDisplayTextHeader), desc.getBytes("UTF-8")), EndOfWapPush);
    }

    private static byte[] mergeByteArray(byte[] by1, byte[] by2) {
        byte[] tmpbyteNew = new byte[by1.length + by2.length];
        System.arraycopy(by1, 0, tmpbyteNew, 0, by1.length);
        System.arraycopy(by2, 0, tmpbyteNew, by1.length, by2.length);
        return tmpbyteNew;
    }

    private static byte[] getLongSmsUdhi(int total, int cur) {
        byte[] byArray = new byte[5];
        byArray[1] = 3;
        byArray[3] = (byte)total;
        byArray[4] = (byte)cur;
        byte[] longSmsUdhi = byArray;
        return longSmsUdhi;
    }
}

