/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.dwrp.ObjectOutboundVariable;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.extend.Property;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;
import org.directwebremoting.util.Messages;

public abstract class BasicObjectConverter
extends BaseV20Converter
implements NamedConverter {
    protected String javascript;
    protected List exclusions = null;
    protected List inclusions = null;
    protected Class instanceType = null;
    protected ConverterManager converterManager = null;
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$convert$BasicObjectConverter == null ? (class$org$directwebremoting$convert$BasicObjectConverter = BasicObjectConverter.class$("org.directwebremoting.convert.BasicObjectConverter")) : class$org$directwebremoting$convert$BasicObjectConverter);
    static /* synthetic */ Class class$org$directwebremoting$convert$BasicObjectConverter;

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws MarshallException {
        String value = iv.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("{")) {
            throw new MarshallException(paramType, Messages.getString("BeanConverter.FormatError", "{"));
        }
        if (!value.endsWith("}")) {
            throw new MarshallException(paramType, Messages.getString("BeanConverter.FormatError", "{"));
        }
        value = value.substring(1, value.length() - 1);
        try {
            Object bean = this.instanceType != null ? this.instanceType.newInstance() : paramType.newInstance();
            if (this.instanceType != null) {
                inctx.addConverted(iv, this.instanceType, bean);
            } else {
                inctx.addConverted(iv, paramType, bean);
            }
            Map properties = this.getPropertyMapFromObject(bean, false, true);
            Map tokens = this.extractInboundTokens(paramType, value);
            Iterator it = tokens.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                Property property = (Property)properties.get(key);
                if (property == null) {
                    log.warn("Missing java bean property to match javascript property: " + key + ". For causes see debug level logs:");
                    log.debug("- The javascript may be refer to a property that does not exist");
                    log.debug("- You may be missing the correct setter: set" + Character.toTitleCase(key.charAt(0)) + key.substring(1) + "()");
                    log.debug("- The property may be excluded using include or exclude rules.");
                    StringBuffer all = new StringBuffer();
                    Iterator pit = properties.keySet().iterator();
                    while (pit.hasNext()) {
                        all.append(pit.next());
                        if (!pit.hasNext()) continue;
                        all.append(',');
                    }
                    log.debug("Fields exist for (" + all + ").");
                    continue;
                }
                Class propType = property.getPropertyType();
                String[] split = ParseUtil.splitInbound(val);
                String splitValue = split[1];
                String splitType = split[0];
                InboundVariable nested = new InboundVariable(iv.getLookup(), null, splitType, splitValue);
                TypeHintContext incc = this.createTypeHintContext(inctx, property);
                Object output = this.converterManager.convertInbound(propType, nested, inctx, incc);
                property.setValue(bean, output);
            }
            return bean;
        }
        catch (MarshallException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MarshallException(paramType, (Throwable)ex);
        }
    }

    protected abstract TypeHintContext createTypeHintContext(InboundContext var1, Property var2);

    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws MarshallException {
        TreeMap<String, OutboundVariable> ovs = new TreeMap<String, OutboundVariable>();
        ObjectOutboundVariable ov = new ObjectOutboundVariable(outctx);
        outctx.put(data, ov);
        try {
            Map properties = this.getPropertyMapFromObject(data, true, false);
            Iterator it = properties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                Property property = (Property)entry.getValue();
                Object value = property.getValue(data);
                OutboundVariable nested = this.getConverterManager().convertOutbound(value, outctx);
                ovs.put(name, nested);
            }
        }
        catch (MarshallException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MarshallException(data.getClass(), (Throwable)ex);
        }
        ov.init(ovs, this.getJavascript());
        return ov;
    }

    public void setExclude(String excludes) {
        if (this.inclusions != null) {
            throw new IllegalArgumentException(Messages.getString("BeanConverter.OnlyIncludeOrExclude"));
        }
        this.exclusions = new ArrayList();
        String toSplit = LocalUtil.replace(excludes, ",", " ");
        StringTokenizer st = new StringTokenizer(toSplit);
        while (st.hasMoreTokens()) {
            String rule = st.nextToken();
            if (rule.startsWith("get")) {
                log.warn("Exclusions are based on property names and not method names. '" + rule + "' starts with 'get' so it looks like a method name and not a property name.");
            }
            this.exclusions.add(rule);
        }
    }

    public void setInclude(String includes) {
        if (this.exclusions != null) {
            throw new IllegalArgumentException(Messages.getString("BeanConverter.OnlyIncludeOrExclude"));
        }
        this.inclusions = new ArrayList();
        String toSplit = LocalUtil.replace(includes, ",", " ");
        StringTokenizer st = new StringTokenizer(toSplit);
        while (st.hasMoreTokens()) {
            String rule = st.nextToken();
            if (rule.startsWith("get")) {
                log.warn("Inclusions are based on property names and not method names. '" + rule + "' starts with 'get' so it looks like a method name and not a property name.");
            }
            this.inclusions.add(rule);
        }
    }

    public void setImplementation(String name) throws ClassNotFoundException {
        this.setInstanceType(LocalUtil.classForName(name));
    }

    public Class getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(Class instanceType) {
        this.instanceType = instanceType;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public ConverterManager getConverterManager() {
        return this.converterManager;
    }

    protected boolean isAllowedByIncludeExcludeRules(String property) {
        String test;
        Iterator it;
        if (this.exclusions != null) {
            it = this.exclusions.iterator();
            while (it.hasNext()) {
                test = (String)it.next();
                if (!property.equals(test)) continue;
                return false;
            }
        }
        if (this.inclusions != null) {
            it = this.inclusions.iterator();
            while (it.hasNext()) {
                test = (String)it.next();
                if (!property.equals(test)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected Map extractInboundTokens(Class paramType, String value) throws MarshallException {
        HashMap<String, String> tokens = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(value, ",");
        int size = st.countTokens();
        for (int i = 0; i < size; ++i) {
            String token = st.nextToken();
            if (token.trim().length() == 0) continue;
            int colonpos = token.indexOf(":");
            if (colonpos == -1) {
                throw new MarshallException(paramType, Messages.getString("BeanConverter.MissingSeparator", ":", token));
            }
            String key = token.substring(0, colonpos).trim();
            String val = token.substring(colonpos + 1).trim();
            tokens.put(key, val);
        }
        return tokens;
    }

    public String getJavascript() {
        return this.javascript;
    }

    public void setJavascript(String javascript) {
        this.javascript = javascript;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

