/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.scatter;

import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.glyph.VanChartLegendGlyph;
import com.fr.plugin.chart.range.LegendType;
import com.fr.plugin.chart.range.glyph.GradualColorDist;
import com.fr.plugin.chart.range.glyph.GradualIntervalConfigGlyph;
import com.fr.plugin.chart.range.glyph.GradualLegendGlyph;
import com.fr.plugin.chart.range.glyph.LegendLabelFormatGlyph;
import com.fr.plugin.chart.range.glyph.SectionColorDist;
import com.fr.plugin.chart.range.glyph.SectionIntervalConfigGlyph;
import com.fr.plugin.chart.range.glyph.SectionLegendGlyph;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.Format;
import java.util.ArrayList;

public class VanChartScatterLegendGlyph
extends VanChartLegendGlyph {
    private static final long serialVersionUID = -4016910054344665740L;
    private static final int PADDING = 5;
    private static final int HEIGHT_GRADUAL = 100;
    private static final int WIDTH_GRADUAL = 15;
    private static final int HEIGHT_BAR = 15;
    private static final int WIDTH_BAR = 10;
    private static final int GAP_LABEL = 5;
    private static final int GAP_ITEM = 5;
    private static final int HEIGHT_ITEM = 25;
    private static final int WIDTH_ITEM = 15;
    private static final String DEFAULT_MIN_LABEL = "0";
    private static final String DEFAULT_MAX_LABEL = "100";
    private LegendType legendType = LegendType.GRADUAL;
    private GradualLegendGlyph gradualLegendGlyph;
    private SectionLegendGlyph sectionLegendGlyph;

    public GradualLegendGlyph getGradualLegendGlyph() {
        return this.gradualLegendGlyph;
    }

    public void setGradualLegendGlyph(GradualLegendGlyph gradualLegendGlyph) {
        this.gradualLegendGlyph = gradualLegendGlyph;
    }

    public SectionLegendGlyph getSectionLegendGlyph() {
        return this.sectionLegendGlyph;
    }

    public void setSectionLegendGlyph(SectionLegendGlyph sectionLegendGlyph) {
        this.sectionLegendGlyph = sectionLegendGlyph;
    }

    public LegendType getLegendType() {
        return this.legendType;
    }

    public void setLegendType(LegendType legendType) {
        this.legendType = legendType;
    }

    private boolean isNormalLegend() {
        return this.legendType == LegendType.ORDINARY;
    }

    private boolean isHorizontalLegend() {
        return this.getPosition() == 3 || this.getPosition() == 1;
    }

    private Format getGradualLabelFormat() {
        return this.gradualLegendGlyph.getLegendLabelFormatGlyph().getFormat();
    }

    private String getGradualMinLabel() {
        Number number = this.gradualLegendGlyph.getGradualIntervalConfigGlyph().getMin();
        return number == null ? DEFAULT_MIN_LABEL : VanChartAttrHelper.getValueStringWithFormat(number.doubleValue(), this.getGradualLabelFormat());
    }

    private String getGradualMaxLabel() {
        Number number = this.gradualLegendGlyph.getGradualIntervalConfigGlyph().getMax();
        return number == null ? DEFAULT_MAX_LABEL : VanChartAttrHelper.getValueStringWithFormat(number.doubleValue(), this.getGradualLabelFormat());
    }

    private ArrayList<GradualColorDist> getGradualColorDist() {
        return this.getGradualLegendGlyph().getGradualIntervalConfigGlyph().getColors();
    }

    private void refreshDistAndColors(ArrayList<GradualColorDist> arrayList, float[] fArray, Color[] colorArray) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            GradualColorDist gradualColorDist = arrayList.get(i);
            fArray[i] = gradualColorDist.getPosition();
            colorArray[i] = gradualColorDist.getColor();
        }
    }

    private Format getIntervalLabelFormat() {
        return this.sectionLegendGlyph.getLegendLabelFormatGlyph().getFormat();
    }

    private ArrayList<SectionColorDist> getIntervalColorDist() {
        return this.getSectionLegendGlyph().getSectionIntervalConfigGlyph().getColors();
    }

    private String getIntervalLabelContent(Number number, Number number2) {
        String string = "";
        if (number != null) {
            string = string + VanChartAttrHelper.getValueStringWithFormat(number.doubleValue(), this.getIntervalLabelFormat());
            string = string + '-';
        }
        if (number2 != null) {
            string = string + VanChartAttrHelper.getValueStringWithFormat(number2.doubleValue(), this.getIntervalLabelFormat());
        }
        return string;
    }

    public void layoutLegendAndRefreshChartBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d, double d2, int n) {
        if (this.isNormalLegend()) {
            super.layoutLegendAndRefreshChartBounds(rectangle2D, rectangle2D2, d, d2, n);
            return;
        }
        double d3 = this.calculateLegendGlyphWidth(rectangle2D2, n);
        double d4 = this.calculateLegendGlyphHeight(rectangle2D2, n);
        double d5 = this.getLegendX(rectangle2D, rectangle2D2, d3 += 10.0);
        double d6 = this.getLegendY(rectangle2D, rectangle2D2, d4 += 10.0);
        this.setLegendBounds(new Rectangle2D.Double(d5, d6, d3, d4));
        this.refreshChartBoundsWithLegendBounds(rectangle2D2, this.getBounds(), d, d2);
    }

    private double getLegendX(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d) {
        if (this.isFloating()) {
            return rectangle2D.getX() + rectangle2D.getWidth() * this.getFloatPercentX() / 100.0;
        }
        if (this.getPosition() == 2) {
            return rectangle2D2.getX();
        }
        if (this.getPosition() == 4 || this.getPosition() == 8) {
            return rectangle2D2.getX() + rectangle2D2.getWidth() - d;
        }
        return rectangle2D2.getX() + (rectangle2D2.getWidth() - d) / 2.0;
    }

    private double getLegendY(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d) {
        if (this.isFloating()) {
            return rectangle2D.getY() + rectangle2D.getHeight() * this.getFloatPercentY() / 100.0;
        }
        if (this.getPosition() == 1) {
            return rectangle2D2.getY();
        }
        if (this.getPosition() == 3) {
            return rectangle2D2.getY() + rectangle2D2.getHeight() - d;
        }
        if (this.getPosition() == 8) {
            return rectangle2D2.getY();
        }
        return rectangle2D2.getY() + (rectangle2D2.getHeight() - d) / 2.0;
    }

    private double calculateLegendGlyphWidth(Rectangle2D rectangle2D, int n) {
        double d;
        double d2 = d = this.legendType == LegendType.GRADUAL ? this.calculateGradualLegendGlyphWidth(n) : this.calculateIntervalLegendGlyphWidth(n);
        if (this.isLimitSize() && !this.isHorizontalLegend()) {
            return Math.min(d, rectangle2D.getWidth() * this.getMaxHeight() / 100.0);
        }
        return d;
    }

    private double calculateGradualLegendGlyphWidth(int n) {
        String string = this.getGradualMinLabel();
        String string2 = this.getGradualMaxLabel();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)new TextAttr(this.getFont()), (int)n);
        Dimension2D dimension2D2 = GlyphUtils.calculateTextDimensionWithNoRotation((String)string2, (TextAttr)new TextAttr(this.getFont()), (int)n);
        double d = Math.max(dimension2D.getWidth(), dimension2D2.getWidth());
        if (this.isHorizontalLegend()) {
            d = Math.max(d, 10.0);
            return 100.0 + d * 2.0;
        }
        return 35.0 + d;
    }

    private double calculateIntervalLegendGlyphWidth(int n) {
        ArrayList<SectionColorDist> arrayList = this.getIntervalColorDist();
        int n2 = arrayList.size();
        if (this.isHorizontalLegend()) {
            double d = 0.0;
            for (int i = 0; i < n2; ++i) {
                SectionColorDist sectionColorDist = arrayList.get(i);
                String string = this.getIntervalLabelContent(sectionColorDist.getFrom(), sectionColorDist.getTo());
                Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)new TextAttr(this.getFont()), (int)n);
                double d2 = (2 * i + 1) * 25 + 2 * i * 5;
                d = Math.max(d, dimension2D.getWidth() - d2);
            }
            return d + (double)(n2 * 25) + (double)((n2 - 1) * 5);
        }
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            SectionColorDist sectionColorDist = arrayList.get(i);
            String string = this.getIntervalLabelContent(sectionColorDist.getFrom(), sectionColorDist.getTo());
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)new TextAttr(this.getFont()), (int)n);
            d = Math.max(d, dimension2D.getWidth());
        }
        return 20.0 + d;
    }

    private double calculateLegendGlyphHeight(Rectangle2D rectangle2D, int n) {
        double d;
        double d2 = d = this.legendType == LegendType.GRADUAL ? this.calculateGradualLegendGlyphHeight(n) : this.calculateIntervalLegendGlyphHeight(n);
        if (this.isLimitSize() && this.isHorizontalLegend()) {
            return Math.min(d, rectangle2D.getHeight() * this.getMaxHeight() / 100.0);
        }
        return d;
    }

    private double calculateGradualLegendGlyphHeight(int n) {
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)DEFAULT_MIN_LABEL, (TextAttr)new TextAttr(this.getFont()), (int)n);
        if (this.isHorizontalLegend()) {
            return 35.0 + dimension2D.getHeight();
        }
        double d = Math.max(0.0, dimension2D.getHeight() - 10.0);
        return 120.0 + d;
    }

    private double calculateIntervalLegendGlyphHeight(int n) {
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)DEFAULT_MIN_LABEL, (TextAttr)new TextAttr(this.getFont()), (int)n);
        if (this.isHorizontalLegend()) {
            return dimension2D.getHeight() + 5.0 + 15.0 + 5.0 + dimension2D.getHeight();
        }
        ArrayList<SectionColorDist> arrayList = this.getIntervalColorDist();
        double d = Math.max(0.0, dimension2D.getHeight() - 10.0);
        return d + (double)(arrayList.size() * 25) + (double)((arrayList.size() - 1) * 5);
    }

    public void draw(Graphics graphics, int n) {
        if (this.isNormalLegend()) {
            super.draw(graphics, n);
            return;
        }
        if (this.visible) {
            this.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Shape shape = graphics2D.getClip();
            graphics2D.clip(this.getBounds());
            graphics2D.translate(this.bounds.getX(), this.bounds.getY());
            if (this.legendType == LegendType.GRADUAL) {
                this.drawGradualLegend(graphics2D, n);
            } else {
                this.drawIntervalLegend(graphics2D, n);
            }
            graphics2D.translate(-this.bounds.getX(), -this.bounds.getY());
            graphics2D.setClip(shape == null ? null : shape.getBounds2D().createIntersection(this.getBounds()));
        }
    }

    private void drawGradualLegend(Graphics2D graphics2D, int n) {
        if (this.isHorizontalLegend()) {
            this.drawHorizontalGradualLegend(graphics2D, n);
        } else {
            this.drawVerticalGradualLegend(graphics2D, n);
        }
    }

    private void drawHorizontalGradualLegend(Graphics2D graphics2D, int n) {
        ArrayList<GradualColorDist> arrayList = this.getGradualColorDist();
        int n2 = (int)(this.getBounds().getWidth() - 100.0) / 2;
        int n3 = 5;
        Point2D.Float float_ = new Point2D.Float(n2, n3);
        Point2D.Float float_2 = new Point2D.Float(100 + n2, n3);
        float[] fArray = new float[arrayList.size()];
        Color[] colorArray = new Color[arrayList.size()];
        this.refreshDistAndColors(arrayList, fArray, colorArray);
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(float_, float_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fillRect(n2, n3, 100, 15);
        graphics2D.setColor(colorArray[0]);
        this.drawGradualLeftBarAndLabel(graphics2D, n2, n3, n);
        graphics2D.setColor(colorArray[arrayList.size() - 1]);
        this.drawGradualRightBarAndLabel(graphics2D, n2, n3, n);
    }

    private void drawGradualLeftBarAndLabel(Graphics2D graphics2D, int n, int n2, int n3) {
        int[] nArray = new int[]{n, n, n - 10, n - 10};
        int[] nArray2 = new int[]{n2 += 15, n2 + 15, n2 + 15, n2 + 5};
        graphics2D.fillPolygon(nArray, nArray2, nArray.length);
        String string = this.getGradualMinLabel();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)new TextAttr(this.getFont()), (int)n3);
        double d = (double)n - dimension2D.getWidth();
        double d2 = n2 + 15;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
        GlyphUtils.drawStrings((Graphics)graphics2D, (String)string, (TextAttr)new TextAttr(this.getFont()), (Rectangle2D)double_, (int)n3);
    }

    private void drawGradualRightBarAndLabel(Graphics2D graphics2D, int n, int n2, int n3) {
        int[] nArray = new int[]{n += 100, n + 10, n + 10, n};
        int[] nArray2 = new int[]{n2 += 15, n2 + 5, n2 + 15, n2 + 15};
        graphics2D.fillPolygon(nArray, nArray2, nArray.length);
        String string = this.getGradualMaxLabel();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)new TextAttr(this.getFont()), (int)n3);
        double d = n2 + 15;
        Rectangle2D.Double double_ = new Rectangle2D.Double(n, d, dimension2D.getWidth(), dimension2D.getHeight());
        GlyphUtils.drawStrings((Graphics)graphics2D, (String)string, (TextAttr)new TextAttr(this.getFont()), (Rectangle2D)double_, (int)n3);
    }

    private void drawVerticalGradualLegend(Graphics2D graphics2D, int n) {
        int n2 = 5;
        int n3 = (int)(this.getBounds().getHeight() - 100.0) / 2;
        Point2D.Float float_ = new Point2D.Float(n2, 100 + n3);
        Point2D.Float float_2 = new Point2D.Float(n2, n3);
        ArrayList<GradualColorDist> arrayList = this.getGradualColorDist();
        float[] fArray = new float[arrayList.size()];
        Color[] colorArray = new Color[arrayList.size()];
        this.refreshDistAndColors(arrayList, fArray, colorArray);
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(float_, float_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fillRect(n2, n3, 15, 100);
        graphics2D.setColor(colorArray[arrayList.size() - 1]);
        this.drawGradualTopBarAndLabel(graphics2D, n2, n3, n);
        graphics2D.setColor(colorArray[0]);
        this.drawGradualBottomBarAndLabel(graphics2D, n2, n3, n);
    }

    private void drawGradualTopBarAndLabel(Graphics2D graphics2D, int n, int n2, int n3) {
        int[] nArray = new int[]{n += 15, n + 5, n + 15, n + 15};
        int[] nArray2 = new int[]{n2, n2 - 10, n2 - 10, n2};
        graphics2D.fillPolygon(nArray, nArray2, nArray.length);
        String string = this.getGradualMaxLabel();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)new TextAttr(this.getFont()), (int)n3);
        double d = n + 15 + 5;
        double d2 = (double)(n2 - 5) - dimension2D.getHeight() / 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
        GlyphUtils.drawStrings((Graphics)graphics2D, (String)string, (TextAttr)new TextAttr(this.getFont()), (Rectangle2D)double_, (int)n3);
    }

    private void drawGradualBottomBarAndLabel(Graphics2D graphics2D, int n, int n2, int n3) {
        int[] nArray = new int[]{n += 15, n + 15, n + 15, n + 5};
        int[] nArray2 = new int[]{n2 += 100, n2, n2 + 10, n2 + 10};
        graphics2D.fillPolygon(nArray, nArray2, nArray.length);
        String string = this.getGradualMinLabel();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)new TextAttr(this.getFont()), (int)n3);
        double d = n + 15 + 5;
        double d2 = (double)(n2 + 5) - dimension2D.getHeight() / 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
        GlyphUtils.drawStrings((Graphics)graphics2D, (String)string, (TextAttr)new TextAttr(this.getFont()), (Rectangle2D)double_, (int)n3);
    }

    private void drawIntervalLegend(Graphics2D graphics2D, int n) {
        if (this.isHorizontalLegend()) {
            this.drawHorizontalIntervalLegend(graphics2D, n);
        } else {
            this.drawVerticalIntervalLegend(graphics2D, n);
        }
    }

    private void drawHorizontalIntervalLegend(Graphics2D graphics2D, int n) {
        ArrayList<SectionColorDist> arrayList = this.getIntervalColorDist();
        int n2 = arrayList.size();
        double d = (this.getBounds().getWidth() - (double)(n2 * 25) - (double)((n2 - 1) * 5)) / 2.0;
        for (int i = 0; i < n2; ++i) {
            SectionColorDist sectionColorDist = arrayList.get(i);
            String string = this.getIntervalLabelContent(sectionColorDist.getFrom(), sectionColorDist.getTo());
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)new TextAttr(this.getFont()), (int)n);
            double d2 = 5.0;
            double d3 = d2 + dimension2D.getHeight() + 5.0;
            double d4 = d3 + 15.0 + 5.0;
            Color color = sectionColorDist.getColor();
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(d, d3, 25.0, 15.0, 2.0, 2.0);
            graphics2D.setColor(color);
            graphics2D.fill(double_);
            double d5 = i % 2 == 0 ? d2 : d4;
            double d6 = d - (dimension2D.getWidth() - 25.0) / 2.0;
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d6, d5, dimension2D.getWidth(), dimension2D.getHeight());
            GlyphUtils.drawStrings((Graphics)graphics2D, (String)string, (TextAttr)new TextAttr(this.getFont()), (Rectangle2D)double_2, (int)n);
            d += 30.0;
        }
    }

    private void drawVerticalIntervalLegend(Graphics2D graphics2D, int n) {
        ArrayList<SectionColorDist> arrayList = this.getIntervalColorDist();
        int n2 = arrayList.size();
        double d = 5.0;
        double d2 = 25.0;
        double d3 = (this.getBounds().getHeight() - (double)(n2 * 25) - (double)((n2 - 1) * 5)) / 2.0;
        for (int i = n2; i > 0; --i) {
            SectionColorDist sectionColorDist = arrayList.get(i - 1);
            String string = this.getIntervalLabelContent(sectionColorDist.getFrom(), sectionColorDist.getTo());
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)new TextAttr(this.getFont()), (int)n);
            Color color = sectionColorDist.getColor();
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(d, d3, 15.0, 25.0, 2.0, 2.0);
            graphics2D.setColor(color);
            graphics2D.fill(double_);
            double d4 = d3 - (dimension2D.getHeight() - 25.0) / 2.0;
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d2, d4, dimension2D.getWidth(), dimension2D.getHeight());
            GlyphUtils.drawStrings((Graphics)graphics2D, (String)string, (TextAttr)new TextAttr(this.getFont()), (Rectangle2D)double_2, (int)n);
            d3 += 30.0;
        }
    }

    @Override
    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        switch (this.getLegendType()) {
            case GRADUAL: {
                GradualLegendGlyph gradualLegendGlyph = this.getGradualLegendGlyph();
                GradualIntervalConfigGlyph gradualIntervalConfigGlyph = gradualLegendGlyph.getGradualIntervalConfigGlyph();
                LegendLabelFormatGlyph legendLabelFormatGlyph = gradualLegendGlyph.getLegendLabelFormatGlyph();
                jSONObject.put("range", (Object)gradualIntervalConfigGlyph.toJSONObject(repository));
                legendLabelFormatGlyph.addToJSONObject(jSONObject, repository);
                break;
            }
            case SECTION: {
                SectionLegendGlyph sectionLegendGlyph = this.getSectionLegendGlyph();
                SectionIntervalConfigGlyph sectionIntervalConfigGlyph = sectionLegendGlyph.getSectionIntervalConfigGlyph();
                LegendLabelFormatGlyph legendLabelFormatGlyph = sectionLegendGlyph.getLegendLabelFormatGlyph();
                sectionIntervalConfigGlyph.addToJSONObject(jSONObject, repository);
                if (legendLabelFormatGlyph.isCommonValueFormat()) {
                    if (legendLabelFormatGlyph.getFormat() == null) break;
                    jSONObject.put("formatter", (Object)VanChartAttrHelper.getIntervalLegendFormatFunction(legendLabelFormatGlyph.getFormat()));
                    break;
                }
                legendLabelFormatGlyph.getHtmlLabel().addToJSONObject(jSONObject);
                break;
            }
        }
        return jSONObject;
    }

    @Override
    public void addLegendJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        switch (this.getLegendType()) {
            case ORDINARY: {
                jSONObject.put("legend", (Object)super.toJSONObject(repository));
                break;
            }
            default: {
                jSONObject.put("rangeLegend", (Object)this.toJSONObject(repository));
            }
        }
    }
}

