/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.radar;

import com.fr.chart.chartattr.Plot;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.mainframe.chart.gui.ChartStylePane;
import com.fr.general.Inter;
import com.fr.plugin.chart.designer.TableLayout4VanChartHelper;
import com.fr.plugin.chart.designer.component.VanChartLineTypePane;
import com.fr.plugin.chart.designer.component.VanChartLineWidthPane;
import com.fr.plugin.chart.designer.style.series.VanChartAbstractPlotSeriesPane;
import com.fr.plugin.chart.radar.RadarType;
import com.fr.plugin.chart.radar.VanChartRadarPlot;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class VanChartRadarSeriesPane
extends VanChartAbstractPlotSeriesPane {
    private static final long serialVersionUID = 6766916711435248193L;
    private UIButtonGroup<String> radarType;

    public VanChartRadarSeriesPane(ChartStylePane chartStylePane, Plot plot) {
        super(chartStylePane, plot);
    }

    protected JPanel getContentInPlotType() {
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d, d, d, d, d, d};
        double[] dArray2 = new double[]{d2};
        this.contentPane = TableLayoutHelper.createTableLayoutPane((Component[][])this.getPaneComponents(), (double[])dArray, (double[])dArray2);
        return this.contentPane;
    }

    private Component[][] getPaneComponents() {
        if (this.plot instanceof VanChartRadarPlot && ((VanChartRadarPlot)this.plot).isStackChart()) {
            return new Component[][]{{this.createRadarTypePane()}, {new JSeparator()}, {this.createBorderPane()}, {new JSeparator()}, {this.createAlphaPane()}};
        }
        return new Component[][]{{this.createRadarTypePane()}, {new JSeparator()}, {this.createLineTypePane()}, {new JSeparator()}, {this.createMarkerPane()}, {new JSeparator()}, {this.createAreaFillColorPane()}};
    }

    private JPanel createRadarTypePane() {
        this.radarType = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_Circle"), Inter.getLocText((String)"Plugin-ChartF_Polygonal")}, (Object[])new String[]{RadarType.CIRCLE.getType(), RadarType.POLYGON.getType()});
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"FR-Chart-Style_Present"), this.radarType);
    }

    @Override
    protected VanChartLineTypePane getLineTypePane() {
        return new VanChartLineWidthPane();
    }

    @Override
    public void populateBean(Plot plot) {
        if (plot == null) {
            return;
        }
        super.populateBean(plot);
        if (plot instanceof VanChartRadarPlot) {
            VanChartRadarPlot vanChartRadarPlot = (VanChartRadarPlot)plot;
            this.radarType.setSelectedItem((Object)vanChartRadarPlot.getRadarType().getType());
        }
    }

    @Override
    public void updateBean(Plot plot) {
        if (plot == null) {
            return;
        }
        super.updateBean(plot);
        if (plot instanceof VanChartRadarPlot) {
            VanChartRadarPlot vanChartRadarPlot = (VanChartRadarPlot)plot;
            vanChartRadarPlot.setRadarType(RadarType.parse((String)this.radarType.getSelectedItem()));
        }
    }
}

