/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.radar;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.plugin.chart.area.VanChartAreaPlot;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.VanChartPlotType;
import com.fr.plugin.chart.attr.axis.VanChartValueAxis;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.glyph.axis.VanChartRadarAxisGlyph;
import com.fr.plugin.chart.radar.RadarType;
import com.fr.plugin.chart.radar.VanChartRadarDataPoint;
import com.fr.plugin.chart.radar.VanChartRadarPlotGlyph;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class VanChartRadarPlot
extends VanChartAreaPlot {
    private static final long serialVersionUID = -3224547323399182733L;
    public static final String VAN_CHART_RADAR_PLOT = "VanChartRadarPlot";
    private RadarType radarType = RadarType.CIRCLE;
    private static final String[] CATE_NAME = new String[]{"speed", "judgment", "calculation", "precision", "observation", "memory"};
    private static final Object[] SERIES_NAME = new Object[]{"michael", "Hepburn"};
    private static final Object[][] VALUE = new Object[][]{{"40", "45", "35", "55", "35", "45"}, {"35", "40", "35", "45", "33", "37"}};
    private static final NormalChartData RADAR_DATA = new NormalChartData((Object[])CATE_NAME, SERIES_NAME, VALUE);

    public void setRadarType(RadarType radarType) {
        this.radarType = radarType;
    }

    public RadarType getRadarType() {
        return this.radarType;
    }

    public VanChartRadarPlot() {
    }

    public VanChartRadarPlot(VanChartPlotType vanChartPlotType) {
        super(vanChartPlotType);
    }

    @Override
    protected void initXYAxisList() {
        this.xAxisList = VanChartAttrHelper.createRadarXAxisList();
        this.yAxisList = VanChartAttrHelper.createRadarYAxisList();
    }

    @Override
    public boolean isCustomChart() {
        return false;
    }

    @Override
    public PlotGlyph createPlotGlyph(ChartData chartData) {
        VanChartRadarPlotGlyph vanChartRadarPlotGlyph = new VanChartRadarPlotGlyph();
        this.install4PlotGlyph(vanChartRadarPlotGlyph, chartData);
        this.installAxisGlyph(vanChartRadarPlotGlyph, chartData);
        return vanChartRadarPlotGlyph;
    }

    @Override
    protected DataPoint createDataPoint() {
        return new VanChartRadarDataPoint(this.isStackChart());
    }

    public void install4PlotGlyph(VanChartRadarPlotGlyph vanChartRadarPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(vanChartRadarPlotGlyph, chartData);
        vanChartRadarPlotGlyph.setRadarType(this.radarType);
        vanChartRadarPlotGlyph.setColumnType(this.isStackChart());
    }

    public void installAxisGlyph(VanChartRadarPlotGlyph vanChartRadarPlotGlyph, ChartData chartData) {
        VanChartRadarAxisGlyph vanChartRadarAxisGlyph = new VanChartRadarAxisGlyph(chartData, this.getDefaultXAxis(), (VanChartValueAxis)this.getDefaultYAxis(), this.getRadarType());
        vanChartRadarPlotGlyph.setRadarAxisGlyph(vanChartRadarAxisGlyph);
        vanChartRadarPlotGlyph.addXAxisGlyph(vanChartRadarAxisGlyph.getDataSeriesCateAxisGlyph());
        vanChartRadarPlotGlyph.addYAxisGlyph(vanChartRadarAxisGlyph.getDataSeriesValueAxisGlyph());
    }

    @Override
    protected void dealDataSeriesCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        this.dealDataSeriesAttrBackgroundCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrLineCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrMarkerCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrFillColorBackgroundCustomCondition(vanChartDataSeries, conditionCollection);
    }

    @Override
    public ChartData defaultChartData() {
        return RADAR_DATA;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof VanChartRadarPlot && super.equals(object) && ComparatorUtils.equals((Object)((Object)((VanChartRadarPlot)object).getRadarType()), (Object)((Object)this.getRadarType()));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        VanChartRadarPlot vanChartRadarPlot = (VanChartRadarPlot)super.clone();
        vanChartRadarPlot.setRadarType(this.getRadarType());
        return vanChartRadarPlot;
    }

    @Override
    protected void readPlotXML(XMLableReader xMLableReader) {
        String string;
        super.readPlotXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("VanChartRadarPlotAttr")) {
            this.radarType = RadarType.parse(xMLableReader.getAttrAsString("radarType", RadarType.CIRCLE.getType()));
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("VanChartRadarPlotAttr").attr("radarType", this.radarType.getType()).end();
    }

    @Override
    public boolean isSupportTrendLine() {
        return false;
    }

    @Override
    public boolean isSupportDataSheet() {
        return false;
    }

    @Override
    public boolean isSupportZoomCategoryAxis() {
        return false;
    }

    @Override
    public boolean isSupportZoomDirection() {
        return false;
    }

    @Override
    public boolean isSupportBorder() {
        return false;
    }

    @Override
    public boolean matchPlotType(Plot plot) {
        return plot instanceof VanChartRadarPlot;
    }

    @Override
    public String getPlotID() {
        return VAN_CHART_RADAR_PLOT;
    }

    @Override
    public String getPlotName() {
        return Inter.getLocText((String)"Plugin-ChartF_NewRadar");
    }

    @Override
    public boolean accept(Class<? extends Plot> clazz) {
        return ComparatorUtils.equals(clazz, VanChartRadarPlot.class);
    }

    @Override
    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.RADAR_VAN_CHART;
    }
}

