/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.glyph.axis;

import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Utils;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.general.FRLogger;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.glyph.axis.VanChartBaseAxisGlyph;
import com.fr.stable.web.Repository;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class VanChartValueAxisGlyph
extends VanChartBaseAxisGlyph {
    private static final double TICK_INTERVAL = 0.25;
    private static final double DIV_4_SECOND = 5.0;
    private static final double LABEL_WIDTH = 8.0;
    protected static final double LOG_MIN = 1.0E-10;
    private static final double BASE_LOG = 10.0;
    private boolean isPercentage = false;
    private boolean isLog = false;
    private double logBase = 10.0;

    public void setPercentage(boolean bl) {
        this.isPercentage = bl;
    }

    public boolean isPercentage() {
        return this.isPercentage;
    }

    public void setLogBase(double d) {
        this.logBase = d;
    }

    public double getLogBase() {
        return this.logBase;
    }

    public void setLog(boolean bl) {
        this.isLog = bl;
    }

    public boolean isLog() {
        return this.isLog;
    }

    public VanChartValueAxisGlyph() {
        if (this.format == null) {
            this.format = VanChartAttrHelper.VALUE_FORMAT;
        }
    }

    public String getJSAxisType() {
        return "value";
    }

    public String getAxisName() {
        return "ValueAxis";
    }

    public double getCrossValueInPlot() {
        if (this.isLog()) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double getObjectValue(Object object) {
        Number number = Utils.objectToNumber((Object)object, (boolean)true);
        if (number != null) {
            return number.doubleValue();
        }
        return this.getCrossValue();
    }

    @Override
    public Object getObjectFromFormula(Formula formula) {
        if (formula == null) {
            return null;
        }
        if (formula.getResult() == null) {
            return ChartBaseUtils.formula2Number((Formula)formula);
        }
        return formula.getResult();
    }

    public Point2D getPointInBounds(double d) {
        if (!this.isLog() || !(this.getCrossValue() > 0.0)) {
            if (d < this.getCrossValue()) {
                d = this.getCrossValue();
            }
            if (d > this.getArrowValue()) {
                d = this.getArrowValue();
            }
        }
        return this.getPoint2D(d);
    }

    @Override
    public Point2D getPoint2D(double d) {
        double d2;
        if (this.isLog() && this.getCrossValue() > 0.0) {
            if (d <= 1.0E-10) {
                d = this.getCrossValue();
            }
            d = (Math.log(d) - Math.log(this.getCrossValue())) / Math.log(this.getMainUnit());
        } else {
            d -= this.getCrossValue();
        }
        double d3 = this.unitLength * d;
        double d4 = this.hasAxisReversed() ? d3 : -d3;
        double d5 = d2 = this.hasAxisReversed() ? -d3 : d3;
        if (this.getPosition() == 2 || this.getPosition() == 4) {
            return new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() + d4);
        }
        if (this.getPosition() == 3 || this.getPosition() == 1) {
            return new Point2D.Double(this.originPoint.getX() + d2, this.originPoint.getY());
        }
        if (this.isXAxis) {
            return new Point2D.Double(this.originPoint.getX() + d2, this.originPoint.getY());
        }
        return new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() + d4);
    }

    public double getPreLeftWidth4DataSheet(int n) {
        this.calculateTitleDimesion(n);
        if (this.position == 2) {
            return this.getMaxLabelWidthAndInitStartEndLabelDim(n) + this.titleDim.getWidth() + this.getTickLengthShow();
        }
        return 0.0;
    }

    private double getMaxLabelWidth(int n) {
        if (!this.isShowAxisLabel) {
            return 0.0;
        }
        double d = 8.0;
        List list = this.getAxisLabelDimList(n);
        if (list == null || list.isEmpty()) {
            return d;
        }
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Dimension2D dimension2D = (Dimension2D)list.get(i);
            double d2 = this.shouldBeHeight() ? dimension2D.getWidth() : dimension2D.getHeight();
            d = d2 < d ? d : d2;
        }
        return d;
    }

    protected double getMaxLabelWidthAndInitStartEndLabelDim(int n) {
        if (!this.isShowAxisLabel) {
            return 0.0;
        }
        double d = 8.0;
        List list = this.getAxisLabelDimList(n);
        if (list == null || list.isEmpty()) {
            return d;
        }
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Dimension2D dimension2D = (Dimension2D)list.get(i);
            double d2 = this.shouldBeHeight() ? dimension2D.getHeight() : dimension2D.getWidth();
            double d3 = d = d2 < d ? d : d2;
            if (i == 0) {
                this.startLabelDim = dimension2D;
            }
            if (i != n2 - 1) continue;
            this.endLabelDim = dimension2D;
        }
        return d;
    }

    private List getAxisLabelDimList(int n) {
        BigDecimal bigDecimal = this.getBigDecimalMainUnit();
        if (bigDecimal.doubleValue() <= 0.0) {
            return null;
        }
        ArrayList<Dimension2D> arrayList = new ArrayList<Dimension2D>();
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(this.minValue));
        if (this.isLog() && this.minValue == 0.0) {
            this.minValue = 1.0;
        }
        bigDecimal = this.checkIncrementNotTooSmall(bigDecimal, this.maxValue - this.minValue);
        double d = this.minValue;
        while (d <= this.maxValue) {
            Dimension2D dimension2D = this.getAxisLabelDim(this.value2String(bigDecimal2.doubleValue()), n);
            arrayList.add(dimension2D);
            bigDecimal2 = this.isLog() ? bigDecimal2.multiply(bigDecimal) : bigDecimal2.add(bigDecimal);
            d = this.isLog() ? d * bigDecimal.doubleValue() : d + bigDecimal.doubleValue();
        }
        return arrayList;
    }

    private BigDecimal checkIncrementNotTooSmall(BigDecimal bigDecimal, double d) {
        BigDecimal bigDecimal2;
        if (!this.isLog() && (bigDecimal2 = bigDecimal.multiply(new BigDecimal(1000))).doubleValue() < d) {
            return new BigDecimal(this.getTickSamplingTime());
        }
        return bigDecimal;
    }

    public void calculateAxisLengthUnit() {
        if (this.isLog()) {
            this.unitLength = this.axisLength / (Math.log(this.maxValue) / Math.log(this.getMainUnit()) - Math.log(this.minValue) / Math.log(this.getMainUnit()));
        } else if (this.maxValue - this.minValue > 0.0) {
            this.unitLength = this.axisLength / (this.maxValue - this.minValue);
        }
    }

    public double getCrossValue() {
        return this.minValue;
    }

    public double getArrowValue() {
        return this.maxValue;
    }

    public void initMinMaxValue(double d, double d2) {
        this.initMinMaxValue(d, d2, false);
    }

    @Override
    public void initMinMaxValue(double d, double d2, boolean bl) {
        try {
            this.calculateNiceDomain(d, d2, bl);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            this.setMinValue(d);
            this.setMaxValue(d2);
            this.setMainUnit(new BigDecimal((d2 - d) / this.getDefaultTickCount()));
        }
        if (!this.isCustomSecUnit()) {
            this.setSecUnit(this.getMainUnit() / 5.0);
        }
    }

    protected void calculateNiceDomain(double d, double d2, boolean bl) {
        if (this.isLog()) {
            this.calculateLogNiceDomain(d, d2);
        } else if (this.isPercentage()) {
            this.calculatePercentValueDomain();
        } else {
            this.calculateValueNiceDomain(bl, d, d2);
        }
    }

    private void calculateLogNiceDomain(double d, double d2) {
        double d3;
        double d4 = d3 = this.getLogBase();
        if (this.isCustomMainUnit()) {
            d4 = (int)this.getMainUnit();
        }
        d = d >= 1.0 ? 1.0 : d;
        double d5 = d = d <= 0.0 ? 1.0 : d;
        if (this.isCustomMinValue) {
            d = this.getMinValue();
        }
        if (this.isCustomMaxValue) {
            d2 = this.getMaxValue();
        }
        d = Math.pow(d3, Math.floor(Math.log(d) / Math.log(d3)));
        d2 = Math.pow(d3, Math.ceil(Math.log(d2) / Math.log(d3)));
        this.setMinMaxTickInterval(d, d2, d4);
    }

    private void calculatePercentValueDomain() {
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 0.25;
        if (this.isCustomMinValue) {
            d = this.getMinValue();
        }
        if (this.isCustomMaxValue) {
            d2 = this.getMaxValue();
        }
        if (this.isCustomMainUnit()) {
            d3 = this.getMainUnit();
        }
        this.setMinMaxTickInterval(d, d2, d3);
        this.setNiceMinValue(d);
        this.setNiceMaxValue(d2);
    }

    private void calculateValueNiceDomain(boolean bl, double d, double d2) {
        this.calculateValueTimeNiceDomain(true, bl, d, d2);
    }

    public int getTickSamplingTime() {
        int n = 1;
        double d = (this.getMaxValue() - this.getMinValue()) / this.mainUnit.doubleValue();
        if (this.isLog()) {
            double d2 = Math.abs(this.getMaxValue() - this.getMinValue());
            int n2 = 0;
            double d3 = 10.0;
            if (this.mainUnit.doubleValue() >= 0.0) {
                d3 = this.mainUnit.doubleValue();
            }
            while (Math.pow(d3, n2) < d2) {
                if (Math.pow(d3, n2 + 1) > d2) {
                    d = n2;
                    break;
                }
                ++n2;
            }
        }
        while (this.axisLength > 1.0 && this.axisLength / Math.ceil(d / (double)n) < 1.0) {
            ++n;
        }
        return n;
    }

    protected Rectangle2D getLabelBounds(double d, double d2, String string, int n) {
        if (this.getCubic() == null) {
            return super.getLabelBounds(d, d2, string, n);
        }
        if (this.plotLastBounds == null) {
            return null;
        }
        Rectangle2D.Double double_ = null;
        Point2D point2D = this.getPoint2D(d + d2);
        TextAttr textAttr = this.getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation((String)string, (TextAttr)textAttr, (int)n);
        int n2 = this.getPosition();
        double d3 = dimension2D.getHeight();
        double d4 = dimension2D.getWidth();
        if (n2 == 2 || n2 == 4) {
            double_ = new Rectangle2D.Double(point2D.getX() - this.getBounds().getWidth() / 2.0 - d4 / 2.0, point2D.getY() - d3 / 2.0, d4, d3);
        } else if (n2 == 3) {
            double_ = new Rectangle2D.Double(point2D.getX() - d4 / 2.0, point2D.getY() + this.bounds.getHeight() / 2.0 - d3 / 2.0, d4, d3);
        }
        return double_;
    }

    protected void drawTicks(Graphics graphics, int n) {
        if (this.axisLength <= 1.0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 0);
        int n2 = this.getTickSamplingTime();
        if (this.isLog()) {
            this.drawTicks4Log(graphics2D, basicStroke);
        } else if (this.maxValue > this.minValue && this.getMainUnit() > 0.0 && this.getSecUnit() > 0.0) {
            this.drawTicks4General(graphics2D, basicStroke, n2);
        }
        this.drawTickLable(graphics, n);
    }

    protected void drawTickLable(Graphics graphics, int n) {
        if (this.axisLength <= 1.0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n2 = this.getLabelNumber() > 0 ? this.getLabelNumber() : this.getTickSamplingTime();
        BigDecimal bigDecimal = this.getBigDecimalMainUnit();
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(n2));
        if (this.isLog()) {
            this.drawLabel4Log(graphics, bigDecimal, bigDecimal2, n);
        } else if (this.maxValue > this.minValue && this.getMainUnit() > 0.0 && this.getSecUnit() > 0.0) {
            this.drawLabel4General(graphics, bigDecimal, bigDecimal2, n);
        }
    }

    private void drawTicks4Log(Graphics graphics, BasicStroke basicStroke) {
        double d;
        if (this.getMainUnit() > 1.0) {
            d = this.getCrossValue();
            double d2 = Math.log(d) / Math.log(this.getMainUnit());
            while (d <= this.maxValue) {
                Line2D line2D = this.getTickLine(d, 5, this.getMainTickLine());
                this.drawTickLine(graphics, line2D, basicStroke);
                d = Math.exp((d2 += 1.0) * Math.log(this.getMainUnit()));
            }
        }
        if (this.getSecUnit() > 1.0) {
            d = this.getCrossValue();
            int n = 0;
            while (d <= this.maxValue) {
                Line2D line2D = this.getTickLine(d, 3, this.getSecTickLine());
                this.drawTickLine(graphics, line2D, basicStroke);
                d += (double)n;
                ++n;
            }
        }
    }

    private void drawTicks4General(Graphics graphics, BasicStroke basicStroke, int n) {
        Line2D line2D;
        double d;
        double d2 = this.getMainUnit() * (double)n;
        double d3 = Math.min(this.maxValue, this.niceMaxValue);
        for (d = this.niceMinValue + d2; d <= d3; d += d2) {
            line2D = this.getTickLine(d, 5, this.getMainTickLine());
            this.drawTickLine(graphics, line2D, basicStroke);
        }
        if (this.maxValue != this.niceMaxValue) {
            Line2D line2D2 = this.getTickLine(this.maxValue, 5, this.getMainTickLine());
            this.drawTickLine(graphics, line2D2, basicStroke);
        }
        if (n <= 1) {
            for (d = this.niceMinValue + this.getMainUnit(); d > this.minValue; d -= this.getSecUnit()) {
                line2D = this.getTickLine(d, 3, this.getSecTickLine());
                this.drawTickLine(graphics, line2D, basicStroke);
            }
            for (d = this.niceMinValue + this.getMainUnit(); d <= this.maxValue; d += this.getSecUnit()) {
                line2D = this.getTickLine(d, 3, this.getSecTickLine());
                this.drawTickLine(graphics, line2D, basicStroke);
            }
        }
    }

    private void drawLabel4Log(Graphics graphics, BigDecimal bigDecimal, BigDecimal bigDecimal2, int n) {
        if (this.getMainUnit() > 1.0) {
            BigDecimal bigDecimal3 = new BigDecimal(Double.toString(this.getCrossValue()));
            BigDecimal bigDecimal4 = new BigDecimal(Math.pow(bigDecimal.doubleValue(), bigDecimal2.doubleValue()));
            double d = this.getCrossValue();
            while (d <= this.maxValue) {
                this.drawLabel(graphics, d, 0.0, this.value2String(bigDecimal3.doubleValue()), n);
                bigDecimal3 = bigDecimal4.multiply(bigDecimal3);
                d = bigDecimal3.doubleValue();
            }
        }
    }

    private void drawLabel4General(Graphics graphics, BigDecimal bigDecimal, BigDecimal bigDecimal2, int n) {
        Object object;
        Object object2;
        GeneralPath generalPath = new GeneralPath();
        BigDecimal bigDecimal3 = new BigDecimal(Double.toString(this.minValue));
        if (this.isCustomMinValue) {
            object2 = new BigDecimal(Double.toString(this.getMinValue()));
            object = bigDecimal3.subtract(bigDecimal);
            while (((BigDecimal)object).compareTo((BigDecimal)object2) > 0) {
                bigDecimal3 = object;
            }
            while (bigDecimal3.compareTo((BigDecimal)object2) < 0) {
                bigDecimal3 = bigDecimal3.add(bigDecimal);
            }
        }
        if (this.minValue != this.niceMinValue || !this.isCustomMinValue) {
            object2 = this.value2String(bigDecimal3.doubleValue());
            this.drawLabel(graphics, this.minValue, 0.0, (String)object2, generalPath, n);
        }
        object2 = new BigDecimal(Double.toString(Math.min(this.maxValue, this.niceMaxValue)));
        bigDecimal3 = new BigDecimal(Double.toString(this.niceMinValue));
        bigDecimal3 = bigDecimal3.add(bigDecimal.multiply(bigDecimal2));
        while (bigDecimal3.compareTo((BigDecimal)object2) <= 0) {
            object = this.value2String(bigDecimal3.doubleValue());
            this.drawLabel(graphics, bigDecimal3.doubleValue(), 0.0, (String)object, generalPath, n);
            bigDecimal3 = bigDecimal3.add(bigDecimal.multiply(bigDecimal2));
        }
        if (this.maxValue != this.niceMaxValue) {
            object = this.value2String(this.maxValue);
            this.drawLabel(graphics, this.maxValue, 0.0, (String)object, generalPath, n);
        }
    }

    public void drawAxisGrid(Graphics graphics) {
        if (this.axisLength <= 1.0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getMainGridStyle() != 0 && this.getMainUnit() > 0.0 && this.getMainGridColor() != null) {
            int n = this.getTickSamplingTime();
            this.drawMainGridLine(graphics2D, n);
        }
    }

    private void drawMainGridLine(Graphics2D graphics2D, int n) {
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.getMainGridColor());
        graphics2D.setStroke(GraphHelper.getStroke((int)this.getMainGridStyle()));
        if (this.isLog()) {
            this.drawMainGridLineWithLog(graphics2D);
        } else {
            this.drawMainGridLineWithGeneral(graphics2D, n);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    private void drawMainGridLineWithLog(Graphics2D graphics2D) {
        if (this.getMainUnit() > 1.0) {
            double d = this.getCrossValue();
            double d2 = Math.log(d) / Math.log(this.getMainUnit());
            while (d <= this.maxValue) {
                this.drawMainGridLineWithValue(graphics2D, d);
                d = Math.exp((d2 += 1.0) * Math.log(this.getMainUnit()));
            }
        }
    }

    private void drawMainGridLineWithGeneral(Graphics2D graphics2D, int n) {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(this.niceMinValue));
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(this.getMainUnit() * (double)n));
        BigDecimal bigDecimal3 = new BigDecimal(Double.toString(Math.min(this.niceMaxValue, this.maxValue)));
        bigDecimal = bigDecimal.add(bigDecimal2);
        while (bigDecimal.compareTo(bigDecimal3) <= 0) {
            this.drawMainGridLineWithValue(graphics2D, bigDecimal.doubleValue());
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
        if (this.maxValue != this.niceMaxValue) {
            this.drawMainGridLineWithValue(graphics2D, this.maxValue);
        }
    }

    protected void drawMainGridLineWithValue(Graphics2D graphics2D, double d) {
        Line2D[] line2DArray;
        for (Line2D line2D : line2DArray = this.getGridLine(d)) {
            graphics2D.draw(line2D);
        }
    }

    @Override
    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        if (this.isLog()) {
            jSONObject.put("log", this.getLogBase());
        }
        return jSONObject;
    }
}

