/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.glyph.axis;

import com.fr.base.GraphHelper;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.axis.TimeType;
import com.fr.plugin.chart.glyph.axis.VanChartBaseAxisGlyph;
import com.fr.stable.web.Repository;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

public class VanChartTimeAxisGlyph
extends VanChartBaseAxisGlyph {
    private static final double FIVE = 5.0;
    private static final double LABEL_WIDTH = 8.0;
    private static final double MONTHDAY = 30.0;
    private static final double YEARDAY = 365.0;
    private TimeType mainType = TimeType.TIME_SECOND;
    private TimeType secondType = TimeType.TIME_SECOND;
    private Format defaultFormat;

    public void setMainType(TimeType timeType) {
        this.mainType = timeType;
    }

    public TimeType getMainType() {
        return this.mainType;
    }

    public void setSecondType(TimeType timeType) {
        this.secondType = timeType;
    }

    public TimeType getSecondType() {
        return this.secondType;
    }

    public void initMinMaxValue(double d, double d2) {
        this.initMinMaxValue(d, d2, false);
    }

    @Override
    public void initMinMaxValue(double d, double d2, boolean bl) {
        try {
            this.calculateTimeNiceDomain(bl, d, d2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            this.setMinValue(d);
            this.setMaxValue(d2);
            this.setMainUnit(new BigDecimal((d2 - d) / this.getDefaultTickCount()));
        }
        Date date = ChartBaseUtils.long2Date((long)((long)this.getMinValue()), (int)6);
        double d3 = ChartBaseUtils.date2Int((Date)date, (int)this.getMainType().getTimeType());
        this.setMinValue(d3);
        Date date2 = ChartBaseUtils.long2Date((long)((long)this.getMaxValue()), (int)6);
        double d4 = ChartBaseUtils.date2Int((Date)date2, (int)this.getMainType().getTimeType());
        this.setMaxValue(d4);
        long l = VanChartAttrHelper.getTimeTypeSecond(this.getMainType());
        double d5 = this.getMainUnit() / (double)l;
        this.setMainUnit(new BigDecimal(d5));
        if (this.isCustomSecUnit()) {
            this.setSecUnit(this.getSecUnit() * (double)VanChartAttrHelper.getTimeTypeSecond(this.getSecondType()) / (double)l);
        } else {
            this.setSecUnit(this.getMainUnit() / 5.0);
        }
    }

    public void calculateTimeNiceDomain(boolean bl, double d, double d2) {
        this.calculateValueTimeNiceDomain(false, bl, d, d2);
    }

    public void drawAxisGrid(Graphics graphics) {
        if (this.needDrawMainAxisGrid()) {
            this.drawGridLine(graphics, this.getMainGridStyle(), this.getMainGridColor(), (int)this.getMainUnit(), this.getMainType().getTimeType());
        }
    }

    private boolean needDrawMainAxisGrid() {
        return this.getMainGridStyle() != 0 && this.getMainUnit() > 0.0 && this.getMainGridColor() != null;
    }

    private void drawGridLine(Graphics graphics, int n, Color color, int n2, int n3) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(color);
        graphics2D.setStroke(GraphHelper.getStroke((int)n));
        Date date = ChartBaseUtils.long2Date((long)((long)this.minValue), (int)this.getMainType().getTimeType());
        Date date2 = ChartBaseUtils.long2Date((long)((long)this.maxValue), (int)this.getMainType().getTimeType());
        int n4 = this.getTickSamplingTime();
        DateUtils.object2Date((Object)new Double(this.getMinValue()), (boolean)false);
        while (this.isBeyondDateRange(date, date2, n2 * n4)) {
            double d = ChartBaseUtils.date2Int((Date)date, (int)this.getMainType().getTimeType());
            Line2D[] line2DArray = this.getGridLine(d);
            for (int i = 0; i < line2DArray.length; ++i) {
                graphics2D.draw(line2DArray[i]);
            }
            date = this.nextDate(date, n3, n2 * n4);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    private boolean isBeyondDateRange(Date date, Date date2, int n) {
        return date.getTime() <= date2.getTime() && n > 0;
    }

    public Date nextDate(Date date, int n, int n2) {
        if (n == 6) {
            date.setSeconds(date.getSeconds() + n2);
        } else if (n == 5) {
            date.setMinutes(date.getMinutes() + n2);
        } else if (n == 4) {
            date.setHours(date.getHours() + n2);
        } else if (n == 2) {
            date.setMonth(date.getMonth() + n2);
        } else if (n == 3) {
            date.setYear(date.getYear() + n2);
        } else if (n == 1) {
            date.setDate(date.getDate() + n2);
        }
        return date;
    }

    @Override
    public double getObjectValue(Object object) {
        Date date = DateUtils.object2Date((Object)object, (boolean)true);
        if (date != null) {
            return ChartBaseUtils.date2Int((Date)date, (int)this.getMainType().getTimeType());
        }
        return this.getCrossValue();
    }

    public int getTickSamplingTime() {
        int n = 1;
        double d = (this.getMaxValue() - this.getMinValue()) / (this.mainUnit.doubleValue() * this.getDateTypeNumber());
        while (this.axisLength > 1.0 && this.axisLength / Math.ceil(d / (double)n) < 1.0) {
            ++n;
        }
        return n;
    }

    public int getTickNumber4CalDim() {
        int n = 1;
        double d = (this.getMaxValue() - this.getMinValue()) / (this.mainUnit.doubleValue() * this.getDateTypeNumber());
        while (Math.ceil(d / (double)n) > 1.0) {
            ++n;
        }
        return n;
    }

    protected double getDateTypeNumber() {
        double d = 1.0;
        if (ComparatorUtils.equals((Object)((Object)TimeType.TIME_MONTH), (Object)((Object)this.getMainType()))) {
            d = 30.0;
        } else if (ComparatorUtils.equals((Object)((Object)TimeType.TIME_YEAR), (Object)((Object)this.getMainType()))) {
            d = 365.0;
        }
        return d;
    }

    protected void calculateAxisLengthUnit() {
        double d = this.getMaxValue() - this.getMinValue();
        if (d <= 0.0) {
            this.unitLength = 1.0;
            return;
        }
        this.unitLength = this.axisLength / Math.max(1.0, d);
    }

    protected double getMaxLabelWidthAndInitStartEndLabelDim(int n) {
        int n2;
        if (!this.isShowAxisLabel) {
            return 0.0;
        }
        double d = 8.0;
        Date date = ChartBaseUtils.long2Date((long)((long)this.minValue), (int)this.getMainType().getTimeType());
        Date date2 = ChartBaseUtils.long2Date((long)((long)this.maxValue), (int)this.getMainType().getTimeType());
        int n3 = 0;
        int n4 = this.getTickNumber4CalDim();
        int n5 = n2 = this.getLabelNumber() > 0 ? this.getLabelNumber() : n4;
        if (this.format == null && this.defaultFormat == null) {
            this.calculateDefaultFormat();
        }
        while (this.isBeyondDateRange(date, date2, (int)this.getMainUnit() * n2)) {
            String string = this.format == null ? this.defaultFormat.format(date) : this.format.format(date);
            Dimension2D dimension2D = this.getAxisLabelDim(string, n);
            if (n3 == 0) {
                this.startLabelDim = dimension2D;
                ++n3;
            } else {
                this.endLabelDim = dimension2D;
            }
            double d2 = this.getAxisLabelWidth(string, n);
            d = d2 < d ? d : d2;
            date = this.nextDate(date, this.getMainType().getTimeType(), (int)this.getMainUnit() * n2);
        }
        return d;
    }

    private void calculateDefaultFormat() {
        if (this.format == null) {
            double d = this.getMainUnit() * (double)VanChartAttrHelper.getTimeTypeMilliSecond4MinMax(this.getMainType());
            this.defaultFormat = d < 8.64E7 ? new SimpleDateFormat("yyyy-MM-dd HH:mm") : (d < 2.592E9 ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM"));
        }
    }

    @Override
    protected void addValueFormat(JSONObject jSONObject, Repository repository) throws JSONException {
        if (!this.isCommonValueFormat() || this.getFormat() != null) {
            super.addValueFormat(jSONObject, repository);
        }
    }

    protected void drawTicks(Graphics graphics, int n) {
        Line2D line2D;
        double d;
        int n2;
        if (this.axisLength < 1.0) {
            return;
        }
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 0);
        Date date = ChartBaseUtils.long2Date((long)((long)this.minValue), (int)this.getMainType().getTimeType());
        Date date2 = ChartBaseUtils.long2Date((long)((long)this.maxValue), (int)this.getMainType().getTimeType());
        Format format = this.getFormat() == null ? this.defaultFormat : this.getFormat();
        int n3 = this.getTickSamplingTime();
        int n4 = n2 = this.getLabelNumber() > 0 ? this.getLabelNumber() : n3;
        while (this.isBeyondDateRange(date, date2, (int)this.getMainUnit())) {
            d = ChartBaseUtils.date2Int((Date)date, (int)this.getMainType().getTimeType());
            line2D = this.getTickLine(d, 5, this.getMainTickLine());
            this.drawTickLine(graphics, line2D, basicStroke);
            date = this.nextDate(date, this.getMainType().getTimeType(), (int)this.getMainUnit() * n2);
        }
        date = ChartBaseUtils.long2Date((long)((long)this.minValue), (int)this.getMainType().getTimeType());
        if (n3 <= 1) {
            while (this.isBeyondDateRange(date, date2, (int)this.getSecUnit())) {
                d = ChartBaseUtils.date2Int((Date)date, (int)this.getMainType().getTimeType());
                line2D = this.getTickLine(d, 3, this.getSecTickLine());
                this.drawTickLine(graphics, line2D, basicStroke);
                date = this.nextDate(date, this.getMainType().getTimeType(), (int)this.getSecUnit() * n2);
            }
        }
        date = ChartBaseUtils.long2Date((long)((long)this.minValue), (int)this.getMainType().getTimeType());
        GeneralPath generalPath = new GeneralPath();
        while (this.isBeyondDateRange(date, date2, (int)this.getMainUnit())) {
            String string;
            double d2 = ChartBaseUtils.date2Int((Date)date, (int)this.getMainType().getTimeType());
            Rectangle2D rectangle2D = this.getLabelBounds(d2, 0.0, string = format.format(date), n);
            if (!generalPath.intersects(rectangle2D)) {
                this.drawLabel(graphics, d2, 0.0, string, n);
                generalPath.append(rectangle2D, false);
            }
            date = this.nextDate(date, this.getMainType().getTimeType(), (int)this.getMainUnit() * n2);
        }
    }

    public double getCrossValue() {
        return this.getMinValue();
    }

    public double getArrowValue() {
        return this.getMaxValue();
    }

    public String getJSAxisType() {
        return "time";
    }

    public String getAxisName() {
        return "timeAxis";
    }

    public double getPreLeftWidth4DataSheet(int n) {
        this.calculateTitleDimesion(n);
        double d = 0.0;
        if (this.titleDim.getWidth() > 0.0) {
            d = this.titleDim.getWidth() + 4.0;
        }
        double d2 = this.getMaxLabelWidthAndInitStartEndLabelDim(n);
        return this.position == 2 ? d2 + d : 0.0;
    }

    @Override
    protected void addMinMaxValue(JSONObject jSONObject, Repository repository) throws JSONException {
        if (this.isCustomMaxValue) {
            jSONObject.put("max", this.getMaxValue() * 1000.0);
        }
        if (this.isCustomMinValue) {
            jSONObject.put("min", this.getMinValue() * 1000.0);
        }
        if (this.isCustomMainUnit()) {
            jSONObject.put("tickInterval", this.getMainUnit() * (double)VanChartAttrHelper.getTimeTypeMilliSecond(this.getMainType()));
        }
        if (this.isCustomSecUnit()) {
            jSONObject.put("minorTickInterval", this.getSecUnit() * (double)VanChartAttrHelper.getTimeTypeMilliSecond(this.getSecondType()));
        }
    }
}

