/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.glyph.axis;

import com.fr.base.GraphHelper;
import com.fr.base.Utils;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.plugin.chart.glyph.axis.VanChartBaseAxisGlyph;
import com.fr.stable.StringUtils;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

public class VanChartCategoryAxisGlyph
extends VanChartBaseAxisGlyph {
    private static final long serialVersionUID = -7226271395500582645L;
    protected ArrayList categoryLabelList = new ArrayList();
    public static final double HALF = 0.5;

    public void addCategoryLabel(Object object) {
        this.categoryLabelList.add(object);
    }

    public int getCategoryCount() {
        return this.categoryLabelList.size();
    }

    public void initMinMaxValue(double d, double d2) {
        this.maxValue = d2;
        this.minValue = d;
        this.mainUnit = new BigDecimal("1");
        this.setSecUnit(0.2);
    }

    @Override
    protected double getMaxTickValue() {
        double d = this.getMaxValue();
        if (!this.isDrawBetweenTick() && this.categoryLabelList != null && this.categoryLabelList.size() > 1) {
            d -= this.getMainUnit();
        }
        return d;
    }

    public double getCrossValue() {
        return this.getMinValue();
    }

    public double getArrowValue() {
        return this.getMaxValue();
    }

    public String getJSAxisType() {
        return "category";
    }

    public String getAxisName() {
        return "CategoryAxis";
    }

    public double getPreLeftWidth4DataSheet(int n) {
        this.calculateTitleDimesion(n);
        double d = 0.0;
        if (this.titleDim.getWidth() > 0.0) {
            d = this.titleDim.getWidth() + 4.0;
        }
        double d2 = this.getMaxLabelWidthAndInitStartEndLabelDim(n);
        return this.position == 2 ? d2 + d : 0.0;
    }

    protected double getMaxLabelWidthAndInitStartEndLabelDim(int n) {
        if (!this.isShowAxisLabel) {
            return 0.0;
        }
        double d = 0.0;
        Object[] objectArray = this.categoryLabelList.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Dimension2D dimension2D = this.getAxisLabelDim(Utils.objectToString((Object)objectArray[i]), n);
            if (i == 0) {
                this.startLabelDim = dimension2D;
            } else {
                this.endLabelDim = dimension2D;
            }
            double d2 = this.getAxisLabelWidth(Utils.objectToString((Object)objectArray[i]), n);
            d = d2 < d ? d : d2;
        }
        return d;
    }

    protected void calculateAxisLengthUnit() {
        double d = this.getMaxValue() - this.getMinValue();
        if (d <= 0.0) {
            this.unitLength = 1.0;
            return;
        }
        this.unitLength = this.isDrawBetweenTick() ? this.axisLength / d : this.axisLength / Math.max(1.0, d - 1.0);
    }

    @Override
    public Point2D getAlertValuePoint(Object object) {
        double d = this.getObjectValue(object);
        if (this.isDrawBetweenTick()) {
            d += 0.5;
        }
        return this.getPointInBounds(d);
    }

    @Override
    public double getObjectValue(Object object) {
        int n = this.categoryLabelList.size();
        for (int i = 0; i < n; ++i) {
            if (!ComparatorUtils.equals(this.categoryLabelList.get(i), (Object)object)) continue;
            return i;
        }
        return this.getCrossValue();
    }

    public void drawAxisGrid(Graphics graphics) {
        if (this.axisLength <= 1.0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = this.getMaxTickValue();
        int n = this.getTickSamplingTime();
        if (this.getMainGridStyle() != 0 && this.getMainUnit() > 0.0 && this.getMainGridColor() != null) {
            Stroke stroke = graphics2D.getStroke();
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(this.getMainGridColor());
            graphics2D.setStroke(GraphHelper.getStroke((int)this.getMainGridStyle()));
            for (double d2 = (this.getMainUnit() + this.getCrossValue()) * (double)n; d2 <= d; d2 += this.getMainUnit() * (double)n) {
                Line2D[] line2DArray = this.getGridLine(d2);
                for (int i = 0; i < line2DArray.length; ++i) {
                    graphics2D.draw(line2DArray[i]);
                }
            }
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
        }
    }

    protected void drawTicks(Graphics graphics, int n) {
        Line2D line2D;
        double d;
        if (this.axisLength <= 1.0) {
            return;
        }
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 0);
        int n2 = this.getTickSamplingTime();
        boolean bl = this.isToNumber();
        double d2 = this.isDrawBetweenTick() ? 0.5 : 0.0;
        int n3 = this.getLabelNumber() > 0 ? this.getLabelNumber() : this.getLabelSamplingTime(n2, bl, 1, n, d2) * n2;
        double d3 = this.getMaxTickValue();
        int n4 = 5;
        for (d = this.getCrossValue() + 1.0; d <= d3; d += 1.0) {
            line2D = this.getTickLine(d, n4, this.getMainTickLine());
            this.drawTickLine(graphics, line2D, basicStroke);
        }
        if (n2 <= 1) {
            for (d = this.getCrossValue() + this.getSecUnit(); d <= d3; d += this.getSecUnit()) {
                line2D = this.getTickLine(d, 3, this.getSecTickLine());
                this.drawTickLine(graphics, line2D, basicStroke);
            }
        }
        this.drawTickLabel(graphics, n, n3, bl, d2);
    }

    protected void drawTickLabel(Graphics graphics, int n, int n2, boolean bl, double d) {
        if (this.isLabelWrap && n2 == 1) {
            int n3 = this.categoryLabelList.size();
            for (int i = 0; i < n3; i += n2) {
                this.drawLabelWrapWhenNeed(graphics, i, d, this.getLabelString(i, bl), n);
            }
        } else {
            int n4 = this.categoryLabelList.size();
            for (int i = 0; i < n4; i += n2) {
                this.drawLabel(graphics, i, d, this.getLabelString(i, bl), n);
            }
        }
    }

    public boolean isToNumber() {
        boolean bl = true;
        int n = this.categoryLabelList.size();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = this.categoryLabelList.toArray();
            Number number = Utils.objectToNumber((Object)objectArray[i], (boolean)true);
            if (number == null) {
                bl = false;
            }
            if (!bl) break;
        }
        return bl;
    }

    public int getLabelSamplingTime(int n, boolean bl, int n2, int n3, double d) {
        int n4 = n * n2;
        GeneralPath generalPath = new GeneralPath();
        int n5 = this.categoryLabelList.size();
        for (int i = 0; i < n5; i += n4) {
            String string = this.getLabelString(i, bl);
            Rectangle2D rectangle2D = this.getLabelBounds(i, d, string, n3);
            if (generalPath.intersects(rectangle2D)) {
                return this.getLabelSamplingTime(n, bl, ++n2, n3, d);
            }
            generalPath.append(rectangle2D, false);
        }
        return n2;
    }

    public String getLabelString(int n, boolean bl) {
        Object e = this.categoryLabelList.get(n);
        String string = Utils.objectToString(e);
        if (this.format != null && StringUtils.isNotEmpty((String)string)) {
            Date date;
            string = bl ? this.format.format(Double.valueOf(string)) : ((date = DateUtils.object2Date(e, (boolean)true)) == null ? string : this.format.format(date));
        }
        return string;
    }
}

