/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.glyph;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.AttrFillStyle;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.StyleContactWithConditionCollection;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionAttrFactory;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.data.condition.Result;
import com.fr.general.Background;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrTooltip;
import com.fr.plugin.chart.glyph.VanChartDataPoint;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.glyph.VanChartPlotGlyphInterface;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public abstract class VanChartPlotGlyph
extends PlotGlyph
implements VanChartPlotGlyphInterface {
    private static final long serialVersionUID = -2857867893828263672L;
    private boolean useDefaultNullData;
    protected AttrLabel defaultAttrLabel;
    protected AttrTooltip defaultAttrTooltip;
    private AttrAlpha defaultAttrAlpha;
    private AttrBorder defaultAttrBorder;

    public void setUseDefaultNullData(boolean bl) {
        this.useDefaultNullData = bl;
    }

    protected AttrLabel getDefaultAttrLabel() {
        if (this.defaultAttrLabel == null) {
            ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
            this.defaultAttrLabel = (AttrLabel)conditionAttr.getExisted(AttrLabel.class);
        }
        return this.defaultAttrLabel;
    }

    protected AttrTooltip getDefaultAttrTooltip() {
        if (this.defaultAttrTooltip == null) {
            ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
            this.defaultAttrTooltip = (AttrTooltip)conditionAttr.getExisted(AttrTooltip.class);
        }
        return this.defaultAttrTooltip;
    }

    protected AttrAlpha getDefaultAttrAlpha() {
        if (this.defaultAttrAlpha == null) {
            ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
            this.defaultAttrAlpha = (AttrAlpha)conditionAttr.getExisted(AttrAlpha.class);
        }
        return this.defaultAttrAlpha;
    }

    protected AttrBorder getDefaultAttrBorder() {
        if (this.defaultAttrBorder == null) {
            ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
            this.defaultAttrBorder = (AttrBorder)conditionAttr.getExisted(AttrBorder.class);
        }
        return this.defaultAttrBorder;
    }

    protected AttrAlpha getAttrAlpha(VanChartDataPoint vanChartDataPoint) {
        AttrAlpha attrAlpha = vanChartDataPoint.getAlpha();
        if (attrAlpha == null) {
            attrAlpha = this.getDefaultAttrAlpha();
        }
        if (attrAlpha == null) {
            attrAlpha = new AttrAlpha(1.0f);
        }
        return attrAlpha;
    }

    protected AttrAlpha getAttrAlpha(VanChartDataSeries vanChartDataSeries) {
        AttrAlpha attrAlpha = vanChartDataSeries.getAlpha();
        if (attrAlpha == null) {
            attrAlpha = this.getDefaultAttrAlpha();
        }
        if (attrAlpha == null) {
            attrAlpha = new AttrAlpha(1.0f);
        }
        return attrAlpha;
    }

    protected AttrBorder getAttrBorder(VanChartDataPoint vanChartDataPoint) {
        AttrBorder attrBorder = vanChartDataPoint.getBorder();
        if (attrBorder == null) {
            attrBorder = this.getDefaultAttrBorder();
        }
        if (attrBorder == null) {
            attrBorder = new AttrBorder();
        }
        return attrBorder;
    }

    protected AttrLabel getAttrLabel(VanChartDataPoint vanChartDataPoint) {
        AttrLabel attrLabel = vanChartDataPoint.getLabel();
        if (attrLabel == null) {
            attrLabel = this.getDefaultAttrLabel();
        }
        return attrLabel;
    }

    protected AttrBackground getAttrBackground(VanChartDataPoint vanChartDataPoint) {
        AttrBackground attrBackground = vanChartDataPoint.getColor();
        if (attrBackground == null) {
            attrBackground = (AttrBackground)ConditionAttrFactory.createConditionAttr(AttrBackground.class, (int)vanChartDataPoint.getSeriesIndex(), (Color[])this.createColors4Series());
        }
        return attrBackground;
    }

    protected Color getAttrLineColor(VanChartDataSeries vanChartDataSeries, Color[] colorArray) {
        AttrBackground attrBackground = vanChartDataSeries.getColor();
        if (attrBackground != null && attrBackground.getSeriesBackground() instanceof ColorBackground) {
            return ((ColorBackground)attrBackground.getSeriesBackground()).getColor();
        }
        return colorArray[vanChartDataSeries.getSeriesIndex()];
    }

    protected void changeInfoWithCondition(GeneralInfo generalInfo, VanChartDataPoint vanChartDataPoint) {
        AttrBorder attrBorder = this.getAttrBorder(vanChartDataPoint);
        generalInfo.changeStyleAttrBorder(attrBorder);
        AttrAlpha attrAlpha = this.getAttrAlpha(vanChartDataPoint);
        generalInfo.changeStyleAttrAlpha(attrAlpha);
        AttrBackground attrBackground = this.getAttrBackground(vanChartDataPoint);
        generalInfo.changeStyleAttrBackground(attrBackground);
    }

    public void layoutAxisGlyph(int n) {
    }

    @Override
    public void layoutAxisGlyph(Rectangle2D rectangle2D, int n) {
        this.layoutAxisGlyph(n);
    }

    protected double[] getMinMaxValue() {
        double[] dArray = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        int n = this.getCategoryCount();
        for (int i = 0; i < n; ++i) {
            int n2 = this.getSeriesSize();
            for (int j = 0; j < n2; ++j) {
                DataPoint dataPoint = this.getSeries(j).getDataPoint(i);
                dArray[0] = Math.min(dArray[0], dataPoint.getValue());
                dArray[1] = Math.max(dArray[1], dataPoint.getValue());
            }
        }
        return dArray;
    }

    public void layoutDataSeriesGlyph(int n) {
        this.createDataPointLabelAfterInstallAxisGlyph();
    }

    public void createDataPointLabelAfterInstallAxisGlyph() {
        this.calculateDataPointPercentValue();
        this.createDataLabel4EverySeries();
    }

    private void createDataLabel4EverySeries() {
        int n = this.getSeriesSize();
        Color[] colorArray = ChartBaseUtils.createFillColorArray((AttrFillStyle)this.getPlotFillStyle(), (int)n);
        for (int i = 0; i < n; ++i) {
            VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(i);
            int n2 = vanChartDataSeries.getDataPointCount();
            for (int j = 0; j < n2; ++j) {
                VanChartDataPoint vanChartDataPoint = (VanChartDataPoint)vanChartDataSeries.getDataPoint(j);
                if (vanChartDataPoint.isValueIsNull()) continue;
                vanChartDataPoint.setDefaultAttrLabel(this.getDefaultAttrLabel());
                vanChartDataPoint.setDefaultColor(colorArray[i]);
                this.createDataLabel4DataPointWithCondition(vanChartDataPoint, vanChartDataSeries);
            }
        }
    }

    protected void createDataLabel4DataPointWithCondition(VanChartDataPoint vanChartDataPoint, VanChartDataSeries vanChartDataSeries) {
        AttrLabel attrLabel = this.getAttrLabel(vanChartDataPoint);
        if (attrLabel == null) {
            return;
        }
        String string = this.getLabelText(attrLabel, vanChartDataPoint);
        TextGlyph textGlyph = new TextGlyph();
        textGlyph.setVisible(true);
        this.getConditionCollection().changeStyleConditionWithInfo((StyleContactWithConditionCollection)textGlyph, (Result)vanChartDataPoint, new Color[0]);
        if (StringUtils.isNotEmpty((String)string)) {
            textGlyph.setText(string);
            textGlyph.setTextAttr(attrLabel.getTextAttr());
            vanChartDataPoint.setDataLabel(textGlyph);
        }
    }

    protected String getLabelText(AttrLabel attrLabel, VanChartDataPoint vanChartDataPoint) {
        return VanChartAttrHelper.getLabelText(attrLabel.getContent(), vanChartDataPoint);
    }

    public LegendItem[] createLegendItems() {
        int n = this.getSeriesSize();
        LegendItem[] legendItemArray = new LegendItem[n];
        Color[] colorArray = this.createColors4Series();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(n2);
            legendItemArray[n3] = new LegendItem(vanChartDataSeries.getSeriesName());
            legendItemArray[n3].setLineMarkerIcon(this.getLegendMarkerIcon(vanChartDataSeries, colorArray));
            ++n2;
            ++n3;
        }
        return legendItemArray;
    }

    protected LineMarkerIcon getLegendMarkerIcon(VanChartDataSeries vanChartDataSeries, Color[] colorArray) {
        LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
        this.dealMarkerIconCondition(lineMarkerIcon, vanChartDataSeries, colorArray);
        return lineMarkerIcon;
    }

    protected LineMarkerIcon dealMarkerIconCondition(LineMarkerIcon lineMarkerIcon, VanChartDataSeries vanChartDataSeries, Color[] colorArray) {
        lineMarkerIcon.setBackground((Background)ColorBackground.getInstance((Color)this.getAttrLineColor(vanChartDataSeries, colorArray)));
        lineMarkerIcon.setAlpha(this.getAttrAlpha(vanChartDataSeries).getAlpha());
        return lineMarkerIcon;
    }

    public void draw(Graphics graphics, int n) {
        if (this.getBounds().getWidth() < 0.0 || this.getBounds().getHeight() < 0.0) {
            return;
        }
        this.drawInfo(graphics, n);
        super.draw(graphics, n);
    }

    protected void drawInfo(Graphics graphics, int n) {
        this.drawInfo(graphics);
    }

    private boolean allNullValue() {
        int n = this.getSeriesSize();
        for (int i = 0; i < n; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            int n2 = dataSeries.getDataPointCount();
            for (int j = 0; j < n2; ++j) {
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                if (dataPoint.isValueIsNull()) continue;
                return false;
            }
        }
        return true;
    }

    public void addSeriesJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        if (this.useDefaultNullData || this.allNullValue()) {
            this.addNullDataSeriesJSON(jSONObject);
        } else {
            this.addNotNullSeriesJSON(jSONObject, repository);
        }
    }

    protected void addNotNullSeriesJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        int n = this.getSeriesSize();
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < n; ++i) {
            jSONArray.put((Object)this.getSeries(i).toJSONObject(repository));
        }
        jSONObject.put("series", (Object)jSONArray);
    }

    private void addNullDataSeriesJSON(JSONObject jSONObject) throws JSONException {
        jSONObject.put("series", new ArrayList());
    }

    protected void addSeriesJSONWithCate2Series(JSONObject jSONObject, Repository repository) throws JSONException {
        int n = this.getCategoryCount();
        int n2 = this.getSeriesSize();
        JSONArray jSONArray = new JSONArray();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = new JSONObject();
                JSONArray jSONArray2 = new JSONArray();
                String string = "";
                for (int j = 0; j < n2; ++j) {
                    DataSeries dataSeries = this.getSeries(j);
                    DataPoint dataPoint = dataSeries.getDataPoint(i);
                    string = dataPoint.getCategoryName();
                    jSONArray2.put((Object)dataPoint.toJSONObject(repository));
                }
                jSONObject2.put("name", (Object)string);
                jSONObject2.put("data", (Object)jSONArray2);
                jSONArray.put((Object)jSONObject2);
            }
        } else if (n2 > 0) {
            JSONObject jSONObject3 = new JSONObject();
            JSONArray jSONArray3 = new JSONArray();
            for (int i = 0; i < n2; ++i) {
                DataSeries dataSeries = this.getSeries(i);
                JSONObject jSONObject4 = new JSONObject();
                jSONObject4.put("x", (Object)dataSeries.getSeriesName());
                jSONArray3.put((Object)jSONObject4);
            }
            jSONObject3.put("data", (Object)jSONArray3);
            jSONArray.put((Object)jSONObject3);
        }
        jSONObject.put("series", (Object)jSONArray);
    }

    public JSONObject getPlotOptionsJSON(Repository repository, boolean bl) throws JSONException {
        AttrBorder attrBorder;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("animation", bl);
        AttrLabel attrLabel = this.getDefaultAttrLabel();
        if (attrLabel != null && attrLabel.isEnable()) {
            this.addLabelJSON(jSONObject, attrLabel, repository);
        } else {
            this.addNullLabelJSON(jSONObject);
        }
        AttrTooltip attrTooltip = this.getDefaultAttrTooltip();
        if (attrTooltip != null && attrTooltip.isEnable()) {
            jSONObject.put("tooltip", (Object)attrTooltip.toJSONObject(repository));
        }
        if ((attrBorder = this.getDefaultAttrBorder()) != null) {
            jSONObject.put("borderWidth", VanChartAttrHelper.getAxisLineStyle(attrBorder.getBorderStyle()));
            if (attrBorder.getBorderColor() != null) {
                jSONObject.put("borderColor", (Object)StableUtils.javaColorToCSSColor((Color)attrBorder.getBorderColor()));
            } else {
                jSONObject.put("borderColor", (Object)"rgba(255,255,255,0)");
            }
            jSONObject.put("borderRadius", attrBorder.getRoundRadius());
        }
        this.addLargeDataJSON(jSONObject);
        return jSONObject;
    }

    protected void addLargeDataJSON(JSONObject jSONObject) throws JSONException {
    }

    protected void addLabelJSON(JSONObject jSONObject, AttrLabel attrLabel, Repository repository) throws JSONException {
        jSONObject.put("dataLabels", (Object)attrLabel.toJSONObject(repository));
    }

    protected void addNullLabelJSON(JSONObject jSONObject) throws JSONException {
    }

    public String getPlotGlyphType() {
        return "";
    }

    public String getSmallIconType() {
        return "";
    }
}

