/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.glyph;

import com.fr.base.FRContext;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.Glyph;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.general.Background;
import com.fr.general.FRFont;
import com.fr.js.JavaScript;
import com.fr.js.NameJavaScript;
import com.fr.js.NameJavaScriptGroup;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.base.AttrFloatColor;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrTooltip;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class VanChartDataPoint
extends DataPoint {
    protected static final int DEFAULT_SIZE = 9;
    private static final long serialVersionUID = 3439431662725988324L;
    protected AttrLabel label;
    private AttrTooltip tooltip;
    protected AttrBackground color;
    private AttrFloatColor floatColor;
    private AttrBorder border;
    private AttrAlpha alpha;
    protected AttrLabel defaultAttrLabel;
    protected Color defaultColor;
    private JSONArray jsonHyperlink;

    public void setLabel(AttrLabel attrLabel) {
        this.label = attrLabel;
    }

    public AttrLabel getLabel() {
        return this.label;
    }

    public void setTooltip(AttrTooltip attrTooltip) {
        this.tooltip = attrTooltip;
    }

    public AttrTooltip getTooltip() {
        return this.tooltip;
    }

    public void setAlpha(AttrAlpha attrAlpha) {
        this.alpha = attrAlpha;
    }

    public void setBorder(AttrBorder attrBorder) {
        this.border = attrBorder;
    }

    public void setColor(AttrBackground attrBackground) {
        this.color = attrBackground;
    }

    public AttrBackground getColor() {
        return this.color;
    }

    public void setFloatColor(AttrFloatColor attrFloatColor) {
        this.floatColor = attrFloatColor;
    }

    public void setDefaultAttrLabel(AttrLabel attrLabel) {
        this.defaultAttrLabel = attrLabel;
    }

    public void setDefaultColor(Color color) {
        this.defaultColor = color;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public AttrBorder getBorder() {
        return this.border;
    }

    public AttrAlpha getAlpha() {
        return this.alpha;
    }

    public void drawLabel(Graphics graphics, int n) {
        if (this.isValueIsNull()) {
            return;
        }
        if (this.getDataLabel() == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.isUseCustomFont()) {
            this.drawCustomFontLabelText(graphics2D, n);
        } else {
            this.drawAutoFontLabelText(graphics2D, n);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public boolean isUseCustomFont() {
        return this.label == null ? this.defaultAttrLabel.isCustom() : this.label.isCustom();
    }

    public void drawCustomFontLabelText(Graphics graphics, int n) {
        this.getDataLabel().draw(graphics, n);
    }

    public void drawAutoFontLabelText(Graphics graphics, int n) {
        FRFont fRFont;
        String string = this.getDataLabel().getText();
        TextAttr textAttr = this.getDataLabel().getTextAttr();
        String string2 = VanChartAttrHelper.getCateAndSeries(this.label == null ? this.defaultAttrLabel.getContent() : this.label.getContent(), this);
        String string3 = VanChartAttrHelper.getValueAndPercent(this.label == null ? this.defaultAttrLabel.getContent() : this.label.getContent(), this);
        TextAttr textAttr2 = new TextAttr();
        this.getDataLabel().setTextAttr(textAttr2);
        FRFont fRFont2 = this.isOutside() ? this.getOutSideCateAndSeriesFont() : this.getInSideCateAndSeriesFont();
        FRFont fRFont3 = fRFont = this.isOutside() ? this.getOutSideValueAndPercentFont() : this.getInSideValueAndPercentFont();
        if (StringUtils.isNotEmpty((String)string2) && StringUtils.contains((String)string, (String)string2)) {
            textAttr2.setFRFont(fRFont2);
            this.getDataLabel().setText(string2);
            this.getDataLabel().draw(graphics, n);
        }
        if (StringUtils.isNotEmpty((String)string3) && StringUtils.contains((String)string, (String)string3)) {
            textAttr2.setFRFont(fRFont);
            this.getDataLabel().setText(string3);
            this.getDataLabel().draw(graphics, n);
        }
        this.getDataLabel().setTextAttr(textAttr);
    }

    public boolean isOutside() {
        return this.label == null ? this.defaultAttrLabel.getPosition() == 6 : this.label.getPosition() == 6;
    }

    public FRFont getInSideCateAndSeriesFont() {
        return FRFont.getInstance((String)"verdana", (int)1, (float)9.0f, (Color)Color.white);
    }

    public FRFont getInSideValueAndPercentFont() {
        return FRFont.getInstance((String)"verdana", (int)0, (float)9.0f, (Color)Color.white);
    }

    public FRFont getOutSideCateAndSeriesFont() {
        Color color = this.getDataPointBackgroundColor();
        if (color != null) {
            return FRFont.getInstance((String)"verdana", (int)1, (float)9.0f, (Color)color);
        }
        return FRFont.getInstance((String)"verdana", (int)1, (float)9.0f, (Color)Color.black);
    }

    public FRFont getOutSideValueAndPercentFont() {
        Color color = this.getDataPointBackgroundColor();
        if (color != null) {
            return FRFont.getInstance((String)"verdana", (int)0, (float)9.0f, (Color)color);
        }
        return FRFont.getInstance((String)"verdana", (int)0, (float)9.0f, (Color)Color.black);
    }

    public Color getDataPointBackgroundColor() {
        ShapeGlyph shapeGlyph;
        GeneralInfo generalInfo;
        Background background;
        Glyph glyph = this.getDrawImpl();
        if (glyph instanceof ShapeGlyph && (background = (generalInfo = (shapeGlyph = (ShapeGlyph)glyph).getGeneralInfo()).getBackground()) instanceof ColorBackground && ((ColorBackground)background).getColor() != null) {
            return ((ColorBackground)background).getColor();
        }
        return null;
    }

    public String createDataPointHotHyperLink(NameJavaScriptGroup nameJavaScriptGroup, Repository repository) {
        String string = super.createDataPointHotHyperLink(nameJavaScriptGroup, repository);
        if (nameJavaScriptGroup != null) {
            try {
                this.jsonHyperlink = this.createJsonHyperlink(nameJavaScriptGroup, repository);
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error("Error in HyperLink", (Throwable)jSONException);
            }
        }
        return string;
    }

    private JSONArray createJsonHyperlink(NameJavaScriptGroup nameJavaScriptGroup, Repository repository) throws JSONException {
        JSONArray jSONArray = JSONArray.create();
        if (nameJavaScriptGroup != null) {
            int n = nameJavaScriptGroup.size();
            for (int i = 0; i < n; ++i) {
                NameJavaScript nameJavaScript = nameJavaScriptGroup.getNameHyperlink(i);
                JavaScript javaScript = nameJavaScript.getJavaScript();
                JSONObject jSONObject = javaScript.createJSONObject(repository);
                jSONObject.put("name", (Object)nameJavaScript.getName());
                jSONArray.put((Object)jSONObject);
            }
        }
        return jSONArray;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        this.addXYJSON(jSONObject);
        this.addLabelToJSON(jSONObject, repository);
        this.addTooltipToJSON(jSONObject, repository);
        this.addColorAndAlphaJSON(jSONObject);
        if (this.floatColor != null) {
            jSONObject.put("mouseOverColor", (Object)StableUtils.javaColorToCSSColor((Color)this.floatColor.getSeriesColor()));
        }
        if (this.border != null) {
            jSONObject.put("borderWidth", VanChartAttrHelper.getAxisLineStyle(this.border.getBorderStyle()));
            jSONObject.put("borderColor", (Object)StableUtils.javaColorToCSSColor((Color)this.border.getBorderColor()));
        }
        if (this.hyperlink != null) {
            jSONObject.put("hyperlink", (Object)this.hyperlink);
        }
        if (this.jsonHyperlink != null) {
            jSONObject.put("jsonHyperlink", (Object)this.jsonHyperlink);
        }
        return jSONObject;
    }

    protected void addTooltipToJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        if (this.tooltip != null && this.tooltip.isEnable()) {
            jSONObject.put("tooltip", (Object)this.tooltip.toJSONObject(repository));
        }
    }

    protected void addLabelToJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        if (this.label != null && this.label.isEnable()) {
            jSONObject.put("dataLabels", (Object)this.label.toJSONObject(repository));
        }
    }

    protected void addXYJSON(JSONObject jSONObject) throws JSONException {
        jSONObject.put("x", (Object)this.getCategoryName());
        jSONObject.put("y", this.isValueIsNull() ? "-" : Double.valueOf(this.getValue()));
    }

    protected void addColorAndAlphaJSON(JSONObject jSONObject) throws JSONException {
        if (this.color != null) {
            float f = this.alpha == null ? 1.0f : this.alpha.getAlpha();
            ColorBackground colorBackground = (ColorBackground)this.color.getSeriesBackground();
            jSONObject.put("color", (Object)VanChartAttrHelper.getRGBAColorWithColorAndAlpha(colorBackground.getColor(), f));
        } else if (this.alpha != null && this.defaultColor != null) {
            jSONObject.put("color", (Object)VanChartAttrHelper.getRGBAColorWithColorAndAlpha(this.defaultColor, this.alpha.getAlpha()));
        }
    }
}

