/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.gauge.glyph;

import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.gauge.GaugeDetailStyle;
import com.fr.plugin.chart.gauge.glyph.GaugeGlyphHelper;
import com.fr.plugin.chart.gauge.glyph.PointerGaugeGlyph;
import com.fr.plugin.chart.glyph.axis.VanChartGaugeAxisGlyph;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class SemiPointerGaugeGlyph
extends PointerGaugeGlyph {
    private static final long serialVersionUID = -4853556539610118272L;
    private static final double HINGE_BACKGROUND = 0.11;
    private static final double HINGE = 0.055;
    private static final double HINGE_GAP = 0.14;
    private static final int START_ANGLE = 180;
    private static final int EXTENT = -180;
    private static final double ANGLE1 = 135.0;
    private static final double ANGLE2 = 45.0;
    private static final double ANGLE3 = 8.0;

    public SemiPointerGaugeGlyph(Rectangle2D rectangle2D, AttrLabel attrLabel, GaugeDetailStyle gaugeDetailStyle, VanChartGaugeAxisGlyph vanChartGaugeAxisGlyph) {
        super(rectangle2D, attrLabel, gaugeDetailStyle, vanChartGaugeAxisGlyph);
    }

    @Override
    protected void initStartAngleAndExtent() {
        this.startAngle = 180;
        this.extent = -180;
    }

    @Override
    protected void calculateRadiusAndCenterPoint(double d, double d2, double d3) {
        double d4 = d2 - d3 - 20.0;
        this.radius = Math.min(d / 2.0, d4 / 1.1400000000000001);
        this.radius = this.radius > 5.0 ? this.radius - 5.0 : this.radius;
        double d5 = d / 2.0;
        double d6 = d2 / 2.0 + this.radius / 2.0;
        if (this.attrLabel != null && this.attrLabel.isEnable()) {
            int n = this.attrLabel.getAttrLabelDetail().getPosition();
            if (n == 3) {
                double d7 = d3 + 20.0 + 0.14 * this.radius;
                if (d7 > d2 - d6) {
                    d6 = d2 - d7;
                }
            } else {
                double d8 = d3 + 20.0 + this.radius;
                if (d8 > d6) {
                    d6 = d8;
                }
            }
        }
        this.centerPoint = new Point2D.Double(d5, d6);
    }

    @Override
    protected void setFirstBigBounds() {
        this.bigBounds.setFrame(this.centerPoint.getX() - this.radius, this.centerPoint.getY() - this.radius, this.radius * 2.0, this.radius - this.radius * 0.11 - this.oneLineHeight * 0.5);
    }

    @Override
    protected Rectangle2D getCateOrPercentLabelBounds(int n, Dimension2D dimension2D) {
        double d = this.centerPoint.getX() - dimension2D.getWidth() / 2.0;
        double d2 = n == 3 ? this.centerPoint.getY() + this.radius * 0.14 + 20.0 - dimension2D.getHeight() / 5.0 : this.centerPoint.getY() - this.radius - 20.0 - dimension2D.getHeight();
        return new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
    }

    @Override
    protected void calculateValueBackgroundBounds(Rectangle2D rectangle2D, double d) {
        double d2 = rectangle2D.getHeight() / 5.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() - d2, rectangle2D.getY() - d2, rectangle2D.getWidth() + d2 * 2.0, rectangle2D.getHeight() + d2 * 2.0);
        if (d >= 45.0 && d <= 135.0) {
            if (double_.getMaxY() > this.bigBounds.getY()) {
                this.bigBounds.setFrame(this.bigBounds.getX(), double_.getMaxY(), this.bigBounds.getWidth(), this.bigBounds.getHeight() - (double_.getMaxY() - this.bigBounds.getY()));
            }
        } else if (d > 135.0) {
            if (this.bigBounds.getX() < double_.getMaxX()) {
                this.bigBounds.setFrame(double_.getMaxX(), this.bigBounds.getY(), this.bigBounds.getWidth(), this.bigBounds.getHeight());
            }
        } else if (d < 45.0 && this.bigBounds.getMaxX() > ((RectangularShape)double_).getX()) {
            this.bigBounds.setFrame(this.bigBounds.getX(), this.bigBounds.getY(), ((RectangularShape)double_).getX() - this.bigBounds.getX(), this.bigBounds.getHeight());
        }
    }

    @Override
    protected void drawPaneBackground(Graphics2D graphics2D) {
        GaugeGlyphHelper.drawArc(graphics2D, this.centerPoint, this.radius, (double)this.startAngle + 8.0, (double)this.extent - 16.0, this.gaugeDetailStyle.getPaneBackgroundColor(), 0);
    }

    @Override
    protected double getHingeBackgroundSize() {
        return 0.11;
    }

    @Override
    protected double getHingeSize() {
        return 0.055;
    }
}

