/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.gauge;

import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.chartattr.ChartXMLUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.MeterChartData;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.plugin.chart.attr.axis.VanChartAxis;
import com.fr.plugin.chart.attr.axis.VanChartGaugeAxis;
import com.fr.plugin.chart.attr.plot.VanChartAxisPlot;
import com.fr.plugin.chart.attr.plot.VanChartLabelPositionPlot;
import com.fr.plugin.chart.attr.plot.VanChartPlot;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrLabelDetail;
import com.fr.plugin.chart.base.AttrTooltip;
import com.fr.plugin.chart.base.AttrTooltipContent;
import com.fr.plugin.chart.gauge.GaugeDetailStyle;
import com.fr.plugin.chart.gauge.GaugeStyle;
import com.fr.plugin.chart.gauge.VanChartGaugeDataPoint;
import com.fr.plugin.chart.gauge.VanChartGaugePlotGlyph;
import com.fr.plugin.chart.glyph.VanChartDataPoint;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.glyph.axis.VanChartGaugeAxisGlyph;
import com.fr.script.Calculator;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class VanChartGaugePlot
extends VanChartPlot
implements VanChartAxisPlot,
VanChartLabelPositionPlot {
    private static final long serialVersionUID = 6197588366201673098L;
    private static final FRFont AXIS_LABEL_FONT = FRFont.getInstance((String)"verdana", (int)0, (float)8.0f, (Color)new Color(102, 102, 102));
    private static final FRFont POINTER_CATE_LABEL_FONT = FRFont.getInstance((String)"verdana", (int)0, (float)10.0f, (Color)new Color(51, 51, 51));
    private static final FRFont POINTER_VALUE_LABEL_FONT = FRFont.getInstance((String)"verdana", (int)0, (float)8.0f, (Color)new Color(51, 51, 51));
    private static final FRFont RING_PERCENT_LABEL_FONT = FRFont.getInstance((String)"verdana", (int)1, (float)18.0f, (Color)Color.black);
    private static final FRFont RING_VALUE_LABEL_FONT = FRFont.getInstance((String)"verdana", (int)0, (float)9.0f, (Color)new Color(119, 119, 119));
    private static final FRFont SLOT_PERCENT_LABEL_FONT = FRFont.getInstance((String)"verdana", (int)1, (float)27.0f, (Color)Color.black);
    private static final FRFont SLOT_VALUE_LABEL_FONT = FRFont.getInstance((String)"verdana", (int)0, (float)10.0f, (Color)new Color(102, 102, 102));
    public static final FRFont THERMOMETER_PERCENT_LABEL_FONT = FRFont.getInstance((String)"verdana", (int)1, (float)14.0f, (Color)new Color(51, 51, 51));
    private static final FRFont THERMOMETER_VALUE_LABEL_FONT = FRFont.getInstance((String)"verdana", (int)0, (float)9.0f, (Color)new Color(186, 186, 186));
    public static final FRFont THERMOMETER_VERTICAL_PERCENT_LABEL_FONT = FRFont.getInstance((String)"verdana", (int)1, (float)9.0f, (Color)new Color(51, 51, 51));
    public static final String VAN_CHART_GAUGE_PLOT = "VanChartGaugePlot";
    private GaugeStyle gaugeStyle = GaugeStyle.POINTER;
    private GaugeDetailStyle gaugeDetailStyle;
    private VanChartGaugeAxis gaugeAxis = new VanChartGaugeAxis();
    private static final MeterChartData SINGLE_DATA = new MeterChartData((Object[])new String[]{"android"}, (Object[])new String[]{"250"});
    private static final MeterChartData THERMOMETER_DATA = new MeterChartData((Object[])new String[]{"android", "ios"}, (Object[])new String[]{"250", "400"});
    private static final String[] NORMAL_CATE = new String[]{"China"};
    private static final String[] NORMAL_SERIES = new String[]{"ios", "android"};
    private static final String[][] NORMAL_VALUE = new String[][]{{"250"}, {"400"}};
    private static final NormalChartData NORMAL_DATA = new NormalChartData((Object[])NORMAL_CATE, (Object[])NORMAL_SERIES, (Object[][])NORMAL_VALUE);

    public GaugeStyle getGaugeStyle() {
        return this.gaugeStyle;
    }

    public void setGaugeStyle(GaugeStyle gaugeStyle) {
        this.gaugeStyle = gaugeStyle;
    }

    public void setGaugeDetailStyle(GaugeDetailStyle gaugeDetailStyle) {
        this.gaugeDetailStyle = gaugeDetailStyle;
    }

    public GaugeDetailStyle getGaugeDetailStyle() {
        return this.gaugeDetailStyle;
    }

    public void setGaugeAxis(VanChartGaugeAxis vanChartGaugeAxis) {
        this.gaugeAxis = vanChartGaugeAxis;
    }

    public VanChartGaugeAxis getGaugeAxis() {
        return this.gaugeAxis;
    }

    public VanChartGaugePlot() {
        this(GaugeStyle.POINTER);
    }

    @Override
    protected void dealDataSeriesCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
    }

    @Override
    protected void dealDataPointCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
    }

    public VanChartGaugePlot(GaugeStyle gaugeStyle) {
        this.resetNullLegendAttr();
        this.gaugeStyle = gaugeStyle;
        this.gaugeDetailStyle = new GaugeDetailStyle(gaugeStyle);
        this.gaugeAxis.getTextAttr().setFRFont(AXIS_LABEL_FONT);
    }

    public boolean isMultiPointer() {
        switch (this.gaugeStyle) {
            case POINTER: {
                return true;
            }
            case POINTER_SEMI: {
                return true;
            }
        }
        return false;
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        VanChartGaugePlotGlyph vanChartGaugePlotGlyph = new VanChartGaugePlotGlyph();
        this.install4PlotGlyph(vanChartGaugePlotGlyph, chartData);
        this.installAxisGlyph(vanChartGaugePlotGlyph, chartData);
        return vanChartGaugePlotGlyph;
    }

    @Override
    protected DataPoint createDataPoint() {
        return new VanChartGaugeDataPoint();
    }

    public void installAxisGlyph(VanChartGaugePlotGlyph vanChartGaugePlotGlyph, ChartData chartData) {
        VanChartGaugeAxisGlyph vanChartGaugeAxisGlyph = this.gaugeAxis.createAxisGlyph(chartData);
        vanChartGaugePlotGlyph.setGaugeAxisGlyph(vanChartGaugeAxisGlyph);
    }

    public void install4PlotGlyph(VanChartGaugePlotGlyph vanChartGaugePlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(vanChartGaugePlotGlyph, chartData);
        vanChartGaugePlotGlyph.setGaugeStyle(this.getGaugeStyle());
        vanChartGaugePlotGlyph.setGaugeDetailStyle(this.getGaugeDetailStyle());
        ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
        AttrLabel attrLabel = (AttrLabel)conditionAttr.getExisted(AttrLabel.class);
        vanChartGaugePlotGlyph.setAttrLabel(attrLabel);
    }

    @Override
    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        if (chartData == null) {
            return;
        }
        if (this.isMultiPointer() && chartData instanceof NormalChartData) {
            super.addSeries2PlotGlyph(plotGlyph, chartData);
        } else if (chartData instanceof MeterChartData) {
            MeterChartData meterChartData = ChartXMLUtils.chartData4Meter((ChartData)chartData);
            this.addSeriesByIndex(plotGlyph, meterChartData);
        }
    }

    protected void addSeriesByIndex(PlotGlyph plotGlyph, MeterChartData meterChartData) {
        int n = meterChartData.getCategoryLabelCount();
        DataSeries dataSeries = this.createDataSeries(0);
        plotGlyph.addSeries(dataSeries);
        for (int i = 0; i < n; ++i) {
            double d;
            DataPoint dataPoint = this.createDataPoint();
            dataPoint.setCategoryIndex(i);
            dataPoint.setSeriesIndex(0);
            Number number = meterChartData.getValue(i);
            if (number != null) {
                d = number.doubleValue();
            } else {
                dataPoint.setValueIsNull(true);
                d = 0.0;
            }
            dataPoint.setValue(d);
            if (i < n) {
                dataPoint.setCategoryName(Utils.objectToString((Object)meterChartData.getCategoryPresentLabel(i)));
                dataPoint.setCategoryOriginalName(Utils.objectToString((Object)meterChartData.getCategoryOriginalLabel(i)));
            }
            dataSeries.addDataPoint(dataPoint);
        }
    }

    @Override
    public VanChartAxis createXAxis(String string, int n) {
        return new VanChartAxis();
    }

    @Override
    public VanChartAxis createYAxis(String string, int n) {
        return new VanChartAxis();
    }

    @Override
    public List<VanChartAxis> getYAxisList() {
        return new ArrayList<VanChartAxis>();
    }

    @Override
    public List<VanChartAxis> getXAxisList() {
        return new ArrayList<VanChartAxis>();
    }

    @Override
    public ConditionCollection getStackAndAxisCondition() {
        return new ConditionCollection();
    }

    @Override
    public boolean isCustomChart() {
        return false;
    }

    @Override
    public String[] getLabelLocationNameArray() {
        switch (this.gaugeStyle) {
            case THERMOMETER: {
                if (this.gaugeDetailStyle.isHorizontalLayout()) {
                    return new String[]{Inter.getLocText((String)"Plugin-ChartF_AlertLeft"), Inter.getLocText((String)"Plugin-ChartF_AlertRight")};
                }
                return new String[]{Inter.getLocText((String)"Plugin-ChartF_AxisTop"), Inter.getLocText((String)"Plugin-ChartF_AxisBottom")};
            }
        }
        return new String[]{Inter.getLocText((String)"Plugin-ChartF_AxisTop"), Inter.getLocText((String)"Plugin-ChartF_AxisBottom")};
    }

    @Override
    public Integer[] getLabelLocationValueArray() {
        switch (this.gaugeStyle) {
            case THERMOMETER: {
                if (this.gaugeDetailStyle.isHorizontalLayout()) {
                    return new Integer[]{2, 4};
                }
                return new Integer[]{1, 3};
            }
        }
        return new Integer[]{1, 3};
    }

    @Override
    public AttrTooltip getDefaultAttrTooltip() {
        AttrTooltip attrTooltip = new AttrTooltip();
        attrTooltip.setEnable(false);
        attrTooltip.setShowMutiSeries(true);
        AttrTooltipContent attrTooltipContent = attrTooltip.getContent();
        attrTooltipContent.getCategoryFormat().setEnable(true);
        attrTooltipContent.getSeriesFormat().setEnable(this.isMultiPointer());
        attrTooltipContent.getValueFormat().setEnable(true);
        attrTooltipContent.getPercentFormat().setEnable(false);
        return attrTooltip;
    }

    @Override
    public AttrLabel getDefaultAttrLabel() {
        AttrLabel attrLabel = new AttrLabel();
        attrLabel.setEnable(true);
        AttrLabelDetail attrLabelDetail = attrLabel.getAttrLabelDetail();
        AttrLabelDetail attrLabelDetail2 = new AttrLabelDetail();
        attrLabel.setGaugeValueLabelDetail(attrLabelDetail2);
        AttrTooltipContent attrTooltipContent = attrLabelDetail.getContent();
        AttrTooltipContent attrTooltipContent2 = attrLabelDetail2.getContent();
        attrTooltipContent.setAllSelectFalse();
        attrTooltipContent2.setAllSelectFalse();
        switch (this.gaugeStyle) {
            case POINTER: {
                this.setMultiDefaultLabel(attrTooltipContent, attrLabelDetail, attrTooltipContent2, attrLabelDetail2);
                break;
            }
            case POINTER_SEMI: {
                this.setMultiDefaultLabel(attrTooltipContent, attrLabelDetail, attrTooltipContent2, attrLabelDetail2);
                break;
            }
            case RING: {
                this.setRingDefaultLabel(attrTooltipContent, attrLabelDetail, attrTooltipContent2, attrLabelDetail2);
                break;
            }
            case SLOT: {
                this.setSlotDefaultLabel(attrTooltipContent, attrLabelDetail, attrTooltipContent2, attrLabelDetail2);
                break;
            }
            case THERMOMETER: {
                this.setThermometerDefaultLabel(attrTooltipContent, attrLabelDetail, attrTooltipContent2, attrLabelDetail2);
            }
        }
        return attrLabel;
    }

    private void setMultiDefaultLabel(AttrTooltipContent attrTooltipContent, AttrLabelDetail attrLabelDetail, AttrTooltipContent attrTooltipContent2, AttrLabelDetail attrLabelDetail2) {
        attrTooltipContent.getCategoryFormat().setEnable(true);
        attrLabelDetail.setPosition(3);
        attrLabelDetail.setCustom(true);
        attrLabelDetail.getTextAttr().setFRFont(POINTER_CATE_LABEL_FONT);
        attrTooltipContent2.getValueFormat().setEnable(true);
        attrLabelDetail2.setCustom(true);
        attrLabelDetail2.getTextAttr().setFRFont(POINTER_VALUE_LABEL_FONT);
        attrLabelDetail2.setBackgroundColor(new Color(245, 245, 247));
    }

    private void setRingDefaultLabel(AttrTooltipContent attrTooltipContent, AttrLabelDetail attrLabelDetail, AttrTooltipContent attrTooltipContent2, AttrLabelDetail attrLabelDetail2) {
        attrTooltipContent.getPercentFormat().setEnable(true);
        attrLabelDetail.getTextAttr().setFRFont(RING_PERCENT_LABEL_FONT);
        attrTooltipContent2.getCategoryFormat().setEnable(true);
        attrTooltipContent2.getValueFormat().setEnable(true);
        attrLabelDetail2.setCustom(true);
        attrLabelDetail2.getTextAttr().setFRFont(RING_VALUE_LABEL_FONT);
    }

    private void setSlotDefaultLabel(AttrTooltipContent attrTooltipContent, AttrLabelDetail attrLabelDetail, AttrTooltipContent attrTooltipContent2, AttrLabelDetail attrLabelDetail2) {
        attrTooltipContent.getPercentFormat().setEnable(true);
        attrLabelDetail.getTextAttr().setFRFont(SLOT_PERCENT_LABEL_FONT);
        attrTooltipContent2.getCategoryFormat().setEnable(true);
        attrTooltipContent2.getValueFormat().setEnable(true);
        attrLabelDetail2.setCustom(true);
        attrLabelDetail2.getTextAttr().setFRFont(SLOT_VALUE_LABEL_FONT);
    }

    private void setThermometerDefaultLabel(AttrTooltipContent attrTooltipContent, AttrLabelDetail attrLabelDetail, AttrTooltipContent attrTooltipContent2, AttrLabelDetail attrLabelDetail2) {
        attrLabelDetail.setCustom(true);
        attrLabelDetail2.setCustom(true);
        attrTooltipContent.getPercentFormat().setEnable(true);
        attrTooltipContent2.getCategoryFormat().setEnable(true);
        attrTooltipContent2.getValueFormat().setEnable(true);
        attrLabelDetail2.getTextAttr().setFRFont(THERMOMETER_VALUE_LABEL_FONT);
        if (this.gaugeDetailStyle.isHorizontalLayout()) {
            attrLabelDetail.setPosition(2);
            attrLabelDetail2.setPosition(2);
            attrLabelDetail.getTextAttr().setFRFont(THERMOMETER_VERTICAL_PERCENT_LABEL_FONT);
        } else {
            attrLabelDetail.setPosition(3);
            attrLabelDetail2.setPosition(3);
            attrLabelDetail.getTextAttr().setFRFont(THERMOMETER_PERCENT_LABEL_FONT);
        }
    }

    @Override
    public ChartData createNullChartData() {
        return null;
    }

    public ChartData defaultChartData() {
        switch (this.gaugeStyle) {
            case RING: {
                return SINGLE_DATA;
            }
            case SLOT: {
                return SINGLE_DATA;
            }
            case THERMOMETER: {
                return THERMOMETER_DATA;
            }
        }
        return NORMAL_DATA;
    }

    @Override
    protected void readPlotXML(XMLableReader xMLableReader) {
        super.readPlotXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("VanChartGaugePlotAttr")) {
                this.gaugeStyle = GaugeStyle.parse(xMLableReader.getAttrAsString("gaugeStyle", GaugeStyle.POINTER.getStyle()));
            } else if (string.equals("GaugeDetailStyle")) {
                this.gaugeDetailStyle = (GaugeDetailStyle)xMLableReader.readXMLObject((XMLReadable)new GaugeDetailStyle(this.gaugeStyle));
            } else if (string.equals("gaugeAxis")) {
                this.gaugeAxis = (VanChartGaugeAxis)((Object)xMLableReader.readXMLObject((XMLReadable)new VanChartGaugeAxis()));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("VanChartGaugePlotAttr").attr("gaugeStyle", this.getGaugeStyle().getStyle()).end();
        if (this.gaugeDetailStyle != null) {
            this.gaugeDetailStyle.writeXML(xMLPrintWriter);
        }
        if (this.gaugeAxis != null) {
            xMLPrintWriter.startTAG("gaugeAxis");
            this.gaugeAxis.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof VanChartGaugePlot && super.equals(object) && ComparatorUtils.equals((Object)((Object)((VanChartGaugePlot)object).getGaugeStyle()), (Object)((Object)this.getGaugeStyle())) && ComparatorUtils.equals((Object)((VanChartGaugePlot)object).getGaugeDetailStyle(), (Object)this.getGaugeDetailStyle()) && ComparatorUtils.equals((Object)((Object)((VanChartGaugePlot)object).getGaugeAxis()), (Object)((Object)this.getGaugeAxis()));
    }

    public Object clone() throws CloneNotSupportedException {
        VanChartGaugePlot vanChartGaugePlot = (VanChartGaugePlot)super.clone();
        vanChartGaugePlot.setGaugeStyle(this.getGaugeStyle());
        vanChartGaugePlot.setGaugeDetailStyle((GaugeDetailStyle)this.getGaugeDetailStyle().clone());
        vanChartGaugePlot.setGaugeAxis((VanChartGaugeAxis)((Object)this.getGaugeAxis().clone()));
        return vanChartGaugePlot;
    }

    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        this.gaugeDetailStyle.dealFormula(calculator);
        this.gaugeAxis.dealFormula(calculator);
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        super.buidExecuteSequenceList(list, calculator);
        this.gaugeAxis.buidExecuteSequenceList(list, calculator);
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        super.modFormulaString(mOD_COLUMN_ROW);
        this.gaugeAxis.modFormulaString(mOD_COLUMN_ROW);
    }

    public boolean isSupportDataSeriesCondition() {
        return false;
    }

    public boolean isSupportLegend() {
        return false;
    }

    public boolean isSupportPlotBackground() {
        return false;
    }

    public boolean isSupportTooltipSeriesType() {
        return true;
    }

    public boolean isMeterPlot() {
        return true;
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof VanChartGaugePlot;
    }

    public String getPlotID() {
        return VAN_CHART_GAUGE_PLOT;
    }

    public String getPlotName() {
        return Inter.getLocText((String)"Plugin-ChartF_NewGauge");
    }

    public boolean accept(Class<? extends Plot> clazz) {
        return ComparatorUtils.equals(clazz, VanChartGaugePlot.class);
    }

    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.METER_VAN_CHART;
    }
}

