/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.style;

import com.fr.base.BaseUtils;
import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.design.dialog.BasicScrollPane;
import com.fr.design.formula.TinyFormulaPane;
import com.fr.design.gui.frpane.UIBubbleFloatPane;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.gui.ibutton.UIToggleButton;
import com.fr.design.gui.icheckbox.UICheckBox;
import com.fr.design.gui.ilable.UILabel;
import com.fr.design.gui.ispinner.UISpinner;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.mainframe.chart.PaneTitleConstants;
import com.fr.design.mainframe.chart.gui.style.ChartTextAttrPane;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.VanChartTitle;
import com.fr.plugin.chart.designer.TableLayout4VanChartHelper;
import com.fr.plugin.chart.designer.component.VanChartFloatPositionPane;
import com.fr.plugin.chart.designer.component.background.VanChartBackgroundWithOutShadowWithRadiusPane;
import com.fr.plugin.chart.designer.style.VanChartStylePane;
import com.fr.plugin.chart.vanchart.VanChart;
import com.fr.stable.StableUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VanChartTitlePane
extends BasicScrollPane<VanChart> {
    private static final long serialVersionUID = -2438898431228882682L;
    private static final int WIDTH = 165;
    private static final int HEIGHT = 100;
    private static final int GAP = 20;
    private UICheckBox isTitleVisible;
    private JPanel titlePane;
    private TinyFormulaPane titleContent;
    private ChartTextAttrPane textAttrPane;
    private UIButtonGroup<Integer> alignmentPane;
    private VanChartBackgroundWithOutShadowWithRadiusPane backgroundPane;
    private UIToggleButton useHtml;
    private UIToggleButton customFloatPositionButton;
    private VanChartFloatPositionPane customFloatPositionPane;
    private UIButtonGroup<Integer> limitSize;
    private UISpinner maxProportion;
    protected VanChartStylePane parent;

    public VanChartTitlePane(VanChartStylePane vanChartStylePane) {
        this.parent = vanChartStylePane;
    }

    private JPanel createTitlePane() {
        this.backgroundPane = new VanChartBackgroundWithOutShadowWithRadiusPane();
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = new double[]{d, d, d, d, d, d, d, d};
        Component[][] componentArray = new Component[][]{{this.createTitleContentPane(new double[]{d, d}, dArray), null}, {new JSeparator(), null}, {this.createTitlePositionPane(new double[]{d, d}, dArray), null}, {new JSeparator(), null}, {this.createTitleStylePane(), null}, {new JSeparator(), null}, {this.backgroundPane, null}, {this.createDisplayStrategy(), null}};
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
    }

    private JPanel createTitleContentPane(double[] dArray, double[] dArray2) {
        this.titleContent = new TinyFormulaPane();
        this.useHtml = new UIToggleButton(Inter.getLocText((String)"Plugin-ChartF_Html"));
        Component[][] componentArray = new Component[][]{{this.titleContent, null}, {this.useHtml, null}};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_Content"), jPanel);
    }

    private JPanel createTitlePositionPane(double[] dArray, double[] dArray2) {
        Icon[] iconArray = new Icon[]{BaseUtils.readIcon((String)"/com/fr/design/images/m_format/cellstyle/h_left_normal.png"), BaseUtils.readIcon((String)"/com/fr/design/images/m_format/cellstyle/h_center_normal.png"), BaseUtils.readIcon((String)"/com/fr/design/images/m_format/cellstyle/h_right_normal.png")};
        Object[] objectArray = new Integer[]{2, 0, 4};
        this.alignmentPane = new UIButtonGroup(iconArray, objectArray);
        this.customFloatPositionButton = new UIToggleButton(Inter.getLocText((String)"Plugin-ChartF_CustomFloatPosition"));
        this.customFloatPositionButton.setEventBannded(true);
        Component[][] componentArray = new Component[][]{{this.alignmentPane, null}, {this.customFloatPositionButton, null}};
        this.customFloatPositionPane = new VanChartFloatPositionPane();
        this.initPositionListener();
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Chart-Layout_Position"), jPanel);
    }

    private JPanel createTitleStylePane() {
        this.textAttrPane = new ChartTextAttrPane();
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"FR-Designer-Widget_Style"), (Component)this.textAttrPane);
    }

    private JPanel createDisplayStrategy() {
        this.maxProportion = new UISpinner(0.0, 100.0, 1.0, 30.0);
        this.limitSize = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_LimitAreaSize"), Inter.getLocText((String)"Plugin-ChartF_NotLimitAreaSize")});
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d2, d};
        double[] dArray2 = new double[]{d, d};
        Component[][] componentArray = new Component[][]{{this.limitSize, null}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_TitleMaxProportion") + ":"), this.maxProportion}};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
        this.limitSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartTitlePane.this.checkMaxProPortionUse();
            }
        });
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_DisplayStrategy"), jPanel);
    }

    private void initPositionListener() {
        this.alignmentPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                VanChartTitlePane.this.customFloatPositionButton.setSelected(false);
                VanChartTitlePane.this.checkDisplayStrategyUse();
            }
        });
        this.customFloatPositionButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!VanChartTitlePane.this.customFloatPositionButton.isSelected()) {
                    VanChartTitlePane.this.customFloatPositionButton.setSelected(true);
                    VanChartTitlePane.this.checkDisplayStrategyUse();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                VanChartTitlePane.this.alignmentPane.setSelectedIndex(-1);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(mouseEvent);
                if (VanChartTitlePane.this.customFloatPositionPane == null) {
                    VanChartTitlePane.this.customFloatPositionPane = new VanChartFloatPositionPane();
                }
                Point point = VanChartTitlePane.this.customFloatPositionButton.getLocationOnScreen();
                Point point2 = new Point(point.x + VanChartTitlePane.this.customFloatPositionButton.getWidth() / 2 - 20, point.y + VanChartTitlePane.this.customFloatPositionButton.getHeight());
                UIBubbleFloatPane uIBubbleFloatPane = new UIBubbleFloatPane(1, point2, VanChartTitlePane.this.customFloatPositionPane, 165, 100){

                    public void updateContentPane() {
                        VanChartTitlePane.this.parent.attributeChanged();
                    }
                };
                uIBubbleFloatPane.show((JComponent)((Object)VanChartTitlePane.this), null);
            }
        });
    }

    private void checkAllUse() {
        this.checkTitlePaneUse();
        this.checkDisplayStrategyUse();
        this.repaint();
    }

    private void checkTitlePaneUse() {
        this.isTitleVisible.setVisible(true);
        this.isTitleVisible.setEnabled(true);
        this.titlePane.setVisible(this.isTitleVisible.isSelected());
    }

    private void checkDisplayStrategyUse() {
        this.limitSize.setEnabled(!this.customFloatPositionButton.isSelected());
        this.checkMaxProPortionUse();
    }

    private void checkMaxProPortionUse() {
        this.maxProportion.setEnabled(this.limitSize.getSelectedIndex() == 0 && this.limitSize.isEnabled());
    }

    public String title4PopupWindow() {
        return PaneTitleConstants.CHART_STYLE_TITLE_TITLE;
    }

    protected JPanel createContentPane() {
        return new ContentPane();
    }

    public void populateBean(VanChart vanChart) {
        VanChartTitle vanChartTitle = (VanChartTitle)vanChart.getTitle();
        if (vanChartTitle == null) {
            return;
        }
        this.isTitleVisible.setSelected(vanChartTitle.isTitleVisible());
        if (vanChartTitle.getTextObject() instanceof Formula) {
            this.titleContent.populateBean(((Formula)vanChartTitle.getTextObject()).getContent());
        } else {
            this.titleContent.populateBean(Utils.objectToString((Object)vanChartTitle.getTextObject()));
        }
        if (!vanChartTitle.isFloating()) {
            this.alignmentPane.setSelectedItem((Object)vanChartTitle.getPosition());
        } else {
            this.alignmentPane.setSelectedIndex(-1);
        }
        TextAttr textAttr = vanChartTitle.getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        this.textAttrPane.populate(textAttr);
        this.backgroundPane.populate((GeneralInfo)vanChartTitle);
        this.useHtml.setSelected(vanChartTitle.isUseHtml());
        this.customFloatPositionButton.setSelected(vanChartTitle.isFloating());
        this.customFloatPositionPane.setFloatPosition_x(vanChartTitle.getFloatPercentX());
        this.customFloatPositionPane.setFloatPosition_y(vanChartTitle.getFloatPercentY());
        this.limitSize.setSelectedIndex(vanChartTitle.isLimitSize() ? 0 : 1);
        this.maxProportion.setValue(vanChartTitle.getMaxHeight());
        this.checkAllUse();
    }

    public void updateBean(VanChart vanChart) {
        VanChartTitle vanChartTitle;
        if (vanChart == null) {
            vanChart = new VanChart();
        }
        if ((vanChartTitle = (VanChartTitle)vanChart.getTitle()) == null) {
            vanChartTitle = new VanChartTitle("");
        }
        vanChartTitle.setTitleVisible(this.isTitleVisible.isSelected());
        String string = this.titleContent.updateBean();
        String string2 = StableUtils.maybeFormula((String)string) ? new Formula(string) : string;
        vanChartTitle.setTextObject(string2);
        TextAttr textAttr = vanChartTitle.getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        if (!this.customFloatPositionButton.isSelected()) {
            vanChartTitle.setPosition((Integer)this.alignmentPane.getSelectedItem());
        }
        vanChartTitle.setUseHtml(this.useHtml.isSelected());
        vanChartTitle.setFloating(this.customFloatPositionButton.isSelected());
        vanChartTitle.setLimitSize(this.limitSize.getSelectedIndex() == 0);
        vanChartTitle.setMaxHeight(this.maxProportion.getValue());
        vanChartTitle.setFloatPercentX(this.customFloatPositionPane.getFloatPosition_x());
        vanChartTitle.setFloatPercentY(this.customFloatPositionPane.getFloatPosition_y());
        this.textAttrPane.update(textAttr);
        this.backgroundPane.update((GeneralInfo)vanChartTitle);
    }

    private class ContentPane
    extends JPanel {
        private static final long serialVersionUID = 5601169655874455336L;

        public ContentPane() {
            this.initComponents();
        }

        private void initComponents() {
            VanChartTitlePane.this.isTitleVisible = new UICheckBox(Inter.getLocText((String)"Chart-Title_Is_Visible"));
            VanChartTitlePane.this.titlePane = VanChartTitlePane.this.createTitlePane();
            double d = -2.0;
            double d2 = -1.0;
            double[] dArray = new double[]{d2};
            double[] dArray2 = new double[]{d, d, d};
            Component[][] componentArray = new Component[][]{{VanChartTitlePane.this.isTitleVisible}, {new JSeparator()}, {VanChartTitlePane.this.titlePane}};
            JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "Center");
            VanChartTitlePane.this.isTitleVisible.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VanChartTitlePane.this.checkTitlePaneUse();
                }
            });
        }
    }
}

