/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer;

import com.fr.chart.chartattr.Plot;
import com.fr.general.FRLogger;
import com.fr.plugin.chart.bubble.VanChartBubblePlot;
import com.fr.plugin.chart.designer.style.VanChartPlotLegendPane;
import com.fr.plugin.chart.designer.style.VanChartStylePane;
import com.fr.plugin.chart.designer.style.label.VanChartGaugePlotLabelPane;
import com.fr.plugin.chart.designer.style.label.VanChartPlotLabelPane;
import com.fr.plugin.chart.designer.style.tooltip.VanChartPlotTooltipPane;
import com.fr.plugin.chart.gauge.VanChartGaugePlot;
import com.fr.plugin.chart.gauge.VanChartGaugePlotTooltipPane;
import com.fr.plugin.chart.scatter.VanChartScatterPlot;
import com.fr.plugin.chart.scatter.VanChartScatterPlotLegendPane;
import com.fr.plugin.chart.scatter.VanChartScatterPlotTooltipPane;
import com.fr.plugin.chart.scatter.component.label.VanChartScatterPlotLabelPane;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class PlotFactory {
    private static Map<Class<? extends Plot>, Class<? extends VanChartPlotLabelPane>> labelMap = new HashMap<Class<? extends Plot>, Class<? extends VanChartPlotLabelPane>>();
    private static Map<Class<? extends Plot>, Class<? extends VanChartPlotLegendPane>> legendMap;
    private static Map<Class<? extends Plot>, Class<? extends VanChartPlotTooltipPane>> toolTipMap;

    public static VanChartPlotLabelPane createPlotLabelPane(Plot plot, VanChartStylePane vanChartStylePane) {
        Class<?> clazz = plot.getClass();
        if (labelMap.containsKey(clazz)) {
            try {
                Class<? extends VanChartPlotLabelPane> clazz2 = labelMap.get(clazz);
                Constructor<? extends VanChartPlotLabelPane> constructor = clazz2.getConstructor(Plot.class, VanChartStylePane.class);
                return constructor.newInstance(new Object[]{plot, vanChartStylePane});
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
            }
        }
        return new VanChartPlotLabelPane(plot, vanChartStylePane);
    }

    public static VanChartPlotLegendPane createPlotLegendPane(Plot plot, VanChartStylePane vanChartStylePane) {
        Class<?> clazz = plot.getClass();
        if (legendMap.containsKey(clazz)) {
            try {
                Class<? extends VanChartPlotLegendPane> clazz2 = legendMap.get(clazz);
                Constructor<? extends VanChartPlotLegendPane> constructor = clazz2.getConstructor(VanChartStylePane.class);
                return constructor.newInstance(new Object[]{vanChartStylePane});
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
            }
        }
        return new VanChartPlotLegendPane(vanChartStylePane);
    }

    public static VanChartPlotTooltipPane createPlotTooltipPane(Plot plot, VanChartStylePane vanChartStylePane) {
        Class<?> clazz = plot.getClass();
        if (toolTipMap.containsKey(clazz)) {
            try {
                Class<? extends VanChartPlotTooltipPane> clazz2 = toolTipMap.get(clazz);
                Constructor<? extends VanChartPlotTooltipPane> constructor = clazz2.getConstructor(Plot.class, VanChartStylePane.class);
                return constructor.newInstance(new Object[]{plot, vanChartStylePane});
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
            }
        }
        return new VanChartPlotTooltipPane(plot, vanChartStylePane);
    }

    static {
        labelMap.put(VanChartGaugePlot.class, VanChartGaugePlotLabelPane.class);
        labelMap.put(VanChartScatterPlot.class, VanChartScatterPlotLabelPane.class);
        labelMap.put(VanChartBubblePlot.class, VanChartScatterPlotLabelPane.class);
        legendMap = new HashMap<Class<? extends Plot>, Class<? extends VanChartPlotLegendPane>>();
        legendMap.put(VanChartScatterPlot.class, VanChartScatterPlotLegendPane.class);
        legendMap.put(VanChartBubblePlot.class, VanChartScatterPlotLegendPane.class);
        toolTipMap = new HashMap<Class<? extends Plot>, Class<? extends VanChartPlotTooltipPane>>();
        toolTipMap.put(VanChartGaugePlot.class, VanChartGaugePlotTooltipPane.class);
        toolTipMap.put(VanChartScatterPlot.class, VanChartScatterPlotTooltipPane.class);
        toolTipMap.put(VanChartBubblePlot.class, VanChartScatterPlotTooltipPane.class);
    }
}

