/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.column;

import com.fr.base.background.ColorBackground;
import com.fr.base.background.ImageBackground;
import com.fr.base.chart.Glyph;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.chartglyph.ChartStyle;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LinearEquation;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TrendLineGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.axis.AxisType;
import com.fr.plugin.chart.base.AttrSeriesImageBackground;
import com.fr.plugin.chart.base.AttrSeriesStackAndAxis;
import com.fr.plugin.chart.base.VanChartAttrTrendLine;
import com.fr.plugin.chart.column.ColumnTopDownShadeStyle;
import com.fr.plugin.chart.column.VanChartColumnDataPoint;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.glyph.VanChartRectanglePlotGlyph;
import com.fr.plugin.chart.glyph.axis.VanChartBaseAxisGlyph;
import com.fr.plugin.chart.glyph.axis.VanChartCategoryAxisGlyph;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class VanChartColumnPlotGlyph
extends VanChartRectanglePlotGlyph {
    private static final long serialVersionUID = -1007991635958523854L;
    private static final double LABEL_BAR_GAP = 6.0;
    private static final double LABEL_COLUMN_GAP = 3.0;
    private double seriesOverlapPercent = 20.0;
    private double categoryIntervalPercent = 20.0;
    private boolean fixedWidth = false;
    private int columnWidth = 0;
    private boolean filledWithImage = false;
    private boolean isBar = false;
    private AttrSeriesImageBackground defaultAttrSeriesImageBackground;

    public void setBar(boolean bl) {
        this.isBar = bl;
    }

    public boolean isBar() {
        return this.isBar;
    }

    public void setSeriesOverlapPercent(double d) {
        this.seriesOverlapPercent = d;
    }

    public double getSeriesOverlapPercent() {
        return this.seriesOverlapPercent;
    }

    public void setCategoryIntervalPercent(double d) {
        this.categoryIntervalPercent = d;
    }

    public double getCategoryIntervalPercent() {
        return this.categoryIntervalPercent;
    }

    public void setColumnWidth(int n) {
        this.columnWidth = n;
    }

    public void setFilledWithImage(boolean bl) {
        this.filledWithImage = bl;
    }

    public void setFixedWidth(boolean bl) {
        this.fixedWidth = bl;
    }

    public boolean isFilledWithImage() {
        return this.filledWithImage;
    }

    public boolean isFixedWidth() {
        return this.fixedWidth;
    }

    private AttrSeriesImageBackground getDefaultAttrSeriesImageBackground() {
        if (this.defaultAttrSeriesImageBackground == null) {
            ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
            this.defaultAttrSeriesImageBackground = (AttrSeriesImageBackground)conditionAttr.getExisted(AttrSeriesImageBackground.class);
        }
        return this.defaultAttrSeriesImageBackground;
    }

    private AttrSeriesImageBackground getAttrSeriesImageBackground(VanChartColumnDataPoint vanChartColumnDataPoint) {
        AttrSeriesImageBackground attrSeriesImageBackground = vanChartColumnDataPoint.getImageBackground();
        if (attrSeriesImageBackground == null) {
            attrSeriesImageBackground = this.getDefaultAttrSeriesImageBackground();
        }
        return attrSeriesImageBackground;
    }

    @Override
    protected void initXAxisLabelDrawPosition(VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        if (!this.isBar()) {
            this.setAxisLabelDrawBetween(vanChartBaseAxisGlyph);
        }
    }

    @Override
    protected void initYAxisLabelDrawPosition(VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        if (this.isBar()) {
            this.setAxisLabelDrawBetween(vanChartBaseAxisGlyph);
        }
    }

    @Override
    protected void initXAxisGlyphMinMaxValue(int n, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        if (this.isBar()) {
            super.initYAxisGlyphMinMaxValue(n, vanChartBaseAxisGlyph);
        } else {
            super.initXAxisGlyphMinMaxValue(n, vanChartBaseAxisGlyph);
        }
    }

    @Override
    protected void initYAxisGlyphMinMaxValue(int n, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        if (this.isBar()) {
            super.initXAxisGlyphMinMaxValue(n, vanChartBaseAxisGlyph);
        } else {
            super.initYAxisGlyphMinMaxValue(n, vanChartBaseAxisGlyph);
        }
    }

    @Override
    protected int getValueAxisIndex(AttrSeriesStackAndAxis attrSeriesStackAndAxis) {
        return attrSeriesStackAndAxis == null ? 0 : (this.isBar ? attrSeriesStackAndAxis.getXAxisIndex() : attrSeriesStackAndAxis.getYAxisIndex());
    }

    @Override
    protected int getCateAxisIndex(AttrSeriesStackAndAxis attrSeriesStackAndAxis) {
        return attrSeriesStackAndAxis == null ? 0 : (this.isBar ? attrSeriesStackAndAxis.getYAxisIndex() : attrSeriesStackAndAxis.getXAxisIndex());
    }

    @Override
    protected VanChartBaseAxisGlyph getCateAxis(int n) {
        return this.isBar ? (VanChartBaseAxisGlyph)((Object)this.yAxisGlyphList.get(n)) : (VanChartBaseAxisGlyph)((Object)this.xAxisGlyphList.get(n));
    }

    @Override
    protected boolean isAdjustXAxisMinMaxValue() {
        return true;
    }

    @Override
    public void layoutDataSeriesGlyph(int n) {
        super.layoutDataSeriesGlyph(n);
        Map<String, List<List<Number>>> map = this.buildAxisMap(false);
        for (String string : map.keySet()) {
            this.buildSingleAxisBars(map.get(string), n);
        }
        this.dealTrendLine();
    }

    private void dealTrendLine() {
        int n = this.getSeriesSize();
        for (int i = 0; i < n; ++i) {
            VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(i);
            VanChartAttrTrendLine vanChartAttrTrendLine = this.getAttrTrendLine(vanChartDataSeries);
            if (vanChartAttrTrendLine == null) continue;
            int n2 = this.calculateLineDataCount(vanChartDataSeries);
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            n2 = 0;
            VanChartBaseAxisGlyph vanChartBaseAxisGlyph = this.getDataSeriesValueAxisGlyph(vanChartDataSeries);
            boolean bl = vanChartBaseAxisGlyph.hasAxisReversed();
            boolean bl2 = vanChartBaseAxisGlyph.isPercentage();
            int n3 = vanChartDataSeries.getDataPointCount();
            for (int j = 0; j < n3; ++j) {
                DataPoint dataPoint = vanChartDataSeries.getDataPoint(j);
                if (dataPoint.isValueIsNull() || dataPoint.getDrawImpl() == null) continue;
                this.calculateFittingData(bl2, bl, dataPoint.getValue(), dArray, dArray2, n2, dataPoint.getDrawImpl().getShape());
                ++n2;
            }
            this.trendLineFitting(dArray, dArray2, vanChartDataSeries);
        }
    }

    private void calculateFittingData(boolean bl, boolean bl2, double d, double[] dArray, double[] dArray2, int n, Shape shape) {
        boolean bl3;
        if (shape == null) {
            return;
        }
        RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
        boolean bl4 = bl3 = d > 0.0 != bl2;
        if (bl) {
            bl3 = true;
        }
        if (this.isBar()) {
            if (bl3) {
                dArray[n] = roundRectangle2D.getX() + roundRectangle2D.getWidth();
                dArray2[n] = roundRectangle2D.getCenterY();
            } else {
                dArray[n] = roundRectangle2D.getX();
                dArray2[n] = roundRectangle2D.getCenterY();
            }
        } else if (bl3) {
            dArray[n] = roundRectangle2D.getCenterX();
            dArray2[n] = roundRectangle2D.getY();
        } else {
            dArray[n] = roundRectangle2D.getCenterX();
            dArray2[n] = roundRectangle2D.getY() + roundRectangle2D.getHeight();
        }
    }

    @Override
    protected void initTrendLineGlyph(TrendLineGlyph trendLineGlyph, double[] dArray, double[] dArray2) {
        if (this.isBar()) {
            int n = dArray.length - 1;
            LinearEquation linearEquation = (LinearEquation)trendLineGlyph.getEquation();
            trendLineGlyph.fitting(dArray2, dArray);
            double d = linearEquation.execute(dArray2[0]);
            double d2 = linearEquation.execute(dArray2[n]);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(d, dArray2[0]);
            generalPath.lineTo(d2, dArray2[n]);
            generalPath.closePath();
            trendLineGlyph.setGeneralPath(generalPath);
        } else {
            super.initTrendLineGlyph(trendLineGlyph, dArray, dArray2);
        }
    }

    @Override
    protected VanChartBaseAxisGlyph getDataSeriesValueAxisGlyph(VanChartDataSeries vanChartDataSeries) {
        return this.isBar() ? (VanChartBaseAxisGlyph)((Object)this.xAxisGlyphList.get(this.getXAxisGlyphIndex(vanChartDataSeries.getAttrSeriesStackAndAxis()))) : (VanChartBaseAxisGlyph)((Object)this.yAxisGlyphList.get(this.getYAxisGlyphIndex(vanChartDataSeries.getAttrSeriesStackAndAxis())));
    }

    @Override
    protected VanChartBaseAxisGlyph getDataSeriesCateAxisGlyph(VanChartDataSeries vanChartDataSeries) {
        return this.isBar() ? (VanChartBaseAxisGlyph)((Object)this.yAxisGlyphList.get(this.getYAxisGlyphIndex(vanChartDataSeries.getAttrSeriesStackAndAxis()))) : (VanChartBaseAxisGlyph)((Object)this.xAxisGlyphList.get(this.getXAxisGlyphIndex(vanChartDataSeries.getAttrSeriesStackAndAxis())));
    }

    private void buildSingleAxisBars(List<List<Number>> list, int n) {
        int n2 = list.get(0).get(0).intValue();
        VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(n2);
        VanChartBaseAxisGlyph vanChartBaseAxisGlyph = this.getDataSeriesCateAxisGlyph(vanChartDataSeries);
        if (ComparatorUtils.equals((Object)((Object)vanChartBaseAxisGlyph.getVanAxisType()), (Object)((Object)AxisType.AXIS_CATEGORY))) {
            this.buildNormalBars(list, (VanChartCategoryAxisGlyph)vanChartBaseAxisGlyph, n);
        } else {
            this.buildDoubleValueBars(list, vanChartBaseAxisGlyph, n);
        }
    }

    private void buildDoubleValueBars(List<List<Number>> list, VanChartBaseAxisGlyph vanChartBaseAxisGlyph, int n) {
        double d = this.getAllPointsCount();
        if (d > 0.0) {
            double d2 = this.fixedWidth ? (double)this.columnWidth : vanChartBaseAxisGlyph.getAxisLength() / d / 3.0;
            double d3 = vanChartBaseAxisGlyph.getCrossValueInPlot();
            for (List<Number> list2 : list) {
                HashMap<String, Double> hashMap = new HashMap<String, Double>();
                HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
                for (Number number : list2) {
                    VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(number.intValue());
                    VanChartBaseAxisGlyph vanChartBaseAxisGlyph2 = this.getDataSeriesValueAxisGlyph(vanChartDataSeries);
                    double d4 = vanChartBaseAxisGlyph2.getCrossValueInPlot();
                    int n2 = vanChartDataSeries.getDataPointCount();
                    for (int i = 0; i < n2; ++i) {
                        double d5;
                        Number number2;
                        double d6;
                        VanChartColumnDataPoint vanChartColumnDataPoint = (VanChartColumnDataPoint)vanChartDataSeries.getDataPoint(i);
                        double d7 = this.getCateValue(vanChartBaseAxisGlyph, vanChartColumnDataPoint, true);
                        double d8 = this.getBarXValueStart(d7, d3, vanChartBaseAxisGlyph) - d2 / 2.0;
                        double d9 = d6 = vanChartBaseAxisGlyph2.isPercentage() ? vanChartColumnDataPoint.getPercentValue() : vanChartColumnDataPoint.getValue();
                        if (d6 > 0.0) {
                            number2 = (Number)hashMap.get(String.valueOf(d7));
                            d5 = d6 + (number2 == null ? 0.0 : number2.doubleValue());
                            hashMap.put(String.valueOf(d7), d5);
                        } else {
                            number2 = (Number)hashMap2.get(String.valueOf(d7));
                            d5 = d6 + (number2 == null ? 0.0 : number2.doubleValue());
                            hashMap2.put(String.valueOf(d7), d5);
                        }
                        double d10 = vanChartBaseAxisGlyph2.get2ValueLength(d6, d4);
                        double d11 = this.getBarValueStart(d5, number2 == null ? d4 : number2.doubleValue(), vanChartBaseAxisGlyph2);
                        AttrBorder attrBorder = this.getAttrBorder(vanChartColumnDataPoint);
                        this.buildDataPointDrawImpl(vanChartBaseAxisGlyph2, vanChartColumnDataPoint, this.getBarShape(d8, d2, d11, d10, attrBorder.getRoundRadius()), n);
                    }
                }
            }
        }
    }

    private int getAllPointsCount() {
        DataSeries dataSeries;
        if (this.getSeriesSize() > 0 && (dataSeries = this.getSeries(0)).getDataPointCount() > 0) {
            return this.getSeriesSize() * dataSeries.getDataPointCount();
        }
        return 0;
    }

    private void buildNormalBars(List<List<Number>> list, VanChartCategoryAxisGlyph vanChartCategoryAxisGlyph, int n) {
        int n2 = vanChartCategoryAxisGlyph.getCategoryCount();
        int n3 = list.size();
        double d = vanChartCategoryAxisGlyph.getUnitLen();
        double d2 = d * this.categoryIntervalPercent / 100.0;
        double d3 = (d - d2) / (double)n3;
        double d4 = this.fixedWidth ? (double)this.columnWidth : d3 * (1.0 - this.seriesOverlapPercent / 100.0);
        for (int i = 0; i < n2; ++i) {
            double d5 = this.getCateStart(d, vanChartCategoryAxisGlyph, n2, i);
            for (int j = 0; j < n3; ++j) {
                List<Number> list2 = list.get(j);
                double d6 = d5 + d2 / 2.0 + (double)j * d3 + d3 / 2.0;
                double d7 = d6 - d4 / 2.0;
                VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(list2.get(0).intValue());
                VanChartBaseAxisGlyph vanChartBaseAxisGlyph = this.getDataSeriesValueAxisGlyph(vanChartDataSeries);
                double d8 = vanChartBaseAxisGlyph.getCrossValueInPlot();
                if (list2.size() == 1) {
                    VanChartColumnDataPoint vanChartColumnDataPoint = (VanChartColumnDataPoint)vanChartDataSeries.getDataPoint(i);
                    double d9 = vanChartBaseAxisGlyph.isPercentage() ? vanChartColumnDataPoint.getPercentValue() : vanChartColumnDataPoint.getValue();
                    double d10 = vanChartBaseAxisGlyph.get2ValueLength(d9, d8);
                    double d11 = this.getBarValueStart(d9, d8, vanChartBaseAxisGlyph);
                    AttrBorder attrBorder = this.getAttrBorder(vanChartColumnDataPoint);
                    this.buildDataPointDrawImpl(vanChartBaseAxisGlyph, vanChartColumnDataPoint, this.getBarShape(d7, d4, d11, d10, attrBorder.getRoundRadius()), n);
                    continue;
                }
                double d12 = 0.0;
                double d13 = 0.0;
                for (Number number : list2) {
                    double d14;
                    VanChartColumnDataPoint vanChartColumnDataPoint = (VanChartColumnDataPoint)this.getSeries(number.intValue()).getDataPoint(i);
                    double d15 = vanChartBaseAxisGlyph.isPercentage() ? vanChartColumnDataPoint.getPercentValue() : vanChartColumnDataPoint.getValue();
                    double d16 = 0.0;
                    if (d15 > 0.0) {
                        d16 = vanChartBaseAxisGlyph.get2ValueLength(d15 + d12, d12);
                        d14 = this.getBarValueStart(d15 + d12, d12, vanChartBaseAxisGlyph);
                        d12 += d15;
                    } else {
                        d16 = vanChartBaseAxisGlyph.get2ValueLength(d15 + d13, d13);
                        d14 = this.getBarValueStart(d15 + d13, d13, vanChartBaseAxisGlyph);
                        d13 += d15;
                    }
                    AttrBorder attrBorder = this.getAttrBorder(vanChartColumnDataPoint);
                    this.buildDataPointDrawImpl(vanChartBaseAxisGlyph, vanChartColumnDataPoint, this.getBarShape(d7, d4, d14, d16, attrBorder.getRoundRadius()), n);
                }
            }
        }
    }

    private double getCateStart(double d, VanChartBaseAxisGlyph vanChartBaseAxisGlyph, int n, int n2) {
        if (this.isBar()) {
            if (vanChartBaseAxisGlyph.hasAxisReversed()) {
                return d * (double)n2;
            }
            return d * (double)(n - n2 - 1);
        }
        if (vanChartBaseAxisGlyph.hasAxisReversed()) {
            return d * (double)(n - n2 - 1);
        }
        return d * (double)n2;
    }

    private double getBarValueStart(double d, double d2, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        if (d > d2) {
            if (this.isBar()) {
                if (vanChartBaseAxisGlyph.hasAxisReversed()) {
                    return vanChartBaseAxisGlyph.getPointInBounds(d).getX();
                }
                return vanChartBaseAxisGlyph.getPointInBounds(d2).getX();
            }
            if (vanChartBaseAxisGlyph.hasAxisReversed()) {
                return vanChartBaseAxisGlyph.getPointInBounds(d2).getY();
            }
            return vanChartBaseAxisGlyph.getPointInBounds(d).getY();
        }
        if (this.isBar()) {
            if (vanChartBaseAxisGlyph.hasAxisReversed()) {
                return vanChartBaseAxisGlyph.getPointInBounds(d2).getX();
            }
            return vanChartBaseAxisGlyph.getPointInBounds(d).getX();
        }
        if (vanChartBaseAxisGlyph.hasAxisReversed()) {
            return vanChartBaseAxisGlyph.getPointInBounds(d).getY();
        }
        return vanChartBaseAxisGlyph.getPointInBounds(d2).getY();
    }

    private double getBarXValueStart(double d, double d2, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        if (this.isBar()) {
            return vanChartBaseAxisGlyph.getPoint2D(d).getY();
        }
        return vanChartBaseAxisGlyph.getPoint2D(d).getX();
    }

    private void buildDataPointDrawImpl(VanChartBaseAxisGlyph vanChartBaseAxisGlyph, VanChartColumnDataPoint vanChartColumnDataPoint, RectangularShape rectangularShape, int n) {
        if (vanChartColumnDataPoint.isValueIsNull()) {
            return;
        }
        AttrSeriesImageBackground attrSeriesImageBackground = this.getAttrSeriesImageBackground(vanChartColumnDataPoint);
        ShapeGlyph shapeGlyph = attrSeriesImageBackground != null ? new ColumnImageShapeGlyph(this.getBarImageDirection(vanChartColumnDataPoint, vanChartBaseAxisGlyph)) : new ShapeGlyph();
        vanChartColumnDataPoint.setDrawImpl((Glyph)shapeGlyph);
        if (this.isOutPlotBounds(rectangularShape)) {
            shapeGlyph.setShape(null);
            vanChartColumnDataPoint.setDataLabel(null);
            return;
        }
        shapeGlyph.setShape((Shape)rectangularShape);
        this.changeInfoWithCondition(shapeGlyph.getGeneralInfo(), vanChartColumnDataPoint);
        if (attrSeriesImageBackground != null) {
            shapeGlyph.getGeneralInfo().changeStyleAttrBackground((AttrBackground)attrSeriesImageBackground);
        }
        this.addChartStyle4DataPoint(vanChartColumnDataPoint, shapeGlyph, rectangularShape);
        this.dealDataPointLabel(vanChartColumnDataPoint, n);
    }

    private Direction getBarImageDirection(DataPoint dataPoint, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        if (dataPoint.getValue() > vanChartBaseAxisGlyph.getCrossValue()) {
            if (this.isBar()) {
                if (vanChartBaseAxisGlyph.hasAxisReversed()) {
                    return Direction.BAR_TOP_RIGHT;
                }
                return Direction.BAR_TOP_LEFT;
            }
            if (vanChartBaseAxisGlyph.hasAxisReversed()) {
                return Direction.COLUMN_LEFT_TOP;
            }
            return Direction.COLUMN_LEFT_BOTTOM;
        }
        if (this.isBar()) {
            if (vanChartBaseAxisGlyph.hasAxisReversed()) {
                return Direction.BAR_TOP_LEFT;
            }
            return Direction.BAR_TOP_RIGHT;
        }
        if (vanChartBaseAxisGlyph.hasAxisReversed()) {
            return Direction.COLUMN_LEFT_BOTTOM;
        }
        return Direction.COLUMN_LEFT_TOP;
    }

    @Override
    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n, DataPoint dataPoint) {
        VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(dataPoint.getSeriesIndex());
        VanChartBaseAxisGlyph vanChartBaseAxisGlyph = this.getDataSeriesValueAxisGlyph(vanChartDataSeries);
        if (this.isBar()) {
            return this.getLabelBoundsInHorizontal(dimension2D, rectangle2D, n, vanChartBaseAxisGlyph);
        }
        return this.getLabelBoundsInVertical(dimension2D, rectangle2D, n, vanChartBaseAxisGlyph);
    }

    private Rectangle2D getLabelBoundsInVertical(Dimension2D dimension2D, Rectangle2D rectangle2D, int n, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        double d;
        boolean bl;
        double d2 = vanChartBaseAxisGlyph.getPoint2D(0.0).getY();
        boolean bl2 = vanChartBaseAxisGlyph.hasAxisReversed();
        boolean bl3 = bl2 ? rectangle2D.getMinY() < d2 : (bl = rectangle2D.getMaxY() > d2);
        if (bl ^= bl2) {
            switch (n) {
                case 5: {
                    d = rectangle2D.getY() + rectangle2D.getHeight() - 3.0 - dimension2D.getHeight();
                    break;
                }
                case 6: {
                    d = rectangle2D.getY() + rectangle2D.getHeight() + 3.0;
                    break;
                }
                default: {
                    d = rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0;
                    break;
                }
            }
        } else {
            switch (n) {
                case 5: {
                    d = rectangle2D.getY() + 3.0;
                    break;
                }
                case 6: {
                    d = rectangle2D.getY() - dimension2D.getHeight() - 3.0;
                    break;
                }
                default: {
                    d = rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0;
                }
            }
        }
        return new Rectangle2D.Double(rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0, d, dimension2D.getWidth(), dimension2D.getHeight());
    }

    private Rectangle2D getLabelBoundsInHorizontal(Dimension2D dimension2D, Rectangle2D rectangle2D, int n, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        double d;
        boolean bl;
        double d2 = vanChartBaseAxisGlyph.getPoint2D(0.0).getX();
        boolean bl2 = vanChartBaseAxisGlyph.hasAxisReversed();
        boolean bl3 = bl2 ? rectangle2D.getMaxX() > d2 : (bl = rectangle2D.getMinX() < d2);
        if (bl ^= bl2) {
            switch (n) {
                case 5: {
                    d = rectangle2D.getX() + 6.0;
                    break;
                }
                case 6: {
                    d = rectangle2D.getX() - dimension2D.getWidth() - 6.0;
                    break;
                }
                default: {
                    d = rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0;
                    break;
                }
            }
        } else {
            switch (n) {
                case 5: {
                    d = rectangle2D.getX() + rectangle2D.getWidth() - dimension2D.getWidth() - 6.0;
                    break;
                }
                case 6: {
                    d = rectangle2D.getX() + rectangle2D.getWidth() + 6.0;
                    break;
                }
                default: {
                    d = rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0;
                }
            }
        }
        return new Rectangle2D.Double(d, rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
    }

    private RectangularShape getBarShape(double d, double d2, double d3, double d4, double d5) {
        if (this.isBar()) {
            return new RoundRectangle2D.Double(d3, d, d4, d2, d5, d5);
        }
        return new RoundRectangle2D.Double(d, d3, d2, d4, d5, d5);
    }

    private boolean isOutPlotBounds(RectangularShape rectangularShape) {
        Rectangle2D rectangle2D = this.getBounds();
        double d = rectangularShape.getX();
        double d2 = rectangularShape.getMaxX();
        double d3 = rectangularShape.getY();
        double d4 = rectangularShape.getMaxY();
        return this.isBar() ? d4 < 0.0 || d3 > rectangle2D.getHeight() + 1.0 : d2 < 0.0 || d > rectangle2D.getWidth() + 1.0;
    }

    private void addChartStyle4DataPoint(VanChartColumnDataPoint vanChartColumnDataPoint, ShapeGlyph shapeGlyph, RectangularShape rectangularShape) {
        int n = this.plotStyle;
        if (shapeGlyph.getBackground() instanceof ColorBackground) {
            Color color = ((ColorBackground)shapeGlyph.getBackground()).getColor();
            ColumnTopDownShadeStyle columnTopDownShadeStyle = null;
            VanChartBaseAxisGlyph vanChartBaseAxisGlyph = this.getDataSeriesValueAxisGlyph((VanChartDataSeries)this.getSeries(vanChartColumnDataPoint.getSeriesIndex()));
            boolean bl = vanChartBaseAxisGlyph.hasAxisReversed();
            if (n == 4) {
                columnTopDownShadeStyle = new ColumnTopDownShadeStyle(color, rectangularShape, this.isBar, true, bl);
            }
            if (columnTopDownShadeStyle != null && this.getAttrAlpha(vanChartColumnDataPoint) != null) {
                columnTopDownShadeStyle.setAlpha(shapeGlyph.getAlpha());
            }
            if (columnTopDownShadeStyle != null && this.getAttrBorder(vanChartColumnDataPoint) != null) {
                columnTopDownShadeStyle.setBorderWidth(VanChartAttrHelper.getAxisLineStyle(shapeGlyph.getBorderStyle()));
                columnTopDownShadeStyle.setBorderColor(shapeGlyph.getBorderColor() == null ? new Color(0, 0, 0, 0) : shapeGlyph.getBorderColor());
            }
            if (columnTopDownShadeStyle != null) {
                vanChartColumnDataPoint.setDataPointStyle((ChartStyle)columnTopDownShadeStyle);
            }
        }
    }

    public int[] getDrawSequence() {
        int n = this.getSeriesSize();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = n - 1 - i;
        }
        return nArray;
    }

    @Override
    public JSONObject getPlotOptionsJSON(Repository repository, boolean bl) throws JSONException {
        JSONObject jSONObject = super.getPlotOptionsJSON(repository, bl);
        AttrSeriesImageBackground attrSeriesImageBackground = this.getDefaultAttrSeriesImageBackground();
        if (this.isFilledWithImage() && attrSeriesImageBackground != null) {
            VanChartAttrHelper.addImageBackgroundAndWidthAndHeight(jSONObject, attrSeriesImageBackground, repository);
        }
        jSONObject.put("gap", (Object)(this.getSeriesOverlapPercent() + "%"));
        jSONObject.put("categoryGap", (Object)(this.getCategoryIntervalPercent() + "%"));
        if (this.isFixedWidth()) {
            jSONObject.put("width", this.columnWidth);
        }
        return jSONObject;
    }

    public String getChartType() {
        return this.isBar ? "bar" : "column";
    }

    private class ColumnImageShapeGlyph
    extends ShapeGlyph {
        private Direction direction;

        private ColumnImageShapeGlyph(Direction direction) {
            this.direction = direction;
        }

        protected void paintBackground(Graphics2D graphics2D, Shape shape) {
            if (this.getBackground() != null && this.getBackground() instanceof ImageBackground) {
                Shape shape2 = graphics2D.getClip();
                graphics2D.setClip(shape);
                this.getBackground().paint((Graphics)graphics2D, this.getPaintBounds(shape));
                graphics2D.setClip(shape2);
            }
        }

        private Shape getPaintBounds(Shape shape) {
            ImageBackground imageBackground = (ImageBackground)this.getBackground();
            Rectangle2D rectangle2D = shape.getBounds2D();
            switch (this.direction) {
                case COLUMN_LEFT_BOTTOM: {
                    int n = imageBackground.getImage().getHeight(new JPanel());
                    double d = Math.ceil(rectangle2D.getHeight() / (double)n) * (double)n;
                    return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() - (d - rectangle2D.getHeight()), rectangle2D.getWidth(), d);
                }
                case COLUMN_LEFT_TOP: {
                    return shape;
                }
                case BAR_TOP_LEFT: {
                    return shape;
                }
                case BAR_TOP_RIGHT: {
                    int n = imageBackground.getImage().getWidth(new JPanel());
                    double d = Math.ceil(rectangle2D.getWidth() / (double)n) * (double)n;
                    return new Rectangle2D.Double(rectangle2D.getX() - (d - rectangle2D.getWidth()), rectangle2D.getY(), d, rectangle2D.getHeight());
                }
            }
            return shape;
        }
    }

    private static enum Direction {
        COLUMN_LEFT_BOTTOM,
        COLUMN_LEFT_TOP,
        BAR_TOP_LEFT,
        BAR_TOP_RIGHT;

    }
}

