/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.base;

import com.fr.base.BaseXMLUtils;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.ImageBackground;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.MarkerType;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class VanChartAttrMarker
extends DataSeriesCondition {
    public static final String XML_TAG = "VanAttrMarker";
    private boolean isCommon = true;
    private MarkerType markerType = MarkerType.MARKER_NULL;
    private ColorBackground colorBackground;
    private double radius = 4.5;
    private ImageBackground imageBackground;
    private double width = 30.0;
    private double height = 30.0;

    public void setColorBackground(ColorBackground colorBackground) {
        this.colorBackground = colorBackground;
    }

    public void setCommon(boolean bl) {
        this.isCommon = bl;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public void setImageBackground(ImageBackground imageBackground) {
        this.imageBackground = imageBackground;
    }

    public void setMarkerType(MarkerType markerType) {
        this.markerType = markerType;
    }

    public void setRadius(double d) {
        this.radius = d;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public ImageBackground getImageBackground() {
        return this.imageBackground;
    }

    public double getWidth() {
        return this.width;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getHeight() {
        return this.height;
    }

    public ColorBackground getColorBackground() {
        return this.colorBackground;
    }

    public boolean isCommon() {
        return this.isCommon;
    }

    public MarkerType getMarkerType() {
        return this.markerType;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                if (xMLableReader.getAttrAsColor("color", null) != null) {
                    this.setColorBackground(ColorBackground.getInstance((Color)xMLableReader.getAttrAsColor("color", null)));
                }
                this.setMarkerType(MarkerType.parse(xMLableReader.getAttrAsString("markerType", "NullMarker")));
                this.setRadius(xMLableReader.getAttrAsDouble("radius", 4.5));
                this.setCommon(xMLableReader.getAttrAsBoolean("isCommon", true));
                this.setWidth(xMLableReader.getAttrAsDouble("width", 4.5));
                this.setHeight(xMLableReader.getAttrAsDouble("height", 4.5));
            } else if (string.equals("Background")) {
                this.setImageBackground((ImageBackground)BaseXMLUtils.readBackground((XMLableReader)xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("isCommon", this.isCommon).attr("markerType", this.markerType.getType()).attr("radius", this.radius).attr("width", this.width).attr("height", this.height);
        if (this.colorBackground != null && this.colorBackground.getColor() != null) {
            xMLPrintWriter.attr("color", this.colorBackground.getColor().getRGB());
        }
        xMLPrintWriter.end();
        BaseXMLUtils.writeBackground((XMLPrintWriter)xMLPrintWriter, (Background)this.imageBackground);
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof VanChartAttrMarker && ComparatorUtils.equals((Object)((VanChartAttrMarker)((Object)object)).isCommon(), (Object)this.isCommon()) && ComparatorUtils.equals((Object)((Object)((VanChartAttrMarker)((Object)object)).getMarkerType()), (Object)((Object)this.getMarkerType())) && ComparatorUtils.equals((Object)((VanChartAttrMarker)((Object)object)).getColorBackground(), (Object)this.getColorBackground()) && ComparatorUtils.equals((Object)((VanChartAttrMarker)((Object)object)).getRadius(), (Object)this.getRadius()) && ComparatorUtils.equals((Object)((VanChartAttrMarker)((Object)object)).getImageBackground(), (Object)this.getImageBackground()) && ComparatorUtils.equals((Object)((VanChartAttrMarker)((Object)object)).getHeight(), (Object)this.getHeight()) && ComparatorUtils.equals((Object)((VanChartAttrMarker)((Object)object)).getWidth(), (Object)this.getWidth());
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("enabled", true);
        if (this.isCommon()) {
            jSONObject.put("radius", this.radius);
            if (this.colorBackground != null) {
                jSONObject.put("fillColor", (Object)StableUtils.javaColorToCSSColor((Color)this.colorBackground.getColor()));
            }
            jSONObject.put("symbol", (Object)VanChartAttrHelper.getMarkerType(this.markerType));
        } else if (this.imageBackground != null) {
            jSONObject.put("symbol", (Object)VanChartAttrHelper.getImageBackground(this.imageBackground, repository));
            jSONObject.put("width", this.width);
            jSONObject.put("height", this.height);
        } else {
            jSONObject.put("enabled", false);
        }
        return jSONObject;
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

