/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.base;

import com.fr.chart.base.DataSeriesCondition;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.LineStyle;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class VanChartAttrLine
extends DataSeriesCondition {
    public static final String XML_TAG = "VanAttrLine";
    private int lineWidth = 2;
    private LineStyle lineStyle = LineStyle.NORMAL;
    private boolean isNullValueBreak = true;

    public void setLineStyle(LineStyle lineStyle) {
        this.lineStyle = lineStyle;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public void setNullValueBreak(boolean bl) {
        this.isNullValueBreak = bl;
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public boolean isNullValueBreak() {
        return this.isNullValueBreak;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            this.setLineWidth(xMLableReader.getAttrAsInt("lineWidth", 5));
            this.setLineStyle(LineStyle.parse(xMLableReader.getAttrAsInt("lineStyle", 0)));
            this.setNullValueBreak(xMLableReader.getAttrAsBoolean("nullValueBreak", true));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("lineWidth", this.lineWidth).attr("lineStyle", this.lineStyle.ordinal()).attr("nullValueBreak", this.isNullValueBreak).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof VanChartAttrLine && ComparatorUtils.equals((Object)((VanChartAttrLine)((Object)object)).getLineWidth(), (Object)this.getLineWidth()) && ComparatorUtils.equals((Object)((Object)((VanChartAttrLine)((Object)object)).getLineStyle()), (Object)((Object)this.getLineStyle())) && ComparatorUtils.equals((Object)((VanChartAttrLine)((Object)object)).isNullValueBreak(), (Object)this.isNullValueBreak());
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        this.addToJSONObject(jSONObject);
        return jSONObject;
    }

    public void addToJSONObject(JSONObject jSONObject) throws JSONException {
        switch (this.lineStyle) {
            case CURVE: {
                jSONObject.put("curve", true);
                break;
            }
            case STEP: {
                jSONObject.put("step", true);
                break;
            }
            default: {
                jSONObject.put("curve", false);
                jSONObject.put("step", false);
            }
        }
        jSONObject.put("connectNulls", !this.isNullValueBreak());
        jSONObject.put("lineWidth", VanChartAttrHelper.getAxisLineStyle(this.getLineWidth()));
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

