/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.base;

import com.fr.base.BaseXMLUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.VanChartHtmlLabel;
import com.fr.plugin.chart.base.format.AttrTooltipCategoryFormat;
import com.fr.plugin.chart.base.format.AttrTooltipPercentFormat;
import com.fr.plugin.chart.base.format.AttrTooltipSeriesFormat;
import com.fr.plugin.chart.base.format.AttrTooltipValueFormat;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.text.Format;

public class AttrTooltipContent
implements XMLable {
    private static final long serialVersionUID = 1834245036047518367L;
    protected static final String PREFIX = "function(){ return ";
    protected static final String SUFFIX = ";}";
    private boolean isCommon = true;
    private AttrTooltipSeriesFormat seriesFormat = new AttrTooltipSeriesFormat();
    private AttrTooltipPercentFormat percentFormat = new AttrTooltipPercentFormat();
    private AttrTooltipCategoryFormat categoryFormat = new AttrTooltipCategoryFormat();
    private AttrTooltipValueFormat valueFormat = new AttrTooltipValueFormat();
    public static final String XML_TAG = "AttrToolTipContent";
    private VanChartHtmlLabel htmlLabel = new VanChartHtmlLabel();

    public VanChartHtmlLabel getHtmlLabel() {
        return this.htmlLabel;
    }

    public void setHtmlLabel(VanChartHtmlLabel vanChartHtmlLabel) {
        this.htmlLabel = vanChartHtmlLabel;
    }

    public void setCommon(boolean bl) {
        this.isCommon = bl;
    }

    public boolean isCommon() {
        return this.isCommon;
    }

    public AttrTooltipSeriesFormat getSeriesFormat() {
        return this.seriesFormat;
    }

    public void setSeriesFormat(AttrTooltipSeriesFormat attrTooltipSeriesFormat) {
        this.seriesFormat = attrTooltipSeriesFormat;
    }

    public AttrTooltipPercentFormat getPercentFormat() {
        return this.percentFormat;
    }

    public void setPercentFormat(AttrTooltipPercentFormat attrTooltipPercentFormat) {
        this.percentFormat = attrTooltipPercentFormat;
    }

    public AttrTooltipCategoryFormat getCategoryFormat() {
        return this.categoryFormat;
    }

    public void setCategoryFormat(AttrTooltipCategoryFormat attrTooltipCategoryFormat) {
        this.categoryFormat = attrTooltipCategoryFormat;
    }

    public AttrTooltipValueFormat getValueFormat() {
        return this.valueFormat;
    }

    public void setValueFormat(AttrTooltipValueFormat attrTooltipValueFormat) {
        this.valueFormat = attrTooltipValueFormat;
    }

    public void setAllSelectFalse() {
        this.getCategoryFormat().setEnable(false);
        this.getSeriesFormat().setEnable(false);
        this.getValueFormat().setEnable(false);
        this.getPercentFormat().setEnable(false);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                this.isCommon = xMLableReader.getAttrAsBoolean("isCommon", true);
                if (this.isCommon()) {
                    this.categoryFormat.setEnable(xMLableReader.getAttrAsBoolean("isCategoryName", false));
                    this.seriesFormat.setEnable(xMLableReader.getAttrAsBoolean("isSeriesName", false));
                    this.valueFormat.setEnable(xMLableReader.getAttrAsBoolean("isValue", true));
                    this.percentFormat.setEnable(xMLableReader.getAttrAsBoolean("isPercentValue", false));
                } else {
                    this.readOldHtmlLabel(xMLableReader);
                }
            } else if ("Format".equals(string)) {
                this.getValueFormat().setFormat(BaseXMLUtils.readFormat((XMLableReader)xMLableReader));
            } else if ("PercentFormat".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "Format".equals(xMLableReader.getTagName())) {
                            AttrTooltipContent.this.getPercentFormat().setFormat(BaseXMLUtils.readFormat((XMLableReader)xMLableReader));
                        }
                    }
                });
            } else if ("CategoryNameFormat".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "Format".equals(xMLableReader.getTagName())) {
                            AttrTooltipContent.this.getCategoryFormat().setFormat(BaseXMLUtils.readFormat((XMLableReader)xMLableReader));
                        }
                    }
                });
            } else if ("SeriesNameFormat".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "Format".equals(xMLableReader.getTagName())) {
                            AttrTooltipContent.this.getSeriesFormat().setFormat(BaseXMLUtils.readFormat((XMLableReader)xMLableReader));
                        }
                    }
                });
            } else if (string.equals("HtmlLabel")) {
                this.setHtmlLabel((VanChartHtmlLabel)xMLableReader.readXMLObject((XMLReadable)new VanChartHtmlLabel()));
            }
        }
    }

    private void readOldHtmlLabel(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("customText", "");
        boolean bl = xMLableReader.getAttrAsBoolean("useHtml", false);
        if (StringUtils.isNotEmpty((String)string) || bl) {
            if (this.htmlLabel == null) {
                this.htmlLabel = new VanChartHtmlLabel();
            }
            this.htmlLabel.setCustomText(string);
            this.htmlLabel.setUseHtml(bl);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("isCommon", this.isCommon).attr("isCategoryName", this.categoryFormat.isEnable()).attr("isSeriesName", this.seriesFormat.isEnable()).attr("isValue", this.valueFormat.isEnable()).attr("isPercentValue", this.percentFormat.isEnable()).end();
        if (this.valueFormat.getFormat() != null) {
            BaseXMLUtils.writeFormat((XMLPrintWriter)xMLPrintWriter, (Format)this.valueFormat.getFormat());
        }
        if (this.percentFormat.getFormat() != null) {
            xMLPrintWriter.startTAG("PercentFormat");
            BaseXMLUtils.writeFormat((XMLPrintWriter)xMLPrintWriter, (Format)this.percentFormat.getFormat());
            xMLPrintWriter.end();
        }
        if (this.categoryFormat.getFormat() != null) {
            xMLPrintWriter.startTAG("CategoryNameFormat");
            BaseXMLUtils.writeFormat((XMLPrintWriter)xMLPrintWriter, (Format)this.categoryFormat.getFormat());
            xMLPrintWriter.end();
        }
        if (this.seriesFormat.getFormat() != null) {
            xMLPrintWriter.startTAG("SeriesNameFormat");
            BaseXMLUtils.writeFormat((XMLPrintWriter)xMLPrintWriter, (Format)this.seriesFormat.getFormat());
            xMLPrintWriter.end();
        }
        if (this.htmlLabel != null) {
            this.htmlLabel.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        AttrTooltipContent attrTooltipContent = (AttrTooltipContent)super.clone();
        attrTooltipContent.setCategoryFormat((AttrTooltipCategoryFormat)this.getCategoryFormat().clone());
        attrTooltipContent.setSeriesFormat((AttrTooltipSeriesFormat)this.getSeriesFormat().clone());
        attrTooltipContent.setPercentFormat((AttrTooltipPercentFormat)this.getPercentFormat().clone());
        attrTooltipContent.setValueFormat((AttrTooltipValueFormat)this.getValueFormat().clone());
        attrTooltipContent.setCommon(this.isCommon());
        attrTooltipContent.setHtmlLabel((VanChartHtmlLabel)this.getHtmlLabel().clone());
        return super.clone();
    }

    public boolean equals(Object object) {
        return object.getClass() == AttrTooltipContent.class && ComparatorUtils.equals((Object)((AttrTooltipContent)object).isCommon(), (Object)this.isCommon()) && ComparatorUtils.equals((Object)((AttrTooltipContent)object).getHtmlLabel(), (Object)this.getHtmlLabel()) && ComparatorUtils.equals((Object)((AttrTooltipContent)object).getValueFormat(), (Object)this.getValueFormat()) && ComparatorUtils.equals((Object)((AttrTooltipContent)object).getPercentFormat(), (Object)this.getPercentFormat()) && ComparatorUtils.equals((Object)((AttrTooltipContent)object).getCategoryFormat(), (Object)this.getCategoryFormat()) && ComparatorUtils.equals((Object)((AttrTooltipContent)object).getSeriesFormat(), (Object)this.getSeriesFormat());
    }

    public boolean hasLabelContent() {
        return this.categoryFormat.isEnable() || this.seriesFormat.isEnable() || this.valueFormat.isEnable() || this.percentFormat.isEnable();
    }

    public void toJSONObject(JSONObject jSONObject) throws JSONException {
        if (this.isCommon) {
            JSONObject jSONObject2 = JSONObject.create();
            jSONObject2.put("identifier", (Object)this.getCommonLabelContent());
            jSONObject2.put("valueFormat", (Object)VanChartAttrHelper.getFormatFunction(this.valueFormat.getFormat()));
            jSONObject2.put("percentFormat", (Object)VanChartAttrHelper.getFormatFunction(this.percentFormat.getFormat()));
            jSONObject2.put("categoryFormat", (Object)VanChartAttrHelper.getFormatFunction(this.categoryFormat.getFormat()));
            jSONObject2.put("seriesFormat", (Object)VanChartAttrHelper.getFormatFunction(this.seriesFormat.getFormat()));
            jSONObject.put("formatter", (Object)jSONObject2);
        } else if (this.htmlLabel != null) {
            this.htmlLabel.addToJSONObject(jSONObject);
        }
    }

    public String getCommonLabelContent() {
        String string = "";
        string = string + this.categoryFormat.getJsText() + this.seriesFormat.getJsText() + this.valueFormat.getJsText() + this.percentFormat.getJsText();
        return string;
    }

    public String getFormatterTextFromCommon() {
        String string = "";
        string = string + this.categoryFormat.getFormatterString(string);
        string = string + this.seriesFormat.getFormatterString(string);
        string = string + this.valueFormat.getFormatterString(string);
        if (!ComparatorUtils.equals((Object)(string = string + this.percentFormat.getFormatterString(string)), (Object)"")) {
            string = PREFIX + string + SUFFIX;
        }
        return string;
    }
}

