/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.attr.axis;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.axis.AxisType;
import com.fr.plugin.chart.attr.axis.VanChartAxis;
import com.fr.plugin.chart.glyph.axis.VanChartValueAxisGlyph;
import com.fr.script.Calculator;
import com.fr.stable.ModColumnRowProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.List;

public class VanChartValueAxis
extends VanChartAxis {
    public static final String XML_TAG = "VanChartValueAxis";
    private static final long serialVersionUID = -5830910929691301496L;
    private boolean isLog = false;
    private Formula logBase = new Formula("10");
    private boolean isPercentage = false;

    public void setLogBase(Formula formula) {
        this.logBase = formula;
    }

    public Formula getLogBase() {
        return this.logBase;
    }

    public void setLog(boolean bl) {
        this.isLog = bl;
    }

    public boolean isLog() {
        return this.isLog;
    }

    @Override
    public AxisType getAxisType() {
        return AxisType.AXIS_VALUE;
    }

    public void setPercentage(boolean bl) {
        this.isPercentage = bl;
    }

    public boolean isPercentage() {
        return this.isPercentage;
    }

    public VanChartValueAxis() {
    }

    public VanChartValueAxis(String string, int n) {
        super(string, n);
    }

    public void initAxisGlyphWithChartData(VanChartValueAxisGlyph vanChartValueAxisGlyph) {
        this.initAxisGlyph(vanChartValueAxisGlyph);
        if (this.isPercentage() && this.getFormat() == null) {
            vanChartValueAxisGlyph.setFormat(VanChartAttrHelper.PERCENT_FORMAT);
        }
    }

    @Override
    public VanChartValueAxisGlyph createAxisGlyph(ChartData chartData) {
        VanChartValueAxisGlyph vanChartValueAxisGlyph = new VanChartValueAxisGlyph();
        this.initAxisGlyphWithChartData(vanChartValueAxisGlyph);
        return vanChartValueAxisGlyph;
    }

    @Override
    public void initAxisGlyph(AxisGlyph axisGlyph) {
        super.initAxisGlyph(axisGlyph);
        VanChartValueAxisGlyph vanChartValueAxisGlyph = (VanChartValueAxisGlyph)axisGlyph;
        vanChartValueAxisGlyph.setPercentage(this.isPercentage());
        vanChartValueAxisGlyph.setLog(this.isLog());
        Number number = ChartBaseUtils.formula2Number((Formula)this.getLogBase());
        if (number != null) {
            vanChartValueAxisGlyph.setLogBase(number.doubleValue());
        } else {
            vanChartValueAxisGlyph.setLogBase(10.0);
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof VanChartValueAxis && ComparatorUtils.equals((Object)((VanChartValueAxis)((Object)object)).isPercentage(), (Object)this.isPercentage()) && ComparatorUtils.equals((Object)((VanChartValueAxis)((Object)object)).isLog(), (Object)this.isLog()) && ComparatorUtils.equals((Object)((VanChartValueAxis)((Object)object)).getLogBase(), (Object)this.getLogBase());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        VanChartValueAxis vanChartValueAxis = (VanChartValueAxis)((Object)super.clone());
        vanChartValueAxis.setLog(this.isLog());
        if (this.logBase != null) {
            vanChartValueAxis.setLogBase((Formula)this.getLogBase().clone());
        }
        vanChartValueAxis.setPercentage(this.isPercentage());
        return vanChartValueAxis;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("VanChartValueAxisAttr")) {
            this.isLog = xMLableReader.getAttrAsBoolean("isLog", false);
            this.logBase = new Formula(xMLableReader.getAttrAsString("baseLog", "10"));
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("VanChartValueAxisAttr").attr("isLog", this.isLog).attr("baseLog", this.logBase.toString()).end();
    }

    @Override
    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        if (this.logBase != null) {
            Utils.dealFormulaValue((Object)this.logBase, (Calculator)calculator);
        }
    }

    @Override
    public void buidExecuteSequenceList(List list, Calculator calculator) {
        super.buidExecuteSequenceList(list, calculator);
        if (this.logBase != null) {
            GeneralUtils.dealBuidExecuteSequence((Object)this.logBase, (List)list, (CalculatorProvider)calculator);
        }
    }

    @Override
    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        super.modFormulaString(mOD_COLUMN_ROW);
        if (this.logBase != null) {
            this.logBase.modColumnRow((ModColumnRowProvider)mOD_COLUMN_ROW);
        }
    }
}

