/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.attr.axis;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.chartattr.Axis;
import com.fr.chart.chartattr.Title;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.ChartAlertValueGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.VanChartHtmlLabel;
import com.fr.plugin.chart.attr.axis.AxisTickLineType;
import com.fr.plugin.chart.attr.axis.AxisType;
import com.fr.plugin.chart.attr.axis.VanChartAlertValue;
import com.fr.plugin.chart.attr.axis.VanChartCustomIntervalBackground;
import com.fr.plugin.chart.glyph.VanChartAlertValueGlyph;
import com.fr.plugin.chart.glyph.axis.VanChartBaseAxisGlyph;
import com.fr.plugin.chart.glyph.axis.VanChartCategoryAxisGlyph;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class VanChartAxis
extends Axis {
    private static final long serialVersionUID = -257446768551206668L;
    public static final String XML_TAG = "VanChartAxis";
    private String axisName;
    private boolean titleUseHtml = false;
    private boolean autoLabelGap = true;
    private boolean limitSize = false;
    private double maxHeight = 15.0;
    private boolean commonValueFormat = true;
    private VanChartHtmlLabel htmlLabel = new VanChartHtmlLabel("function(){ return this; }");
    private List<VanChartAlertValue> alertValues = new ArrayList<VanChartAlertValue>();
    private Color defaultIntervalBackgroundColor = null;
    private List<VanChartCustomIntervalBackground> customIntervalBackgroundArray = new ArrayList<VanChartCustomIntervalBackground>();
    private AxisTickLineType mainTickLine = AxisTickLineType.TICK_LINE_OUTSIDE;
    private AxisTickLineType secTickLine = AxisTickLineType.TICK_LINE_NONE;

    public VanChartHtmlLabel getHtmlLabel() {
        return this.htmlLabel;
    }

    public void setHtmlLabel(VanChartHtmlLabel vanChartHtmlLabel) {
        this.htmlLabel = vanChartHtmlLabel;
    }

    public void setMainTickLine(AxisTickLineType axisTickLineType) {
        this.mainTickLine = axisTickLineType;
    }

    public void setSecTickLine(AxisTickLineType axisTickLineType) {
        this.secTickLine = axisTickLineType;
    }

    public AxisTickLineType getSecTickLine() {
        return this.secTickLine;
    }

    public AxisTickLineType getMainTickLine() {
        return this.mainTickLine;
    }

    public void setTickMarkType(int n) {
        this.mainTickLine = AxisTickLineType.parse(n);
    }

    public void setSecTickMarkType(int n) {
        this.secTickLine = AxisTickLineType.parse(n);
    }

    public void setAxisName(String string) {
        this.axisName = string;
    }

    public String getAxisName() {
        return this.axisName;
    }

    public void setTitleUseHtml(boolean bl) {
        this.titleUseHtml = bl;
    }

    public boolean isTitleUseHtml() {
        return this.titleUseHtml;
    }

    public void setAutoLabelGap(boolean bl) {
        this.autoLabelGap = bl;
    }

    public boolean isAutoLabelGap() {
        return this.autoLabelGap;
    }

    public void setCommonValueFormat(boolean bl) {
        this.commonValueFormat = bl;
    }

    public boolean isCommonValueFormat() {
        return this.commonValueFormat;
    }

    public void setAlertValues(List<VanChartAlertValue> list) {
        this.alertValues = list;
    }

    public List<VanChartAlertValue> getAlertValues() {
        return this.alertValues;
    }

    public void setCustomIntervalBackgroundArray(List<VanChartCustomIntervalBackground> list) {
        this.customIntervalBackgroundArray = list;
    }

    public void setDefaultIntervalBackgroundColor(Color color) {
        this.defaultIntervalBackgroundColor = color;
    }

    public List<VanChartCustomIntervalBackground> getCustomIntervalBackgroundArray() {
        return this.customIntervalBackgroundArray;
    }

    public Color getDefaultIntervalBackgroundColor() {
        return this.defaultIntervalBackgroundColor;
    }

    public void setLimitSize(boolean bl) {
        this.limitSize = bl;
    }

    public boolean isLimitSize() {
        return this.limitSize;
    }

    public void setMaxHeight(double d) {
        this.maxHeight = d;
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }

    public AxisType getAxisType() {
        return AxisType.AXIS_CATEGORY;
    }

    public VanChartAxis() {
        this(" ", 3);
    }

    public VanChartAxis(String string, int n) {
        this.axisName = string;
        this.position = n;
        this.setMainGridStyle(1);
        this.getTextAttr().setFRFont(VanChartAttrHelper.DEFAULT_AXIS_TITLE_LABLE_FONT);
        if (this.getTitle() == null) {
            this.setTitle(new Title((Object)""));
        }
        this.getTitle().getTextAttr().setFRFont(VanChartAttrHelper.DEFAULT_AXIS_TITLE_LABLE_FONT);
        if (!VanChartAttrHelper.isXAxis(string)) {
            this.getTitle().getTextAttr().setRotation(-90);
        }
    }

    public void initAxisGlyphWithChartData(ChartData chartData, VanChartCategoryAxisGlyph vanChartCategoryAxisGlyph) {
        this.initAxisGlyph(vanChartCategoryAxisGlyph);
        int n = chartData.getCategoryLabelCount();
        for (int i = 0; i < n; ++i) {
            vanChartCategoryAxisGlyph.addCategoryLabel(chartData.getCategoryPresentLabel(i) == null ? "" : chartData.getCategoryPresentLabel(i));
        }
        vanChartCategoryAxisGlyph.initMinMaxValue(0.0, chartData.getCategoryLabelCount());
    }

    public VanChartBaseAxisGlyph createAxisGlyph(ChartData chartData) {
        VanChartCategoryAxisGlyph vanChartCategoryAxisGlyph = new VanChartCategoryAxisGlyph();
        this.initAxisGlyphWithChartData(chartData, vanChartCategoryAxisGlyph);
        return vanChartCategoryAxisGlyph;
    }

    public void initAxisGlyph(AxisGlyph axisGlyph) {
        super.initAxisGlyph(axisGlyph);
        VanChartBaseAxisGlyph vanChartBaseAxisGlyph = (VanChartBaseAxisGlyph)axisGlyph;
        vanChartBaseAxisGlyph.setVanAxisType(this.getAxisType());
        vanChartBaseAxisGlyph.setTitleUseHtml(this.isTitleUseHtml());
        vanChartBaseAxisGlyph.setISXAxis(VanChartAttrHelper.isXAxis(this.getAxisName()));
        vanChartBaseAxisGlyph.setVanAxisName(this.getAxisName());
        vanChartBaseAxisGlyph.setLimitSize(this.isLimitSize());
        vanChartBaseAxisGlyph.setMaxHeight(this.getMaxHeight());
        vanChartBaseAxisGlyph.setAutoLabelGap(this.isAutoLabelGap());
        vanChartBaseAxisGlyph.setDefaultIntervalBackgroundColor(this.getDefaultIntervalBackgroundColor());
        this.installAlertValues(vanChartBaseAxisGlyph);
        vanChartBaseAxisGlyph.setCustomIntervalBackgroundArray(this.getCustomIntervalBackgroundArray());
        vanChartBaseAxisGlyph.setCommonValueFormat(this.isCommonValueFormat());
        vanChartBaseAxisGlyph.setHtmlLabel(this.getHtmlLabel());
        vanChartBaseAxisGlyph.setMainTickLine(this.getMainTickLine());
        vanChartBaseAxisGlyph.setSecTickLine(this.getSecTickLine());
    }

    private void installAlertValues(VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        if (this.alertValues != null) {
            ArrayList<ChartAlertValueGlyph> arrayList = new ArrayList<ChartAlertValueGlyph>();
            for (int i = 0; i < this.alertValues.size(); ++i) {
                Formula formula;
                VanChartAlertValue vanChartAlertValue = this.alertValues.get(i);
                if (vanChartAlertValue.getAlertValueFormula() == null) continue;
                VanChartAlertValueGlyph vanChartAlertValueGlyph = new VanChartAlertValueGlyph();
                String string = Utils.objectToString((Object)vanChartAlertValue.getAlertContentFormula());
                if (vanChartAlertValue.getAlertContentFormula() instanceof Formula && (formula = (Formula)vanChartAlertValue.getAlertContentFormula()).getResult() != null) {
                    string = Utils.objectToString((Object)formula.getResult());
                }
                vanChartAlertValueGlyph.setAlertContent(string);
                vanChartAlertValueGlyph.setAlertFont(vanChartAlertValue.getAlertFont());
                vanChartAlertValueGlyph.setAlertLineAlpha(vanChartAlertValue.getAlertLineAlpha());
                vanChartAlertValueGlyph.setAlertPaneSelectName(vanChartAlertValue.getAlertPaneSelectName());
                vanChartAlertValueGlyph.setAlertPosition(vanChartAlertValue.getAlertPosition());
                vanChartAlertValueGlyph.setAlertValueFormula(vanChartAlertValue.getAlertValueFormula());
                vanChartAlertValueGlyph.setLineColor(vanChartAlertValue.getLineColor());
                vanChartAlertValueGlyph.setLineStyle(vanChartAlertValue.getLineStyle());
                vanChartAlertValueGlyph.setIndex(i);
                vanChartAlertValueGlyph.setAxisGlyph(vanChartBaseAxisGlyph);
                arrayList.add(vanChartAlertValueGlyph);
            }
            vanChartBaseAxisGlyph.setAlertValues(arrayList);
        }
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof VanChartAxis && ComparatorUtils.equals((Object)((Object)((VanChartAxis)((Object)object)).getMainTickLine()), (Object)((Object)this.getMainTickLine())) && ComparatorUtils.equals((Object)((Object)((VanChartAxis)((Object)object)).getSecTickLine()), (Object)((Object)this.getSecTickLine())) && ComparatorUtils.equals((Object)((VanChartAxis)((Object)object)).getAxisName(), (Object)this.getAxisName()) && ComparatorUtils.equals((Object)((VanChartAxis)((Object)object)).isTitleUseHtml(), (Object)this.isTitleUseHtml()) && ComparatorUtils.equals((Object)((VanChartAxis)((Object)object)).isAutoLabelGap(), (Object)this.isAutoLabelGap()) && ComparatorUtils.equals((Object)((VanChartAxis)((Object)object)).isLimitSize(), (Object)this.isLimitSize()) && ComparatorUtils.equals((Object)((VanChartAxis)((Object)object)).getMaxHeight(), (Object)this.getMaxHeight()) && ComparatorUtils.equals((Object)((VanChartAxis)((Object)object)).isCommonValueFormat(), (Object)this.isCommonValueFormat()) && ComparatorUtils.equals((Object)((VanChartAxis)((Object)object)).getHtmlLabel(), (Object)this.getHtmlLabel()) && ComparatorUtils.equals((Object)((VanChartAxis)((Object)object)).getDefaultIntervalBackgroundColor(), (Object)this.getDefaultIntervalBackgroundColor()) && ComparatorUtils.equals(((VanChartAxis)((Object)object)).getAlertValues(), this.getAlertValues()) && ComparatorUtils.equals(((VanChartAxis)((Object)object)).getCustomIntervalBackgroundArray(), this.getCustomIntervalBackgroundArray());
    }

    public Object clone() throws CloneNotSupportedException {
        VanChartAxis vanChartAxis = (VanChartAxis)((Object)super.clone());
        vanChartAxis.setMainTickLine(this.getMainTickLine());
        vanChartAxis.setSecTickLine(this.getSecTickLine());
        vanChartAxis.setAxisName(this.getAxisName());
        vanChartAxis.setTitleUseHtml(this.isTitleUseHtml());
        vanChartAxis.setAutoLabelGap(this.isAutoLabelGap());
        vanChartAxis.setLimitSize(this.isLimitSize());
        vanChartAxis.setMaxHeight(this.getMaxHeight());
        vanChartAxis.setCommonValueFormat(this.isCommonValueFormat());
        vanChartAxis.setHtmlLabel((VanChartHtmlLabel)this.getHtmlLabel().clone());
        vanChartAxis.setDefaultIntervalBackgroundColor(this.getDefaultIntervalBackgroundColor());
        vanChartAxis.alertValues = new ArrayList<VanChartAlertValue>();
        for (VanChartAlertValue fCloneable : this.alertValues) {
            vanChartAxis.alertValues.add((VanChartAlertValue)((Object)fCloneable.clone()));
        }
        vanChartAxis.customIntervalBackgroundArray = new ArrayList<VanChartCustomIntervalBackground>();
        for (VanChartCustomIntervalBackground vanChartCustomIntervalBackground : this.customIntervalBackgroundArray) {
            vanChartAxis.customIntervalBackgroundArray.add((VanChartCustomIntervalBackground)vanChartCustomIntervalBackground.clone());
        }
        return vanChartAxis;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("VanChartAxisAttr")) {
                int n = xMLableReader.getAttrAsInt("mainTickLine", -1);
                int n2 = xMLableReader.getAttrAsInt("secTickLine", -1);
                if (n != -1) {
                    this.mainTickLine = AxisTickLineType.parse(n);
                }
                if (n2 != -1) {
                    this.secTickLine = AxisTickLineType.parse(n2);
                }
                this.axisName = xMLableReader.getAttrAsString("axisName", "");
                this.titleUseHtml = xMLableReader.getAttrAsBoolean("titleUseHtml", false);
                this.autoLabelGap = xMLableReader.getAttrAsBoolean("autoLabelGap", true);
                this.limitSize = xMLableReader.getAttrAsBoolean("limitSize", false);
                this.maxHeight = xMLableReader.getAttrAsInt("maxHeight", 0);
                this.commonValueFormat = xMLableReader.getAttrAsBoolean("commonValueFormat", true);
                this.readOldHtmlLabel(xMLableReader);
                this.defaultIntervalBackgroundColor = xMLableReader.getAttrAsColor("defaultIntervalBackgroundColor", null);
            } else if (string.equals("HtmlLabel")) {
                this.setHtmlLabel((VanChartHtmlLabel)xMLableReader.readXMLObject((XMLReadable)new VanChartHtmlLabel()));
            } else if (string.equals("alertList")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("VanChartAlert")) {
                            VanChartAlertValue vanChartAlertValue = (VanChartAlertValue)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader);
                            VanChartAxis.this.alertValues.add(vanChartAlertValue);
                        }
                    }
                });
            } else if (string.equals("customBackgroundList")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("VanChartCustomBackground")) {
                            VanChartCustomIntervalBackground vanChartCustomIntervalBackground = (VanChartCustomIntervalBackground)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader);
                            VanChartAxis.this.customIntervalBackgroundArray.add(vanChartCustomIntervalBackground);
                        }
                    }
                });
            }
        }
    }

    private void readOldHtmlLabel(XMLableReader xMLableReader) {
        if (!this.commonValueFormat) {
            String string = xMLableReader.getAttrAsString("customValueFormatText", "");
            boolean bl = xMLableReader.getAttrAsBoolean("customValueUseHtml", false);
            if (StringUtils.isNotEmpty((String)string) || bl) {
                if (this.htmlLabel == null) {
                    this.htmlLabel = new VanChartHtmlLabel();
                }
                this.htmlLabel.setCustomText(string);
                this.htmlLabel.setUseHtml(bl);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("VanChartAxisAttr").attr("mainTickLine", this.getMainTickLine().getType()).attr("secTickLine", this.getSecTickLine().getType()).attr("axisName", this.axisName).attr("titleUseHtml", this.titleUseHtml).attr("autoLabelGap", this.autoLabelGap).attr("limitSize", this.limitSize).attr("maxHeight", this.maxHeight).attr("commonValueFormat", this.commonValueFormat);
        if (this.defaultIntervalBackgroundColor != null) {
            xMLPrintWriter.attr("defaultIntervalBackgroundColor", this.defaultIntervalBackgroundColor.getRGB());
        }
        xMLPrintWriter.end();
        if (this.htmlLabel != null) {
            this.htmlLabel.writeXML(xMLPrintWriter);
        }
        if (this.alertValues != null) {
            xMLPrintWriter.startTAG("alertList");
            for (VanChartAlertValue fCloneable : this.alertValues) {
                GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)fCloneable, (String)"VanChartAlert");
            }
            xMLPrintWriter.end();
        }
        if (this.customIntervalBackgroundArray != null) {
            xMLPrintWriter.startTAG("customBackgroundList");
            for (VanChartCustomIntervalBackground vanChartCustomIntervalBackground : this.customIntervalBackgroundArray) {
                GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)vanChartCustomIntervalBackground, (String)"VanChartCustomBackground");
            }
            xMLPrintWriter.end();
        }
    }

    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        for (VanChartAlertValue fCloneable : this.alertValues) {
            fCloneable.dealFormula(calculator);
        }
        for (VanChartCustomIntervalBackground vanChartCustomIntervalBackground : this.customIntervalBackgroundArray) {
            vanChartCustomIntervalBackground.dealFormula(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        super.buidExecuteSequenceList(list, calculator);
        for (VanChartAlertValue fCloneable : this.alertValues) {
            fCloneable.buidExecuteSequenceList(list, calculator);
        }
        for (VanChartCustomIntervalBackground vanChartCustomIntervalBackground : this.customIntervalBackgroundArray) {
            vanChartCustomIntervalBackground.buidExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        super.modFormulaString(mOD_COLUMN_ROW);
        for (VanChartAlertValue fCloneable : this.alertValues) {
            fCloneable.modFormulaString(mOD_COLUMN_ROW);
        }
        for (VanChartCustomIntervalBackground vanChartCustomIntervalBackground : this.customIntervalBackgroundArray) {
            vanChartCustomIntervalBackground.modFormulaString(mOD_COLUMN_ROW);
        }
    }
}

