/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.area;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.data.condition.Result;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.plugin.chart.area.VanChartAreaPlotGlyph;
import com.fr.plugin.chart.attr.VanChartPlotType;
import com.fr.plugin.chart.attr.axis.VanChartAxis;
import com.fr.plugin.chart.base.AttrSeriesStackAndAxis;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.line.VanChartLinePlot;
import com.fr.stable.fun.FunctionProcessor;

public class VanChartAreaPlot
extends VanChartLinePlot {
    private static final long serialVersionUID = -5646135698046165505L;
    public static final String VAN_CHART_AREA_PLOT_ID = "VanChartAreaPlot";

    public VanChartAreaPlot() {
    }

    public VanChartAreaPlot(VanChartPlotType vanChartPlotType) {
        super(vanChartPlotType);
    }

    @Override
    public PlotGlyph createPlotGlyph(ChartData chartData) {
        VanChartAreaPlotGlyph vanChartAreaPlotGlyph = new VanChartAreaPlotGlyph();
        this.install4PlotGlyph(vanChartAreaPlotGlyph, chartData);
        this.installAxisGlyph(vanChartAreaPlotGlyph, chartData);
        return vanChartAreaPlotGlyph;
    }

    @Override
    protected void dealDataSeriesCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        super.dealDataSeriesCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrFillColorBackgroundCustomCondition(vanChartDataSeries, conditionCollection);
    }

    @Override
    protected void dealDataSeriesStackAndAxisCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        if (this.isCustomChart()) {
            AttrSeriesStackAndAxis attrSeriesStackAndAxis = (AttrSeriesStackAndAxis)conditionCollection.getCustomDataSeriesCondition(AttrSeriesStackAndAxis.class, (Result)vanChartDataSeries);
            vanChartDataSeries.setAttrSeriesStackAndAxis(attrSeriesStackAndAxis);
            if (attrSeriesStackAndAxis != null && attrSeriesStackAndAxis.isPercentStacked()) {
                VanChartAxis vanChartAxis = this.getDefaultValueAxis(attrSeriesStackAndAxis);
                vanChartAxis.setPercentage(true);
            }
        } else if (this.isStackChart()) {
            AttrSeriesStackAndAxis attrSeriesStackAndAxis = new AttrSeriesStackAndAxis();
            vanChartDataSeries.setAttrSeriesStackAndAxis(attrSeriesStackAndAxis);
        } else if (this.isPercentStackChart()) {
            AttrSeriesStackAndAxis attrSeriesStackAndAxis = new AttrSeriesStackAndAxis();
            attrSeriesStackAndAxis.setPercentStacked(true);
            vanChartDataSeries.setAttrSeriesStackAndAxis(attrSeriesStackAndAxis);
            VanChartAxis vanChartAxis = this.getDefaultValueAxis();
            vanChartAxis.setPercentage(true);
        }
    }

    @Override
    public String getPlotName() {
        return Inter.getLocText((String)"Plugin-ChartF_NewArea");
    }

    @Override
    public String getPlotID() {
        return VAN_CHART_AREA_PLOT_ID;
    }

    @Override
    public boolean matchPlotType(Plot plot) {
        return plot instanceof VanChartAreaPlot;
    }

    @Override
    public boolean accept(Class<? extends Plot> clazz) {
        return ComparatorUtils.equals(VanChartAreaPlot.class, clazz);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof VanChartAreaPlot && super.equals(object);
    }

    @Override
    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.AREA_VAN_CHARTS;
    }
}

