/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl;

import com.sun.enterprise.security.jauth.callback.CertStoreCallback;
import com.sun.enterprise.security.jauth.callback.PasswordValidationCallback;
import com.sun.enterprise.security.jauth.callback.PrivateKeyCallback;
import com.sun.enterprise.security.jauth.callback.SecretKeyCallback;
import com.sun.enterprise.security.jauth.callback.TrustStoreCallback;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import com.sun.xml.ws.security.impl.kerberos.KerberosContext;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.Timestamp;
import com.sun.xml.wss.core.reference.KeyIdentifierSPI;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurityHeaderException;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.NonceCache;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.saml.Assertion;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WssProviderSecurityEnvironment
implements SecurityEnvironment {
    private Map _securityOptions;
    private CallbackHandler _handler;
    protected final long MAX_CLOCK_SKEW = 360000L;
    protected final long TIMESTAMP_FRESHNESS_LIMIT = 300000L;
    private static final SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat calendarFormatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
    NonceCache nonceCache = null;
    static final boolean USE_DAEMON_THREAD = true;
    static final Timer nonceCleanupTimer = new Timer(true);

    public WssProviderSecurityEnvironment(CallbackHandler handler, Map options) throws XWSSecurityException {
        this._handler = handler;
        this._securityOptions = options;
        if (this._securityOptions != null) {
            String mo_aliases = (String)this._securityOptions.get("ALIASES");
            String mo_keypwds = (String)this._securityOptions.get("PASSWORDS");
            if (mo_aliases != null && mo_keypwds != null) {
                StringTokenizer aliases = new StringTokenizer(mo_aliases, " ");
                StringTokenizer keypwds = new StringTokenizer(mo_keypwds, " ");
                if (aliases.countTokens() != keypwds.countTokens()) {
                    // empty if block
                }
            }
        }
    }

    public PrivateKey getPrivateKey(Map context, String alias) throws XWSSecurityException {
        PrivateKey privateKey = null;
        try {
            PrivateKeyCallback.AliasRequest request = new PrivateKeyCallback.AliasRequest(alias);
            PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
            Callback[] callbacks = new Callback[]{pkCallback};
            this._handler.handle(callbacks);
            privateKey = pkCallback.getKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        if (privateKey == null) {
            throw new XWSSecurityException("Unable to locate private key for the alias " + alias);
        }
        return privateKey;
    }

    public PrivateKey getPrivateKey(Map context, byte[] keyIdentifier) throws XWSSecurityException {
        try {
            Set<X500PrivateCredential> set;
            Subject subject = this.getSubject(context);
            if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
                for (X500PrivateCredential cred : set) {
                    if (!this.matchesKeyIdentifier(Base64.decode(keyIdentifier), cred.getCertificate())) continue;
                    return cred.getPrivateKey();
                }
            }
            PrivateKeyCallback.SubjectKeyIDRequest request = new PrivateKeyCallback.SubjectKeyIDRequest(keyIdentifier);
            PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
            Callback[] callbacks = new Callback[]{pkCallback};
            this._handler.handle(callbacks);
            return pkCallback.getKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public PrivateKey getPrivateKey(Map context, X509Certificate cert) throws XWSSecurityException {
        try {
            Set<X500PrivateCredential> set;
            Subject subject = this.getSubject(context);
            if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
                String issuerName = RFC2253Parser.normalize(cert.getIssuerDN().getName());
                for (X500PrivateCredential cred : set) {
                    X509Certificate x509Cert = cred.getCertificate();
                    BigInteger serialNo = x509Cert.getSerialNumber();
                    String currentIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                    if (!serialNo.equals(cert.getSerialNumber()) || !currentIssuerName.equals(issuerName)) continue;
                    return cred.getPrivateKey();
                }
            }
            PrivateKeyCallback.IssuerSerialNumRequest request = new PrivateKeyCallback.IssuerSerialNumRequest(cert.getIssuerX500Principal(), cert.getSerialNumber());
            PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
            Callback[] callbacks = new Callback[]{pkCallback};
            this._handler.handle(callbacks);
            return pkCallback.getKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public PrivateKey getPrivateKey(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        try {
            Set<X500PrivateCredential> set;
            Subject subject = this.getSubject(context);
            if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
                for (X500PrivateCredential cred : set) {
                    X509Certificate x509Cert = cred.getCertificate();
                    BigInteger serialNo = x509Cert.getSerialNumber();
                    String currentIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                    if (!serialNo.equals(serialNumber) || !currentIssuerName.equals(issuerName)) continue;
                    return cred.getPrivateKey();
                }
            }
            PrivateKeyCallback.IssuerSerialNumRequest request = new PrivateKeyCallback.IssuerSerialNumRequest(new X500Principal(issuerName), serialNumber);
            PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
            Callback[] callbacks = new Callback[]{pkCallback};
            this._handler.handle(callbacks);
            return pkCallback.getKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public X509Certificate getDefaultCertificate(Map context) throws XWSSecurityException {
        Set<X509Certificate> set;
        Subject subject = this.getSubject(context);
        if (subject != null && (set = subject.getPublicCredentials(X509Certificate.class)) != null && set.size() == 1) {
            return (X509Certificate)set.toArray()[0];
        }
        PrivateKeyCallback pkCallback = new PrivateKeyCallback(null);
        Callback[] _callbacks = new Callback[]{pkCallback};
        try {
            this._handler.handle(_callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        Certificate[] chain = pkCallback.getChain();
        if (chain == null) {
            throw new XWSSecurityException("Empty certificate chain returned by PrivateKeyCallback");
        }
        return (X509Certificate)chain[0];
    }

    public boolean authenticateUser(Map context, String username, String password) throws XWSSecurityException {
        char[] pwd = password == null ? null : password.toCharArray();
        PasswordValidationCallback pvCallback = new PasswordValidationCallback(username, pwd);
        Callback[] callbacks = new Callback[]{pvCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        if (pwd != null) {
            pvCallback.clearPassword();
        }
        return pvCallback.getResult();
    }

    public boolean authenticateUser(Map context, String username, String passwordDigest, String nonce, String created) throws XWSSecurityException {
        return false;
    }

    public boolean validateCertificate(X509Certificate cert) throws XWSSecurityException {
        CertPathBuilder builder;
        PKIXBuilderParameters parameters;
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            throw new XWSSecurityException("X509Certificate Expired", e);
        }
        catch (CertificateNotYetValidException e) {
            throw new XWSSecurityException("X509Certificate not yet valid", e);
        }
        X509CertSelector certSelector = new X509CertSelector();
        certSelector.setCertificate(cert);
        try {
            Callback[] callbacks = null;
            CertStoreCallback csCallback = null;
            TrustStoreCallback tsCallback = null;
            if (tsCallback == null && csCallback == null) {
                csCallback = new CertStoreCallback();
                tsCallback = new TrustStoreCallback();
                callbacks = new Callback[]{csCallback, tsCallback};
            } else if (csCallback == null) {
                csCallback = new CertStoreCallback();
                callbacks = new Callback[]{csCallback};
            } else if (tsCallback == null) {
                tsCallback = new TrustStoreCallback();
                callbacks = new Callback[]{tsCallback};
            }
            try {
                this._handler.handle(callbacks);
            }
            catch (Exception e) {
                throw new XWSSecurityException(e);
            }
            parameters = new PKIXBuilderParameters(tsCallback.getTrustStore(), (CertSelector)certSelector);
            parameters.setRevocationEnabled(false);
            if (KeyIdentifierSPI.isIBMVM) {
                CertStore cs = CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singleton(cert)));
                parameters.addCertStore(cs);
            } else {
                parameters.addCertStore(csCallback.getCertStore());
            }
            builder = CertPathBuilder.getInstance("PKIX");
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        try {
            PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(parameters);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public X509Certificate getMatchingCertificate(Map context, byte[] keyIdMatch) throws XWSSecurityException {
        X509Certificate otherPartyCert;
        KeyStore trustStore;
        Set<X500PrivateCredential> set;
        Subject subject = this.getSubject(context);
        if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
            for (X500PrivateCredential cred : set) {
                X509Certificate cert = cred.getCertificate();
                if (!this.matchesKeyIdentifier(keyIdMatch, cert)) continue;
                return cert;
            }
        }
        PrivateKeyCallback.SubjectKeyIDRequest request = new PrivateKeyCallback.SubjectKeyIDRequest(keyIdMatch);
        PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
        TrustStoreCallback tsCallback = new TrustStoreCallback();
        Callback[] callbacks = new Callback[]{pkCallback, tsCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        Certificate[] chain = pkCallback.getChain();
        if (chain != null) {
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate x509Cert = (X509Certificate)chain[i];
                if (!this.matchesKeyIdentifier(keyIdMatch, x509Cert)) continue;
                return x509Cert;
            }
        }
        if ((trustStore = tsCallback.getTrustStore()) != null && (otherPartyCert = this.getMatchingCertificate(keyIdMatch, trustStore)) != null) {
            return otherPartyCert;
        }
        throw new XWSSecurityException("No Matching Certificate for :" + Arrays.toString(keyIdMatch) + " found in KeyStore or TrustStore");
    }

    public X509Certificate getMatchingCertificate(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        X509Certificate otherPartyCert;
        KeyStore trustStore;
        Set<X500PrivateCredential> set;
        Subject subject = this.getSubject(context);
        if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
            for (X500PrivateCredential cred : set) {
                X509Certificate x509Cert = cred.getCertificate();
                BigInteger serialNo = x509Cert.getSerialNumber();
                String currentIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                if (!serialNo.equals(serialNumber) || !currentIssuerName.equals(issuerName)) continue;
                return x509Cert;
            }
        }
        PrivateKeyCallback.IssuerSerialNumRequest request = new PrivateKeyCallback.IssuerSerialNumRequest(new X500Principal(issuerName), serialNumber);
        PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
        TrustStoreCallback tsCallback = new TrustStoreCallback();
        Callback[] callbacks = new Callback[]{pkCallback, tsCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        Certificate[] chain = pkCallback.getChain();
        if (chain != null) {
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate x509Cert = (X509Certificate)chain[i];
                if (!this.matchesIssuerSerialAndName(serialNumber, issuerName, x509Cert)) continue;
                return x509Cert;
            }
        }
        if ((trustStore = tsCallback.getTrustStore()) != null && (otherPartyCert = this.getMatchingCertificate(serialNumber, issuerName, trustStore)) != null) {
            return otherPartyCert;
        }
        throw new XWSSecurityException("No Matching Certificate for : found in KeyStore or TrustStore");
    }

    public X509Certificate getMatchingCertificate(Map context, byte[] keyIdMatch, String valueType) throws XWSSecurityException {
        X509Certificate otherPartyCert;
        KeyStore trustStore;
        Set<X500PrivateCredential> set;
        if ("Identifier".equals(valueType)) {
            return this.getMatchingCertificate(context, keyIdMatch);
        }
        Subject subject = this.getSubject(context);
        if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
            for (X500PrivateCredential cred : set) {
                X509Certificate cert = cred.getCertificate();
                if (!this.matchesThumbPrint(keyIdMatch, cert)) continue;
                return cert;
            }
        }
        PrivateKeyCallback.SubjectKeyIDRequest request = new PrivateKeyCallback.SubjectKeyIDRequest(keyIdMatch);
        PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
        TrustStoreCallback tsCallback = new TrustStoreCallback();
        Callback[] callbacks = new Callback[]{pkCallback, tsCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        Certificate[] chain = pkCallback.getChain();
        if (chain != null) {
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate x509Cert = (X509Certificate)chain[i];
                if (!this.matchesThumbPrint(keyIdMatch, x509Cert)) continue;
                return x509Cert;
            }
        }
        if ((trustStore = tsCallback.getTrustStore()) != null && (otherPartyCert = this.getMatchingCertificate(keyIdMatch, trustStore, valueType)) != null) {
            return otherPartyCert;
        }
        throw new XWSSecurityException("No Matching Certificate for :" + Arrays.toString(keyIdMatch) + " found in KeyStore or TrustStore");
    }

    public SecretKey getSecretKey(Map context, String alias, boolean encryptMode) throws XWSSecurityException {
        SecretKeyCallback.AliasRequest request = new SecretKeyCallback.AliasRequest(alias);
        SecretKeyCallback skCallback = new SecretKeyCallback((SecretKeyCallback.Request)request);
        Callback[] callbacks = new Callback[]{skCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        return skCallback.getKey();
    }

    public X509Certificate getCertificate(Map context, String alias, boolean forSigning) throws XWSSecurityException {
        X509Certificate cert;
        block10: {
            cert = null;
            try {
                PrivateKeyCallback pkCallback = null;
                if (forSigning) {
                    try {
                        Set<X500PrivateCredential> set;
                        Subject subject = this.getSubject(context);
                        if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
                            for (X500PrivateCredential cred : set) {
                                if (!cred.getAlias().equals(alias)) continue;
                                return cred.getCertificate();
                            }
                        }
                        PrivateKeyCallback.AliasRequest request = new PrivateKeyCallback.AliasRequest(alias);
                        pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
                        Callback[] callbacks = new Callback[]{pkCallback};
                        this._handler.handle(callbacks);
                    }
                    catch (Exception e) {
                        throw new XWSSecurityException(e);
                    }
                    Certificate[] chain = pkCallback.getChain();
                    if (chain != null) {
                        cert = (X509Certificate)chain[0];
                    }
                    break block10;
                }
                TrustStoreCallback tsCallback = new TrustStoreCallback();
                Callback[] _callbacks = new Callback[]{tsCallback};
                this._handler.handle(_callbacks);
                cert = this.getDynamicCertificate(context, tsCallback.getTrustStore());
                if (cert == null && tsCallback.getTrustStore() != null) {
                    cert = (X509Certificate)tsCallback.getTrustStore().getCertificate(alias);
                }
            }
            catch (Exception e) {
                throw new XWSSecurityException(e);
            }
        }
        if (cert == null) {
            throw new XWSSecurityException("Unable to locate certificate for the alias '" + alias + "'");
        }
        return cert;
    }

    private boolean matchesKeyIdentifier(byte[] keyIdMatch, X509Certificate x509Cert) throws XWSSecurityException {
        byte[] keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(x509Cert);
        if (keyId == null) {
            return false;
        }
        return Arrays.equals(keyIdMatch, keyId);
    }

    public static byte[] getThumbprintIdentifier(X509Certificate cert) throws XWSSecurityException {
        byte[] thumbPrintIdentifier = null;
        try {
            thumbPrintIdentifier = MessageDigest.getInstance("SHA-1").digest(cert.getEncoded());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XWSSecurityException("Digest algorithm SHA-1 not found");
        }
        catch (CertificateEncodingException ex) {
            throw new XWSSecurityException("Error while getting certificate's raw content");
        }
        return thumbPrintIdentifier;
    }

    private boolean matchesThumbPrint(byte[] keyIdMatch, X509Certificate x509Cert) throws XWSSecurityException {
        byte[] keyId = WssProviderSecurityEnvironment.getThumbprintIdentifier(x509Cert);
        if (keyId == null) {
            return false;
        }
        return Arrays.equals(keyIdMatch, keyId);
    }

    private X509Certificate getMatchingCertificate(byte[] keyIdMatch, KeyStore kStore) throws XWSSecurityException {
        if (kStore == null) {
            return null;
        }
        try {
            Enumeration<String> enum1 = kStore.aliases();
            while (enum1.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                String alias = enum1.nextElement();
                Certificate cert = kStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType()) || (keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(x509Cert = (X509Certificate)cert)) == null || !Arrays.equals(keyIdMatch, keyId)) continue;
                return x509Cert;
            }
        }
        catch (KeyStoreException kEx) {
            throw new XWSSecurityException(kEx);
        }
        return null;
    }

    private X509Certificate getMatchingCertificate(byte[] keyIdMatch, KeyStore kStore, String valueType) throws XWSSecurityException {
        if ("Identifier".equals(valueType)) {
            return this.getMatchingCertificate(keyIdMatch, kStore);
        }
        if (kStore == null) {
            return null;
        }
        try {
            Enumeration<String> enum1 = kStore.aliases();
            while (enum1.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                String alias = enum1.nextElement();
                Certificate cert = kStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType()) || !Arrays.equals(keyIdMatch, keyId = WssProviderSecurityEnvironment.getThumbprintIdentifier(x509Cert = (X509Certificate)cert))) continue;
                return x509Cert;
            }
        }
        catch (KeyStoreException kEx) {
            throw new XWSSecurityException(kEx);
        }
        return null;
    }

    private boolean matchesIssuerSerialAndName(BigInteger serialNumberMatch, String issuerNameMatch, X509Certificate x509Cert) {
        BigInteger serialNumber = x509Cert.getSerialNumber();
        String issuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
        return serialNumber.equals(serialNumberMatch) && issuerName.equals(issuerNameMatch);
    }

    private X509Certificate getMatchingCertificate(BigInteger serialNumber, String issuerName, KeyStore kStore) throws XWSSecurityException {
        if (kStore == null) {
            return null;
        }
        try {
            Enumeration<String> enum1 = kStore.aliases();
            while (enum1.hasMoreElements()) {
                String alias = enum1.nextElement();
                Certificate cert = kStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType())) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                BigInteger serialNo = x509Cert.getSerialNumber();
                String currentIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                if (!serialNo.equals(serialNumber) || !currentIssuerName.equals(issuerName)) continue;
                return x509Cert;
            }
        }
        catch (KeyStoreException kEx) {
            throw new XWSSecurityException(kEx);
        }
        return null;
    }

    public void updateOtherPartySubject(final Subject subject, final String username, final String password) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String x500Name = "CN=" + username;
                X500Principal principal = new X500Principal(x500Name);
                subject.getPrincipals().add(principal);
                subject.getPrivateCredentials().add(password);
                return null;
            }
        });
    }

    public void updateOtherPartySubject(final Subject subject, final X509Certificate cert) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                X500Principal principal = cert.getSubjectX500Principal();
                subject.getPrincipals().add(principal);
                subject.getPublicCredentials().add(cert);
                return null;
            }
        });
    }

    public void updateOtherPartySubject(Subject subject, Assertion assertion) {
    }

    public PublicKey getPublicKey(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        return this.getMatchingCertificate(context, serialNumber, issuerName).getPublicKey();
    }

    public PublicKey getPublicKey(String keyIdentifier) throws XWSSecurityException {
        try {
            return this.getMatchingCertificate(null, this.getDecodedBase64EncodedData(keyIdentifier)).getPublicKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public PublicKey getPublicKey(Map context, byte[] keyIdentifier) throws XWSSecurityException {
        try {
            return this.getMatchingCertificate(context, keyIdentifier).getPublicKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public PublicKey getPublicKey(Map context, byte[] identifier, String valueType) throws XWSSecurityException {
        return this.getMatchingCertificate(context, identifier, valueType).getPublicKey();
    }

    private byte[] getDecodedBase64EncodedData(String encodedData) throws XWSSecurityException {
        try {
            return Base64.decode(encodedData);
        }
        catch (Base64DecodingException e) {
            throw new SecurityHeaderException("Unable to decode Base64 encoded data", e);
        }
    }

    public X509Certificate getCertificate(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        return this.getMatchingCertificate(context, serialNumber, issuerName);
    }

    public X509Certificate getCertificate(String keyIdentifier) throws XWSSecurityException {
        try {
            byte[] decoded = this.getDecodedBase64EncodedData(keyIdentifier);
            return this.getMatchingCertificate(null, decoded);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public PrivateKey getPrivateKey(Map context, PublicKey publicKey, boolean forSign) {
        return null;
    }

    public X509Certificate getCertificate(Map context, byte[] ski) {
        return null;
    }

    public X509Certificate getCertificate(Map context, PublicKey publicKey, boolean forSign) throws XWSSecurityException {
        return null;
    }

    public X509Certificate getCertificate(Map context, byte[] identifier, String valueType) throws XWSSecurityException {
        return null;
    }

    public boolean validateSamlIssuer(String issuer) {
        return true;
    }

    public boolean validateSamlUser(String user, String domain, String format) {
        return true;
    }

    public void setSubject(Subject subject, Map context) {
        context.put("javax.security.auth.Subject.self", subject);
    }

    public void setRequesterSubject(Subject subject, Map context) {
        context.put("javax.security.auth.Subject", subject);
    }

    public Subject getSubject() {
        return null;
    }

    public Subject getSubject(Map context) {
        return (Subject)context.get("javax.security.auth.Subject.self");
    }

    public Subject getRequesterSubject(Map context) {
        return (Subject)context.get("javax.security.auth.Subject");
    }

    private Date getGMTDateWithSkewAdjusted(Calendar c, boolean addSkew) {
        long offset = c.get(15);
        if (c.getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)c.getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        currentTime = addSkew ? (currentTime += 360000L) : (currentTime -= 360000L);
        c.setTimeInMillis(currentTime);
        return c.getTime();
    }

    public String getUsername(Map context) throws XWSSecurityException {
        NameCallback nameCallback = new NameCallback("Username: ");
        try {
            Callback[] cbs = new Callback[]{nameCallback};
            this._handler.handle(cbs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return nameCallback.getName();
    }

    public String getPassword(Map context) throws XWSSecurityException {
        PasswordCallback pwdCallback = new PasswordCallback("Password: ", false);
        try {
            Callback[] cbs = new Callback[]{pwdCallback};
            this._handler.handle(cbs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (pwdCallback.getPassword() == null) {
            return null;
        }
        return new String(pwdCallback.getPassword());
    }

    public boolean validateAndCacheNonce(String nonce, String created, long maxNonceAge) throws XWSSecurityException {
        if (this.nonceCache == null || this.nonceCache.wasCanceled()) {
            this.initNonceCache(maxNonceAge);
        }
        if (!this.nonceCache.isScheduled()) {
            this.setNonceCacheCleanup();
        }
        return this.nonceCache.validateAndCacheNonce(nonce, created);
    }

    private synchronized void initNonceCache(long maxNonceAge) {
        if (this.nonceCache == null) {
            this.nonceCache = maxNonceAge == 0L ? new NonceCache() : new NonceCache(maxNonceAge);
        } else if (this.nonceCache.wasCanceled()) {
            this.nonceCache = maxNonceAge == 0L ? new NonceCache() : new NonceCache(maxNonceAge);
        }
    }

    private synchronized void setNonceCacheCleanup() {
        if (!this.nonceCache.isScheduled()) {
            nonceCleanupTimer.schedule((TimerTask)this.nonceCache, this.nonceCache.getMaxNonceAge(), this.nonceCache.getMaxNonceAge());
            this.nonceCache.scheduled(true);
        }
    }

    public void validateTimestamp(Map context, String created, String expires, long maxClockSkew, long freshnessLimit) throws XWSSecurityException {
        if (WssProviderSecurityEnvironment.expiresBeforeCreated(created, expires)) {
            XWSSecurityException xwsse = new XWSSecurityException("Message expired!");
            throw DefaultSecurityEnvironmentImpl.newSOAPFaultException(MessageConstants.WSU_MESSAGE_EXPIRED, "Message expired!", xwsse);
        }
        this.validateCreationTime(context, created, maxClockSkew, freshnessLimit);
        this.validateExpirationTime(expires, maxClockSkew, freshnessLimit);
    }

    public void validateTimestamp(Map context, Timestamp timestamp, long maxClockSkew, long freshnessLimit) throws XWSSecurityException {
        this.validateTimestamp(context, timestamp.getCreated(), timestamp.getExpires(), maxClockSkew, freshnessLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean expiresBeforeCreated(String creationTime, String expirationTime) throws XWSSecurityException {
        Date expires;
        Date created;
        block16: {
            created = null;
            expires = null;
            try {
                try {
                    SimpleDateFormat simpleDateFormat = calendarFormatter1;
                    synchronized (simpleDateFormat) {
                        created = calendarFormatter1.parse(creationTime);
                    }
                    if (expirationTime == null) break block16;
                    simpleDateFormat = calendarFormatter1;
                    synchronized (simpleDateFormat) {
                        expires = calendarFormatter1.parse(expirationTime);
                    }
                }
                catch (ParseException pe) {
                    SimpleDateFormat simpleDateFormat = calendarFormatter2;
                    synchronized (simpleDateFormat) {
                        created = calendarFormatter2.parse(creationTime);
                    }
                    if (expirationTime == null) break block16;
                    simpleDateFormat = calendarFormatter2;
                    synchronized (simpleDateFormat) {
                        expires = calendarFormatter2.parse(expirationTime);
                    }
                }
            }
            catch (ParseException pe) {
                throw new XWSSecurityException(pe.getMessage());
            }
        }
        return expires != null && expires.before(created);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateCreationTime(Map context, String creationTime, long maxClockSkew, long timestampFreshnessLimit) throws XWSSecurityException {
        Date created;
        try {
            SimpleDateFormat simpleDateFormat = calendarFormatter1;
            synchronized (simpleDateFormat) {
                created = calendarFormatter1.parse(creationTime);
            }
        }
        catch (ParseException pe) {
            try {
                SimpleDateFormat simpleDateFormat = calendarFormatter2;
                synchronized (simpleDateFormat) {
                    created = calendarFormatter2.parse(creationTime);
                }
            }
            catch (ParseException pe1) {
                throw new XWSSecurityException("Exception while parsing Creation Time :" + pe1.getMessage());
            }
        }
        Date current = null;
        try {
            current = WssProviderSecurityEnvironment.getFreshnessAndSkewAdjustedDate(maxClockSkew, timestampFreshnessLimit);
        }
        catch (ParseException pe) {
            throw new XWSSecurityException(pe.getMessage());
        }
        if (created.before(current)) {
            XWSSecurityException xwsse = new XWSSecurityException("Creation Time is older than configured Timestamp Freshness Interval!");
            throw DefaultSecurityEnvironmentImpl.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Creation Time is older than configured Timestamp Freshness Interval!", xwsse);
        }
        Date currentTime = WssProviderSecurityEnvironment.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, true);
        if (currentTime.before(created)) {
            XWSSecurityException xwsse = new XWSSecurityException("Creation Time ahead of Current Time!");
            throw DefaultSecurityEnvironmentImpl.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Creation Time ahead of Current Time!", xwsse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateExpirationTime(String expirationTime, long maxClockSkew, long timestampFreshnessLimit) throws XWSSecurityException {
        if (expirationTime != null) {
            Date expires;
            try {
                SimpleDateFormat simpleDateFormat = calendarFormatter1;
                synchronized (simpleDateFormat) {
                    expires = calendarFormatter1.parse(expirationTime);
                }
            }
            catch (ParseException pe) {
                try {
                    SimpleDateFormat simpleDateFormat = calendarFormatter2;
                    synchronized (simpleDateFormat) {
                        expires = calendarFormatter2.parse(expirationTime);
                    }
                }
                catch (ParseException pe1) {
                    throw new XWSSecurityException("Exception while parsing Expiration Time :" + pe1.getMessage());
                }
            }
            Date currentTime = WssProviderSecurityEnvironment.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, false);
            if (expires.before(currentTime)) {
                XWSSecurityException xwsse = new XWSSecurityException("Message Expired!");
                throw DefaultSecurityEnvironmentImpl.newSOAPFaultException(MessageConstants.WSU_MESSAGE_EXPIRED, "Message Expired!", xwsse);
            }
        }
    }

    public CallbackHandler getCallbackHandler() throws XWSSecurityException {
        return this._handler;
    }

    public void validateSAMLAssertion(Map context, Element assertion) throws XWSSecurityException {
        throw new UnsupportedOperationException("Not supported");
    }

    public Element locateSAMLAssertion(Map context, Element binding, String assertionId, Document ownerDoc) throws XWSSecurityException {
        throw new UnsupportedOperationException("Not supported");
    }

    public AuthenticationTokenPolicy.SAMLAssertionBinding populateSAMLPolicy(Map fpcontext, AuthenticationTokenPolicy.SAMLAssertionBinding policy, DynamicApplicationContext context) throws XWSSecurityException {
        throw new UnsupportedOperationException("Not supported");
    }

    private static Date getGMTDateWithSkewAdjusted(Calendar c, long maxClockSkew, boolean addSkew) {
        long offset = c.get(15);
        if (c.getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)c.getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        currentTime = addSkew ? (currentTime += maxClockSkew) : (currentTime -= maxClockSkew);
        c.setTimeInMillis(currentTime);
        return c.getTime();
    }

    private static Date getFreshnessAndSkewAdjustedDate(long maxClockSkew, long timestampFreshnessLimit) throws ParseException {
        GregorianCalendar c = new GregorianCalendar();
        long offset = c.get(15);
        if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        long adjustedTime = currentTime - maxClockSkew - timestampFreshnessLimit;
        c.setTimeInMillis(adjustedTime);
        return c.getTime();
    }

    private X509Certificate getDynamicCertificate(Map context, KeyStore trustStore) {
        X509Certificate cert = null;
        Subject requesterSubject = this.getRequesterSubject(context);
        String keyId = (String)context.get("requester.keyid");
        String issuerName = (String)context.get("requester.issuername");
        BigInteger issuerSerial = (BigInteger)context.get("requester.serial");
        if (keyId != null) {
            try {
                cert = this.getMatchingCertificate(keyId.getBytes(), trustStore);
                if (cert != null) {
                    return cert;
                }
            }
            catch (XWSSecurityException e) {}
        } else if (issuerName != null && issuerSerial != null) {
            try {
                cert = this.getMatchingCertificate(issuerSerial, issuerName, trustStore);
                if (cert != null) {
                    return cert;
                }
            }
            catch (XWSSecurityException e) {}
        } else if (requesterSubject != null) {
            Set<Object> publicCredentials = requesterSubject.getPublicCredentials();
            for (Object cred : publicCredentials) {
                if (!(cred instanceof X509Certificate)) continue;
                cert = (X509Certificate)cred;
            }
            if (cert != null) {
                return cert;
            }
        }
        return null;
    }

    public void updateOtherPartySubject(Subject subj, String encryptedKey) {
    }

    public void updateOtherPartySubject(Subject subject, Key secretKey) {
    }

    public PrivateKey getPrivateKey(Map context, byte[] keyIdentifier, String valueType) throws XWSSecurityException {
        if ("Identifier".equals(valueType)) {
            return this.getPrivateKey(context, keyIdentifier);
        }
        try {
            Set<X500PrivateCredential> set;
            Subject subject = this.getSubject(context);
            if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
                for (X500PrivateCredential cred : set) {
                    if (!this.matchesThumbPrint(Base64.decode(keyIdentifier), cred.getCertificate())) continue;
                    return cred.getPrivateKey();
                }
            }
            PrivateKeyCallback.SubjectKeyIDRequest request = new PrivateKeyCallback.SubjectKeyIDRequest(keyIdentifier);
            PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
            Callback[] callbacks = new Callback[]{pkCallback};
            this._handler.handle(callbacks);
            return pkCallback.getKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public void validateSAMLAssertion(Map context, XMLStreamReader assertion) throws XWSSecurityException {
        throw new UnsupportedOperationException("Not supported");
    }

    public void updateOtherPartySubject(Subject subject, XMLStreamReader assertion) {
    }

    public boolean isSelfCertificate(X509Certificate cert) {
        throw new UnsupportedOperationException("Not supported");
    }

    public void updateOtherPartySubject(Subject subject, Subject bootStrapSubject) {
        throw new UnsupportedOperationException("Not supported");
    }

    public KerberosContext doKerberosLogin() throws XWSSecurityException {
        throw new UnsupportedOperationException("Not supported");
    }

    public KerberosContext doKerberosLogin(byte[] tokenValue) throws XWSSecurityException {
        throw new UnsupportedOperationException("Not supported");
    }
}

