/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.common;

import com.sun.enterprise.transaction.TransactionImport;
import com.sun.xml.ws.tx.common.LocalizationMessages;
import com.sun.xml.ws.tx.common.TransactionManagerImpl;
import com.sun.xml.ws.tx.common.TxLogger;
import java.util.logging.Level;
import javax.resource.spi.XATerminator;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;

public class TransactionImportManager
implements TransactionImport {
    private static final TxLogger logger = TxLogger.getATLogger(TransactionManagerImpl.class);
    static final TransactionImport instance = new TransactionImportManager();
    private static TransactionImport javaeeTM;

    private TransactionImportManager() {
        try {
            javaeeTM = (TransactionImport)TransactionManagerImpl.getInstance().getTransactionManager();
        }
        catch (ClassCastException cce) {
            String CLASSNAME = javaeeTM == null ? "null" : javaeeTM.getClass().getName();
            logger.severe("TransactionImportManager", LocalizationMessages.NO_TXN_IMPORT_2014(CLASSNAME), cce);
        }
    }

    public static TransactionImport getInstance() {
        return instance;
    }

    public void recreate(Xid xid, long timeout) {
        javaeeTM.recreate(xid, timeout);
    }

    public void release(Xid xid) {
        javaeeTM.release(xid);
    }

    public XATerminator getXATerminator() {
        return javaeeTM.getXATerminator();
    }

    public int getTransactionRemainingTimeout() throws SystemException {
        String METHOD = "getRemainingTimeout";
        int result = 0;
        try {
            result = javaeeTM.getTransactionRemainingTimeout();
        }
        catch (IllegalStateException ise) {
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("getRemainingTimeout", "looking up remaining txn timeout, no current transaction", ise);
            } else {
                logger.info("getRemainingTimeout", LocalizationMessages.TXN_MGR_OPERATION_FAILED_2008("getTransactionRemainingTimeout", ise.getLocalizedMessage()));
            }
        }
        catch (Throwable t) {
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("getRemainingTimeout", "ignoring exception " + t.getClass().getName() + " thrown calling" + "TM.getTransactionRemainingTimeout method");
            }
            logger.info("getRemainingTimeout", LocalizationMessages.TXN_MGR_OPERATION_FAILED_2008("getTransactionRemainingTimeout", t.getLocalizedMessage()));
        }
        return result;
    }
}

