/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl;

import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.client.STSIssuedTokenConfiguration;
import com.sun.xml.ws.api.security.trust.client.SecondaryIssuedTokenParameters;
import com.sun.xml.ws.mex.client.MetadataClient;
import com.sun.xml.ws.mex.client.PortInfo;
import com.sun.xml.ws.mex.client.schema.Metadata;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.trust.Configuration;
import com.sun.xml.ws.security.trust.TrustPlugin;
import com.sun.xml.ws.security.trust.WSTrustClientContract;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.OnBehalfOf;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponseCollection;
import com.sun.xml.ws.security.trust.elements.SecondaryParameters;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.wss.impl.dsig.WSSPolicyConsumerImpl;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.AddressingFeature;

public class TrustPluginImpl
implements TrustPlugin {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    private final Configuration config;
    private static final String PRE_CONFIGURED_STS = "PreconfiguredSTS";
    private static final String NAMESPACE = "namespace";
    private static final String CONFIG_NAMESPACE = "";
    private static final String ENDPOINT = "endPoint";
    private static final String METADATA = "metadata";
    private static final String WSDL_LOCATION = "wsdlLocation";
    private static final String SERVICE_NAME = "serviceName";
    private static final String PORT_NAME = "portName";
    private static final String REQUEST_SECURITY_TOKEN_TEMPLATE = "RequestSecurityTokenTemplate";
    private static final String CLAIMS = "Claims";
    private static final String DIALECT = "Dialect";

    public TrustPluginImpl(Configuration config) {
        this.config = config;
    }

    public void process(IssuedTokenContext itc) throws WSTrustException {
        String appliesTo = itc.getEndpointAddress();
        STSIssuedTokenConfiguration stsConfig = (STSIssuedTokenConfiguration)itc.getSecurityPolicy().get(0);
        String stsURI = stsConfig.getSTSEndpoint();
        if (stsURI == null) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0029_COULD_NOT_GET_STS_LOCATION(appliesTo));
            throw new WebServiceException(LogStringsMessages.WST_0029_COULD_NOT_GET_STS_LOCATION(appliesTo));
        }
        URI wsdlLocation = null;
        QName serviceName = null;
        QName portName = null;
        String metadataStr = stsConfig.getSTSMEXAddress();
        if (metadataStr != null) {
            wsdlLocation = URI.create(metadataStr);
        } else {
            String namespace = stsConfig.getSTSNamespace();
            String wsdlLocationStr = stsConfig.getSTSWSDLLocation();
            if (wsdlLocationStr == null) {
                wsdlLocationStr = stsURI;
            } else {
                String portNameStr;
                String serviceNameStr = stsConfig.getSTSServiceName();
                if (serviceNameStr != null && namespace != null) {
                    serviceName = new QName(namespace, serviceNameStr);
                }
                if ((portNameStr = stsConfig.getSTSPortName()) != null && namespace != null) {
                    portName = new QName(namespace, portNameStr);
                }
            }
            wsdlLocation = URI.create(wsdlLocationStr);
        }
        Token oboToken = stsConfig.getOBOToken();
        BaseSTSResponse result = null;
        try {
            RequestSecurityToken request = this.createRequest(stsConfig, appliesTo, oboToken);
            result = this.invokeRST(request, wsdlLocation, serviceName, portName, stsURI, stsConfig);
            WSTrustClientContract contract = WSTrustFactory.createWSTrustClientContract(this.config);
            contract.handleRSTR(request, result, itc);
            KeyPair keyPair = (KeyPair)stsConfig.getOtherOptions().get("UseKey-RSAKeyPair");
            if (keyPair != null) {
                itc.setProofKeyPair(keyPair);
            }
        }
        catch (RemoteException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, appliesTo), ex);
            throw new WSTrustException(LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, appliesTo), ex);
        }
        catch (URISyntaxException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, appliesTo), ex);
            throw new WSTrustException(LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, appliesTo));
        }
    }

    private RequestSecurityToken createRequest(STSIssuedTokenConfiguration stsConfig, String appliesTo, Token oboToken) throws URISyntaxException, WSTrustException, NumberFormatException {
        SecondaryIssuedTokenParameters sitp;
        WSTrustVersion wstVer = WSTrustVersion.getInstance(stsConfig.getProtocol());
        WSTrustElementFactory fact = WSTrustElementFactory.newInstance(wstVer);
        URI requestType = URI.create(wstVer.getIssueRequestTypeURI());
        AppliesTo applTo = null;
        if (appliesTo != null) {
            applTo = WSTrustUtil.createAppliesTo(appliesTo);
        }
        RequestSecurityToken rst = fact.createRSTForIssue(null, requestType, null, applTo, null, null, null);
        if (oboToken != null) {
            OnBehalfOf obo = fact.createOnBehalfOf(oboToken);
            rst.setOnBehalfOf(obo);
        }
        String tokenType = null;
        String keyType = null;
        long keySize = -1L;
        String signWith = null;
        String encryptWith = null;
        String signatureAlgorithm = null;
        String encryptionAlgorithm = null;
        String canonicalizationAlgorithm = null;
        Claims claims = null;
        if (wstVer.getNamespaceURI().equals(WSTrustVersion.WS_TRUST_13.getNamespaceURI()) && (sitp = stsConfig.getSecondaryIssuedTokenParameters()) != null) {
            SecondaryParameters sp = fact.createSecondaryParameters();
            tokenType = sitp.getTokenType();
            if (tokenType != null) {
                sp.setTokenType(URI.create(tokenType));
            }
            if ((keyType = sitp.getKeyType()) != null) {
                sp.setKeyType(URI.create(keyType));
            }
            if ((keySize = sitp.getKeySize()) > 0L) {
                sp.setKeySize(keySize);
            }
            if ((encryptWith = sitp.getEncryptWith()) != null) {
                sp.setEncryptWith(URI.create(encryptWith));
            }
            if ((signWith = sitp.getSignWith()) != null) {
                sp.setSignWith(URI.create(signWith));
            }
            if ((signatureAlgorithm = sitp.getSignatureAlgorithm()) != null) {
                sp.setSignatureAlgorithm(URI.create(signatureAlgorithm));
            }
            if ((encryptionAlgorithm = sitp.getEncryptionAlgorithm()) != null) {
                sp.setEncryptionAlgorithm(URI.create(encryptionAlgorithm));
            }
            if ((canonicalizationAlgorithm = sitp.getCanonicalizationAlgorithm()) != null) {
                sp.setCanonicalizationAlgorithm(URI.create(canonicalizationAlgorithm));
            }
            if ((claims = sitp.getClaims()) != null) {
                sp.setClaims(claims);
            }
            rst.setSecondaryParameters(sp);
        }
        if (tokenType == null && (tokenType = stsConfig.getTokenType()) != null) {
            rst.setTokenType(URI.create(tokenType));
        }
        if (keyType == null && (keyType = stsConfig.getKeyType()) != null) {
            rst.setKeyType(URI.create(keyType));
        }
        if (keySize < 1L && (keySize = stsConfig.getKeySize()) > 0L) {
            rst.setKeySize(keySize);
        }
        if (encryptWith == null && (encryptWith = stsConfig.getEncryptWith()) != null) {
            rst.setEncryptWith(URI.create(encryptWith));
        }
        if (signWith == null && (signWith = stsConfig.getSignWith()) != null) {
            rst.setSignWith(URI.create(signWith));
        }
        if (signatureAlgorithm == null && (signatureAlgorithm = stsConfig.getSignatureAlgorithm()) != null) {
            rst.setSignWith(URI.create(signWith));
        }
        if (encryptionAlgorithm == null && (encryptionAlgorithm = stsConfig.getEncryptionAlgorithm()) != null) {
            rst.setEncryptionAlgorithm(URI.create(encryptionAlgorithm));
        }
        if (canonicalizationAlgorithm == null && (canonicalizationAlgorithm = stsConfig.getCanonicalizationAlgorithm()) != null) {
            rst.setCanonicalizationAlgorithm(URI.create(canonicalizationAlgorithm));
        }
        if (claims == null && (claims = stsConfig.getClaims()) != null) {
            rst.setClaims(claims);
        }
        int len = 32;
        if (keySize > 0L) {
            len = (int)keySize / 8;
        }
        if (wstVer.getSymmetricKeyTypeURI().equals(keyType)) {
            SecureRandom secRandom = new SecureRandom();
            byte[] nonce = new byte[len];
            secRandom.nextBytes(nonce);
            BinarySecret binarySecret = fact.createBinarySecret(nonce, wstVer.getNonceBinarySecretTypeURI());
            Entropy entropy = fact.createEntropy(binarySecret);
            rst.setEntropy(entropy);
            rst.setComputedKeyAlgorithm(URI.create(wstVer.getCKPSHA1algorithmURI()));
        } else if (!wstVer.getPublicKeyTypeURI().equals(keyType) || keySize > 1L) {
            // empty if block
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WST_1006_CREATED_RST_ISSUE(this.elemToString(rst)));
        }
        return rst;
    }

    private BaseSTSResponse invokeRST(RequestSecurityToken request, URI wsdlLocation, QName serviceName, QName portName, String stsURI, STSIssuedTokenConfiguration stsConfig) throws RemoteException, WSTrustException {
        WSTrustVersion wstVer = WSTrustVersion.getInstance(stsConfig.getProtocol());
        WSTrustElementFactory fact = WSTrustElementFactory.newInstance(wstVer);
        if (serviceName == null || portName == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, LogStringsMessages.WST_1012_SERVICE_PORTNAME_MEX(serviceName, portName));
            }
            QName[] names = TrustPluginImpl.doMexRequest(wsdlLocation.toString(), stsURI);
            serviceName = names[0];
            portName = names[1];
        }
        Service service = null;
        try {
            String url = wsdlLocation.toString();
            service = Service.create(new URL(url), serviceName);
        }
        catch (MalformedURLException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0041_SERVICE_NOT_CREATED(wsdlLocation.toString()), ex);
            throw new WebServiceException(LogStringsMessages.WST_0041_SERVICE_NOT_CREATED(wsdlLocation.toString()), ex);
        }
        Dispatch<Object> dispatch = service.createDispatch(portName, WSTrustElementFactory.getContext(wstVer), Service.Mode.PAYLOAD, new RespectBindingFeature(), new AddressingFeature(false));
        if (stsURI != null) {
            dispatch.getRequestContext().put("javax.xml.ws.service.endpoint.address", stsURI);
        }
        dispatch.getRequestContext().put("isTrustMessage", "true");
        dispatch.getRequestContext().put(wstVer.getIssueRequestAction(), wstVer.getIssueRequestAction());
        String userName = (String)stsConfig.getOtherOptions().get("javax.xml.ws.security.auth.username");
        String password = (String)stsConfig.getOtherOptions().get("javax.xml.ws.security.auth.password");
        if (userName != null) {
            dispatch.getRequestContext().put("javax.xml.ws.security.auth.username", userName);
        }
        if (password != null) {
            dispatch.getRequestContext().put("javax.xml.ws.security.auth.password", password);
        }
        KeyPair keyPair = (KeyPair)stsConfig.getOtherOptions().get("UseKey-RSAKeyPair");
        String id = (String)stsConfig.getOtherOptions().get("UseKey-SignatureID");
        if (keyPair != null) {
            dispatch.getRequestContext().put("UseKey-RSAKeyPair", keyPair);
        }
        if (id != null) {
            dispatch.getRequestContext().put("UseKey-SignatureID", id);
        }
        BaseSTSResponse rstr = wstVer.getNamespaceURI().equals(WSTrustVersion.WS_TRUST_13.getNamespaceURI()) ? fact.createRSTRCollectionFrom((JAXBElement)dispatch.invoke(fact.toJAXBElement(request))) : fact.createRSTRFrom((JAXBElement)dispatch.invoke(fact.toJAXBElement(request)));
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WST_1014_RESPONSE_INVOKING_RST(this.elemToString(rstr)));
        }
        return rstr;
    }

    protected static QName[] doMexRequest(String wsdlLocation, String stsURI) throws WSTrustException {
        QName[] serviceInfo = new QName[2];
        MetadataClient mexClient = new MetadataClient();
        Metadata metadata = mexClient.retrieveMetadata(wsdlLocation);
        if (metadata != null) {
            List<PortInfo> ports = mexClient.getServiceInformation(metadata);
            for (PortInfo port : ports) {
                String uri = port.getAddress();
                if (!uri.equals(stsURI)) continue;
                serviceInfo[0] = port.getServiceName();
                serviceInfo[1] = port.getPortName();
                break;
            }
            if (serviceInfo[0] == null || serviceInfo[1] == null) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0042_NO_MATCHING_SERVICE_MEX(stsURI));
                throw new WSTrustException(LogStringsMessages.WST_0042_NO_MATCHING_SERVICE_MEX(stsURI));
            }
        } else {
            log.log(Level.SEVERE, LogStringsMessages.WST_0017_SERVICE_PORTNAME_ERROR(wsdlLocation));
            throw new WSTrustException(LogStringsMessages.WST_0017_SERVICE_PORTNAME_ERROR(wsdlLocation));
        }
        return serviceInfo;
    }

    private KeyInfo createKeyInfo(PublicKey pubKey) throws WSTrustException {
        KeyInfoFactory kif = WSSPolicyConsumerImpl.getInstance().getKeyInfoFactory();
        KeyValue kv = null;
        try {
            kv = kif.newKeyValue(pubKey);
        }
        catch (KeyException ex) {
            throw new WSTrustException("Unable to create key value", ex);
        }
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(kv);
        KeyInfo ki = kif.newKeyInfo(kvs);
        return ki;
    }

    private String elemToString(RequestSecurityTokenResponse rstr) {
        return rstr.toString();
    }

    private String elemToString(RequestSecurityToken rst) {
        return rst.toString();
    }

    private String elemToString(BaseSTSResponse rstr) {
        if (rstr instanceof RequestSecurityTokenResponse) {
            return this.elemToString((RequestSecurityTokenResponse)rstr);
        }
        if (rstr instanceof RequestSecurityTokenResponseCollection) {
            return this.elemToString((RequestSecurityTokenResponseCollection)rstr);
        }
        return null;
    }
}

