/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.crypto.dsig;

import com.sun.xml.ws.security.opt.crypto.dsig.SignedInfo;
import com.sun.xml.ws.security.opt.crypto.dsig.internal.HmacSHA1;
import com.sun.xml.ws.security.opt.crypto.dsig.internal.MacOutputStream;
import com.sun.xml.ws.security.opt.crypto.dsig.internal.SignerOutputStream;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.util.NamespaceAndPrefixMapper;
import com.sun.xml.ws.security.opt.impl.util.WSSNamespacePrefixMapper;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.c14n.AttributeNS;
import com.sun.xml.wss.impl.c14n.EXC14nStAXReaderBasedCanonicalizer;
import com.sun.xml.wss.impl.c14n.StAXEXC14nCanonicalizerImpl;
import com.sun.xml.wss.logging.impl.opt.signature.LogStringsMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.stream.XMLStreamException;
import org.jvnet.staxex.NamespaceContextEx;
import org.jvnet.staxex.XMLStreamReaderEx;

public class SignatureProcessor {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.signature", "com.sun.xml.wss.logging.impl.opt.signature.LogStrings");
    private JAXBContext _jaxbContext;
    StAXEXC14nCanonicalizerImpl _exc14nCanonicalizer = new StAXEXC14nCanonicalizerImpl();
    EXC14nStAXReaderBasedCanonicalizer _exc14nSBCanonicalizer;
    XMLCryptoContext context = null;
    private Signature _rsaSignature;
    private Signature _dsaSignature;

    public void setJAXBContext(JAXBContext _jaxbContext) {
        this._jaxbContext = _jaxbContext;
    }

    public JAXBContext getJAXBContext() {
        return this._jaxbContext;
    }

    public void setCryptoContext(XMLCryptoContext context) {
        this.context = context;
    }

    public byte[] performRSASign(Key privateKey, SignedInfo signedInfo) throws InvalidKeyException {
        if (privateKey == null || signedInfo == null) {
            throw new NullPointerException();
        }
        if (!(privateKey instanceof PrivateKey)) {
            throw new InvalidKeyException("key must be PrivateKey");
        }
        if (this._rsaSignature == null) {
            try {
                this._rsaSignature = Signature.getInstance("SHA1withRSA");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new XWSSecurityRuntimeException(ex);
            }
        }
        this._rsaSignature.initSign((PrivateKey)privateKey);
        SignerOutputStream signerOutputStream = new SignerOutputStream(this._rsaSignature);
        try {
            Marshaller marshaller = this.getMarshaller();
            this._exc14nCanonicalizer.reset();
            this.setNamespaceAndPrefixList();
            this._exc14nCanonicalizer.setStream(signerOutputStream);
            marshaller.marshal((Object)signedInfo, this._exc14nCanonicalizer);
            if (logger.isLoggable(Level.FINEST)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this._exc14nCanonicalizer.reset();
                this._exc14nCanonicalizer.setStream(baos);
                marshaller.marshal((Object)signedInfo, this._exc14nCanonicalizer);
                logger.log(Level.FINEST, LogStringsMessages.WSS_1756_CANONICALIZED_SIGNEDINFO_VALUE(baos.toString()));
            }
        }
        catch (JAXBException ex) {
            throw new XWSSecurityRuntimeException(ex);
        }
        try {
            return this._rsaSignature.sign();
        }
        catch (SignatureException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    public byte[] performHMACSign(Key key, SignedInfo signedInfo, int outputLength) throws InvalidKeyException {
        if (key == null || signedInfo == null) {
            throw new NullPointerException();
        }
        HmacSHA1 hmac = new HmacSHA1();
        hmac.init(key, outputLength);
        MacOutputStream macOutputStream = new MacOutputStream(hmac);
        try {
            Marshaller marshaller = this.getMarshaller();
            this._exc14nCanonicalizer.reset();
            this.setNamespaceAndPrefixList();
            this._exc14nCanonicalizer.setStream(macOutputStream);
            marshaller.marshal((Object)signedInfo, this._exc14nCanonicalizer);
            if (logger.isLoggable(Level.FINEST)) {
                marshaller = this.getMarshaller();
                this._exc14nCanonicalizer.reset();
                this.setNamespaceAndPrefixList();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                this._exc14nCanonicalizer.setStream(bos);
                marshaller.marshal((Object)signedInfo, this._exc14nCanonicalizer);
                logger.log(Level.FINEST, LogStringsMessages.WSS_1756_CANONICALIZED_SIGNEDINFO_VALUE(bos.toString()));
            }
        }
        catch (JAXBException ex) {
            throw new XWSSecurityRuntimeException(ex);
        }
        try {
            return hmac.sign();
        }
        catch (SignatureException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    public byte[] performDSASign(Key privateKey, SignedInfo signedInfo) throws InvalidKeyException {
        if (privateKey == null || signedInfo == null) {
            throw new NullPointerException();
        }
        if (!(privateKey instanceof PrivateKey)) {
            throw new InvalidKeyException("key must be PrivateKey");
        }
        if (this._dsaSignature == null) {
            try {
                this._dsaSignature = Signature.getInstance("SHA1withDSA");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new XWSSecurityRuntimeException(ex);
            }
        }
        this._dsaSignature.initSign((PrivateKey)privateKey);
        SignerOutputStream signerOutputStream = new SignerOutputStream(this._dsaSignature);
        try {
            Marshaller marshaller = this.getMarshaller();
            this._exc14nCanonicalizer.reset();
            this.setNamespaceAndPrefixList();
            this._exc14nCanonicalizer.setStream(signerOutputStream);
            marshaller.marshal((Object)signedInfo, this._exc14nCanonicalizer);
        }
        catch (JAXBException ex) {
            throw new XWSSecurityRuntimeException(ex);
        }
        try {
            return SignatureProcessor.convertASN1toXMLDSIG(this._dsaSignature.sign());
        }
        catch (SignatureException se) {
            throw new RuntimeException(se.getMessage());
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex.getMessage());
        }
    }

    private static byte[] convertASN1toXMLDSIG(byte[] asn1Bytes) throws IOException {
        int sLength;
        int j;
        int rLength;
        int i;
        for (i = rLength = asn1Bytes[3]; i > 0 && asn1Bytes[4 + rLength - i] == 0; --i) {
        }
        for (j = sLength = asn1Bytes[5 + rLength]; j > 0 && asn1Bytes[6 + rLength + sLength - j] == 0; --j) {
        }
        if (asn1Bytes[0] != 48 || asn1Bytes[1] != asn1Bytes.length - 2 || asn1Bytes[2] != 2 || i > 20 || asn1Bytes[4 + rLength] != 2 || j > 20) {
            throw new IOException("Invalid ASN.1 format of DSA signature");
        }
        byte[] xmldsigBytes = new byte[40];
        System.arraycopy(asn1Bytes, 4 + rLength - i, xmldsigBytes, 20 - i, i);
        System.arraycopy(asn1Bytes, 6 + rLength + sLength - j, xmldsigBytes, 40 - j, j);
        return xmldsigBytes;
    }

    public boolean verifyDSASignature(Key publicKey, SignedInfo si, byte[] signatureValue) throws InvalidKeyException, SignatureException {
        if (!(publicKey instanceof PublicKey)) {
            throw new InvalidKeyException("key must be PublicKey");
        }
        if (this._dsaSignature == null) {
            try {
                this._dsaSignature = Signature.getInstance("SHA1withDSA");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new SignatureException("SHA1withDSA Signature not found");
            }
        }
        this._dsaSignature.initVerify((PublicKey)publicKey);
        SignerOutputStream sos = new SignerOutputStream(this._dsaSignature);
        if (si.getSignedInfo() != null) {
            XMLStreamReaderEx signedInfo = si.getSignedInfo();
            if (this._exc14nSBCanonicalizer == null) {
                this._exc14nSBCanonicalizer = new EXC14nStAXReaderBasedCanonicalizer();
            }
            NamespaceContextEx nsContext = signedInfo.getNamespaceContext();
            Iterator<NamespaceContextEx.Binding> itr = nsContext.iterator();
            ArrayList<AttributeNS> list = new ArrayList<AttributeNS>();
            while (itr.hasNext()) {
                NamespaceContextEx.Binding binding = itr.next();
                AttributeNS ans = new AttributeNS();
                ans.setPrefix(binding.getPrefix());
                ans.setUri(binding.getNamespaceURI());
                list.add(ans);
            }
            this._exc14nSBCanonicalizer.addParentNamespaces(list);
            try {
                this._exc14nSBCanonicalizer.canonicalize(signedInfo, sos, null);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("SHA1withDSA"));
                throw new SignatureException(LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("SHA1withDSA"), ex);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("SHA1withDSA"));
                throw new SignatureException(LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("SHA1withDSA"), ex);
            }
        } else {
            sos.write(si.getCanonicalizedSI());
        }
        try {
            return this._dsaSignature.verify(SignatureProcessor.convertXMLDSIGtoASN1(signatureValue));
        }
        catch (SignatureException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("SHA1withDSA"));
            throw new SignatureException(LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("SHA1withDSA"), ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("SHA1withDSA"));
            throw new SignatureException(LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("SHA1withDSA"), ex);
        }
    }

    public boolean verifyHMACSignature(Key key, SignedInfo si, byte[] signatureValue, int outputLength) throws InvalidKeyException, SignatureException {
        if (key == null || si == null || signatureValue == null) {
            throw new NullPointerException("key, signedinfo or signature data can't be null");
        }
        HmacSHA1 hmac = new HmacSHA1();
        hmac.init(key, outputLength);
        MacOutputStream mos = new MacOutputStream(hmac);
        if (si.getSignedInfo() != null) {
            XMLStreamReaderEx signedInfo = si.getSignedInfo();
            if (this._exc14nSBCanonicalizer == null) {
                this._exc14nSBCanonicalizer = new EXC14nStAXReaderBasedCanonicalizer();
            }
            NamespaceContextEx nsContext = signedInfo.getNamespaceContext();
            Iterator<NamespaceContextEx.Binding> itr = nsContext.iterator();
            ArrayList<AttributeNS> list = new ArrayList<AttributeNS>();
            while (itr.hasNext()) {
                NamespaceContextEx.Binding binding = itr.next();
                AttributeNS ans = new AttributeNS();
                ans.setPrefix(binding.getPrefix());
                ans.setUri(binding.getNamespaceURI());
                list.add(ans);
            }
            this._exc14nSBCanonicalizer.addParentNamespaces(list);
            this._exc14nSBCanonicalizer.addParentNamespaces(list);
            try {
                this._exc14nSBCanonicalizer.canonicalize(signedInfo, mos, null);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("HMAC_SHA1"));
                throw new SignatureException(LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("HMAC_SHA1"), ex);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("HMAC_SHA1"));
                throw new SignatureException(LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("HMAC_SHA1"), ex);
            }
        } else {
            mos.write(si.getCanonicalizedSI());
        }
        return hmac.verify(signatureValue);
    }

    public boolean verifyRSASignature(Key publicKey, SignedInfo si, byte[] signatureValue) throws InvalidKeyException, SignatureException {
        if (!(publicKey instanceof PublicKey)) {
            throw new InvalidKeyException("key must be PublicKey");
        }
        if (this._rsaSignature == null) {
            try {
                this._rsaSignature = Signature.getInstance("SHA1withRSA");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new SignatureException("SHA1withRSA Signature not found");
            }
        }
        this._rsaSignature.initVerify((PublicKey)publicKey);
        SignerOutputStream sos = new SignerOutputStream(this._rsaSignature);
        if (si.getSignedInfo() != null) {
            XMLStreamReaderEx signedInfo = si.getSignedInfo();
            if (this._exc14nSBCanonicalizer == null) {
                this._exc14nSBCanonicalizer = new EXC14nStAXReaderBasedCanonicalizer();
            }
            NamespaceContextEx nsContext = signedInfo.getNamespaceContext();
            Iterator<NamespaceContextEx.Binding> itr = nsContext.iterator();
            ArrayList<AttributeNS> list = new ArrayList<AttributeNS>();
            while (itr.hasNext()) {
                NamespaceContextEx.Binding binding = itr.next();
                AttributeNS ans = new AttributeNS();
                ans.setPrefix(binding.getPrefix());
                ans.setUri(binding.getNamespaceURI());
                list.add(ans);
            }
            this._exc14nSBCanonicalizer.addParentNamespaces(list);
            try {
                this._exc14nSBCanonicalizer.canonicalize(signedInfo, sos, null);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("SHA1WithRSA"));
                throw new SignatureException(LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("SHA1WithRSA"), ex);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("SHA1WithRSA"));
                throw new SignatureException(LogStringsMessages.WSS_1724_SIGTYPE_VERIFICATION_FAILED("SHA1WithRSA"), ex);
            }
        } else {
            sos.write(si.getCanonicalizedSI());
        }
        return this._rsaSignature.verify(signatureValue);
    }

    private static byte[] convertXMLDSIGtoASN1(byte[] xmldsigBytes) throws IOException {
        int k;
        int i;
        if (xmldsigBytes.length != 40) {
            throw new IOException("Invalid XMLDSIG format of DSA signature");
        }
        for (i = 20; i > 0 && xmldsigBytes[20 - i] == 0; --i) {
        }
        int j = i;
        if (xmldsigBytes[20 - i] < 0) {
            ++j;
        }
        for (k = 20; k > 0 && xmldsigBytes[40 - k] == 0; --k) {
        }
        int l = k;
        if (xmldsigBytes[40 - k] < 0) {
            ++l;
        }
        byte[] asn1Bytes = new byte[6 + j + l];
        asn1Bytes[0] = 48;
        asn1Bytes[1] = (byte)(4 + j + l);
        asn1Bytes[2] = 2;
        asn1Bytes[3] = (byte)j;
        System.arraycopy(xmldsigBytes, 20 - i, asn1Bytes, 4 + j - i, i);
        asn1Bytes[4 + j] = 2;
        asn1Bytes[5 + j] = (byte)l;
        System.arraycopy(xmldsigBytes, 40 - k, asn1Bytes, 6 + j + l - k, k);
        return asn1Bytes;
    }

    private Marshaller getMarshaller() throws JAXBException {
        JAXBFilterProcessingContext wssContext = (JAXBFilterProcessingContext)this.context.get("http://wss.sun.com#processingContext");
        Marshaller marshaller = this._jaxbContext.createMarshaller();
        marshaller.setProperty("com.sun.xml.bind.xmlDeclaration", false);
        if (wssContext != null) {
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", new WSSNamespacePrefixMapper(wssContext.isSOAP12()));
        } else {
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", new WSSNamespacePrefixMapper());
        }
        marshaller.setProperty("jaxb.fragment", true);
        return marshaller;
    }

    private void setNamespaceAndPrefixList() {
        NamespaceAndPrefixMapper nsMapper = (NamespaceAndPrefixMapper)this.context.get("NS_And_Prefix_Mapper");
        if (nsMapper != null) {
            NamespaceContextEx nc = nsMapper.getNamespaceContext();
            for (NamespaceContextEx.Binding nd : nc) {
                try {
                    this._exc14nCanonicalizer.writeNamespace(nd.getPrefix(), nd.getNamespaceURI());
                }
                catch (XMLStreamException ex) {
                    throw new XWSSecurityRuntimeException(ex);
                }
            }
            List<String> incList = nsMapper.getInlusivePrefixList();
            this._exc14nCanonicalizer.setInclusivePrefixList(incList);
        }
    }
}

