/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.util;

import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.spi.PolicyAssertionValidator;
import com.sun.xml.ws.rm.RMVersion;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public class RMPolicyValidator
implements PolicyAssertionValidator {
    private static final ArrayList<QName> serverSideSupportedAssertions = new ArrayList(7);
    private static final ArrayList<QName> clientSideSupportedAssertions = new ArrayList(6);

    public PolicyAssertionValidator.Fitness validateClientSide(PolicyAssertion assertion) {
        return clientSideSupportedAssertions.contains(assertion.getName()) ? PolicyAssertionValidator.Fitness.SUPPORTED : PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    public PolicyAssertionValidator.Fitness validateServerSide(PolicyAssertion assertion) {
        QName assertionName = assertion.getName();
        if (serverSideSupportedAssertions.contains(assertionName)) {
            return PolicyAssertionValidator.Fitness.SUPPORTED;
        }
        if (clientSideSupportedAssertions.contains(assertionName)) {
            return PolicyAssertionValidator.Fitness.UNSUPPORTED;
        }
        return PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    public String[] declareSupportedDomains() {
        return new String[]{RMVersion.WSRM10.policyNamespaceUri, RMVersion.WSRM11.policyNamespaceUri, "http://schemas.microsoft.com/net/2005/02/rm/policy", "http://sun.com/2006/03/rm", "http://sun.com/2006/03/rm/client"};
    }

    static {
        serverSideSupportedAssertions.add(new QName(RMVersion.WSRM10.policyNamespaceUri, "RMAssertion"));
        serverSideSupportedAssertions.add(new QName(RMVersion.WSRM11.policyNamespaceUri, "RMAssertion"));
        serverSideSupportedAssertions.add(new QName(RMVersion.WSRM11.policyNamespaceUri, "SequenceSTR"));
        serverSideSupportedAssertions.add(new QName(RMVersion.WSRM11.policyNamespaceUri, "SequenceTransportSecurity"));
        serverSideSupportedAssertions.add(new QName("http://sun.com/2006/03/rm", "Ordered"));
        serverSideSupportedAssertions.add(new QName("http://sun.com/2006/03/rm", "AllowDuplicates"));
        serverSideSupportedAssertions.add(new QName("http://schemas.microsoft.com/net/2005/02/rm/policy", "RmFlowControl"));
        clientSideSupportedAssertions.add(new QName("http://sun.com/2006/03/rm/client", "AckRequestInterval"));
        clientSideSupportedAssertions.add(new QName("http://sun.com/2006/03/rm/client", "ResendInterval"));
        clientSideSupportedAssertions.add(new QName("http://sun.com/2006/03/rm/client", "CloseTimeout"));
        clientSideSupportedAssertions.addAll(serverSideSupportedAssertions);
    }
}

