/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.assembler;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.client.WSPortInfo;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.Codecs;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipelineAssembler;
import com.sun.xml.ws.api.pipe.PipelineAssemblerFactory;
import com.sun.xml.ws.api.pipe.SOAPBindingCodec;
import com.sun.xml.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.StreamSOAPCodec;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.assembler.ActionDumpPipe;
import com.sun.xml.ws.assembler.ClientPipeConfiguration;
import com.sun.xml.ws.assembler.ClientPipelineHook;
import com.sun.xml.ws.assembler.MessageDumpingFeature;
import com.sun.xml.ws.assembler.ServerPipeConfiguration;
import com.sun.xml.ws.assembler.ServerPipelineHook;
import com.sun.xml.ws.encoding.LazyStreamCodec;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.WSDLPolicyMapWrapper;
import com.sun.xml.ws.policy.jaxws.client.PolicyFeature;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.WsdlDocumentFilter;
import com.sun.xml.ws.policy.util.PolicyMapUtil;
import com.sun.xml.ws.rm.RMVersion;
import com.sun.xml.ws.rm.jaxws.runtime.client.RMClientTube;
import com.sun.xml.ws.rm.jaxws.runtime.server.RMServerTube;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.transport.tcp.wsit.TCPConstants;
import com.sun.xml.ws.transport.tcp.wsit.TCPTransportPipeFactory;
import com.sun.xml.ws.tx.client.TxClientPipe;
import com.sun.xml.ws.tx.common.Util;
import com.sun.xml.ws.tx.service.TxServerPipe;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.jaxws.impl.SecurityClientPipe;
import com.sun.xml.wss.jaxws.impl.SecurityServerPipe;
import com.sun.xml.xwss.XWSSClientPipe;
import com.sun.xml.xwss.XWSSServerPipe;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.PortInfo;

public final class PipelineAssemblerFactoryImpl
extends PipelineAssemblerFactory {
    private static final String PREFIX = "com.sun.xml.ws.assembler";
    private static final String CLIENT_PREFIX = "com.sun.xml.ws.assembler.client";
    private static final String SERVER_PREFIX = "com.sun.xml.ws.assembler.server";
    private static final String BEFORE_SUFFIX = ".before";
    private static final String AFTER_SUFFIX = ".after";
    private static final String TRANSPORT_SUFFIX = ".transport";
    private static final String ACTION_SUFFIX = ".action";
    private static final String WSS_SUFFIX = ".wss";
    private static final String WSA_SUFFIX = ".wsa";
    private static final String WSMEX_SUFFIX = ".wsmex";
    private static final String WSRM_SUFFIX = ".wsrm";
    private static final String WSTX_SUFFIX = ".wstx";
    private static final String WSAT_SOAP_NSURI = "http://schemas.xmlsoap.org/ws/2004/10/wsat";
    private static final QName AT_ALWAYS_CAPABILITY = new QName("http://schemas.xmlsoap.org/ws/2004/10/wsat", "ATAlwaysCapability");
    private static final QName AT_ASSERTION = new QName("http://schemas.xmlsoap.org/ws/2004/10/wsat", "ATAssertion");
    private static final String AUTO_OPTIMIZED_TRANSPORT_POLICY_NAMESPACE_URI = "http://java.sun.com/xml/ns/wsit/2006/09/policy/transport/client";
    private static final QName AUTO_OPTIMIZED_TRANSPORT_POLICY_ASSERTION = new QName("http://java.sun.com/xml/ns/wsit/2006/09/policy/transport/client", "AutomaticallySelectOptimalTransport");
    private static final String xwss20ClientPipe = "com.sun.xml.xwss.XWSSClientPipe";
    private static final String xwss20ServerPipe = "com.sun.xml.xwss.XWSSServerPipe";
    private static final String SERVLET_CONTEXT_CLASSNAME = "javax.servlet.ServletContext";
    private static final Logger logger = Logger.getLogger(PipelineAssemblerFactoryImpl.class.getName());

    public PipelineAssembler doCreate(BindingID bindingId) {
        return new WsitPipelineAssembler(bindingId);
    }

    private static boolean isSecurityConfigPresent(ClientPipeAssemblerContext context) {
        return true;
    }

    private static boolean isSecurityConfigPresent(ServerPipeAssemblerContext context) {
        QName serviceQName = context.getEndpoint().getServiceName();
        String serviceLocalName = serviceQName.getLocalPart();
        Container container = context.getEndpoint().getContainer();
        Object ctxt = null;
        if (container != null) {
            try {
                Class<?> contextClass = Class.forName(SERVLET_CONTEXT_CLASSNAME);
                ctxt = container.getSPI(contextClass);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        String serverName = "server";
        if (ctxt != null) {
            String serverConfig = "/WEB-INF/" + serverName + "_" + "security_config.xml";
            URL url = SecurityUtil.loadFromContext(serverConfig, ctxt);
            if (url == null) {
                serverConfig = "/WEB-INF/" + serviceLocalName + "_" + "security_config.xml";
                url = SecurityUtil.loadFromContext(serverConfig, ctxt);
            }
            if (url != null) {
                return true;
            }
        } else {
            String serverConfig = "META-INF/" + serverName + "_" + "security_config.xml";
            URL url = SecurityUtil.loadFromClasspath(serverConfig);
            if (url == null) {
                serverConfig = "META-INF/" + serviceLocalName + "_" + "security_config.xml";
                url = SecurityUtil.loadFromClasspath(serverConfig);
            }
            if (url != null) {
                return true;
            }
        }
        return false;
    }

    private static Pipe initializeXWSSClientPipe(WSDLPort prt, WSService svc, WSBinding bnd, Pipe nextP) {
        return new XWSSClientPipe(prt, svc, bnd, nextP);
    }

    private static Pipe initializeXWSSServerPipe(WSEndpoint epoint, WSDLPort prt, Pipe nextP) {
        return new XWSSServerPipe(epoint, prt, nextP);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WsitPipelineAssembler
    implements PipelineAssembler {
        private BindingID bindingId;

        WsitPipelineAssembler(BindingID bindingId) {
            this.bindingId = bindingId;
        }

        @Override
        @NotNull
        public Pipe createClient(@NotNull ClientPipeAssemblerContext context) {
            ClientPipelineHook[] hooks;
            boolean isSecurityEnabled;
            WSDLPort wsdlPort = context.getWsdlModel();
            PolicyFeature feature = this.initPolicyMap(context);
            WSDLModel wsdlModel = null;
            PolicyMap policyMap = null;
            PortInfo portInfo = null;
            if (feature != null) {
                wsdlModel = feature.getWsdlModel();
                policyMap = feature.getPolicyMap();
                portInfo = feature.getPortInfo();
            }
            if (wsdlPort == null && portInfo != null && wsdlModel != null) {
                QName serviceName = portInfo.getServiceName();
                QName portName = portInfo.getPortName();
                WSDLService service = wsdlModel.getService(serviceName);
                if (service != null) {
                    wsdlPort = service.get(portName);
                }
            }
            if (isSecurityEnabled = this.isSecurityEnabled(policyMap, wsdlPort)) {
                this.setSecurityCodec(context);
            }
            Pipe p = this.isOptimizedTransportEnabled(policyMap, wsdlPort, (WSPortInfo)portInfo) ? TCPTransportPipeFactory.doCreate(context, false) : context.createTransportPipe();
            MessageDumpingFeature msgDumper = context.getBinding().getFeature(MessageDumpingFeature.class);
            if (msgDumper != null) {
                p = PipeAdapter.adapt(msgDumper.createMessageDumpingTube(PipeAdapter.adapt(p)));
            }
            p = this.dump(context, PipelineAssemblerFactoryImpl.CLIENT_PREFIX, p);
            p = this.dumpAction("com.sun.xml.ws.assembler.client.action", context.getBinding(), p);
            p = this.dump(context, "com.sun.xml.ws.assembler.client.transport", p);
            p = this.dump(context, "com.sun.xml.ws.assembler.client.wss.after", p);
            SecureConversationInitiator scInit = null;
            ClientPipelineHook hook = context.getContainer().getSPI(ClientPipelineHook.class);
            if (hook == null && (hooks = WsitPipelineAssembler.loadSPs(ClientPipelineHook.class)) != null && hooks.length > 0) {
                hook = hooks[0];
            }
            if (hook != null) {
                p = hook.createSecurityPipe(policyMap, context, p);
                if (isSecurityEnabled) {
                    scInit = (SecureConversationInitiator)((Object)p);
                }
            } else if (isSecurityEnabled) {
                ClientPipeConfiguration config = new ClientPipeConfiguration(policyMap, wsdlPort, context.getService(), context.getBinding());
                p = new SecurityClientPipe(config, p);
                scInit = (SecureConversationInitiator)((Object)p);
            } else if ((policyMap == null || policyMap.isEmpty()) && PipelineAssemblerFactoryImpl.isSecurityConfigPresent(context)) {
                p = PipelineAssemblerFactoryImpl.initializeXWSSClientPipe(wsdlPort, context.getService(), context.getBinding(), p);
            }
            p = this.dump(context, "com.sun.xml.ws.assembler.client.wss.before", p);
            p = this.dump(context, "com.sun.xml.ws.assembler.client.wsrm.after", p);
            if (this.isReliableMessagingEnabled(policyMap, wsdlPort)) {
                Tube nextTube = PipeAdapter.adapt(p);
                RMClientTube rmClientTube = new RMClientTube(wsdlPort, context.getBinding(), scInit, nextTube);
                p = PipeAdapter.adapt(rmClientTube);
            }
            p = this.dump(context, "com.sun.xml.ws.assembler.client.wsrm.before", p);
            p = this.dump(context, "com.sun.xml.ws.assembler.client.wstx.after", p);
            if (this.isTransactionsEnabled(policyMap, wsdlPort, false)) {
                p = new TxClientPipe(new ClientPipeConfiguration(policyMap, wsdlPort, context.getService(), context.getBinding()), p);
            }
            p = this.dump(context, "com.sun.xml.ws.assembler.client.wstx.before", p);
            p = this.dump(context, "com.sun.xml.ws.assembler.client.wsa.after", p);
            if (this.isAddressingEnabled(policyMap, wsdlPort, context.getBinding())) {
                p = context.createWsaPipe(p);
            }
            p = this.dump(context, "com.sun.xml.ws.assembler.client.wsa.before", p);
            p = context.createClientMUPipe(p);
            p = context.createValidationPipe(p);
            p = context.createHandlerPipe(p);
            return p;
        }

        @Override
        @NotNull
        public Pipe createServer(ServerPipeAssemblerContext context) {
            ServiceDefinition sd = context.getEndpoint().getServiceDefinition();
            if (sd != null) {
                sd.addFilter(new WsdlDocumentFilter());
            }
            PolicyMap policyMap = this.initPolicyMap(context);
            Pipe p = context.getTerminalPipe();
            p = context.createValidationPipe(p);
            p = context.createHandlerPipe(p);
            p = context.createServerMUPipe(p);
            p = context.createMonitoringPipe(p);
            p = this.dump(context, "com.sun.xml.ws.assembler.server.wstx.after", p);
            if (this.isTransactionsEnabled(policyMap, context.getWsdlModel(), true)) {
                p = new TxServerPipe(context.getWsdlModel(), context.getEndpoint().getBinding(), policyMap, p);
            }
            p = this.dump(context, "com.sun.xml.ws.assembler.server.wstx.before", p);
            p = this.dump(context, "com.sun.xml.ws.assembler.server.wsrm.after", p);
            if (this.isReliableMessagingEnabled(policyMap, context.getWsdlModel())) {
                Tube nextTube = PipeAdapter.adapt(p);
                RMServerTube tube = new RMServerTube(context.getWsdlModel(), context.getEndpoint().getBinding(), nextTube);
                p = PipeAdapter.adapt(tube);
            }
            p = this.dump(context, "com.sun.xml.ws.assembler.server.wsrm.before", p);
            p = this.dump(context, "com.sun.xml.ws.assembler.server.wsa.after", p);
            if (this.isAddressingEnabled(policyMap, context.getWsdlModel(), context.getEndpoint().getBinding())) {
                p = context.createWsaPipe(p);
            }
            p = this.dump(context, "com.sun.xml.ws.assembler.server.wsa.before", p);
            p = this.dump(context, "com.sun.xml.ws.assembler.server.wss.after", p);
            boolean securityIsEnabled = this.isSecurityEnabled(policyMap, context.getWsdlModel());
            ServerPipelineHook hook = context.getEndpoint().getContainer().getSPI(ServerPipelineHook.class);
            if (hook != null) {
                if (securityIsEnabled) {
                    this.setSecurityCodec(context);
                }
                p = hook.createSecurityPipe(policyMap, context.getSEIModel(), context.getWsdlModel(), context.getEndpoint(), p);
            } else if (securityIsEnabled) {
                this.setSecurityCodec(context);
                ServerPipeConfiguration config = new ServerPipeConfiguration(policyMap, context.getWsdlModel(), context.getEndpoint());
                p = new SecurityServerPipe(config, p);
            } else {
                try {
                    if ((null == policyMap || policyMap.isEmpty()) && PipelineAssemblerFactoryImpl.isSecurityConfigPresent(context)) {
                        p = PipelineAssemblerFactoryImpl.initializeXWSSServerPipe(context.getEndpoint(), context.getWsdlModel(), p);
                    }
                }
                catch (NoClassDefFoundError err) {
                    // empty catch block
                }
            }
            p = this.dump(context, "com.sun.xml.ws.assembler.server.wss.before", p);
            p = this.dump(context, "com.sun.xml.ws.assembler.server.transport", p);
            p = this.dumpAction("com.sun.xml.ws.assembler.server.action", context.getEndpoint().getBinding(), p);
            p = this.dump(context, PipelineAssemblerFactoryImpl.SERVER_PREFIX, p);
            return p;
        }

        private Pipe dump(ClientPipeAssemblerContext context, String name, Pipe p) {
            if (Boolean.getBoolean(name)) {
                p = context.createDumpPipe(name, System.out, p);
            }
            return p;
        }

        private Pipe dump(ServerPipeAssemblerContext context, String name, Pipe p) {
            if (Boolean.getBoolean(name)) {
                p = context.createDumpPipe(name, System.out, p);
            }
            return p;
        }

        private boolean isOptimizedTransportEnabled(PolicyMap policyMap, WSDLPort port, WSPortInfo portInfo) {
            if (policyMap == null || port == null) {
                return false;
            }
            String schema = null;
            if (port != null) {
                schema = port.getAddress().getURI().getScheme();
            } else if (portInfo != null) {
                schema = portInfo.getEndpointAddress().getURI().getScheme();
            }
            if (schema == null) {
                return false;
            }
            if ("vnd.sun.ws.tcp".equals(schema)) {
                return true;
            }
            if (policyMap == null) {
                return false;
            }
            try {
                PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(port.getOwner().getName(), port.getName());
                Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
                if (policy != null && policy.contains(TCPConstants.TCPTRANSPORT_POLICY_ASSERTION) && policy.contains(AUTO_OPTIMIZED_TRANSPORT_POLICY_ASSERTION)) {
                    for (AssertionSet assertionSet : policy) {
                        for (PolicyAssertion assertion : assertionSet) {
                            if (!assertion.getName().equals(TCPConstants.TCPTRANSPORT_POLICY_ASSERTION)) continue;
                            String value = assertion.getAttributeValue(new QName("enabled"));
                            if (value == null) {
                                return false;
                            }
                            return Boolean.valueOf(value = value.trim()) != false || value.equalsIgnoreCase("yes");
                        }
                    }
                }
                return false;
            }
            catch (PolicyException e) {
                throw new WebServiceException(e);
            }
        }

        private boolean isTransactionsEnabled(PolicyMap policyMap, WSDLPort wsdlPort, boolean isServerSide) {
            if (policyMap == null || wsdlPort == null || !Util.isJTAAvailable()) {
                return false;
            }
            try {
                PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName());
                Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
                for (WSDLBoundOperation wSDLBoundOperation : wsdlPort.getBinding().getBindingOperations()) {
                    PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName(), wSDLBoundOperation.getName());
                    policy = policyMap.getOperationEffectivePolicy(operationKey);
                    if (policy == null) continue;
                    if (isServerSide && policy.contains(AT_ALWAYS_CAPABILITY)) {
                        return true;
                    }
                    if (!policy.contains(AT_ASSERTION)) continue;
                    return true;
                }
            }
            catch (PolicyException e) {
                throw new WebServiceException(e);
            }
            return false;
        }

        private boolean isReliableMessagingEnabled(PolicyMap policyMap, WSDLPort port) {
            if (policyMap == null || port == null) {
                return false;
            }
            try {
                PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(port.getOwner().getName(), port.getName());
                Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
                if (policy == null) {
                    return false;
                }
                return policy.contains(RMVersion.WSRM10.policyNamespaceUri) || policy.contains(RMVersion.WSRM11.policyNamespaceUri);
            }
            catch (PolicyException e) {
                throw new WebServiceException(e);
            }
        }

        private boolean isAddressingEnabled(PolicyMap policyMap, WSDLPort port, WSBinding binding) {
            if (AddressingVersion.isEnabled(binding)) {
                return true;
            }
            if (policyMap == null || port == null) {
                return false;
            }
            try {
                PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(port.getOwner().getName(), port.getName());
                Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
                return policy != null && (policy.contains(AddressingVersion.W3C.policyNsUri) || policy.contains(AddressingVersion.MEMBER.policyNsUri));
            }
            catch (PolicyException e) {
                throw new WebServiceException(e);
            }
        }

        private boolean isSecurityEnabled(PolicyMap policyMap, WSDLPort wsdlPort) {
            if (policyMap == null || wsdlPort == null) {
                return false;
            }
            try {
                PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName());
                Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
                if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY200512.namespaceUri))) {
                    return true;
                }
                for (WSDLBoundOperation wSDLBoundOperation : wsdlPort.getBinding().getBindingOperations()) {
                    PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName(), wSDLBoundOperation.getName());
                    policy = policyMap.getOperationEffectivePolicy(operationKey);
                    if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                        return true;
                    }
                    policy = policyMap.getInputMessageEffectivePolicy(operationKey);
                    if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                        return true;
                    }
                    policy = policyMap.getOutputMessageEffectivePolicy(operationKey);
                    if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                        return true;
                    }
                    policy = policyMap.getFaultMessageEffectivePolicy(operationKey);
                    if (policy == null || !policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) && !policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri)) continue;
                    return true;
                }
            }
            catch (PolicyException e) {
                throw new WebServiceException(e);
            }
            return false;
        }

        private static <P> P[] loadSPs(Class<P> svcClass) {
            return ServiceFinder.find(svcClass).toArray();
        }

        private Pipe dumpAction(String name, WSBinding binding, Pipe p) {
            if (Boolean.getBoolean(name)) {
                ActionDumpPipe[] pipes = WsitPipelineAssembler.loadSPs(ActionDumpPipe.class);
                if (pipes.length > 0) {
                    return pipes[0];
                }
                return new ActionDumpPipe(name, binding, p);
            }
            return p;
        }

        private PolicyFeature initPolicyMap(ClientPipeAssemblerContext context) {
            logger.entering(this.getClass().getName(), "initPolicyMap", new Object[]{context});
            PolicyFeature feature = null;
            PolicyMap map = null;
            WSDLModel model = null;
            WSDLPort wsdlPort = context.getWsdlModel();
            if (wsdlPort != null) {
                model = wsdlPort.getBinding().getOwner();
                WSDLPolicyMapWrapper mapWrapper = model.getExtension(WSDLPolicyMapWrapper.class);
                if (mapWrapper != null) {
                    map = mapWrapper.getPolicyMap();
                }
                feature = new PolicyFeature(map, model, null);
            } else {
                WSBinding binding = context.getBinding();
                feature = binding.getFeature(PolicyFeature.class);
            }
            logger.exiting(this.getClass().getName(), "initPolicyMap", feature);
            return feature;
        }

        private PolicyMap initPolicyMap(ServerPipeAssemblerContext context) throws WebServiceException {
            PolicyMap map = null;
            WSDLPort wsdlPort = context.getWsdlModel();
            if (wsdlPort != null) {
                WSDLModel model = wsdlPort.getBinding().getOwner();
                WSDLPolicyMapWrapper mapWrapper = model.getExtension(WSDLPolicyMapWrapper.class);
                if (mapWrapper != null) {
                    map = mapWrapper.getPolicyMap();
                }
                if (map != null) {
                    try {
                        PolicyMapUtil.rejectAlternatives(map);
                    }
                    catch (PolicyException e) {
                        throw new WebServiceException(e);
                    }
                }
            }
            return map;
        }

        private void setSecurityCodec(ServerPipeAssemblerContext context) {
            StreamSOAPCodec primaryCodec = Codecs.createSOAPEnvelopeXmlCodec(context.getEndpoint().getBinding().getSOAPVersion());
            LazyStreamCodec lsc = new LazyStreamCodec(primaryCodec);
            SOAPBindingCodec fullCodec = Codecs.createSOAPBindingCodec(context.getEndpoint().getBinding(), lsc);
            context.setCodec(fullCodec);
        }

        private void setSecurityCodec(ClientPipeAssemblerContext context) {
            StreamSOAPCodec primaryCodec = Codecs.createSOAPEnvelopeXmlCodec(context.getBinding().getSOAPVersion());
            LazyStreamCodec lsc = new LazyStreamCodec(primaryCodec);
            SOAPBindingCodec fullCodec = Codecs.createSOAPBindingCodec(context.getBinding(), lsc);
            context.setCodec(fullCodec);
        }

        private static class MapModelRecord {
            private final PolicyMap policyMap;
            private final WSDLModel wsdlModel;

            MapModelRecord(PolicyMap map, WSDLModel model) {
                this.policyMap = map;
                this.wsdlModel = model;
            }

            public PolicyMap getPolicyMap() {
                return this.policyMap;
            }

            public WSDLModel getWsdlModel() {
                return this.wsdlModel;
            }
        }
    }
}

