/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.unzip;

import com.fr.zip4j.core.HeaderReader;
import com.fr.zip4j.crypto.AESDecrypter;
import com.fr.zip4j.crypto.IDecrypter;
import com.fr.zip4j.crypto.StandardDecrypter;
import com.fr.zip4j.exception.ZipException;
import com.fr.zip4j.io.InflaterInputStream;
import com.fr.zip4j.io.PartInputStream;
import com.fr.zip4j.io.ZipInputStream;
import com.fr.zip4j.model.AESExtraDataRecord;
import com.fr.zip4j.model.FileHeader;
import com.fr.zip4j.model.LocalFileHeader;
import com.fr.zip4j.model.UnzipParameters;
import com.fr.zip4j.model.ZipModel;
import com.fr.zip4j.progress.ProgressMonitor;
import com.fr.zip4j.unzip.UnzipUtil;
import com.fr.zip4j.util.Raw;
import com.fr.zip4j.util.Zip4jUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.zip.CRC32;

public class UnzipEngine {
    private ZipModel zipModel;
    private FileHeader fileHeader;
    private int currSplitFileCounter = 0;
    private LocalFileHeader localFileHeader;
    private IDecrypter decrypter;
    private CRC32 crc;

    public UnzipEngine(ZipModel zipModel, FileHeader fileHeader) throws ZipException {
        if (zipModel == null || fileHeader == null) {
            throw new ZipException("Invalid parameters passed to StoreUnzip. One or more of the parameters were null");
        }
        this.zipModel = zipModel;
        this.fileHeader = fileHeader;
        this.crc = new CRC32();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unzipFile(ProgressMonitor progressMonitor, String string, String string2, UnzipParameters unzipParameters) throws ZipException {
        FileOutputStream fileOutputStream;
        ZipInputStream zipInputStream;
        block9: {
            block8: {
                if (this.zipModel == null) throw new ZipException("Invalid parameters passed during unzipping file. One or more of the parameters were null");
                if (this.fileHeader == null) throw new ZipException("Invalid parameters passed during unzipping file. One or more of the parameters were null");
                if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
                    throw new ZipException("Invalid parameters passed during unzipping file. One or more of the parameters were null");
                }
                zipInputStream = null;
                fileOutputStream = null;
                try {
                    try {
                        byte[] byArray = new byte[4096];
                        int n = -1;
                        zipInputStream = this.getInputStream();
                        fileOutputStream = this.getOutputStream(string, string2);
                        while ((n = ((InputStream)zipInputStream).read(byArray)) != -1) {
                            ((OutputStream)fileOutputStream).write(byArray, 0, n);
                            progressMonitor.updateWorkCompleted(n);
                            if (!progressMonitor.isCancelAllTasks()) continue;
                            progressMonitor.setResult(3);
                            progressMonitor.setState(0);
                            Object var10_11 = null;
                            break block8;
                        }
                        this.closeStreams(zipInputStream, fileOutputStream);
                        UnzipUtil.applyFileAttributes(this.fileHeader, new File(this.getOutputFileNameWithPath(string, string2)), unzipParameters);
                        break block9;
                    }
                    catch (IOException iOException) {
                        throw new ZipException(iOException);
                    }
                    catch (Exception exception) {
                        throw new ZipException(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    this.closeStreams(zipInputStream, fileOutputStream);
                    throw throwable;
                }
            }
            this.closeStreams(zipInputStream, fileOutputStream);
            return;
        }
        Object var10_12 = null;
        this.closeStreams(zipInputStream, fileOutputStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ZipInputStream getInputStream() throws ZipException {
        if (this.fileHeader == null) {
            throw new ZipException("file header is null, cannot get inputstream");
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = this.createFileHandler("r");
            String string = "local header and file header do not match";
            if (!this.checkLocalHeader()) {
                throw new ZipException(string);
            }
            this.init(randomAccessFile);
            long l = this.localFileHeader.getCompressedSize();
            long l2 = this.localFileHeader.getOffsetStartOfData();
            if (this.localFileHeader.isEncrypted()) {
                if (this.localFileHeader.getEncryptionMethod() == 99) {
                    if (!(this.decrypter instanceof AESDecrypter)) throw new ZipException("invalid decryptor when trying to calculate compressed size for AES encrypted file: " + this.fileHeader.getFileName());
                    l -= (long)(((AESDecrypter)this.decrypter).getSaltLength() + ((AESDecrypter)this.decrypter).getPasswordVerifierLength() + 10);
                    l2 += (long)(((AESDecrypter)this.decrypter).getSaltLength() + ((AESDecrypter)this.decrypter).getPasswordVerifierLength());
                } else if (this.localFileHeader.getEncryptionMethod() == 0) {
                    l -= 12L;
                    l2 += 12L;
                }
            }
            int n = this.fileHeader.getCompressionMethod();
            if (this.fileHeader.getEncryptionMethod() == 99) {
                if (this.fileHeader.getAesExtraDataRecord() == null) throw new ZipException("AESExtraDataRecord does not exist for AES encrypted file: " + this.fileHeader.getFileName());
                n = this.fileHeader.getAesExtraDataRecord().getCompressionMethod();
            }
            randomAccessFile.seek(l2);
            switch (n) {
                case 0: {
                    return new ZipInputStream(new PartInputStream(randomAccessFile, l2, l, this));
                }
                case 8: {
                    return new ZipInputStream(new InflaterInputStream(randomAccessFile, l2, l, this));
                }
            }
            throw new ZipException("compression type not supported");
        }
        catch (ZipException zipException) {
            if (randomAccessFile == null) throw zipException;
            try {
                randomAccessFile.close();
                throw zipException;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw zipException;
        }
        catch (Exception exception) {
            if (randomAccessFile == null) throw new ZipException(exception);
            try {
                randomAccessFile.close();
                throw new ZipException(exception);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ZipException(exception);
        }
    }

    private void init(RandomAccessFile randomAccessFile) throws ZipException {
        if (this.localFileHeader == null) {
            throw new ZipException("local file header is null, cannot initialize input stream");
        }
        try {
            this.initDecrypter(randomAccessFile);
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private void initDecrypter(RandomAccessFile randomAccessFile) throws ZipException {
        if (this.localFileHeader == null) {
            throw new ZipException("local file header is null, cannot init decrypter");
        }
        if (this.localFileHeader.isEncrypted()) {
            if (this.localFileHeader.getEncryptionMethod() == 0) {
                this.decrypter = new StandardDecrypter(this.fileHeader, this.getStandardDecrypterHeaderBytes(randomAccessFile));
            } else if (this.localFileHeader.getEncryptionMethod() == 99) {
                this.decrypter = new AESDecrypter(this.localFileHeader, this.getAESSalt(randomAccessFile), this.getAESPasswordVerifier(randomAccessFile));
            } else {
                throw new ZipException("unsupported encryption method");
            }
        }
    }

    private byte[] getStandardDecrypterHeaderBytes(RandomAccessFile randomAccessFile) throws ZipException {
        try {
            byte[] byArray = new byte[12];
            randomAccessFile.seek(this.localFileHeader.getOffsetStartOfData());
            randomAccessFile.read(byArray, 0, 12);
            return byArray;
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private byte[] getAESSalt(RandomAccessFile randomAccessFile) throws ZipException {
        if (this.localFileHeader.getAesExtraDataRecord() == null) {
            return null;
        }
        try {
            AESExtraDataRecord aESExtraDataRecord = this.localFileHeader.getAesExtraDataRecord();
            byte[] byArray = new byte[this.calculateAESSaltLength(aESExtraDataRecord)];
            randomAccessFile.seek(this.localFileHeader.getOffsetStartOfData());
            randomAccessFile.read(byArray);
            return byArray;
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
    }

    private byte[] getAESPasswordVerifier(RandomAccessFile randomAccessFile) throws ZipException {
        try {
            byte[] byArray = new byte[2];
            randomAccessFile.read(byArray);
            return byArray;
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
    }

    private int calculateAESSaltLength(AESExtraDataRecord aESExtraDataRecord) throws ZipException {
        if (aESExtraDataRecord == null) {
            throw new ZipException("unable to determine salt length: AESExtraDataRecord is null");
        }
        switch (aESExtraDataRecord.getAesStrength()) {
            case 1: {
                return 8;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 16;
            }
        }
        throw new ZipException("unable to determine salt length: invalid aes key strength");
    }

    public void checkCRC() throws ZipException {
        if (this.fileHeader != null) {
            if (this.fileHeader.getEncryptionMethod() == 99) {
                if (this.decrypter != null && this.decrypter instanceof AESDecrypter) {
                    byte[] byArray = ((AESDecrypter)this.decrypter).getCalculatedAuthenticationBytes();
                    byte[] byArray2 = ((AESDecrypter)this.decrypter).getStoredMac();
                    byte[] byArray3 = new byte[10];
                    if (byArray3 == null || byArray2 == null) {
                        throw new ZipException("CRC (MAC) check failed for " + this.fileHeader.getFileName());
                    }
                    System.arraycopy(byArray, 0, byArray3, 0, 10);
                    if (!Arrays.equals(byArray3, byArray2)) {
                        throw new ZipException("invalid CRC (MAC) for file: " + this.fileHeader.getFileName());
                    }
                }
            } else {
                long l = this.crc.getValue() & 0xFFFFFFFFL;
                if (l != this.fileHeader.getCrc32()) {
                    String string = "invalid CRC for file: " + this.fileHeader.getFileName();
                    if (this.localFileHeader.isEncrypted() && this.localFileHeader.getEncryptionMethod() == 0) {
                        string = string + " - Wrong Password?";
                    }
                    throw new ZipException(string);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private boolean checkLocalHeader() throws ZipException {
        boolean bl;
        RandomAccessFile randomAccessFile;
        block16: {
            block14: {
                boolean bl2;
                block15: {
                    randomAccessFile = null;
                    randomAccessFile = this.checkSplitFile();
                    if (randomAccessFile == null) {
                        randomAccessFile = new RandomAccessFile(new File(this.zipModel.getZipFile()), "r");
                    }
                    HeaderReader headerReader = new HeaderReader(randomAccessFile);
                    this.localFileHeader = headerReader.readLocalFileHeader(this.fileHeader);
                    if (this.localFileHeader == null) {
                        throw new ZipException("error reading local file header. Is this a valid zip file?");
                    }
                    if (this.localFileHeader.getCompressionMethod() == this.fileHeader.getCompressionMethod()) break block14;
                    bl2 = false;
                    Object var5_6 = null;
                    if (randomAccessFile == null) break block15;
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            bl = true;
            Object var5_7 = null;
            if (randomAccessFile == null) break block16;
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new ZipException(fileNotFoundException);
            }
            catch (Throwable throwable) {
                block17: {
                    Object var5_8 = null;
                    if (randomAccessFile == null) break block17;
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
        }
    }

    private RandomAccessFile checkSplitFile() throws ZipException {
        if (this.zipModel.isSplitArchive()) {
            int n = this.fileHeader.getDiskNumberStart();
            this.currSplitFileCounter = n + 1;
            String string = this.zipModel.getZipFile();
            String string2 = null;
            string2 = n == this.zipModel.getEndCentralDirRecord().getNoOfThisDisk() ? this.zipModel.getZipFile() : (n >= 9 ? string.substring(0, string.lastIndexOf(".")) + ".z" + (n + 1) : string.substring(0, string.lastIndexOf(".")) + ".z0" + (n + 1));
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "r");
                if (this.currSplitFileCounter == 1) {
                    byte[] byArray = new byte[4];
                    randomAccessFile.read(byArray);
                    if ((long)Raw.readIntLittleEndian(byArray, 0) != 134695760L) {
                        throw new ZipException("invalid first part split file signature");
                    }
                }
                return randomAccessFile;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ZipException(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new ZipException(iOException);
            }
        }
        return null;
    }

    private RandomAccessFile createFileHandler(String string) throws ZipException {
        if (this.zipModel == null || !Zip4jUtil.isStringNotNullAndNotEmpty(this.zipModel.getZipFile())) {
            throw new ZipException("input parameter is null in getFilePointer");
        }
        try {
            RandomAccessFile randomAccessFile = null;
            randomAccessFile = this.zipModel.isSplitArchive() ? this.checkSplitFile() : new RandomAccessFile(new File(this.zipModel.getZipFile()), string);
            return randomAccessFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZipException(fileNotFoundException);
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private FileOutputStream getOutputStream(String string, String string2) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("invalid output path");
        }
        try {
            File file = new File(this.getOutputFileNameWithPath(string, string2));
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            return fileOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZipException(fileNotFoundException);
        }
    }

    private String getOutputFileNameWithPath(String string, String string2) throws ZipException {
        String string3 = null;
        string3 = Zip4jUtil.isStringNotNullAndNotEmpty(string2) ? string2 : this.fileHeader.getFileName();
        return string + System.getProperty("file.separator") + string3;
    }

    public RandomAccessFile startNextSplitFile() throws IOException, FileNotFoundException {
        String string = this.zipModel.getZipFile();
        String string2 = null;
        string2 = this.currSplitFileCounter == this.zipModel.getEndCentralDirRecord().getNoOfThisDisk() ? this.zipModel.getZipFile() : (this.currSplitFileCounter >= 9 ? string.substring(0, string.lastIndexOf(".")) + ".z" + (this.currSplitFileCounter + 1) : string.substring(0, string.lastIndexOf(".")) + ".z0" + (this.currSplitFileCounter + 1));
        ++this.currSplitFileCounter;
        try {
            if (!Zip4jUtil.checkFileExists(string2)) {
                throw new IOException("zip split file does not exist: " + string2);
            }
        }
        catch (ZipException zipException) {
            throw new IOException(zipException.getMessage());
        }
        return new RandomAccessFile(string2, "r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void closeStreams(InputStream inputStream, OutputStream outputStream) throws ZipException {
        block13: {
            block12: {
                if (inputStream == null) break block12;
                inputStream.close();
                inputStream = null;
            }
            Object var5_3 = null;
            try {
                if (outputStream != null) {
                    outputStream.close();
                    outputStream = null;
                }
                break block13;
            }
            catch (IOException iOException) {}
            break block13;
            {
                catch (IOException iOException) {
                    if (iOException != null && Zip4jUtil.isStringNotNullAndNotEmpty(iOException.getMessage()) && iOException.getMessage().indexOf(" - Wrong Password?") >= 0) {
                        throw new ZipException(iOException.getMessage());
                    }
                    Object var5_4 = null;
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                            outputStream = null;
                        }
                        break block13;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (outputStream != null) {
                        outputStream.close();
                        outputStream = null;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void updateCRC(int n) {
        this.crc.update(n);
    }

    public void updateCRC(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            this.crc.update(byArray, n, n2);
        }
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public IDecrypter getDecrypter() {
        return this.decrypter;
    }

    public ZipModel getZipModel() {
        return this.zipModel;
    }

    public LocalFileHeader getLocalFileHeader() {
        return this.localFileHeader;
    }
}

