/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.crypto;

import com.fr.zip4j.crypto.IEncrypter;
import com.fr.zip4j.crypto.engine.ZipCryptoEngine;
import com.fr.zip4j.exception.ZipException;
import java.util.Random;

public class StandardEncrypter
implements IEncrypter {
    private ZipCryptoEngine zipCryptoEngine;
    private byte[] headerBytes;

    public StandardEncrypter(char[] cArray, int n) throws ZipException {
        if (cArray == null || cArray.length <= 0) {
            throw new ZipException("input password is null or empty in standard encrpyter constructor");
        }
        this.zipCryptoEngine = new ZipCryptoEngine();
        this.headerBytes = new byte[12];
        this.init(cArray, n);
    }

    private void init(char[] cArray, int n) throws ZipException {
        if (cArray == null || cArray.length <= 0) {
            throw new ZipException("input password is null or empty, cannot initialize standard encrypter");
        }
        this.zipCryptoEngine.initKeys(cArray);
        this.headerBytes = this.generateRandomBytes(12);
        this.zipCryptoEngine.initKeys(cArray);
        this.headerBytes[11] = (byte)(n >>> 24);
        this.headerBytes[10] = (byte)(n >>> 16);
        if (this.headerBytes.length < 12) {
            throw new ZipException("invalid header bytes generated, cannot perform standard encryption");
        }
        this.encryptData(this.headerBytes);
    }

    public int encryptData(byte[] byArray) throws ZipException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        return this.encryptData(byArray, 0, byArray.length);
    }

    public int encryptData(byte[] byArray, int n, int n2) throws ZipException {
        if (n2 < 0) {
            throw new ZipException("invalid length specified to decrpyt data");
        }
        try {
            for (int i = n; i < n + n2; ++i) {
                byArray[i] = this.encryptByte(byArray[i]);
            }
            return n2;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    protected byte encryptByte(byte by) {
        byte by2 = (byte)(by ^ this.zipCryptoEngine.decryptByte() & 0xFF);
        this.zipCryptoEngine.updateKeys(by);
        return by2;
    }

    protected byte[] generateRandomBytes(int n) throws ZipException {
        if (n <= 0) {
            throw new ZipException("size is either 0 or less than 0, cannot generate header for standard encryptor");
        }
        byte[] byArray = new byte[n];
        Random random = new Random();
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.encryptByte((byte)random.nextInt(256));
        }
        return byArray;
    }

    public byte[] getHeaderBytes() {
        return this.headerBytes;
    }
}

