/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write.config;

import com.fr.cache.list.IntList;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Where;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogLevel;
import com.fr.general.FRLogger;
import com.fr.general.PropertiesUtils;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.FormulaProvider;
import com.fr.stable.StableUtils;
import com.fr.write.config.ColumnConfig;
import com.fr.write.config.DMLConfig;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class InsertConfig
extends DMLConfig {
    protected Map pstmtMap = new HashMap();
    protected static final int BATCH_SIZE = 500;
    private int totalTimes = 0;

    public int getTotalTimes() {
        return this.totalTimes;
    }

    public void setTotalTimes(int n) {
        this.totalTimes = n;
    }

    public int dmlSubmit(Connection connection, Calculator calculator, Object[] objectArray, Map map) throws SQLException {
        int n = this.insert(connection, calculator, objectArray);
        if (this.getDialect(connection).isSupportQueryWhileInsert(n)) {
            this.putSelfInCreaseColumn2Map(this, map, connection);
        }
        return n;
    }

    protected int dmlSubmitBatch(int n, Connection connection, Calculator calculator, Object[] objectArray, Map map) throws SQLException {
        int n2 = this.insertBatch(n, connection, calculator, objectArray);
        if (this.getDialect(connection).isSupportQueryWhileInsert(n2)) {
            this.putSelfInCreaseColumn2Map(this, map, connection);
        }
        return n2;
    }

    public void simpleSubmit(Connection connection, Object[] objectArray) throws SQLException {
        this.insert(connection, null, objectArray);
    }

    private void putSelfInCreaseColumn2Map(DMLConfig dMLConfig, Map map, Connection connection) {
        if (map != null) {
            String string = null;
            string = this.findSelfIncreaseKey(dMLConfig);
            if (string != null) {
                Object object;
                int n = 0;
                int n2 = this.getColumnConfigCount();
                for (int i = 0; i < n2; ++i) {
                    if (!ComparatorUtils.equals(this.getColumnName(i), string)) continue;
                    n = this.getColumnType(this.getColumnName(i), connection);
                    break;
                }
                if ((object = this.findRecordInsertedBySelfIncreaseKey(string, n, this.getDialect(connection), connection)) != null) {
                    map.putAll(this.findRecordByKeyAndValue(string, object, connection, this.getDialect(connection)));
                }
            }
        }
    }

    private String findSelfIncreaseKey(DMLConfig dMLConfig) {
        String string = null;
        string = this.findSelfIncreaseKeyByConfig();
        if (string == null) {
            string = this.findSelfIncreaseKeyByDefault(dMLConfig);
        }
        return string;
    }

    private String findSelfIncreaseKeyByConfig() {
        PropertiesUtils.initSequenceProperties();
        return PropertiesUtils.getSequenceProperties().getProperty(this.table.getName() + ".increaseKey");
    }

    private String findSelfIncreaseKeyByDefault(DMLConfig dMLConfig) {
        int n = dMLConfig.getColumnConfigCount();
        for (int i = 0; i < n; ++i) {
            ColumnConfig columnConfig = dMLConfig.getColumnConfig(i);
            if (!columnConfig.isKey()) continue;
            return columnConfig.getColumnName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map findRecordByKeyAndValue(String string, Object object, Connection connection, Dialect dialect) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String[] stringArray = DBUtils.checkInColumnNames(connection, dialect, DataCoreUtils.createSelectSQL(this.getTable(), null, dialect));
        if (stringArray.length == 0) {
            return hashMap;
        }
        Where where = new Where();
        where.addColumn(string, object);
        Select select = new Select(this.getTable(), where, dialect);
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = select.createPreparedStatement(connection);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        hashMap.put(stringArray[i], resultSet.getObject(stringArray[i]));
                    }
                }
                Object var13_13 = null;
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                Object var13_14 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(preparedStatement);
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(preparedStatement);
            throw throwable;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(preparedStatement);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object findRecordInsertedBySelfIncreaseKey(String string, int n, Dialect dialect, Connection connection) {
        Object object = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                String string2 = dialect.getIdentitySelectString(dialect.table2SQL(this.getTable()), string, n);
                preparedStatement = connection.prepareStatement(string2);
                ResultSet resultSet = preparedStatement.executeQuery();
                resultSet.next();
                object = resultSet.getObject(1);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
                Object var10_11 = null;
                DBUtils.closeStatement(preparedStatement);
                return object;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            DBUtils.closeStatement(preparedStatement);
            throw throwable;
        }
        DBUtils.closeStatement(preparedStatement);
        return object;
    }

    protected void closeStatement(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.pstmtMap.get(connection);
        if (preparedStatement != null) {
            preparedStatement.close();
            this.pstmtMap.remove(connection);
        }
    }

    private PreparedStatement getInsertedPreparedStatement(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.pstmtMap.get(connection);
        if (preparedStatement == null) {
            preparedStatement = this.createInsertedPreparedStatement(connection);
            this.pstmtMap.put(connection, preparedStatement);
        }
        return preparedStatement;
    }

    public PreparedStatement createInsertedPreparedStatement(Connection connection) throws SQLException {
        IntList intList = new IntList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Dialect dialect = this.getDialect(connection);
        int n = this.getColumnConfigCount();
        for (int i = 0; i < n; ++i) {
            if (this.isIgnoreColumn(i)) continue;
            arrayList.add(dialect.column2SQL(this.getColumnConfig(i).getColumnName()));
            arrayList2.add("?");
            intList.add(i);
        }
        if (arrayList2.isEmpty()) {
            return null;
        }
        String string = "INSERT INTO " + this.getTable().toStatementSQLString(dialect) + " (" + StableUtils.join(arrayList, ",") + ") VALUES (" + StableUtils.join(arrayList2, ",") + ")";
        if (FRLogger.getLogger().isLoggable(FRLogLevel.DEBUG)) {
            FRLogger.getLogger().info(string);
        }
        return connection.prepareStatement(string.toString());
    }

    private boolean isIgnoreByEmptyFormula(int n) {
        return this.isEmptyFormula(this.getColumnConfig(n).getColumnValue());
    }

    private boolean isIgnoreColumn(int n) {
        if (this.isIgnoreByEmptyFormula(n)) {
            return true;
        }
        return this.isIgnoreInConfig(this.getColumnName(n));
    }

    private boolean isIgnoreInConfig(String string) {
        if (string == null) {
            return false;
        }
        Properties properties = PropertiesUtils.getProperties("insertIgnoreColumn");
        String string2 = null;
        try {
            string2 = properties.getProperty(new String(this.table.getName().getBytes(), "ISO8859-1") + ".ignoreColumns");
            if (string2 != null) {
                string2 = new String(string2.getBytes("ISO8859-1"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        String[] stringArray = string2.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!ComparatorUtils.equals(string.compareToIgnoreCase(stringArray[i].trim()), 0)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmptyFormula(Object object) {
        if (!(object instanceof FormulaProvider)) {
            return false;
        }
        FormulaProvider formulaProvider = (FormulaProvider)object;
        return ComparatorUtils.equals("", formulaProvider.getPureContent());
    }

    private void fillInsertedPreparedStatement(PreparedStatement preparedStatement, Connection connection, Calculator calculator, Object[] objectArray) throws SQLException {
        int n = 0;
        for (int i = 0; i < this.getColumnConfigCount(); ++i) {
            if (this.isIgnoreColumn(i)) continue;
            DBUtils.applyColumnTypeValue(this.getDialect(connection), connection, this.getTable(calculator), this.getColumnName(i), this.getColumnDefValue(i), preparedStatement, n + 1, this.getColumnType(this.getColumnName(i), connection), objectArray[i]);
            ++n;
        }
    }

    private int insert(Connection connection, Calculator calculator, Object[] objectArray) throws SQLException {
        PreparedStatement preparedStatement = this.getStatement(connection, calculator, objectArray);
        try {
            return preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            preparedStatement = this.getStatement(connection, calculator, objectArray);
            preparedStatement.addBatch();
            int[] nArray = preparedStatement.executeBatch();
            preparedStatement.close();
            this.pstmtMap.remove(connection);
            return ArrayUtils.getLength(nArray);
        }
    }

    private int insertBatch(int n, Connection connection, Calculator calculator, Object[] objectArray) throws SQLException {
        PreparedStatement preparedStatement = this.getStatement(connection, calculator, objectArray);
        preparedStatement.addBatch();
        if ((n + 1) % 500 == 0 || n + 1 == this.getTotalTimes() || 0 == this.getTotalTimes()) {
            int n2 = ArrayUtils.getLength(preparedStatement.executeBatch());
            preparedStatement.clearBatch();
            return n2;
        }
        return 0;
    }

    private PreparedStatement getStatement(Connection connection, Calculator calculator, Object[] objectArray) throws SQLException {
        PreparedStatement preparedStatement = this.getInsertedPreparedStatement(connection);
        this.fillInsertedPreparedStatement(preparedStatement, connection, calculator, objectArray);
        return preparedStatement;
    }

    public String toString() {
        return "insert into " + this.table.toString() + " " + super.toString();
    }

    protected boolean isIgnoreUpdate(Calculator calculator) {
        return false;
    }

    protected void dealWithIllegal(Connection connection, Calculator calculator) throws SQLException {
        PreparedStatement preparedStatement = this.getInsertedPreparedStatement(connection);
        preparedStatement.executeBatch();
    }
}

