/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write.config;

import com.fr.base.Parameter;
import com.fr.base.ParameterMapNameSpace;
import com.fr.cache.Attachment;
import com.fr.cache.list.IntList;
import com.fr.data.AbstractDataModel;
import com.fr.data.DBFeedback;
import com.fr.data.DataXmlUtils;
import com.fr.data.SubmitJob;
import com.fr.data.condition.ListCondition;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.core.db.ColumnInformation;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.data.Condition;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.ColumnRowGroup;
import com.fr.stable.ColumnRowRelated;
import com.fr.stable.FormulaProvider;
import com.fr.stable.Mapper;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.js.WidgetName;
import com.fr.stable.script.CalculatorKey;
import com.fr.stable.script.CalculatorUtils;
import com.fr.stable.xml.FRFile;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.third.antlr.ANTLRException;
import com.fr.write.DBWriteAction;
import com.fr.write.DMLConfigJob;
import com.fr.write.DMLReport;
import com.fr.write.NameSubmitJob;
import com.fr.write.config.ColumnConfig;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class DMLConfig
implements XMLable,
ColumnRowRelated {
    public static final CalculatorKey KEY = CalculatorKey.createKey(DMLConfig.class.getName());
    public static final CalculatorKey P_TAG = CalculatorKey.createKey("es_process_tag");
    public static final String XML_TAG = "DMLConfig";
    protected Table table = null;
    protected transient Table evaledTable = null;
    protected Dialect dialect = null;
    protected List<ColumnConfig> columnConfigList = new ArrayList<ColumnConfig>();
    protected List<NameSubmitJob> submitJobList = new ArrayList<NameSubmitJob>();
    protected Condition condition = null;
    private transient ColumnInformation[] columnInformations = null;
    private boolean updateSelected = false;
    private static Mapper toName = new Mapper(){

        public Object map(int n, Object object, List list) {
            return ((ColumnConfig)object).getColumnName();
        }
    };
    private static Mapper toValue = new Mapper(){

        public Object map(int n, Object object, List list) {
            return ((ColumnConfig)object).getColumnValue();
        }
    };

    public int getTotalTimes() {
        return 0;
    }

    public void setTotalTimes(int n) {
    }

    public Dialect getDialect(Connection connection) {
        if (this.dialect == null) {
            this.dialect = DialectFactory.generateDialect(connection);
        }
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public Table getTable() {
        return this.getTable(false);
    }

    public Table getOriTable() {
        return this.getTable(true);
    }

    private Table getTable(boolean bl) {
        if (!bl) {
            this.evaledTable = this.getTable(Calculator.createCalculator());
            return this.evaledTable;
        }
        return this.table;
    }

    private String getEvaledName(Calculator calculator, String string) {
        if (StableUtils.canBeFormula(string)) {
            try {
                return GeneralUtils.objectToString(calculator.eval(string));
            }
            catch (UtilEvalError utilEvalError) {
                FRLogger.getLogger().error(utilEvalError.getMessage());
            }
        }
        return string;
    }

    public Table getTable(Calculator calculator) {
        if (this.table == null) {
            return null;
        }
        if (calculator == null) {
            return this.table;
        }
        String string = this.getEvaledName(calculator, this.table.getSchema());
        String string2 = this.getEvaledName(calculator, this.table.getName());
        return new Table(string, string2);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void addColumnConfig(ColumnConfig columnConfig) {
        this.columnConfigList.add(columnConfig);
    }

    public int getColumnConfigCount() {
        return this.columnConfigList.size();
    }

    public ColumnConfig getColumnConfig(int n) {
        return this.columnConfigList.get(n);
    }

    public void clearColumnConfigs() {
        this.columnConfigList.clear();
    }

    public void addSubmitJob(NameSubmitJob nameSubmitJob) {
        this.submitJobList.add(nameSubmitJob);
    }

    public int getSubmitJobCount() {
        return this.submitJobList.size();
    }

    public NameSubmitJob getSubmitJob(int n) {
        return this.submitJobList.get(n);
    }

    public void clearSubmitJobs() {
        this.submitJobList.clear();
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public boolean isUpdateSelected() {
        return this.updateSelected;
    }

    public void setUpdateSelected(boolean bl) {
        this.updateSelected = bl;
    }

    public ColumnRow[] getRelatedColumnRows() {
        return this.getRelatedColumnRows(-1);
    }

    public ColumnRow[] getRelatedColumnRows(int n) {
        HashSet<ColumnRow> hashSet = new HashSet<ColumnRow>();
        int n2 = this.getColumnConfigCount();
        for (int i = 0; i < n2; ++i) {
            ColumnConfig columnConfig = this.getColumnConfig(i);
            Object object = columnConfig.getColumnValue();
            if (object instanceof ColumnRowGroup) {
                ColumnRowGroup columnRowGroup = (ColumnRowGroup)object;
                if (n < 0 || n >= columnRowGroup.getSize()) continue;
                hashSet.add(columnRowGroup.getColumnRow(n));
                continue;
            }
            if (object instanceof ColumnRowRelated) {
                hashSet.addAll(Arrays.asList(((ColumnRowRelated)object).getRelatedColumnRows()));
                continue;
            }
            if (!(object instanceof String) || !((String)object).startsWith("=")) continue;
            try {
                hashSet.addAll(Arrays.asList(CalculatorUtils.relatedColumnRowArray((String)object)));
                continue;
            }
            catch (ANTLRException aNTLRException) {
                FRLogger.getLogger().error(aNTLRException.getMessage(), aNTLRException);
            }
        }
        return hashSet.toArray(new ColumnRow[0]);
    }

    private boolean isColumnRowGroup() {
        int n = this.getColumnConfigCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getColumnConfig(i).getColumnValue();
            if (!(object instanceof ColumnRowGroup)) continue;
            return true;
        }
        return false;
    }

    private int getColumnRowGroupSize() {
        int n = this.getColumnConfigCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getColumnConfig(i).getColumnValue();
            if (!(object instanceof ColumnRowGroup)) continue;
            return ((ColumnRowGroup)object).getSize();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, Calculator calculator) throws Exception {
        ExtractionSubmitter extractionSubmitter = new ExtractionSubmitter(connection);
        calculator.setAttribute(KEY, (Object)this);
        try {
            this.extractGroup(extractionSubmitter, calculator);
        }
        finally {
            this.closeStatement(connection);
            calculator.removeAttribute(KEY);
        }
    }

    public DBFeedback executeAndFeedback(Connection connection, Calculator calculator) throws Exception {
        ExtractionSubmitter extractionSubmitter = new ExtractionSubmitter(connection, new DBFeedback());
        this.extractGroup(extractionSubmitter, calculator);
        return extractionSubmitter.getFeedback();
    }

    private void extractGroup(ExtractionSubmitter extractionSubmitter, Calculator calculator) throws Exception {
        if (this.isColumnRowGroup()) {
            int n = this.getColumnRowGroupSize();
            for (int i = 0; i < n; ++i) {
                DMLConfig.extract(calculator, this.getRelatedColumnRows(i), calculator.getCurrentFromColumnRow(), extractionSubmitter, i);
            }
        } else {
            DMLConfig.extract(calculator, this.getRelatedColumnRows(), calculator.getCurrentFromColumnRow(), extractionSubmitter, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extract(Calculator calculator, ColumnRow[] columnRowArray, ColumnRow columnRow, DBWriteAction dBWriteAction, int n) throws Exception {
        int n2 = 0;
        DMLReport dMLReport = (DMLReport)calculator.getAttribute(DMLReport.KEY);
        if (dMLReport != null) {
            DMLReport dMLReport2 = dMLReport;
            synchronized (dMLReport2) {
                n2 = dMLReport.setCurrentColumnRow(columnRowArray, columnRow, calculator, dBWriteAction, n);
            }
        }
        if (n2 <= 0) {
            dBWriteAction.run(0, calculator, n);
        }
    }

    private DMLColumnValues[] rebuildDMLConfig(Calculator calculator, int n) throws CloneNotSupportedException {
        Object[] objectArray = new Object[this.getColumnConfigCount()];
        int n2 = this.getColumnConfigCount();
        for (int i = 0; i < n2; ++i) {
            ColumnConfig columnConfig = this.getColumnConfig(i);
            objectArray[i] = this.calculateColumnValue2DML(columnConfig.getColumnValue(), calculator, n);
        }
        return this.extractByValues2Column(objectArray);
    }

    /*
     * Unable to fully structure code
     */
    private Object calculateColumnValue2DML(Object var1_1, Calculator var2_2, int var3_3) {
        if (var1_1 instanceof Parameter) {
            try {
                var1_1 = var2_2.evalValue(((Parameter)var1_1).getName());
            }
            catch (UtilEvalError var4_4) {
                FRLogger.getLogger().error(var4_4.getMessage(), var4_4);
                return null;
            }
        }
        if (var1_1 instanceof ColumnRow) {
            var1_1 = var2_2.resolveVariable(var1_1);
        } else if (var1_1 instanceof ColumnRowGroup) {
            var1_1 = var2_2.resolveVariable(((ColumnRowGroup)var1_1).getColumnRow(var3_3));
        } else if (var1_1 instanceof FormulaProvider) {
            try {
                var1_1 = var2_2.evalValue(((FormulaProvider)var1_1).getContent());
                if (!ComparatorUtils.equals(var1_1, (Object)"")) ** GOTO lbl30
                var1_1 = Primitive.NULL;
            }
            catch (UtilEvalError var4_5) {
                FRLogger.getLogger().error(var4_5.getMessage(), var4_5);
                return null;
            }
        } else if (var1_1 instanceof WidgetName) {
            try {
                var1_1 = var2_2.evalValue(((WidgetName)var1_1).getName());
            }
            catch (UtilEvalError var4_6) {
                FRLogger.getLogger().error(var4_6.getMessage(), var4_6);
                return null;
            }
        }
lbl30:
        // 8 sources

        if (var1_1 instanceof FArray) {
            var4_7 = new FArray<Object>();
            var6_9 = ((FArray)var1_1).length();
            for (var5_8 = 0; var5_8 < var6_9; ++var5_8) {
                var4_7.add(this.processStringCharset(var1_1.elementAt(var5_8), var2_2));
            }
            var1_1 = var4_7;
        } else {
            var1_1 = this.processStringCharset(var1_1, var2_2);
        }
        return var1_1;
    }

    private Object processStringCharset(Object object, Calculator calculator) {
        if (object instanceof String && calculator.resolveVariable("$$_NEWCHAR") != null && calculator.resolveVariable("$$_ORIGINALCHAR") != null) {
            try {
                return new String(((String)object).getBytes((String)calculator.resolveVariable("$$_NEWCHAR")), (String)calculator.resolveVariable("$$_ORIGINALCHAR"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
        return object;
    }

    private int getPrimaryIndex(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!this.isAttachmentGroup(object)) continue;
            return i;
        }
        return -1;
    }

    private boolean isAttachmentGroup(Object object) {
        return object instanceof FArray && ((FArray)object).length() > 0 && ((FArray)object).elementAt(0) instanceof Attachment;
    }

    public DMLColumnValues[] extractByValues2Column(Object[] objectArray) throws CloneNotSupportedException {
        int n = this.getPrimaryIndex(objectArray);
        ArrayList<DMLColumnValues> arrayList = new ArrayList<DMLColumnValues>();
        if (n == -1) {
            DMLColumnValues dMLColumnValues = new DMLColumnValues();
            arrayList.add(dMLColumnValues);
            this.addDMLConfig2List(dMLColumnValues, 0, objectArray, arrayList);
        } else {
            this.addDMLConfig2ListWithPrimary(arrayList, objectArray, n);
        }
        return arrayList.toArray(new DMLColumnValues[arrayList.size()]);
    }

    private void addDMLConfig2ListWithPrimary(List list, Object[] objectArray, int n) throws CloneNotSupportedException {
        FArray fArray = (FArray)objectArray[n];
        for (int i = 0; i < fArray.length(); ++i) {
            DMLColumnValues dMLColumnValues = new DMLColumnValues();
            list.add(dMLColumnValues);
            this.setDMLConfigValues(dMLColumnValues, 0, objectArray, n, i);
        }
    }

    private void setDMLConfigValues(DMLColumnValues dMLColumnValues, int n, Object[] objectArray, int n2, int n3) throws CloneNotSupportedException {
        if (n >= objectArray.length) {
            return;
        }
        FArray fArray = (FArray)objectArray[n2];
        Object object = objectArray[n];
        if (object instanceof FArray) {
            int n4 = ((FArray)object).length();
            object = ((FArray)object).elementAt(n3 < n4 ? n3 : n4 - 1);
        }
        dMLColumnValues.set(n, object);
        this.setDMLConfigValues(dMLColumnValues, ++n, objectArray, n2, n3);
    }

    private void addDMLConfig2List(DMLColumnValues dMLColumnValues, int n, Object[] objectArray, List list) throws CloneNotSupportedException {
        if (n >= objectArray.length) {
            return;
        }
        Object object = objectArray[n];
        if (object instanceof FArray) {
            int n2 = ((FArray)object).length();
            if (n2 == 0) {
                ((FArray)object).add("");
                ++n2;
            }
            for (int i = 0; i < n2; ++i) {
                DMLColumnValues dMLColumnValues2 = dMLColumnValues;
                Object t = ((FArray)object).elementAt(i);
                if (i > 0) {
                    dMLColumnValues2 = (DMLColumnValues)dMLColumnValues2.clone();
                    list.add(dMLColumnValues2);
                }
                dMLColumnValues2.set(n, t);
                this.addDMLConfig2List(dMLColumnValues2, n + 1, objectArray, list);
            }
        } else {
            dMLColumnValues.set(n, object);
            this.addDMLConfig2List(dMLColumnValues, n + 1, objectArray, list);
        }
    }

    protected abstract int dmlSubmit(Connection var1, Calculator var2, Object[] var3, Map var4) throws SQLException;

    protected abstract int dmlSubmitBatch(int var1, Connection var2, Calculator var3, Object[] var4, Map var5) throws SQLException;

    protected abstract boolean isIgnoreUpdate(Calculator var1);

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearColumnConfigs();
            this.clearSubmitJobs();
            this.condition = new ListCondition();
        } else if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Table".equals(string)) {
                this.table = new Table();
                xMLableReader.readXMLObject(this.table);
            } else if ("ColumnConfig".equals(string)) {
                ColumnConfig columnConfig = new ColumnConfig();
                xMLableReader.readXMLObject(columnConfig);
                this.addColumnConfig(columnConfig);
            } else if ("NameSubmitJob".equals(string)) {
                NameSubmitJob nameSubmitJob = new NameSubmitJob();
                xMLableReader.readXMLObject(nameSubmitJob);
                this.addSubmitJob(nameSubmitJob);
            } else if ("SubmitJob".equals(string)) {
                SubmitJob submitJob = DataXmlUtils.readSubmitJob(xMLableReader);
                if (submitJob != null) {
                    NameSubmitJob nameSubmitJob = new NameSubmitJob();
                    nameSubmitJob.setSubmitJob(submitJob);
                    this.addSubmitJob(nameSubmitJob);
                }
            } else if ("Condition".equals(string)) {
                this.condition = DataCoreXmlUtils.readCondition(xMLableReader);
            } else if ("UpdateAttr".equals(string)) {
                this.updateSelected = xMLableReader.getAttrAsBoolean("updateStatus", false);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n;
        if (this.table != null) {
            this.table.writeXML(xMLPrintWriter);
        }
        int n2 = this.getColumnConfigCount();
        for (n = 0; n < n2; ++n) {
            ColumnConfig columnConfig = this.getColumnConfig(n);
            if (columnConfig == null) continue;
            columnConfig.writeXML(xMLPrintWriter);
        }
        n2 = this.getSubmitJobCount();
        for (n = 0; n < n2; ++n) {
            this.getSubmitJob(n).writeXML(xMLPrintWriter);
        }
        if (this.condition != null) {
            DataCoreXmlUtils.writeXMLCondition(xMLPrintWriter, this.condition);
        }
        if (this.updateSelected) {
            xMLPrintWriter.startTAG("UpdateAttr").attr("updateStatus", this.updateSelected).end();
        }
    }

    protected Where generateWhere(Connection connection, Object[] objectArray) {
        Where where = null;
        for (int i = 0; i < this.getColumnConfigCount(); ++i) {
            ColumnConfig columnConfig = this.getColumnConfig(i);
            if (!columnConfig.isKey()) continue;
            if (where == null) {
                where = new Where();
            }
            String string = columnConfig.getColumnName();
            int n = this.getColumnType(string, connection);
            where.addColumn(string, n, 0, objectArray[i]);
        }
        return where;
    }

    protected int getColumnType(String string, Connection connection) {
        this.checkColumnTypes(connection);
        for (int i = 0; i < this.columnInformations.length; ++i) {
            if (!string.equalsIgnoreCase(this.columnInformations[i].getColumnName())) continue;
            return this.columnInformations[i].getColumnType();
        }
        return 0;
    }

    private void checkColumnTypes(Connection connection) {
        if (this.columnInformations == null) {
            Dialect dialect = this.getDialect(connection);
            String string = DataCoreUtils.createSelectSQL(this.table, this.getDialect(connection));
            try {
                this.columnInformations = DBUtils.checkInColumnInformation(connection, dialect, string);
            }
            catch (Exception exception) {
                this.table = this.getTable(false);
                string = DataCoreUtils.createSelectSQL(this.table, this.getDialect(connection));
                try {
                    this.columnInformations = DBUtils.checkInColumnInformation(connection, dialect, string);
                }
                catch (SQLException sQLException) {
                    FRLogger.getLogger().error(exception.getMessage());
                    this.columnInformations = new ColumnInformation[0];
                }
            }
        }
    }

    protected void closeStatement(Connection connection) throws SQLException {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getColumnConfigCount();
        if (n > 0) {
            stringBuffer.append('(').append(StableUtils.join(StableUtils.map(this.columnConfigList, toName), ", ")).append(") values(").append(StableUtils.join(StableUtils.map(this.columnConfigList, toValue), ", ")).append(')');
        }
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        DMLConfig dMLConfig = (DMLConfig)super.clone();
        if (this.table != null) {
            dMLConfig.table = (Table)this.table.clone();
        }
        if (this.columnConfigList != null) {
            dMLConfig.columnConfigList = new ArrayList<ColumnConfig>();
            for (n = 0; n < this.getColumnConfigCount(); ++n) {
                dMLConfig.addColumnConfig((ColumnConfig)this.getColumnConfig(n).clone());
            }
        }
        if (this.submitJobList != null) {
            dMLConfig.submitJobList = new ArrayList<NameSubmitJob>();
            for (n = 0; n < this.submitJobList.size(); ++n) {
                dMLConfig.submitJobList.add((NameSubmitJob)this.getSubmitJob(n).clone());
            }
        }
        if (this.condition != null) {
            dMLConfig.condition = (Condition)this.condition.clone();
        }
        return dMLConfig;
    }

    protected String getColumnName(int n) {
        return this.getColumnConfig(n).getColumnName();
    }

    protected Object getColumnDefValue(int n) {
        return this.getColumnConfig(n).getColumnValue();
    }

    protected Exception dealWithException(Exception exception) {
        return exception;
    }

    protected void dealWithIllegal(Connection connection, Calculator calculator) throws SQLException {
    }

    public static class DMLColumnValues
    implements Serializable,
    Cloneable {
        private ArrayList values = new ArrayList();

        protected void set(int n, Object object) {
            while (n >= this.values.size()) {
                this.values.add(null);
            }
            if (object instanceof FRFile) {
                this.values.set(n, ((FRFile)object).getBytes());
            } else {
                this.values.set(n, object);
            }
        }

        public Object get(int n) {
            return this.values.get(n);
        }

        protected int size() {
            return this.values.size();
        }

        protected Object[] toArray() {
            return this.values.toArray();
        }

        public Object clone() throws CloneNotSupportedException {
            DMLColumnValues dMLColumnValues = (DMLColumnValues)super.clone();
            dMLColumnValues.values = new ArrayList();
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                dMLColumnValues.set(i, StableUtils.cloneObject(this.get(i)));
            }
            return dMLColumnValues;
        }
    }

    public class SimpleDataModel
    extends AbstractDataModel
    implements DataModel {
        List row_list = new ArrayList();
        String[] columnNames;

        public SimpleDataModel(List list, String[] stringArray) {
            this.row_list = list;
            this.columnNames = stringArray;
        }

        public int getColumnCount() throws TableDataException {
            if (!this.row_list.isEmpty()) {
                return ((Object[])this.row_list.get(0)).length;
            }
            return 0;
        }

        public String getColumnName(int n) throws TableDataException {
            return this.columnNames != null && this.columnNames.length > n ? this.columnNames[n] : "";
        }

        public boolean hasRow(int n) throws TableDataException {
            return !this.row_list.isEmpty();
        }

        public int getRowCount() throws TableDataException {
            return this.row_list.size();
        }

        public Object getValueAt(int n, int n2) throws TableDataException {
            Object[] objectArray;
            if (this.row_list != null && this.row_list.size() > n && (objectArray = (Object[])this.row_list.get(n)).length > n2) {
                return objectArray[n2];
            }
            return new Object();
        }

        public void release() throws Exception {
        }
    }

    class ExtractionSubmitter
    implements DBWriteAction {
        DBFeedback feedback;
        Connection conn;
        private PreparedStatement insertedPreparedStatement = null;

        ExtractionSubmitter(Connection connection) {
            this(connection, null);
        }

        ExtractionSubmitter(Connection connection, DBFeedback dBFeedback) {
            this.conn = connection;
            this.feedback = dBFeedback;
        }

        public DBFeedback getFeedback() {
            return this.feedback;
        }

        PreparedStatement getInsertedPreparedStatement() throws SQLException {
            if (this.insertedPreparedStatement == null) {
                this.insertedPreparedStatement = this.createInsertedPreparedStatement(this.conn);
            }
            return this.insertedPreparedStatement;
        }

        private PreparedStatement createInsertedPreparedStatement(Connection connection) throws SQLException {
            IntList intList = new IntList();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Dialect dialect = DMLConfig.this.getDialect(connection);
            int n = DMLConfig.this.getColumnConfigCount();
            for (int i = 0; i < n; ++i) {
                arrayList.add(dialect.column2SQL(DMLConfig.this.getColumnConfig(i).getColumnName()));
                arrayList2.add("?");
                intList.add(i);
            }
            if (arrayList2.isEmpty()) {
                return null;
            }
            String string = "INSERT INTO " + DMLConfig.this.getTable().toStatementSQLString(dialect) + " (" + StableUtils.join(arrayList, ",") + ") VALUES (" + StableUtils.join(arrayList2, ",") + ")";
            PreparedStatement preparedStatement = connection.prepareStatement(string.toString());
            return preparedStatement;
        }

        public void close() throws SQLException {
            if (this.insertedPreparedStatement != null) {
                this.insertedPreparedStatement.close();
            }
        }

        public void run(int n, Calculator calculator, int n2) throws Exception {
            HashMap<String, Object> hashMap = null;
            if (this.feedback != null || DMLConfig.this.getSubmitJobCount() > 0) {
                hashMap = new HashMap<String, Object>();
            }
            DMLColumnValues[] dMLColumnValuesArray = DMLConfig.this.rebuildDMLConfig(calculator, n2);
            int n3 = dMLColumnValuesArray.length;
            for (int i = 0; i < n3; ++i) {
                int n4;
                Object[] objectArray = dMLColumnValuesArray[i].toArray();
                if (this.isAllNull(objectArray) || !this.passCondition(objectArray, calculator)) {
                    DMLConfig.this.dealWithIllegal(this.conn, calculator);
                    continue;
                }
                if (hashMap != null) {
                    int n5 = DMLConfig.this.getColumnConfigCount();
                    for (n4 = 0; n4 < n5; ++n4) {
                        hashMap.put(DMLConfig.this.getColumnConfig(n4).getColumnName(), objectArray[n4]);
                    }
                }
                DMLConfig.this.dmlSubmitBatch(n, this.conn, calculator, objectArray, hashMap);
                n4 = DMLConfig.this.isIgnoreUpdate(calculator) ? 1 : 0;
                if (this.feedback != null) {
                    this.feedback.addFeedbackMap(hashMap);
                }
                if (n4 != 0) continue;
                ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(hashMap);
                calculator.pushNameSpace(parameterMapNameSpace);
                Object object = calculator.getAttribute(P_TAG);
                calculator.removeAttribute(P_TAG);
                int n6 = DMLConfig.this.getSubmitJobCount();
                for (int j = 0; j < n6; ++j) {
                    SubmitJob submitJob = DMLConfig.this.getSubmitJob(j).getSubmitJob();
                    submitJob.doJob(calculator);
                    if (!(submitJob instanceof DMLConfigJob) || this.feedback == null) continue;
                    this.feedback.addFeedback(((DMLConfigJob)submitJob).getFeedback());
                }
                if (object != null) {
                    calculator.setAttribute(P_TAG, object);
                }
                calculator.removeNameSpace(parameterMapNameSpace);
            }
        }

        public boolean isDynamic() {
            return false;
        }

        private boolean isAllNull(Object[] objectArray) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null || objectArray[i] == Primitive.NULL) continue;
                return false;
            }
            return true;
        }

        private boolean passCondition(Object[] objectArray, Calculator calculator) {
            if (DMLConfig.this.condition != null) {
                Condition condition = DMLConfig.this.condition;
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                arrayList.add(objectArray);
                String[] stringArray = new String[DMLConfig.this.columnConfigList.size()];
                for (int i = 0; i < DMLConfig.this.columnConfigList.size(); ++i) {
                    stringArray[i] = DMLConfig.this.columnConfigList.get(i).getColumnName();
                }
                SimpleDataModel simpleDataModel = new SimpleDataModel(arrayList, stringArray);
                int[] nArray = condition.evalTableData(simpleDataModel, new int[]{0}, 0, calculator);
                if (nArray != null && nArray.length == 1) {
                    return true;
                }
            }
            return false;
        }
    }
}

