/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write;

import com.fr.data.core.db.dml.Table;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.FormulaProvider;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.write.config.ColumnConfig;
import com.fr.write.config.DMLConfig;
import com.fr.write.config.DeleteConfig;
import com.fr.write.config.InsertConfig;
import com.fr.write.config.IntelliDMLConfig;
import com.fr.write.config.UpdateConfig;

public class DBManipulation
implements XMLable {
    private String name;
    private String dbName = null;
    private DMLConfig dmlConfig;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getDBName(Calculator calculator) {
        if (this.dbName != null && this.dbName.startsWith("=")) {
            try {
                FormulaProvider formulaProvider = (FormulaProvider)((Object)StableFactory.createXmlObject("Formula"));
                formulaProvider.setContent(this.dbName);
                return GeneralUtils.objectToString(calculator.evalValue(formulaProvider));
            }
            catch (Exception exception) {
                return this.dbName;
            }
        }
        return this.dbName;
    }

    public void setDBName(String string) {
        this.dbName = string;
    }

    public DMLConfig getDmlConfig() {
        return this.dmlConfig;
    }

    public void setDmlConfig(DMLConfig dMLConfig) {
        this.dmlConfig = dMLConfig;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attributes").attr("dsName", this.dbName).attr("name", this.name).end();
        GeneralXMLTools.writeXMLable(xMLPrintWriter, this.dmlConfig, "DMLConfig");
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("DMLConfig".equals(string)) {
                DMLConfig dMLConfig = DBManipulation.readDMLConfig(xMLableReader);
                this.setDmlConfig(dMLConfig);
            } else if ("Attributes".equals(string)) {
                String string2 = xMLableReader.getAttrAsString("dsName", null);
                if (string2 != null) {
                    this.setDBName(string2);
                }
                if ((string2 = xMLableReader.getAttrAsString("name", null)) != null) {
                    this.setName(string2);
                }
                String string3 = xMLableReader.getAttrAsString("schemaName", null);
                String string4 = xMLableReader.getAttrAsString("tableName", null);
                if (string4 != null) {
                    IntelliDMLConfig intelliDMLConfig = new IntelliDMLConfig();
                    intelliDMLConfig.setTable(new Table(string3, string4));
                    this.setDmlConfig(intelliDMLConfig);
                }
            } else if ("Column".equals(string)) {
                String string5 = xMLableReader.getAttrAsString("name", null);
                boolean bl = xMLableReader.getAttrAsBoolean("isKey", false);
                boolean bl2 = xMLableReader.getAttrAsBoolean("skipUnmodified", false);
                DMLConfig dMLConfig = this.getDmlConfig();
                if (dMLConfig instanceof IntelliDMLConfig) {
                    DMLConfig dMLConfig2 = dMLConfig;
                    dMLConfig2.addColumnConfig(new ColumnConfig(string5, DBManipulation.readColumnValue(xMLableReader), bl, bl2));
                }
            }
        }
    }

    public static DMLConfig readDMLConfig(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("class", null);
        if (string == null) {
            return null;
        }
        DMLConfig dMLConfig = null;
        if (string.endsWith(".IntelliDMLConfig")) {
            dMLConfig = new IntelliDMLConfig();
        } else if (string.endsWith(".InsertConfig")) {
            dMLConfig = new InsertConfig();
        } else if (string.endsWith(".UpdateConfig")) {
            dMLConfig = new UpdateConfig();
        } else if (string.endsWith(".DeleteConfig")) {
            dMLConfig = new DeleteConfig();
        } else {
            try {
                dMLConfig = (DMLConfig)GeneralUtils.classForName(string).newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        if (dMLConfig != null) {
            xMLableReader.readXMLObject(dMLConfig);
        }
        return dMLConfig;
    }

    public static Object readColumnValue(XMLableReader xMLableReader) {
        XMLObject xMLObject = new XMLObject(""){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if ("ColumnRow".endsWith(string)) {
                        int n = xMLableReader.getAttrAsInt("column", 0);
                        int n2 = xMLableReader.getAttrAsInt("row", 0);
                        this.obj = ColumnRow.valueOf(n, n2);
                    } else if ("Parameter".equals(string)) {
                        this.obj = StableXMLUtils.readParameter(xMLableReader);
                    } else if ("Object".equals(string) || "O".equals(string)) {
                        this.obj = GeneralXMLTools.readObject(xMLableReader);
                    }
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        return xMLObject.getObject();
    }

    public String toString() {
        return this.dmlConfig == null ? "" : this.dmlConfig.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        DBManipulation dBManipulation = (DBManipulation)super.clone();
        if (this.dmlConfig != null) {
            dBManipulation.dmlConfig = (DMLConfig)this.dmlConfig.clone();
        }
        return dBManipulation;
    }
}

