/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.data.NetworkHelper;
import com.fr.file.ClusterConfigManager;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.general.LicChangedListener;
import com.fr.general.SiteCenter;
import com.fr.general.VT4FR;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.ExtraClassManager;
import com.fr.script.Calculator;
import com.fr.stable.FRException;
import com.fr.stable.LicUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.SessionCloseProcessor;
import com.fr.stable.fun.SessionManageProcessor;
import com.fr.stable.fun.SessionPrivilegeFilterProvider;
import com.fr.stable.fun.UnregisteredPageProcessor;
import com.fr.stable.html.Tag;
import com.fr.stable.html.TextHtml;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import com.fr.stable.web.SessionProvider;
import com.fr.stable.web.Weblet;
import com.fr.web.NoPrivilegeException;
import com.fr.web.WebletException;
import com.fr.web.cluster.ClusterManager;
import com.fr.web.core.DefaultHandlerMethod;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.factory.WebletFactory;
import com.fr.web.utils.WebUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionDealWith {
    private static Timer SESSION_DEAL_WITH_TIMER = null;
    private static boolean registed = false;
    private static boolean isRegOnline = false;
    private static Random sessionIDRandom = null;
    private static final int DEFAULT_COUNT = 2;
    private static int MAXADDRESS_COUNT = 2;
    private static final long __INIT_TIME__ = System.currentTimeMillis();
    private static final int LIC_PROMPT = 2102;
    private static final Object SESSION_ID_MAP_LOCK;
    private static Map sessionIDMap;
    private static ExecutorService closeSessionPool;
    private static Set<Object> sessionToDelete;
    private static final Object ADDRESS_MANAGER_LOCK;
    private static ConcurrentMap addressManager;
    private static final int ONE = 1;
    private static final int TEN = 10;
    private static final int MILLISECOND_PER_HOUR = 3600000;
    private static final int HOUR_PER_DAY = 24;

    private SessionDealWith() {
    }

    private static void authenticateLicense() {
        LicUtils.retryLicLock();
        byte[] byArray = StableUtils.getBytes();
        if (registed && byArray == null) {
            registed = false;
            GeneralContext.fireRegStatusChangeListener(registed);
        }
        if (isRegOnline && !StableUtils.isMatchOnline()) {
            MAXADDRESS_COUNT = 2;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            LicUtils.decode(byArray, byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            boolean bl = registed;
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            if (jSONObject.getLong("DEADLINE") > Calendar.getInstance().getTimeInMillis()) {
                registed = true;
                if (bl != registed) {
                    GeneralContext.fireRegStatusChangeListener(registed);
                }
                int n = 0;
                if (jSONObject.has("ONLINECHECK")) {
                    isRegOnline = true;
                }
                MAXADDRESS_COUNT = n <= 0 ? Integer.MAX_VALUE : n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getOrGenerateSessionIDWithCheckRegister(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = NetworkHelper.getHTTPRequestSessionIDParameter(httpServletRequest);
        if (string == null) {
            string = SessionDealWith.generateSessionIDWithCheckRegister(httpServletRequest, httpServletResponse);
        }
        return string;
    }

    public static String generateSessionIDWithCheckRegister(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Weblet weblet;
        try {
            SessionDealWith.generateSessionID_checkPromptRegisted(httpServletRequest, httpServletResponse);
            weblet = WebletFactory.createWebletByRequest(httpServletRequest, httpServletResponse);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            return null;
        }
        return SessionDealWith.generateSessionID(httpServletRequest, httpServletResponse, weblet);
    }

    public static String generateSessionID(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Weblet weblet) throws Exception {
        if (weblet == null) {
            throw new WebletException("Need to specify parameter \"reportlet\" or \"resultlet\" or \"formllet\".");
        }
        String string = WebUtils.getIpAddr(httpServletRequest);
        Map map = WebUtils.parameters4SessionIDInforContainMPCache(httpServletRequest);
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "op");
        if ((string2 == null || weblet.isSessionOccupy()) && SessionDealWith.generateSessionID_dealWithOverFlow(httpServletRequest, httpServletResponse, string)) {
            return null;
        }
        SessionProvider sessionProvider = null;
        if (weblet != null) {
            sessionProvider = weblet.createSessionIDInfor(httpServletRequest, string, map);
        }
        return SessionDealWith.generateSessionID_addSessionIDInfor(sessionProvider, string, weblet);
    }

    private static String generateSessionID_addSessionIDInfor(SessionProvider sessionProvider, String string, Weblet weblet) throws Exception {
        String string2 = SessionDealWith.addSessionIDInfor(sessionProvider);
        if (weblet.isSessionOccupy()) {
            HashSet<String> hashSet = new HashSet<String>();
            Set set = addressManager.putIfAbsent(string, hashSet);
            hashSet = set == null ? hashSet : set;
            hashSet.add(string2);
        }
        return string2;
    }

    private static boolean generateSessionID_dealWithOverFlow(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if (SessionDealWith.isAddressOverFlow(string)) {
            try {
                FRContext.getLogger().error(Inter.getLocText("FR-Base-NS_register_ipFull"));
                WebUtils.getPageWhenOverflow(httpServletResponse, addressManager.keySet());
                return true;
            }
            catch (Exception exception) {
                throw new Exception(Inter.getLocText("FR-Base-EX-IP_Address_Overflow"));
            }
        }
        return false;
    }

    private static boolean isAddressOverFlow(String string) {
        if (isRegOnline && !StableUtils.isMatchOnline()) {
            return MAXADDRESS_COUNT < addressManager.size();
        }
        return MAXADDRESS_COUNT < addressManager.size() && (StringUtils.isBlank(string) || !addressManager.containsKey(string));
    }

    public static boolean generateSessionID_isPromptRegisted(HttpServletRequest httpServletRequest) throws Exception {
        boolean bl;
        if (SessionDealWith.generateSessionID_checkReg(httpServletRequest)) {
            return false;
        }
        boolean bl2 = bl = Math.random() * 10.0 <= (double)((System.currentTimeMillis() - __INIT_TIME__) / 3600000L / 24L + 1L);
        if (bl && WebUtils.getDevice(httpServletRequest).isMobile()) {
            throw new Exception(Inter.getLocText("FR-Base-Need_Purchase_Info"));
        }
        return bl;
    }

    public static void generateSessionID_checkPromptRegisted(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!SessionDealWith.generateSessionID_checkReg(httpServletRequest)) {
            boolean bl;
            boolean bl2 = bl = Math.random() * 10.0 <= (double)((System.currentTimeMillis() - __INIT_TIME__) / 3600000L / 24L + 1L);
            if (bl) {
                FRException fRException = new FRException(2102, Inter.getLocText("FR-Base-Need_Purchase_Info"));
                UnregisteredPageProcessor unregisteredPageProcessor = (UnregisteredPageProcessor)ExtraClassManager.getInstance().getSingle("UnregisteredPageProcessor");
                Weblet weblet = unregisteredPageProcessor != null ? unregisteredPageProcessor.createWeblet() : WebletFactory.createEmbeddedWeblet("/com/fr/web/tpl/lic.frm");
                fRException.setHandlerMethod(new DefaultHandlerMethod(weblet));
                throw fRException;
            }
        }
    }

    public static boolean generateSessionID_checkReg(HttpServletRequest httpServletRequest) {
        return registed || SessionDealWith.isLocalHost(httpServletRequest);
    }

    public static void writeRegistrationDiv(HttpServletRequest httpServletRequest, PrintWriter printWriter) {
        String string = SiteCenter.getInstance().acquireUrlByKind("help.register");
        if (!SessionDealWith.generateSessionID_checkReg(httpServletRequest)) {
            Tag tag = new Tag("div");
            tag.css("left", "2px");
            tag.css("bottom", "36px");
            tag.css("font", "normal bolder 10pt Arial");
            tag.css("position", "absolute");
            tag.sub(new TextHtml("<a href='" + string + " target='_blank'>" + Inter.getLocText("Registration-Please_Purchase") + "</a>"));
            tag.writeHtml(printWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String addSessionIDInfor(SessionProvider sessionProvider) throws Exception {
        if (sessionProvider == null) {
            return null;
        }
        String string = null;
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            string = SessionDealWith.randomSessionID();
            Set set = ExtraClassManager.getInstance().getArray("SessionPrivilegeFilterProvider");
            for (SessionPrivilegeFilterProvider sessionPrivilegeFilterProvider : set) {
                string = sessionPrivilegeFilterProvider.encodeSessionID(string);
            }
            while (sessionIDMap.containsKey(string)) {
                string = SessionDealWith.randomSessionID();
            }
            sessionIDMap.put(string, sessionProvider);
        }
        SessionDealWith.recordSessionCreate(string);
        Calculator.putThreadSavedNameSpace(SessionIDInfor.asNameSpace(string));
        sessionProvider.setSessionID(string);
        return string;
    }

    private static void recordSessionCreate(String string) {
        SessionManageProcessor sessionManageProcessor = (SessionManageProcessor)ExtraClassManager.getInstance().getSingle("SessionManageProcessor");
        if (sessionManageProcessor != null) {
            sessionManageProcessor.registSessionCreate(string);
        }
    }

    private static void recordSessionDestroy(String string) {
        SessionManageProcessor sessionManageProcessor = (SessionManageProcessor)ExtraClassManager.getInstance().getSingle("SessionManageProcessor");
        if (sessionManageProcessor != null) {
            sessionManageProcessor.registSesssionDestroy(string);
        }
    }

    private static boolean isLocalHost(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getIpAddr(httpServletRequest);
        return WebUtils.isLocalHost(string);
    }

    private static String randomSessionID() {
        if (sessionIDRandom == null) {
            sessionIDRandom = new Random();
        }
        String string = String.valueOf(sessionIDRandom.nextInt(100000));
        if (ClusterConfigManager.getInstance().isUseCluster()) {
            string = ClusterManager.clusterHelp(string);
        }
        return string;
    }

    public static void closeSession(final Object object) {
        sessionToDelete.add(object);
        closeSessionPool.submit(new Runnable(){

            public void run() {
                SessionDealWith.processCloseSession(object);
                sessionToDelete.remove(object);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCloseSession(Object object) {
        FRContext.getLogger().info(Inter.getLocText("LOG-Close_Session") + ":" + object);
        SessionIDInfor sessionIDInfor = null;
        Object object2 = SESSION_ID_MAP_LOCK;
        synchronized (object2) {
            sessionIDInfor = (SessionIDInfor)sessionIDMap.remove(object);
        }
        if (sessionIDInfor != null) {
            sessionIDInfor.release();
            SessionDealWith.recordSessionDestroy((String)object);
            object2 = sessionIDInfor.getRemoteAddress();
            Object object3 = ADDRESS_MANAGER_LOCK;
            synchronized (object3) {
                Set set = (Set)addressManager.get(object2);
                if (set != null) {
                    set.remove(object);
                }
                if (set == null || set.isEmpty()) {
                    addressManager.remove(object2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllSession() {
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            HashSet hashSet = new HashSet(sessionIDMap.keySet());
            for (Object e : hashSet) {
                SessionDealWith.closeSession(e);
            }
        }
    }

    public static void writeSessionTimeout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (WebUtils.getDevice(httpServletRequest).isMobile()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("message", "session");
            jSONObject.put("exception", "session is timeout");
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.println(jSONObject);
            printWriter.flush();
            printWriter.close();
        } else {
            WebUtils.dealWithTemplate("/com/fr/web/core/session.html", httpServletResponse);
        }
    }

    public static void responseSessionID(String string, HttpServletResponse httpServletResponse) throws Exception {
        if (string != null && !SessionDealWith.hasSessionID(string)) {
            string = null;
        }
        if (string != null) {
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.write(string);
            printWriter.flush();
            printWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSessionID(String string) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        SessionIDInfor sessionIDInfor = null;
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            sessionIDInfor = (SessionIDInfor)sessionIDMap.get(string);
        }
        if (sessionIDInfor != null) {
            sessionIDInfor.updateTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionIDInfor getSessionIDInfor(String string) {
        if (StringUtils.isBlank(string) || sessionToDelete.contains(string)) {
            return null;
        }
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            return (SessionIDInfor)sessionIDMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasSessionID(String string) {
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            return sessionIDMap.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void viewSessions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONArray jSONArray = new JSONArray();
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            for (SessionIDInfor sessionIDInfor : sessionIDMap.values()) {
                jSONArray.put(new JSONObject().put("startTime", new Date(sessionIDInfor.getStartTime()).toLocaleString()).put("name", sessionIDInfor.getWebTitle()).put("ip", sessionIDInfor.getRemoteAddress()).put("user", sessionIDInfor.getParameterValue("fr_username")));
            }
        }
        object = WebUtils.createPrintWriter(httpServletResponse);
        ((PrintWriter)object).print(jSONArray);
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SessionIDInfor> getAllSession() {
        ArrayList<SessionIDInfor> arrayList = new ArrayList<SessionIDInfor>();
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            for (SessionIDInfor sessionIDInfor : sessionIDMap.values()) {
                arrayList.add(sessionIDInfor);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JSONObject> getVisitInforFromSession(Locale locale) throws JSONException {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            for (SessionIDInfor sessionIDInfor : sessionIDMap.values()) {
                arrayList.add(new JSONObject().put("startTime", new Date(sessionIDInfor.getStartTime()).toLocaleString()).put("name", sessionIDInfor.getWebTitle()).put("ip", sessionIDInfor.getRemoteAddress()).put("user", sessionIDInfor.getParameterValue("fr_username") == null ? Inter.getLocText("FS-Base-User_Not_Login", locale) : sessionIDInfor.getParameterValue("fr_username")));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTimeoutSessions() {
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            if (sessionIDMap == null) {
                return;
            }
            SessionIDInfor[] sessionIDInforArray = sessionIDMap.values().toArray(new SessionIDInfor[0]);
            for (int i = 0; i < sessionIDInforArray.length; ++i) {
                SessionIDInfor sessionIDInfor = sessionIDInforArray[i];
                if (!sessionIDInfor.isTimeout()) continue;
                SessionDealWith.closeSession(sessionIDInfor.getSessionID());
            }
        }
    }

    public static void setSessionIDRandom(Random random) {
        sessionIDRandom = random;
    }

    static {
        SessionDealWith.authenticateLicense();
        SESSION_DEAL_WITH_TIMER = new Timer();
        SESSION_DEAL_WITH_TIMER.schedule(new TimerTask(){

            public void run() {
                try {
                    if (ConfigManager.getProviderInstance().isLicUseLock()) {
                        SessionDealWith.authenticateLicense();
                    }
                    SessionDealWith.removeTimeoutSessions();
                    SessionCloseProcessor sessionCloseProcessor = (SessionCloseProcessor)ExtraClassManager.getInstance().getSingle("SessionCloseProcessor");
                    if (sessionCloseProcessor != null) {
                        sessionCloseProcessor.actionAfterSessionClose();
                    }
                }
                catch (Throwable throwable) {
                    FRContext.getLogger().error(throwable.getMessage(), throwable);
                }
            }
        }, ConfigManager.getProviderInstance().getSessionDeadCheckTime(), ConfigManager.getProviderInstance().getSessionDeadCheckTime());
        VT4FR.addLicChangedListener(new LicChangedListener(){

            public void licChange() {
                SessionDealWith.authenticateLicense();
            }
        });
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            public void onServletStop() {
                try {
                    if (SESSION_DEAL_WITH_TIMER != null) {
                        SESSION_DEAL_WITH_TIMER.cancel();
                    }
                }
                catch (Throwable throwable) {
                    FRContext.getLogger().error("cancel timer-1 failed");
                }
            }
        });
        SESSION_ID_MAP_LOCK = new Object();
        sessionIDMap = new Hashtable();
        closeSessionPool = Executors.newFixedThreadPool(10);
        sessionToDelete = new CopyOnWriteArraySet<Object>();
        ADDRESS_MANAGER_LOCK = new Object();
        addressManager = new ConcurrentHashMap();
    }
}

