/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.stable.FRException;
import com.fr.stable.web.Weblet;
import com.fr.web.core.HandlerMethodHelper;
import com.fr.web.core.HandlerMethodImpl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultHandlerMethod
extends HandlerMethodImpl {
    private TEMPLATE_TYPE templateType;
    private String templatePath;
    private Weblet weblet;

    public DefaultHandlerMethod() {
    }

    public DefaultHandlerMethod(Weblet weblet) {
        this.weblet = weblet;
    }

    public DefaultHandlerMethod(String string) {
        this.templatePath = string;
        this.templateType = this.getTemplateType();
    }

    private TEMPLATE_TYPE getTemplateType() {
        if (this.templatePath.endsWith(".html")) {
            return TEMPLATE_TYPE.HTML;
        }
        if (this.templatePath.endsWith(".frm") || this.templatePath.endsWith(".cpt")) {
            return TEMPLATE_TYPE.REPORT;
        }
        return TEMPLATE_TYPE.OTHER;
    }

    public void handlerMethodOnPC(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Throwable throwable) {
        if (this.weblet != null) {
            HandlerMethodHelper.solveWebletOnPC(httpServletRequest, httpServletResponse, string, this.weblet);
        } else if (this.templateType == TEMPLATE_TYPE.REPORT) {
            HandlerMethodHelper.postTemplateOnPC(httpServletRequest, httpServletResponse, string, throwable, this.templatePath);
        } else if (this.templateType == TEMPLATE_TYPE.HTML) {
            HandlerMethodHelper.postErrorMessageOnPC(httpServletRequest, httpServletResponse, string, throwable, this.templatePath);
        } else {
            HandlerMethodHelper.postErrorMessageOnPC(httpServletRequest, httpServletResponse, string, throwable);
        }
    }

    public void handlerMethodOnMobile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Throwable throwable) {
        HandlerMethodHelper.postErrorMessageWithJSONObject(httpServletRequest, httpServletResponse, string, throwable);
    }

    public void handlerMethodOnMobile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FRException fRException) {
        HandlerMethodHelper.postErrorMessageWithJSONObject(httpServletRequest, httpServletResponse, fRException);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TEMPLATE_TYPE {
        REPORT,
        HTML,
        OTHER;

    }
}

