/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web;

import com.fr.base.Base64;
import com.fr.base.TemplateUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONObject;
import com.fr.plugin.ExtraClassManager;
import com.fr.script.Calculator;
import com.fr.stable.CheckOut;
import com.fr.stable.CodeUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.ServletURLTransformer;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.BrowserProvider;
import com.fr.stable.web.Device;
import com.fr.stable.web.Repository;
import com.fr.web.Browser;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.utils.WebUtils;
import java.awt.Image;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RepositoryDeal
implements Repository {
    private HttpServletRequest req;
    protected SessionIDInfor sessionIDInfor;
    private String servletURL;
    private Browser browser;
    private Calculator i18nCalculator;
    private int resolution = 96;
    private double fontScale = 1.0;

    public RepositoryDeal(HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor) {
        this(httpServletRequest, sessionIDInfor, 96);
    }

    public RepositoryDeal(HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor, int n) {
        this.req = httpServletRequest;
        this.sessionIDInfor = sessionIDInfor;
        this.servletURL = WebUtils.createServletURL(httpServletRequest);
        this.browser = Browser.resolve(httpServletRequest);
        this.resolution = n;
        this.initCalculator();
    }

    private void initCalculator() {
        if (this.i18nCalculator == null) {
            this.i18nCalculator = Calculator.createCalculator();
            Locale locale = null;
            String string = this.sessionIDInfor == null ? "" : (String)this.sessionIDInfor.getParameterValue("fr_locale");
            locale = StringUtils.isNotBlank(string) ? StableUtils.createLocale(string) : WebUtils.getLocale(this.req);
            this.i18nCalculator.set("__locale__", locale);
            this.i18nCalculator.setAttribute(SessionIDInfor.KEY, (Object)this.sessionIDInfor);
        }
    }

    public BrowserProvider getBrowser() {
        return this.browser;
    }

    public Device getDevice() {
        return WebUtils.getDevice(this.req);
    }

    public double getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(double d) {
        this.fontScale = d;
    }

    public String checkoutObject(Object object, String string) {
        String string2 = this.servletURL;
        ServletURLTransformer servletURLTransformer = (ServletURLTransformer)ExtraClassManager.getInstance().getSingle("ServletURLTransformer");
        if (object == null && ComparatorUtils.equals("image", string)) {
            if (servletURLTransformer != null) {
                string2 = servletURLTransformer.prefixForImage(this.servletURL, string);
            }
            return string2 + "?op=resource&resource=/com/fr/web/images/s.gif";
        }
        if (object instanceof JSONObject) {
            if (servletURLTransformer != null) {
                string2 = servletURLTransformer.prefixForWrite(this.servletURL, object, string);
            }
            JSONObject jSONObject = (JSONObject)object;
            return string2 + "?op=widget" + (string == null ? "" : "&ftype=" + string) + "&location=" + CodeUtils.encodeURIComponent(jSONObject.toString()) + "&sessionID=" + this.sessionIDInfor.getSessionID();
        }
        CheckOut checkOut = CheckOut.getByValue(string);
        if (servletURLTransformer != null) {
            string2 = servletURLTransformer.prefixForResource(this.servletURL, checkOut);
        }
        switch (checkOut) {
            case CHECKOUTFORMLET: {
                return string2 + "?formlet=" + CodeUtils.encodeURIComponent(CodeUtils.cjkEncode((String)object));
            }
            case CHECKOUTREPORTLET: {
                return string2 + "?reportlet=" + CodeUtils.encodeURIComponent(CodeUtils.cjkEncode((String)object));
            }
            case CHECKOUTWIDGET: {
                return string2 + "?op=widget&widgetname=" + object + "&sessionID=" + this.sessionIDInfor.getSessionID();
            }
            case CHECKOUTIMAGE: {
                return this.checkOutImage(object, string2);
            }
        }
        return "";
    }

    private String checkOutImage(Object object, String string) {
        if (!(object instanceof Image)) {
            return "";
        }
        Image image = (Image)object;
        if (this.getDevice().isMobile()) {
            return Base64.encode(image, "png");
        }
        if (this.browser.supportIMAGEBase64Decode()) {
            return "data:image/png;base64," + Base64.encode(image, "png");
        }
        return string + "?op=fr_attach&cmd=ah_image&id=" + this.sessionIDInfor.addImage(image);
    }

    public String getServletURL() {
        return this.servletURL;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.req;
    }

    public String getHTTPRequestParameter(String string) {
        return WebUtils.getHTTPRequestParameter(this.req, string);
    }

    public String i18n(String string) {
        if (string == null) {
            return null;
        }
        return TemplateUtils.renderTpl(this.i18nCalculator, string);
    }

    public CalculatorProvider getCalculator() {
        return this.i18nCalculator;
    }

    public int getResolution() {
        return this.resolution;
    }

    public Map getReportParameterMap() {
        return this.sessionIDInfor.getParameterMap4Execute();
    }

    public String getSessionID() {
        return this.sessionIDInfor.getSessionID();
    }
}

