/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.plugin.closeable;

import com.fr.stable.plugin.closeable.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CloseableUtils {
    public static boolean isClosed(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Closeable) {
            return ((Closeable)object).isClosed();
        }
        return false;
    }

    public static <T> Set<T> filterSet(Set<T> set) {
        if (set == null) {
            return null;
        }
        try {
            Set set2 = (Set)set.getClass().newInstance();
            for (T t : set) {
                if (CloseableUtils.isClosed(t)) continue;
                set2.add(t);
            }
            return set2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <V> Collection<V> filterCollection(Collection<V> collection) {
        if (collection == null) {
            return null;
        }
        try {
            Collection collection2 = (Collection)collection.getClass().newInstance();
            for (V v2 : collection) {
                if (CloseableUtils.isClosed(v2)) continue;
                collection2.add(v2);
            }
            return collection2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <T, K> Map<T, K> filterMap(Map<T, K> map) {
        if (map == null) {
            return null;
        }
        try {
            Map map2 = (Map)map.getClass().newInstance();
            for (Map.Entry<T, K> entry : map.entrySet()) {
                if (CloseableUtils.isClosed(entry.getValue())) continue;
                map2.put(entry.getKey(), entry.getValue());
            }
            return map2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <T, K> boolean allClosed(Map<T, K> map) {
        if (map == null) {
            return true;
        }
        for (Map.Entry<T, K> entry : map.entrySet()) {
            K k = entry.getValue();
            if (CloseableUtils.isClosed(k)) continue;
            return false;
        }
        return true;
    }

    public static <T, K> int openingSize(Map<T, K> map) {
        if (map == null) {
            return 0;
        }
        int n = 0;
        for (Map.Entry<T, K> entry : map.entrySet()) {
            if (CloseableUtils.isClosed(entry.getValue())) continue;
            ++n;
        }
        return n;
    }
}

