/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.utils;

import java.util.Random;

public class RandomXS128
extends Random {
    private static final double NORM_DOUBLE = (double)1.110223E-16f;
    private static final double NORM_FLOAT = 5.960464477539063E-8;
    private long seed0;
    private long seed1;

    public RandomXS128() {
        this.setSeed(new Random().nextLong());
    }

    public RandomXS128(long l) {
        this.setSeed(l);
    }

    public RandomXS128(long l, long l2) {
        this.setState(l, l2);
    }

    public long nextLong() {
        long l;
        long l2 = this.seed0;
        this.seed0 = l = this.seed1;
        l2 ^= l2 << 23;
        this.seed1 = l2 ^ l ^ l2 >>> 17 ^ l >>> 26;
        return this.seed1 + l;
    }

    protected final int next(int n) {
        return (int)(this.nextLong() & (1L << n) - 1L);
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    public long nextLong(long l) {
        long l2;
        long l3;
        if (l <= 0L) {
            throw new IllegalArgumentException("n must be positive");
        }
        while ((l3 = this.nextLong() >>> 1) - (l2 = l3 % l) + (l - 1L) < 0L) {
        }
        return l2;
    }

    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    public float nextFloat() {
        return (float)((double)(this.nextLong() >>> 40) * 5.960464477539063E-8);
    }

    public boolean nextBoolean() {
        return (this.nextLong() & 1L) != 0L;
    }

    public void nextBytes(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        while (n2 != 0) {
            n = n2 < 8 ? n2 : 8;
            long l = this.nextLong();
            while (n-- != 0) {
                byArray[--n2] = (byte)l;
                l >>= 8;
            }
        }
    }

    public void setSeed(long l) {
        long l2 = RandomXS128.murmurHash3(l == 0L ? Long.MIN_VALUE : l);
        this.setState(l2, RandomXS128.murmurHash3(l2));
    }

    public void setState(long l, long l2) {
        this.seed0 = l;
        this.seed1 = l2;
    }

    public long getState(int n) {
        return n == 0 ? this.seed0 : this.seed1;
    }

    private static final long murmurHash3(long l) {
        l ^= l >>> 33;
        l *= -49064778989728563L;
        l ^= l >>> 33;
        l *= -4265267296055464877L;
        l ^= l >>> 33;
        return l;
    }
}

