/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.utils;

import com.fr.stable.collections.utils.RandomXS128;
import java.util.Random;

public final class MathUtils {
    public static final float nanoToSec = 1.0E-9f;
    public static final float FLOAT_ROUNDING_ERROR = 1.0E-6f;
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float E = (float)Math.E;
    private static final int SIN_BITS = 14;
    private static final int SIN_MASK = 16383;
    private static final int SIN_COUNT = 16384;
    private static final float radFull = (float)Math.PI * 2;
    private static final float degFull = 360.0f;
    private static final float radToIndex = 2607.5945f;
    private static final float degToIndex = 45.511112f;
    public static final float radiansToDegrees = 57.295776f;
    public static final float radDeg = 57.295776f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float degRad = (float)Math.PI / 180;
    public static Random random = new RandomXS128();
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final double CEIL = 0.9999999;
    private static final double BIG_ENOUGH_CEIL = 16384.999999999996;
    private static final double BIG_ENOUGH_ROUND = 16384.5;

    public static float sin(float f) {
        return Sin.table[(int)(f * 2607.5945f) & 0x3FFF];
    }

    public static float cos(float f) {
        return Sin.table[(int)((f + 1.5707964f) * 2607.5945f) & 0x3FFF];
    }

    public static float sinDeg(float f) {
        return Sin.table[(int)(f * 45.511112f) & 0x3FFF];
    }

    public static float cosDeg(float f) {
        return Sin.table[(int)((f + 90.0f) * 45.511112f) & 0x3FFF];
    }

    public static float atan2(float f, float f2) {
        if (f2 == 0.0f) {
            if (f > 0.0f) {
                return 1.5707964f;
            }
            if (f == 0.0f) {
                return 0.0f;
            }
            return -1.5707964f;
        }
        float f3 = f / f2;
        if (Math.abs(f3) < 1.0f) {
            float f4 = f3 / (1.0f + 0.28f * f3 * f3);
            if (f2 < 0.0f) {
                return f4 + (f < 0.0f ? (float)(-Math.PI) : (float)Math.PI);
            }
            return f4;
        }
        float f5 = 1.5707964f - f3 / (f3 * f3 + 0.28f);
        return f < 0.0f ? f5 - (float)Math.PI : f5;
    }

    public static int random(int n) {
        return random.nextInt(n + 1);
    }

    public static int random(int n, int n2) {
        return n + random.nextInt(n2 - n + 1);
    }

    public static long random(long l) {
        return (long)(random.nextDouble() * (double)l);
    }

    public static long random(long l, long l2) {
        return l + (long)(random.nextDouble() * (double)(l2 - l));
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static boolean randomBoolean(float f) {
        return MathUtils.random() < f;
    }

    public static float random() {
        return random.nextFloat();
    }

    public static float random(float f) {
        return random.nextFloat() * f;
    }

    public static float random(float f, float f2) {
        return f + random.nextFloat() * (f2 - f);
    }

    public static int randomSign() {
        return 1 | random.nextInt() >> 31;
    }

    public static float randomTriangular() {
        return random.nextFloat() - random.nextFloat();
    }

    public static float randomTriangular(float f) {
        return (random.nextFloat() - random.nextFloat()) * f;
    }

    public static float randomTriangular(float f, float f2) {
        return MathUtils.randomTriangular(f, f2, (f + f2) * 0.5f);
    }

    public static float randomTriangular(float f, float f2, float f3) {
        float f4;
        float f5 = random.nextFloat();
        if (f5 <= (f3 - f) / (f4 = f2 - f)) {
            return f + (float)Math.sqrt(f5 * f4 * (f3 - f));
        }
        return f2 - (float)Math.sqrt((1.0f - f5) * f4 * (f2 - f3));
    }

    public static int nextPowerOfTwo(int n) {
        if (n == 0) {
            return 1;
        }
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    public static boolean isPowerOfTwo(int n) {
        return n != 0 && (n & n - 1) == 0;
    }

    public static short clamp(short s, short s2, short s3) {
        if (s < s2) {
            return s2;
        }
        if (s > s3) {
            return s3;
        }
        return s;
    }

    public static int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static long clamp(long l, long l2, long l3) {
        if (l < l2) {
            return l2;
        }
        if (l > l3) {
            return l3;
        }
        return l;
    }

    public static float clamp(float f, float f2, float f3) {
        if (f < f2) {
            return f2;
        }
        if (f > f3) {
            return f3;
        }
        return f;
    }

    public static double clamp(double d, double d2, double d3) {
        if (d < d2) {
            return d2;
        }
        if (d > d3) {
            return d3;
        }
        return d;
    }

    public static float lerp(float f, float f2, float f3) {
        return f + (f2 - f) * f3;
    }

    public static float lerpAngle(float f, float f2, float f3) {
        float f4 = (f2 - f + (float)Math.PI * 2 + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI;
        return (f + f4 * f3 + (float)Math.PI * 2) % ((float)Math.PI * 2);
    }

    public static float lerpAngleDeg(float f, float f2, float f3) {
        float f4 = (f2 - f + 360.0f + 180.0f) % 360.0f - 180.0f;
        return (f + f4 * f3 + 360.0f) % 360.0f;
    }

    public static int floor(float f) {
        return (int)((double)f + 16384.0) - 16384;
    }

    public static int floorPositive(float f) {
        return (int)f;
    }

    public static int ceil(float f) {
        return (int)((double)f + 16384.999999999996) - 16384;
    }

    public static int ceilPositive(float f) {
        return (int)((double)f + 0.9999999);
    }

    public static int round(float f) {
        return (int)((double)f + 16384.5) - 16384;
    }

    public static int roundPositive(float f) {
        return (int)(f + 0.5f);
    }

    public static boolean isZero(float f) {
        return Math.abs(f) <= 1.0E-6f;
    }

    public static boolean isZero(float f, float f2) {
        return Math.abs(f) <= f2;
    }

    public static boolean isEqual(float f, float f2) {
        return Math.abs(f - f2) <= 1.0E-6f;
    }

    public static boolean isEqual(float f, float f2, float f3) {
        return Math.abs(f - f2) <= f3;
    }

    public static float log(float f, float f2) {
        return (float)(Math.log(f2) / Math.log(f));
    }

    public static float log2(float f) {
        return MathUtils.log(2.0f, f);
    }

    private static class Sin {
        static final float[] table;

        private Sin() {
        }

        static {
            int n;
            table = new float[16384];
            for (n = 0; n < 16384; ++n) {
                Sin.table[n] = (float)Math.sin(((float)n + 0.5f) / 16384.0f * ((float)Math.PI * 2));
            }
            for (n = 0; n < 360; n += 90) {
                Sin.table[(int)((float)n * 45.511112f) & 0x3FFF] = (float)Math.sin((float)n * ((float)Math.PI / 180));
            }
        }
    }
}

