/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.Array;
import com.fr.stable.collections.array.IntArray;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIntMap<K>
implements Iterable<Entry<K>> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    public int size;
    K[] keyTable;
    int[] valueTable;
    int capacity;
    int stashSize;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private Entries entries1;
    private Entries entries2;
    private Values values1;
    private Values values2;
    private Keys keys1;
    private Keys keys2;

    public ObjectIntMap() {
        this(51, 0.8f);
    }

    public ObjectIntMap(int n) {
        this(n, 0.8f);
    }

    public ObjectIntMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n);
        }
        if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n);
        }
        this.capacity = n;
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f);
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new Object[this.capacity + this.stashCapacity];
        this.valueTable = new int[this.keyTable.length];
    }

    public ObjectIntMap(ObjectIntMap<? extends K> objectIntMap) {
        this((int)Math.floor((float)objectIntMap.capacity * objectIntMap.loadFactor), objectIntMap.loadFactor);
        this.stashSize = objectIntMap.stashSize;
        System.arraycopy(objectIntMap.keyTable, 0, this.keyTable, 0, objectIntMap.keyTable.length);
        System.arraycopy(objectIntMap.valueTable, 0, this.valueTable, 0, objectIntMap.valueTable.length);
        this.size = objectIntMap.size;
    }

    public void put(K k, int n) {
        int n2;
        if (k == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] KArray = this.keyTable;
        int n3 = k.hashCode();
        int n4 = n3 & this.mask;
        K k2 = KArray[n4];
        if (k.equals(k2)) {
            this.valueTable[n4] = n;
            return;
        }
        int n5 = this.hash2(n3);
        K k3 = KArray[n5];
        if (k.equals(k3)) {
            this.valueTable[n5] = n;
            return;
        }
        int n6 = this.hash3(n3);
        K k4 = KArray[n6];
        if (k.equals(k4)) {
            this.valueTable[n6] = n;
            return;
        }
        int n7 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n7; ++n2) {
            if (!k.equals(KArray[n2])) continue;
            this.valueTable[n2] = n;
            return;
        }
        if (k2 == null) {
            KArray[n4] = k;
            this.valueTable[n4] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (k3 == null) {
            KArray[n5] = k;
            this.valueTable[n5] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (k4 == null) {
            KArray[n6] = k;
            this.valueTable[n6] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k, n, n4, k2, n5, k3, n6, k4);
    }

    public void putAll(ObjectIntMap<K> objectIntMap) {
        for (Entry entry : objectIntMap.entries()) {
            this.put(entry.key, entry.value);
        }
    }

    private void putResize(K k, int n) {
        int n2 = k.hashCode();
        int n3 = n2 & this.mask;
        K k2 = this.keyTable[n3];
        if (k2 == null) {
            this.keyTable[n3] = k;
            this.valueTable[n3] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n4 = this.hash2(n2);
        K k3 = this.keyTable[n4];
        if (k3 == null) {
            this.keyTable[n4] = k;
            this.valueTable[n4] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n5 = this.hash3(n2);
        K k4 = this.keyTable[n5];
        if (k4 == null) {
            this.keyTable[n5] = k;
            this.valueTable[n5] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k, n, n3, k2, n4, k3, n5, k4);
    }

    private void push(K k, int n, int n2, K k2, int n3, K k3, int n4, K k4) {
        int n5;
        K k5;
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n6 = this.mask;
        int n7 = 0;
        int n8 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    k5 = k2;
                    n5 = nArray[n2];
                    KArray[n2] = k;
                    nArray[n2] = n;
                    break;
                }
                case 1: {
                    k5 = k3;
                    n5 = nArray[n3];
                    KArray[n3] = k;
                    nArray[n3] = n;
                    break;
                }
                default: {
                    k5 = k4;
                    n5 = nArray[n4];
                    KArray[n4] = k;
                    nArray[n4] = n;
                }
            }
            int n9 = k5.hashCode();
            n2 = n9 & n6;
            k2 = KArray[n2];
            if (k2 == null) {
                KArray[n2] = k5;
                nArray[n2] = n5;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n3 = this.hash2(n9);
            k3 = KArray[n3];
            if (k3 == null) {
                KArray[n3] = k5;
                nArray[n3] = n5;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n4 = this.hash3(n9);
            k4 = KArray[n4];
            if (k4 == null) {
                KArray[n4] = k5;
                nArray[n4] = n5;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n7 == n8) break;
            k = k5;
            n = n5;
        }
        this.putStash(k5, n5);
    }

    private void putStash(K k, int n) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(k, n);
            return;
        }
        int n2 = this.capacity + this.stashSize;
        this.keyTable[n2] = k;
        this.valueTable[n2] = n;
        ++this.stashSize;
        ++this.size;
    }

    public int get(K k, int n) {
        int n2 = k.hashCode();
        int n3 = n2 & this.mask;
        if (!(k.equals(this.keyTable[n3]) || k.equals(this.keyTable[n3 = this.hash2(n2)]) || k.equals(this.keyTable[n3 = this.hash3(n2)]))) {
            return this.getStash(k, n);
        }
        return this.valueTable[n3];
    }

    private int getStash(K k, int n) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (!k.equals(KArray[n2])) continue;
            return this.valueTable[n2];
        }
        return n;
    }

    public int getAndIncrement(K k, int n, int n2) {
        int n3 = k.hashCode();
        int n4 = n3 & this.mask;
        if (!(k.equals(this.keyTable[n4]) || k.equals(this.keyTable[n4 = this.hash2(n3)]) || k.equals(this.keyTable[n4 = this.hash3(n3)]))) {
            return this.getAndIncrementStash(k, n, n2);
        }
        int n5 = this.valueTable[n4];
        this.valueTable[n4] = n5 + n2;
        return n5;
    }

    private int getAndIncrementStash(K k, int n, int n2) {
        int n3;
        K[] KArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (!k.equals(KArray[n3])) continue;
            int n5 = this.valueTable[n3];
            this.valueTable[n3] = n5 + n2;
            return n5;
        }
        this.put(k, n + n2);
        return n;
    }

    public int remove(K k, int n) {
        int n2 = k.hashCode();
        int n3 = n2 & this.mask;
        if (k.equals(this.keyTable[n3])) {
            this.keyTable[n3] = null;
            int n4 = this.valueTable[n3];
            --this.size;
            return n4;
        }
        n3 = this.hash2(n2);
        if (k.equals(this.keyTable[n3])) {
            this.keyTable[n3] = null;
            int n5 = this.valueTable[n3];
            --this.size;
            return n5;
        }
        n3 = this.hash3(n2);
        if (k.equals(this.keyTable[n3])) {
            this.keyTable[n3] = null;
            int n6 = this.valueTable[n3];
            --this.size;
            return n6;
        }
        return this.removeStash(k, n);
    }

    int removeStash(K k, int n) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (!k.equals(KArray[n2])) continue;
            int n4 = this.valueTable[n2];
            this.removeStashIndex(n2);
            --this.size;
            return n4;
        }
        return n;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            this.keyTable[n] = this.keyTable[n2];
            this.valueTable[n] = this.valueTable[n2];
        }
    }

    public void shrink(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n);
        }
        if (this.size > n) {
            n = this.size;
        }
        if (this.capacity <= n) {
            return;
        }
        n = MathUtils.nextPowerOfTwo(n);
        this.resize(n);
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        K[] KArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        while (n-- > 0) {
            KArray[n] = null;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public boolean containsValue(int n) {
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            if (KArray[n2] == null || nArray[n2] != n) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(K k) {
        int n = k.hashCode();
        int n2 = n & this.mask;
        if (!(k.equals(this.keyTable[n2]) || k.equals(this.keyTable[n2 = this.hash2(n)]) || k.equals(this.keyTable[n2 = this.hash3(n)]))) {
            return this.containsKeyStash(k);
        }
        return true;
    }

    private boolean containsKeyStash(K k) {
        int n;
        K[] KArray = this.keyTable;
        int n2 = n + this.stashSize;
        for (n = this.capacity; n < n2; ++n) {
            if (!k.equals(KArray[n])) continue;
            return true;
        }
        return false;
    }

    public K findKey(int n) {
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            if (KArray[n2] == null || nArray[n2] != n) continue;
            return KArray[n2];
        }
        return null;
    }

    public void ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / this.loadFactor)));
        }
    }

    private void resize(int n) {
        int n2 = this.capacity + this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        this.keyTable = new Object[n + this.stashCapacity];
        this.valueTable = new int[n + this.stashCapacity];
        int n3 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n3 > 0) {
            for (int i = 0; i < n2; ++i) {
                K k = KArray[i];
                if (k == null) continue;
                this.putResize(k, nArray[i]);
            }
        }
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    public int hashCode() {
        int n = 0;
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        for (int i = 0; i < n2; ++i) {
            K k = KArray[i];
            if (k == null) continue;
            n += k.hashCode() * 31;
            int n3 = nArray[i];
            n += n3;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectIntMap)) {
            return false;
        }
        ObjectIntMap objectIntMap = (ObjectIntMap)object;
        if (objectIntMap.size != this.size) {
            return false;
        }
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        for (int i = 0; i < n; ++i) {
            K k = KArray[i];
            if (k == null) continue;
            int n2 = objectIntMap.get(k, 0);
            if (n2 == 0 && !objectIntMap.containsKey(k)) {
                return false;
            }
            int n3 = nArray[i];
            if (n2 == n3) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        K k;
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n = KArray.length;
        while (n-- > 0) {
            k = KArray[n];
            if (k == null) continue;
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n]);
            break;
        }
        while (n-- > 0) {
            k = KArray[n];
            if (k == null) continue;
            stringBuilder.append(", ");
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Entries<K> iterator() {
        return this.entries();
    }

    public Entries<K> entries() {
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public Values values() {
        if (this.values1 == null) {
            this.values1 = new Values((ObjectIntMap<?>)this);
            this.values2 = new Values((ObjectIntMap<?>)this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public Keys<K> keys() {
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Keys<K>
    extends MapIterator<K>
    implements Iterable<K>,
    Iterator<K> {
        public Keys(ObjectIntMap<K> objectIntMap) {
            super(objectIntMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object k = this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return k;
        }

        @Override
        public Keys<K> iterator() {
            return this;
        }

        public Array<K> toArray() {
            Array<K> array = new Array<K>(true, this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        public Array<K> toArray(Array<K> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Values
    extends MapIterator<Object> {
        public Values(ObjectIntMap<?> objectIntMap) {
            super(objectIntMap);
        }

        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return n;
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.map.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entries<K>
    extends MapIterator<K>
    implements Iterable<Entry<K>>,
    Iterator<Entry<K>> {
        private Entry<K> entry = new Entry();

        public Entries(ObjectIntMap<K> objectIntMap) {
            super(objectIntMap);
        }

        @Override
        public Entry<K> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            K[] KArray = this.map.keyTable;
            this.entry.key = KArray[this.nextIndex];
            this.entry.value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Entries<K> iterator() {
            return this;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapIterator<K> {
        public boolean hasNext;
        final ObjectIntMap<K> map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(ObjectIntMap<K> objectIntMap) {
            this.map = objectIntMap;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        void findNextIndex() {
            this.hasNext = false;
            K[] KArray = this.map.keyTable;
            int n = this.map.capacity + this.map.stashSize;
            while (++this.nextIndex < n) {
                if (KArray[this.nextIndex] == null) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            if (this.currentIndex >= this.map.capacity) {
                this.map.removeStashIndex(this.currentIndex);
                this.nextIndex = this.currentIndex - 1;
                this.findNextIndex();
            } else {
                this.map.keyTable[this.currentIndex] = null;
            }
            this.currentIndex = -1;
            --this.map.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<K> {
        public K key;
        public int value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

