/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.fun.impl;

import com.fr.base.GraphHelper;
import com.fr.base.Style;
import com.fr.general.Inter;
import com.fr.report.fun.impl.AbstractVerticalTextProcessor;
import com.fr.report.fun.impl.SymbolConverter;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.unit.PT;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;

public class DefaultVerticalTextProcessor
extends AbstractVerticalTextProcessor {
    private static int ONECHARACTERLEN = 6;
    private static final char SBC_SPACE = '\u3000';
    private static final char DBC_SPACE = ' ';
    private static final char DBC_CHAR_END = '\u007f';
    private static final int CONVERT_STEP = 65248;

    public String[] getComboxOption() {
        return new String[]{Inter.getLocText("FR-Designer_Vertical-LeftToRight"), Inter.getLocText("FR-Designer_Vertical-RightToLeft")};
    }

    public String[] process(String string, Style style, Font font, double d, double d2, int n) {
        if (font == null) {
            font = style.getFRFont();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() <= 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (style.getRotation() != 0) {
            arrayList.add(string);
            return new String[]{string};
        }
        string = SymbolConverter.converVerticalSymbol(style, string);
        string = DefaultVerticalTextProcessor.half2Full(string);
        ArrayList arrayList2 = new ArrayList();
        int n2 = 0;
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(font);
        int n3 = fontMetrics.getHeight();
        int n4 = style.getTextStyle();
        int n5 = style.getVerticalAlignment();
        int[] nArray = new int[2];
        nArray[0] = n2;
        if (n4 == 0) {
            DefaultVerticalTextProcessor.lineTextListWrapText(arrayList2, n5, string, d, nArray, n3, style, n);
        } else {
            DefaultVerticalTextProcessor.lineTextListNotWrapText(arrayList2, string, nArray);
        }
        DefaultVerticalTextProcessor.verticalToHorizontal(arrayList2, arrayList, fontMetrics, nArray, style);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void lineTextListWrapText(List list, int n, String string, double d, int[] nArray, int n2, Style style, int n3) {
        double d2 = d;
        boolean bl = true;
        int n4 = 0;
        int n5 = 0;
        n2 = (int)((double)n2 + PT.pt2pix(style.getSpacingBefore(), n3) + PT.pt2pix(style.getSpacingAfter(), n3) + PT.pt2pix(style.getLineSpacing(), n3));
        int n6 = (int)d2 / n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' && !bl) continue;
            if (c == '\n') {
                list.add(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
                n5 = 0;
                n4 = 0;
                continue;
            }
            if (c != ' ') {
                bl = false;
            }
            if (c == '\\' && i + 1 < string.length() && string.charAt(i + 1) == 'n') {
                ++i;
                list.add(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
                n5 = 0;
                nArray[0] = Math.max(nArray[0], ++n4);
                n4 = 0;
                continue;
            }
            stringBuffer.append(c);
            n5 += n2;
            nArray[0] = Math.max(nArray[0], ++n4);
            if (!((double)n5 > d2)) continue;
            list.add(stringBuffer.substring(0, stringBuffer.length() - 1));
            stringBuffer.delete(0, stringBuffer.length() - 1);
            n5 = n2;
            nArray[0] = Math.min(nArray[0], n4 - 1);
            n4 = 1;
        }
        DefaultVerticalTextProcessor.addLastVerticalText(list, stringBuffer, n6, n);
    }

    private static void addLastVerticalText(List list, StringBuffer stringBuffer, int n, int n2) {
        if (list.isEmpty()) {
            list.add(stringBuffer.toString());
        } else {
            DefaultVerticalTextProcessor.verticaltextlistAddLastString(list, stringBuffer.toString(), n, n2);
        }
    }

    private static void verticaltextlistAddLastString(List list, String string, int n, int n2) {
        int n3 = string.length();
        int n4 = n - n3;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 0) {
            int n5;
            int n6 = n4 / 2;
            int n7 = n4 - n6;
            for (n5 = 0; n5 < n6; ++n5) {
                stringBuffer.append('\u3000');
            }
            stringBuffer.append(string);
            for (n5 = 0; n5 < n7; ++n5) {
                stringBuffer.append('\u3000');
            }
            list.add(stringBuffer.toString());
        } else if (n2 == 1) {
            int n8 = n4;
            stringBuffer.append(string);
            for (int i = 0; i < n8; ++i) {
                stringBuffer.append('\u3000');
            }
            list.add(stringBuffer.toString());
        } else if (n2 == 3) {
            int n9 = n4;
            for (int i = 0; i < n9; ++i) {
                stringBuffer.append('\u3000');
            }
            stringBuffer.append(string);
            list.add(stringBuffer.toString());
        }
    }

    private static void lineTextListNotWrapText(List list, String string, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c;
            if (i >= string.length() || (c = string.charAt(i)) == '\n') continue;
            if (c == '\\') {
                if (i + 1 < string.length() && string.charAt(i + 1) == 'n') {
                    ++i;
                    continue;
                }
                stringBuffer.append(c);
                nArray[0] = nArray[0] + 1;
                continue;
            }
            stringBuffer.append(c);
            nArray[0] = nArray[0] + 1;
        }
        list.add(stringBuffer.toString());
        stringBuffer.delete(0, stringBuffer.length());
    }

    private static void verticalToHorizontal(List list, List list2, FontMetrics fontMetrics, int[] nArray, Style style) {
        for (int i = 0; i < nArray[0]; ++i) {
            char c;
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            if (style.getTextDirection() == 1) {
                for (n = 0; n < list.size(); ++n) {
                    if (((String)list.get(n)).length() > i) {
                        c = ((String)list.get(n)).charAt(i);
                        stringBuffer.append(c);
                        if (fontMetrics.charWidth(c) != ONECHARACTERLEN) continue;
                        stringBuffer.append(' ');
                        continue;
                    }
                    stringBuffer.append(' ');
                    stringBuffer.append(' ');
                }
            } else {
                for (n = list.size() - 1; n >= 0; --n) {
                    if (((String)list.get(n)).length() > i) {
                        c = ((String)list.get(n)).charAt(i);
                        stringBuffer.append(c);
                        if (fontMetrics.charWidth(c) != ONECHARACTERLEN) continue;
                        stringBuffer.append(' ');
                        continue;
                    }
                    stringBuffer.append(' ');
                    stringBuffer.append(' ');
                }
            }
            list2.add(stringBuffer.toString());
        }
    }

    private static String half2Full(String string) {
        if (StringUtils.isEmpty(string)) {
            return "";
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == ' ') {
                cArray[i] = 12288;
                continue;
            }
            if (cArray[i] <= ' ' || cArray[i] >= '\u007f') continue;
            cArray[i] = (char)(cArray[i] + 65248);
        }
        return new String(cArray);
    }
}

