/*
 * Decompiled with CFR 0.152.
 */
package com.fr.record;

import com.fr.base.FRContext;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.AbstractTableObject;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.json.JSONObject;
import com.fr.record.DBRecordManager;
import com.fr.record.FunctionRecord;
import com.fr.record.JdbcTemplate;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.fun.impl.AbstractFunctionProcessor;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import java.sql.Connection;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class FunctionRecorderManager
extends AbstractFunctionProcessor {
    private static final long SLEEP_TIME = 120000L;
    private ConcurrentHashMap<Integer, Integer> funcMap = new ConcurrentHashMap();
    private Timer scheduleTimer;
    private JdbcTemplate jdbcTemplate;
    private boolean needRecordFunction = true;
    private static FunctionRecorderManager functionRecorderManager = new FunctionRecorderManager();

    public static FunctionRecorderManager getInstance() {
        return functionRecorderManager;
    }

    private FunctionRecorderManager() {
        this.init();
    }

    public void init() {
        try {
            this.jdbcTemplate = new JdbcTemplate(DBRecordManager.getDB());
            this.initRecordTimer();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private void executeInsert(Insert insert) throws Exception {
        if (insert != null) {
            this.jdbcTemplate.execute(insert);
        }
    }

    public void recordFunction(FunctionProcessor functionProcessor) {
        if (this.needRecordFunction) {
            this.recordFunction(functionProcessor.getId());
        }
    }

    public void setNeedRecordFunction(boolean bl) {
        this.needRecordFunction = bl;
    }

    public void recordFunction(int n) {
        int n2 = this.funcMap.containsKey(n) ? this.funcMap.get(n) : 0;
        this.funcMap.put(n, ++n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordIntoDB() {
        String string = this.toString();
        Insert insert = FunctionRecord.getInstance().createInsert(string, new Date());
        Connection connection = null;
        try {
            FR_FUNCTIONRECORD fR_FUNCTIONRECORD = new FR_FUNCTIONRECORD();
            connection = DBRecordManager.getDB().createConnection();
            fR_FUNCTIONRECORD.createTable(connection);
            this.executeInsert(insert);
        }
        catch (Exception exception) {
            try {
                FRContext.getLogger().error(exception.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeConnection(connection);
                throw throwable;
            }
            DBUtils.closeConnection(connection);
            return;
        }
        DBUtils.closeConnection(connection);
        this.funcMap.clear();
    }

    private void initRecordTimer() {
        this.scheduleTimer = new Timer();
        this.scheduleTimer.schedule((TimerTask)new FunctionRecordTimerTask(), new Date(), 120000L);
    }

    private void releaseTimer() {
        if (this.scheduleTimer != null) {
            this.scheduleTimer.cancel();
            this.scheduleTimer = null;
        }
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject(this.funcMap);
        return jSONObject.toString();
    }

    protected boolean isEmpty() {
        return this.funcMap.isEmpty();
    }

    static {
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            public void onServletStop() {
                functionRecorderManager.releaseTimer();
                FunctionRecorderManager.functionRecorderManager = null;
            }

            public void onServletStart() {
                if (functionRecorderManager == null) {
                    FunctionRecorderManager.functionRecorderManager = new FunctionRecorderManager();
                }
            }
        });
    }

    protected class FR_FUNCTIONRECORD
    extends AbstractTableObject {
        protected FR_FUNCTIONRECORD() {
        }

        public Table getTable() {
            return new Table("fr_functionrecord");
        }

        public void initColumns() {
            this.addColumn("func", 12, new ColumnSize(255));
            this.addColumn("logtime", 93, new ColumnSize());
        }
    }

    private class FunctionRecordTimerTask
    extends TimerTask {
        private FunctionRecordTimerTask() {
        }

        public void run() {
            if (FunctionRecorderManager.this.funcMap.isEmpty()) {
                return;
            }
            FunctionRecorderManager.this.recordIntoDB();
        }
    }
}

