/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.file.filetree.FileNode;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.plugin.Plugin;
import com.fr.plugin.PluginConfigManager;
import com.fr.plugin.PluginManagerHelper;
import com.fr.plugin.dependence.PluginDependence;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.RegStatusChangedListener;
import com.fr.stable.StableUtils;
import com.fr.stable.plugin.PluginReadListener;
import com.fr.stable.plugin.event.PluginChangeTransponder;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.ResourceHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader
implements XMLWriter,
XMLReadable {
    private static PluginLoader loader;
    private Set<Plugin> plugins = new HashSet<Plugin>();
    private Set<String> pluginsFoldersWaitForRead = new HashSet<String>();
    private Set<Plugin> hiddenPlugins = new HashSet<Plugin>();

    public static synchronized PluginLoader getLoader() {
        PluginLoader.init();
        return loader;
    }

    public static synchronized void init() {
        if (loader == null) {
            loader = new PluginLoader();
            try {
                loader.readPlugins();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public static synchronized void foreInit() {
        PluginLoader.destroy();
        PluginLoader.init();
        ResourceHelper.clearAllJsCache();
    }

    private static void destroy() {
        PluginLoader.beforeDestroy();
        loader = null;
    }

    private static void beforeDestroy() {
        PluginChangeTransponder.getInstance().clearSpecificPluginListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPluginsWaitForRead() {
        PluginLoader pluginLoader = this;
        synchronized (pluginLoader) {
            Env env = FRContext.getCurrentEnv();
            if (env == null) {
                return;
            }
            for (String string : PluginLoader.loader.pluginsFoldersWaitForRead) {
                InputStream inputStream = null;
                try {
                    inputStream = env.readBean("plugin.xml", StableUtils.pathJoin("plugins", string));
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage(), exception);
                }
                if (inputStream == null) continue;
                Plugin plugin = new Plugin(string);
                try {
                    InputStream inputStream2 = plugin.readEncryptXml(inputStream);
                    XMLTools.readInputStreamXML(plugin, inputStream2);
                    InputStream inputStream3 = env.readBean(plugin.getId() + ".lic", StableUtils.pathJoin("plugins", string));
                    PluginManagerHelper.checkLic(plugin, inputStream3);
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage(), exception);
                }
                this.addPlugin(plugin);
            }
            GeneralContext.firePluginReadListener(PluginReadListener.Status.LAZY);
        }
    }

    public void addRemotePlugin(Plugin plugin) {
        this.addPlugin(plugin);
    }

    private void addPlugin(Plugin plugin) {
        if (!plugin.isHidden()) {
            this.plugins.add(plugin);
        } else {
            this.hiddenPlugins.add(plugin);
        }
        PluginConfigManager.getProviderInstance().pushNewPlugin(plugin);
    }

    private void readPlugins() throws Exception {
        this.readFromInstallHome();
        Env env = FRContext.getCurrentEnv();
        if (env == null) {
            return;
        }
        this.readFromEnv();
        GeneralContext.firePluginReadListener(PluginReadListener.Status.NORMAL);
    }

    private void readFromInstallHome() throws Exception {
        String string = StableUtils.getInstallHome();
        if (".".equals(string)) {
            return;
        }
        File file = new File(StableUtils.pathJoin(string, "plugins"));
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            File file3;
            if (!file2.isDirectory() || !(file3 = new File(StableUtils.pathJoin(file2.getAbsolutePath(), "plugin.xml"))).exists()) continue;
            FileInputStream fileInputStream = new FileInputStream(file3);
            Plugin plugin = new Plugin(file2.getName());
            XMLTools.readInputStreamXML(plugin, fileInputStream);
            if (plugin.checkIfJarExpired()) {
                FRLogger.getLogger().error(Inter.getLocText("FR-Plugin-Jar_Expired") + plugin.getName());
            }
            this.addPlugin(plugin);
        }
    }

    private void readFromEnv() throws Exception {
        Env env = FRContext.getCurrentEnv();
        FileNode[] fileNodeArray = env.listFile("plugins");
        HashSet<PluginDependence> hashSet = new HashSet<PluginDependence>();
        for (FileNode fileNode : fileNodeArray) {
            InputStream inputStream;
            if (!fileNode.isDirectory() || (inputStream = env.readBean("plugin.xml", StableUtils.pathJoin("plugins", fileNode.getName()))) == null) continue;
            Plugin plugin = new Plugin(fileNode.getName());
            InputStream inputStream2 = plugin.readEncryptXml(inputStream);
            XMLTools.readInputStreamXML(plugin, inputStream2);
            if (plugin.checkIfJarExpired()) {
                FRLogger.getLogger().error(Inter.getLocText("FR-Plugin-Jar_Expired") + plugin.getName());
            } else {
                PluginDependence pluginDependence;
                env.checkAndRegisterLic(fileNode, plugin);
                if (plugin.isWaitForRead()) {
                    this.pluginsFoldersWaitForRead.add(fileNode.getName());
                }
                if ((pluginDependence = plugin.getDependence()) != null) {
                    hashSet.add(pluginDependence);
                }
                plugin.start(env);
            }
            this.addPlugin(plugin);
        }
        env.readPluginLicenses();
        this.analyDependence(hashSet);
    }

    private void analyDependence(Set<PluginDependence> set) {
        for (PluginDependence pluginDependence : set) {
            pluginDependence.checkDependExist();
        }
    }

    public void checkAndRegisterLic(FileNode fileNode, Plugin plugin) throws Exception {
        InputStream inputStream = FRContext.getCurrentEnv().readBean(plugin.getId() + ".lic", StableUtils.pathJoin("plugins", fileNode.getName()));
        PluginManagerHelper.checkLic(plugin, inputStream);
    }

    public Plugin[] getInstalled() {
        return this.plugins.toArray(new Plugin[this.plugins.size()]);
    }

    public boolean isInstalled(Plugin plugin) {
        return this.plugins.contains(plugin);
    }

    public Plugin getPluginById(String string) {
        for (Plugin plugin : this.plugins) {
            if (!ComparatorUtils.equals(plugin.getId(), string)) continue;
            return plugin;
        }
        return null;
    }

    public String pluginsToString() throws Exception {
        JSONArray jSONArray = new JSONArray();
        for (Plugin plugin : this.plugins) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("id", plugin.getId());
            jSONObject.put("version", plugin.getVersion());
            jSONArray.put(jSONObject);
        }
        return jSONArray.toString();
    }

    public void deletePlugin(Plugin plugin) {
        this.plugins.remove(plugin);
        PluginConfigManager.getProviderInstance().removePlugin(plugin);
        PluginConfigManager.getProviderInstance().syncPluginConfig();
    }

    public Plugin findPlugin(String string) {
        Plugin plugin = this.getPluginById(string);
        if (plugin == null) {
            plugin = this.getHiddenPluginById(string);
        }
        return plugin;
    }

    private Plugin getHiddenPluginById(String string) {
        for (Plugin plugin : this.hiddenPlugins) {
            if (!ComparatorUtils.equals(plugin.getId(), string)) continue;
            return plugin;
        }
        return null;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    static {
        GeneralContext.addEnvChangedListenerToLast(new EnvChangedListener(){

            public void envChanged() {
                PluginLoader.foreInit();
            }
        });
        GeneralContext.addRegStatusChangedListener(new RegStatusChangedListener(){

            public void regStatusChanged(boolean bl) {
                PluginLoader.foreInit();
            }
        });
        GeneralContext.addPluginReadListener(new PluginReadListener(){

            public void success(PluginReadListener.Status status) {
                PluginConfigManager.getProviderInstance().syncPluginConfig();
            }
        });
        loader = null;
    }
}

