/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.general.ComparatorUtils;
import com.fr.general.IOUtils;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.File;
import java.io.IOException;

public class PluginEmbFile
implements XMLable {
    private static final int ADD_OPERATION = 0;
    private static final int DEL_OPERATION = 1;
    private String fileName;
    private String filePath;
    private int fileOperation;
    private boolean deleteAfterUnistall;

    public PluginEmbFile() {
    }

    public PluginEmbFile(String string, String string2, int n) {
        this.fileName = string;
        this.filePath = string2;
        this.fileOperation = n;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public int getFileOperation() {
        return this.fileOperation;
    }

    public void setFileOperation(int n) {
        this.fileOperation = n;
    }

    public void operate(File file) {
        if (StringUtils.isEmpty(this.fileName)) {
            return;
        }
        Env env = FRContext.getCurrentEnv();
        switch (this.fileOperation) {
            case 0: {
                this.addFile(file, env);
                return;
            }
            case 1: {
                this.removeFile(file, env);
                return;
            }
        }
    }

    private void removeFile(File file, Env env) {
    }

    private void addFile(File file, Env env) {
        Object object;
        File file2 = new File(this.filePath);
        if (!file2.exists()) {
            object = StableUtils.pathJoin(env.getPath(), this.filePath);
            file2 = new File((String)object);
        }
        object = file.listFiles();
        int n = ArrayUtils.getLength(object);
        for (int i = 0; i < n; ++i) {
            File file3 = object[i];
            if (!ComparatorUtils.equals(file3.getName(), this.fileName)) continue;
            File file4 = new File(StableUtils.pathJoin(file2.getPath(), this.fileName));
            if (file4.exists()) continue;
            this.copyFile(file2, file3);
            break;
        }
    }

    private void copyFile(File file, File file2) {
        try {
            IOUtils.copy(file2, file);
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage());
        }
    }

    public boolean del() {
        if (this.deleteAfterUnistall) {
            File file = new File(StableUtils.pathJoin(this.filePath, this.fileName));
            if (file.exists()) {
                return StableUtils.deleteFile(file);
            }
            String string = FRContext.getCurrentEnv().getPath();
            String string2 = StableUtils.pathJoin(string, this.filePath, this.fileName);
            return StableUtils.deleteFile(new File(string2));
        }
        return false;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if ("File".equals(string)) {
            this.fileName = xMLableReader.getAttrAsString("name", "");
            this.filePath = xMLableReader.getAttrAsString("dir", "");
            this.fileOperation = xMLableReader.getAttrAsInt("operation", 0);
            this.deleteAfterUnistall = xMLableReader.getAttrAsBoolean("deleteAfterUnistall", false);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

