/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin;

import com.fr.base.FRContext;
import com.fr.file.XMLFileManager;
import com.fr.general.FRLogger;
import com.fr.plugin.PluginCollector;
import com.fr.plugin.PluginInvalidLevelException;
import com.fr.plugin.PluginLicenseManager;
import com.fr.plugin.PluginMessage;
import com.fr.plugin.proxy.PluginInstanceProxyFactory;
import com.fr.stable.StringUtils;
import com.fr.stable.collections.map.CloseableContainedMap;
import com.fr.stable.collections.set.CloseableContainedSet;
import com.fr.stable.fun.Authorize;
import com.fr.stable.fun.Level;
import com.fr.stable.fun.mark.API;
import com.fr.stable.fun.mark.Aftermath;
import com.fr.stable.fun.mark.Immutable;
import com.fr.stable.fun.mark.Layer;
import com.fr.stable.fun.mark.Mutable;
import com.fr.stable.plugin.PluginSimplify;
import com.fr.stable.xml.XMLableReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtraXMLFileManager
extends XMLFileManager {
    protected static ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private Map<String, Set<Mutable>> mutableMap = new HashMap<String, Set<Mutable>>();
    private Map<String, Map<String, Immutable>> immutableMap = new HashMap<String, Map<String, Immutable>>();

    public <T extends Mutable> Set<T> getArray(String string) {
        Set<Mutable> set = this.mutableMap.get(string);
        if (set == null) {
            return new HashSet();
        }
        return Collections.unmodifiableSet(set);
    }

    public <T extends Mutable> Set<T> getArray(String string, Mutable mutable) {
        Set<Mutable> set = this.mutableMap.get(string);
        if (set == null) {
            set = new CloseableContainedSet<Mutable, HashSet>(HashSet.class);
        }
        if (set.size() == 0) {
            set.add(mutable);
        }
        return Collections.unmodifiableSet(set);
    }

    public void addMutable(String string, Mutable mutable, PluginSimplify pluginSimplify) {
        this.addMutable(string, mutable, mutable.getClass(), pluginSimplify);
    }

    public void addMutable(String string, Mutable mutable, Class<?> clazz, PluginSimplify pluginSimplify) {
        API aPI = clazz.getAnnotation(API.class);
        if (aPI != null) {
            this.validAPILevel(mutable, aPI.level(), pluginSimplify.getPluginName());
            Set<Mutable> set = this.mutableMap.get(string);
            if (set == null) {
                set = new CloseableContainedSet<Mutable, HashSet>(HashSet.class);
                this.mutableMap.put(string, set);
            }
            set.add(mutable);
            this.doAftermath(mutable);
        }
    }

    private void doAftermath(Mutable mutable) {
        if (mutable instanceof Aftermath) {
            ((Aftermath)((Object)mutable)).process();
        }
    }

    public Map<String, Immutable> collectImmutableMap(String string) {
        return this.immutableMap.get(string);
    }

    public <T extends Immutable> T getSingle(String string) {
        return (T)this.getSingle(string, (T)((Object)""));
    }

    public <T extends Immutable> T getSingle(String string, String string2) {
        Map<String, Immutable> map = this.immutableMap.get(string);
        if (map != null && !map.isEmpty()) {
            if (StringUtils.isNotEmpty(string2)) {
                return (T)map.get(string2);
            }
            return (T)this.findMaxLayerIndex(map);
        }
        return null;
    }

    public <T extends Immutable> T getSingle(String string, Class<? extends T> clazz) {
        return (T)this.getSingle(string, "", (T)((Object)clazz));
    }

    public <T extends Immutable> T getSingle(String string, String string2, Class<? extends T> clazz) {
        Map<String, Immutable> map = this.immutableMap.get(string);
        if (map != null && !map.isEmpty()) {
            if (StringUtils.isNotEmpty(string2)) {
                return (T)map.get(string2);
            }
            return (T)this.findMaxLayerIndex(map);
        }
        try {
            return (T)((Immutable)clazz.newInstance());
        }
        catch (InstantiationException instantiationException) {
            FRLogger.getLogger().error(instantiationException.getMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            FRLogger.getLogger().error(illegalAccessException.getMessage(), illegalAccessException);
        }
        return null;
    }

    public <T extends Immutable> T getSingle(String string, T t) {
        Iterator<Map.Entry<String, Immutable>> iterator;
        Map<String, Immutable> map = this.immutableMap.get(string);
        if (map != null && !map.isEmpty() && (iterator = map.entrySet().iterator()).hasNext()) {
            Map.Entry<String, Immutable> entry = iterator.next();
            return (T)entry.getValue();
        }
        return t;
    }

    public <T extends Immutable> T getSingle(String string, String string2, T t) {
        Map<String, Immutable> map = this.immutableMap.get(string);
        if (map != null && !map.isEmpty()) {
            if (StringUtils.isNotEmpty(string2)) {
                return (T)map.get(string2);
            }
            return (T)this.findMaxLayerIndex(map);
        }
        return t;
    }

    private Immutable findMaxLayerIndex(Map<String, Immutable> map) {
        Layer layer = null;
        for (Map.Entry<String, Immutable> entry : map.entrySet()) {
            if (layer == null) {
                layer = entry.getValue();
                continue;
            }
            if (layer.layerIndex() >= entry.getValue().layerIndex()) continue;
            layer = entry.getValue();
        }
        return layer;
    }

    public void setImmutable(String string, Immutable immutable, PluginSimplify pluginSimplify) {
        this.setImmutable(string, immutable, immutable.getClass(), pluginSimplify);
    }

    public void setImmutable(String string, Immutable immutable, Class<?> clazz, PluginSimplify pluginSimplify) {
        API aPI = clazz.getAnnotation(API.class);
        if (aPI != null) {
            this.validAPILevel(immutable, aPI.level(), pluginSimplify.getPluginName());
            Map<String, Immutable> map = this.immutableMap.get(string);
            if (map == null) {
                map = new CloseableContainedMap<String, Immutable, HashMap>(HashMap.class);
                this.immutableMap.put(string, map);
            }
            map.put(pluginSimplify.getPluginID(), immutable);
        }
    }

    protected void validAPILevel(Level level, int n, String string) {
        if (PluginCollector.getCollector().isError(level, n, string)) {
            throw new PluginInvalidLevelException(string, level.currentAPILevel());
        }
    }

    public void readXML(XMLableReader xMLableReader, List<String> list, PluginSimplify pluginSimplify) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (list != null) {
                list.add(string2);
            }
            if (StringUtils.isEmpty(string = xMLableReader.getAttrAsString("class", ""))) {
                return;
            }
            this.readStandard(string2, string, pluginSimplify, xMLableReader);
        }
    }

    protected void readStandard(String string, String string2, PluginSimplify pluginSimplify, XMLableReader xMLableReader) {
        try {
            Level level;
            Class<?> clazz = loader.loadClass(string2);
            Authorize authorize = clazz.getAnnotation(Authorize.class);
            if (authorize != null) {
                PluginLicenseManager.getInstance().registerPaid(authorize, pluginSimplify);
            }
            if ((level = (Level)new PluginInstanceProxyFactory(clazz, pluginSimplify).addProxy("isClosed").getProxyObj()) instanceof Mutable) {
                this.addMutable(string, (Mutable)level, clazz, pluginSimplify);
            } else if (level instanceof Immutable) {
                this.setImmutable(string, (Immutable)level, clazz, pluginSimplify);
            } else {
                this.readSpecific(string, level, pluginSimplify, xMLableReader);
            }
        }
        catch (PluginInvalidLevelException pluginInvalidLevelException) {
            PluginMessage.remindUpdate(pluginInvalidLevelException.getMessage());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    protected void readSpecific(String string, Level level, PluginSimplify pluginSimplify, XMLableReader xMLableReader) throws Exception {
    }
}

