/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance;

import com.fr.performance.EmptyExtendPerformanceManager;
import com.fr.performance.EmptyRuntimeMonitor;
import com.fr.performance.ExtendPerformanceManager;
import com.fr.performance.IRuntimeMonitor;
import com.fr.performance.info.EmptyInfoFactory;
import com.fr.performance.info.IPerformanceInfoFactory;
import com.fr.performance.memory.BaseMemoryEstimation;
import com.fr.performance.memory.EmptyMemoryEstimation;
import com.fr.performance.recorder.EmptyPerformanceRecorderManager;
import com.fr.performance.recorder.PerformanceRecorder;
import com.fr.performance.recorder.PerformanceRecorderManager;
import com.fr.stable.web.SessionProvider;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class PerformanceManager {
    private static PerformanceRecorderManager performanceRecorderManager;
    private static ExtendPerformanceManager extendPerformanceManager;
    private static IRuntimeMonitor runtimeMonitor;
    private static BaseMemoryEstimation memoryEstimation;
    private static IPerformanceInfoFactory infoFactory;
    public static ThreadLocal<SessionProvider> sessionIDInforThreadLocal;
    private static ReentrantLock lock;

    private static void registerEmptyManager() {
        performanceRecorderManager = EmptyPerformanceRecorderManager.getInstance();
        extendPerformanceManager = EmptyExtendPerformanceManager.getInstance();
        runtimeMonitor = EmptyRuntimeMonitor.getInstance();
        memoryEstimation = EmptyMemoryEstimation.getInstance();
        infoFactory = EmptyInfoFactory.getInstance();
    }

    public static BaseMemoryEstimation getMemoryEstimation() {
        return memoryEstimation;
    }

    public static void registerMemoryEstimation(BaseMemoryEstimation baseMemoryEstimation) {
        memoryEstimation = baseMemoryEstimation;
    }

    public static IPerformanceInfoFactory getInfoFactory() {
        return infoFactory;
    }

    public static void registerInfoFactory(IPerformanceInfoFactory iPerformanceInfoFactory) {
        infoFactory = iPerformanceInfoFactory;
    }

    public static IRuntimeMonitor getRuntimeMonitor() {
        return runtimeMonitor;
    }

    public static void registerRuntimeMonitor(IRuntimeMonitor iRuntimeMonitor) {
        runtimeMonitor = iRuntimeMonitor;
    }

    public static PerformanceRecorder getRecorder() {
        return performanceRecorderManager.getThreadPerformanceRecorder();
    }

    public static boolean isUsePerformanceRecorder() {
        return !(performanceRecorderManager instanceof EmptyPerformanceRecorderManager);
    }

    public static PerformanceRecorderManager getRecorderManager() {
        return performanceRecorderManager;
    }

    public static void reset() {
        performanceRecorderManager.reset();
    }

    public static void clearThreadLocal() {
        PerformanceManager.reset();
    }

    public static void registerRecorderManager(PerformanceRecorderManager performanceRecorderManager) {
        PerformanceManager.performanceRecorderManager = performanceRecorderManager;
    }

    public static void registerExtendPerformanceManager(ExtendPerformanceManager extendPerformanceManager) {
        PerformanceManager.extendPerformanceManager = extendPerformanceManager;
    }

    public static void bindSessionInfo(SessionProvider sessionProvider) {
        sessionIDInforThreadLocal.set(sessionProvider);
    }

    public static void releaseSessionInfo() {
        sessionIDInforThreadLocal.set(null);
    }

    public static SessionProvider getThreadSession() {
        return sessionIDInforThreadLocal.get();
    }

    public static void bindSessionInfo(String string) {
        if (extendPerformanceManager != null) {
            extendPerformanceManager.bindSessionInfo(string);
        }
    }

    public static void lock() {
        lock.lock();
    }

    public static boolean tryLock(long l) throws InterruptedException {
        return lock.tryLock(l, TimeUnit.MILLISECONDS);
    }

    public static void unlock() {
        lock.unlock();
    }

    static {
        PerformanceManager.registerEmptyManager();
        sessionIDInforThreadLocal = new ThreadLocal();
        lock = new ReentrantLock();
    }
}

