/*
 * Decompiled with CFR 0.152.
 */
package com.fr.parser;

import com.fr.general.GeneralUtils;
import com.fr.parser.MathExpression;
import com.fr.stable.OperationUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.Node;
import com.fr.stable.script.TinyHunter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PowerExpression
extends MathExpression {
    private static final String POW = "^";
    Node[] unarys;

    PowerExpression(Node[] nodeArray) {
        this.unarys = nodeArray;
    }

    protected int sizeOfNodes() {
        return this.unarys.length;
    }

    protected String emptyNodesException() {
        return "unaryList should not be empty";
    }

    protected Node getNodeByIndex(int n) {
        return this.unarys[n];
    }

    protected String getOpByIndex(int n) {
        return POW;
    }

    protected boolean shortcutJudge() {
        return false;
    }

    protected Object ccNINI(String string) {
        return OperationUtils.ZERO;
    }

    protected Object ccNIPI(String string) {
        return OperationUtils.NEGATIVE_INFINITY;
    }

    protected Object ccNIRE(Object object, String string) {
        Number number = GeneralUtils.objectToNumber(object, true);
        if (number == null) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        if (number.intValue() < 0) {
            return OperationUtils.ZERO;
        }
        return OperationUtils.NEGATIVE_INFINITY;
    }

    protected Object ccPINI(String string) {
        return OperationUtils.ZERO;
    }

    protected Object ccPIPI(String string) {
        return OperationUtils.POSITIVE_INFINITY;
    }

    protected Object ccPIRE(Object object, String string) {
        Number number = GeneralUtils.objectToNumber(object, true);
        if (number == null) {
            return OperationUtils.POSITIVE_INFINITY;
        }
        if (number.intValue() < 0) {
            return OperationUtils.ZERO;
        }
        return OperationUtils.POSITIVE_INFINITY;
    }

    protected Object ccRENI(Object object, String string) {
        return OperationUtils.ZERO;
    }

    protected Object ccREPI(Object object, String string) {
        Number number = GeneralUtils.objectToNumber(object, true);
        if (number == null) {
            return OperationUtils.POSITIVE_INFINITY;
        }
        int n = number.intValue();
        if (n > 0) {
            return OperationUtils.POSITIVE_INFINITY;
        }
        if (n == 0) {
            return OperationUtils.ZERO;
        }
        return OperationUtils.NEGATIVE_INFINITY;
    }

    protected Object ccRERE(Object object, Object object2, String string) {
        return this.numberOperation(object, object2, string);
    }

    protected Object decimalOperation(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) {
        return this.doubleOperation(bigDecimal.doubleValue(), bigDecimal2.doubleValue(), string);
    }

    protected Object doubleOperation(double d, double d2, String string) {
        return new Double(Math.pow(d, d2));
    }

    protected Object longOperation(long l, long l2, String string) {
        return new Double(Math.pow(l, l2));
    }

    public void traversal4Tiny(TinyHunter tinyHunter) {
        for (int i = 0; i < this.unarys.length; ++i) {
            this.unarys[i].traversal4Tiny(tinyHunter);
        }
    }

    public String exString(CalculatorProvider calculatorProvider) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.unarys.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ^ ");
            }
            stringBuffer.append(this.unarys[i].exString(calculatorProvider));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.unarys.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ^ ");
            }
            stringBuffer.append(this.unarys[i]);
        }
        return stringBuffer.toString();
    }

    public String getExpression(int n, int n2, int n3, int n4, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.unarys.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ^ ");
            }
            stringBuffer.append(this.unarys[i].getExpression(n, n2, n3, n4, bl));
        }
        return stringBuffer.toString();
    }

    public String[] parserParameter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.unarys.length;
        for (int i = 0; i < n; ++i) {
            if (this.unarys[i].parserParameter() == null) continue;
            arrayList.addAll(Arrays.asList(this.unarys[i].parserParameter()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] parserParameterNoColumnRow() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.unarys.length;
        for (int i = 0; i < n; ++i) {
            if (this.unarys[i].parserParameterNoColumnRow() == null) continue;
            arrayList.addAll(Arrays.asList(this.unarys[i].parserParameterNoColumnRow()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean delay4PageCal() {
        for (int i = 0; i < this.unarys.length; ++i) {
            if (!this.unarys[i].delay4PageCal()) continue;
            return true;
        }
        return false;
    }

    public void trav4HuntSIL(List list) {
        for (int i = 0; i < this.unarys.length; ++i) {
            this.unarys[i].trav4HuntSIL(list);
        }
    }

    public void trav4HuntBIL(List list) {
        for (int i = 0; i < this.unarys.length; ++i) {
            this.unarys[i].trav4HuntBIL(list);
        }
    }
}

